; /*************************************************************************/
; /*								       														*/
; /*		       DV-16110    .			*/
; /*																								*/
; /*************************************************************************/

						NAME    LCD_DRIVER

LCD_DRIVER			SEGMENT	CODE

						PUBLIC  Init_LCD
						PUBLIC  _Write_String_To_LCD
						PUBLIC  _Write_Data_To_LCD
						PUBLIC  _Write_Code_To_LCD
						PUBLIC  _LCD_Backlight

LCD_Data_Bus		DATA	0A0H			; P2   -    .
LCD_Backlight		BIT	084H			; P0.4 -   .
LCD_Enable			BIT	085H			; P0.5 -   E.
LCD_Read_Write		BIT	086H			; P0.6 -  / RW.
LCD_Reg_Select		BIT	087H			; P0.7 -    RS.
EA						BIT	0AFH			;    .

						RSEG	LCD_DRIVER
						USING   0


; /*************************************************************************/
; /*								       														*/
; /*		               .							*/
; /*																								*/
; /* void Display(idata char * ptr)														*/
; /* :		     .					*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
_Write_String_To_LCD:

  ;      .
  		  MOV		 A,R7
        MOV     R0,A

  ;  ,  -   .
        MOV     R7,#001H
        ACALL   _Write_Code_To_LCD

  ;    8    00h .
        MOV     B,#008H
Put_First_Half_String:
        MOV     A,@R0				;   .
        JZ      End_Put_String	;     - .
        MOV     R7,A					;    .
        ACALL   _Write_Data_To_LCD
        INC     R0					;  .
        DJNZ    B,Put_First_Half_String;

  ;        .
        MOV     R7,#0C0H
        ACALL   _Write_Code_To_LCD

  ;    8    40h .
        MOV     B,#008H
Put_Second_Half_String:
        MOV     A,@R0				;   .
        JZ      End_Put_String	;     - .
        MOV     R7,A					;    .
        ACALL   _Write_Data_To_LCD
        INC     R0					;  .
        DJNZ    B,Put_Second_Half_String;

End_Put_String:
        RET     


; /*************************************************************************/
; /*								       														*/
; /*		     L1692   .			*/
; /*																								*/
; /* void Write_Code_To_LCD(char Data)													*/
; /* :		    R7.								*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
_Write_Code_To_LCD:
		  CLR		 EA

  ;      .
        MOV     LCD_Data_Bus,#0FFH

  ;       .
        CLR     LCD_Reg_Select
        SETB    LCD_Read_Write
Write_Code_To_LCD_Wait_Ready:
        SETB    LCD_Enable
        MOV     ACC,LCD_Data_Bus
        CLR     LCD_Enable
        JB      ACC.7,Write_Code_To_LCD_Wait_Ready

  ;      .
        CLR     LCD_Read_Write
        SETB    LCD_Enable
        MOV     LCD_Data_Bus,R7
        CLR     LCD_Enable

		  SETB	 EA
        RET     


; /*************************************************************************/
; /*								       														*/
; /*	       L1692   .		*/
; /*																								*/
; /* void Write_Data_To_LCD(char Data)													*/
; /* :		  .										*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
_Write_Data_To_LCD:
		  CLR		 EA

  ;      .
        MOV     LCD_Data_Bus,#0FFH

  ;       .
        CLR     LCD_Reg_Select
        SETB    LCD_Read_Write
Write_Data_To_LCD_Wait_Ready:
        SETB    LCD_Enable
        MOV     ACC,LCD_Data_Bus
        CLR     LCD_Enable
        JB      ACC.7,Write_Data_To_LCD_Wait_Ready

  ;      .
        SETB    LCD_Reg_Select
        CLR     LCD_Read_Write
        SETB    LCD_Enable
        MOV     LCD_Data_Bus,R7
        CLR     LCD_Enable

		  SETB	 EA
        RET     


; /*************************************************************************/
; /*								       														*/
; /*			   L1692   .			*/
; /*																								*/
; /* void Init_LCD(void)																	*/
; /* :		  .												*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
Init_LCD:

  ;      .
        CLR     LCD_Reg_Select
        CLR     LCD_Read_Write
        SETB    LCD_Enable
        MOV     LCD_Data_Bus,#030H
        CLR     LCD_Enable

  ;     512    12 .
        CLR     A
		  DJNZ	 ACC,$

  ;    - 2 ,   5 x 7.
        MOV     R7,#038H
        ACALL   _Write_Code_To_LCD

  ;   ,  .
        MOV     R7,#006H
        ACALL   _Write_Code_To_LCD

  ;        .
        MOV     R7,#001H
        ACALL   _Write_Code_To_LCD

  ;  ,   . 
        MOV     R7,#00CH
        ACALL   _Write_Code_To_LCD

        RET     


; /*************************************************************************/
; /*								       														*/
; /*						   .						*/
; /*																								*/
; /* void LCD_Backlight(char )															*/
; /* :		  :									*/
; /*				   ="0" -  , <>"0" -  .	*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
_LCD_Backlight:
		  CLR		 EA

		  MOV A,R7
		  JZ Backlight_Off

Backlight_On:
		  SETB LCD_Backlight
		  SJMP LCD_Backlight_End

Backlight_Off:
		  CLR LCD_Backlight

LCD_Backlight_End:
		  SETB	 EA
		  RET


; /*************************************************************************/
		  END

























































