/*********************************************************************/
/*																							*/
/*              AT89S8252.				*/
/*                   , 18.02.2000 .	 					*/
/*																							*/
/*********************************************************************/
#ifndef _REG_S8252
#define _REG_S8252

/*===================================================================*/
/*              .  					*/
/*===================================================================*/
sfr at 0x80 P0    ;		//  0.
sfr at 0x81 SP    ;		//  .
sfr at 0x82 DPL   ;		//   DPTR.
sfr at 0x83 DPH   ;		//   DPTR.
sfr at 0x84 DPL1  ;		//    DPTR.
sfr at 0x85 DPH1  ;		//    DPTR.
sfr at 0x86 SPDR  ;		//   SPI.
sfr at 0x87 PCON  ;		//   .
sfr at 0x88 TCON  ;		//  .
sfr at 0x89 TMOD  ;		//    0  1.
sfr at 0x8A TL0   ;		//     0.
sfr at 0x8B TL1   ;		//     1.
sfr at 0x8C TH0   ;		//     0.
sfr at 0x8D TH1   ;		//     1.
sfr at 0x90 P1    ;		//  1.
sfr at 0x96 WMCON ;		//   Watch Dog .
sfr at 0x98 SCON  ;		//   UART.
sfr at 0x99 SBUF  ;		//   UART.
sfr at 0xA0 P2    ;		//  2.
sfr at 0xA8 IE    ;		//   .
sfr at 0xAA SPSR  ;		//   SPI.
sfr at 0xB0 P3    ;		//  3.
sfr at 0xB8 IP    ;		//   .
sfr at 0xC8 T2CON ;		//   .
sfr at 0xC9 T2MOD ;		//    2.
sfr at 0xCA RCAP2L;		//      2.
sfr at 0xCB RCAP2H;		//      2.
sfr at 0xCC TL2   ;		//     2.
sfr at 0xCD TH2   ;		//     2.
sfr at 0xD0 PSW   ;		//  .
sfr at 0xD5 SPCR  ;		//   SPI.
sfr at 0xE0 ACC   ;		// .
sfr at 0xF0 B     ;		//  B.


/*===================================================================*/
/*            .  				*/
/*===================================================================*/

/*-------------------------------------------------------------------*/
/* PSW -   .   											*/
sbit at 0xD7 CY   ;		//  .
sbit at 0xD6 AC   ;		//   .
sbit at 0xD5 F0   ;		//  .
sbit at 0xD4 RS1  ;		//    .
sbit at 0xD3 RS0  ;
sbit at 0xD2 OV   ;		//  .
sbit at 0xD0 P    ;		//  .

/*-------------------------------------------------------------------*/
/* TCON -  . 													*/
sbit at 0x8F TF1  ;		//   / 1.
sbit at 0x8E TR1  ;		//   / 1.
sbit at 0x8D TF0  ;		//   / 0.
sbit at 0x8C TR0  ;		//   / 0.
sbit at 0x8B IE1  ;		//     INT1.
sbit at 0x8A IT1  ;		//      INT1.
sbit at 0x89 IE0  ;		//     INT0.
sbit at 0x88 IT0  ;		//      INT0.

/*-------------------------------------------------------------------*/
/* IE -   .  										*/
sbit at 0xAF EA   ;		//    .
sbit at 0xAD ET2  ;		//      2.
sbit at 0xAC ES   ;		//     UART.
sbit at 0xAB ET1  ;		//      1.
sbit at 0xAA EX1  ;		//      INT1.
sbit at 0xA9 ET0  ;		//      0.
sbit at 0xA8 EX0  ;		//      INT0.

/*-------------------------------------------------------------------*/
/* IP -   . 										*/ 
sbit at 0xBD PT2  ;		//      2.
sbit at 0xBC PS   ;		//     UART.
sbit at 0xBB PT1  ;		//      1.
sbit at 0xBA PX1  ;		//     INT1.
sbit at 0xB9 PT0  ;		//      0.
sbit at 0xB8 PX0  ;		//     INT0.

/*-------------------------------------------------------------------*/
/* P0 -    0.												*/
sbit at 0x87 AD7  ;		//  /   AD7.
sbit at 0x86 AD6  ;		//  /   AD6.
sbit at 0x85 AD5  ;		//  /   AD5.
sbit at 0x84 AD4  ;		//  /   AD4.
sbit at 0x83 AD3  ;		//  /   AD3.
sbit at 0x82 AD2  ;		//  /   AD2.
sbit at 0x81 AD1  ;		//  /   AD1.
sbit at 0x80 AD0  ;		//  /   AD0.

sbit at 0x87 P07  ;
sbit at 0x86 P06  ;
sbit at 0x85 P05  ;
sbit at 0x84 P04  ;
sbit at 0x83 P03  ;
sbit at 0x82 P02  ;
sbit at 0x81 P01  ;
sbit at 0x80 P00  ;

/*-------------------------------------------------------------------*/
/* P1 -    1.												*/
sbit at 0x97 SCK  ;		//   SPI.
sbit at 0x96 MISO ;		//  MISO SPI.
sbit at 0x95 MOSI ;		//  MOSI SPI.
sbit at 0x94 SS   ;		//  SS SPI.
sbit at 0x91 T2EX ;		//   .
sbit at 0x90 T2   ;		//   / 2.

sbit at 0x97 P17  ;
sbit at 0x96 P16  ;
sbit at 0x95 P15  ;
sbit at 0x94 P14  ;
sbit at 0x93 P13  ;
sbit at 0x92 P12  ;
sbit at 0x91 P11  ;
sbit at 0x90 P10  ;

/*-------------------------------------------------------------------*/
/* P2 -    2.												*/
sbit at 0xA7 A15  ;		//     A15.
sbit at 0xA6 A14  ;		//     A14.
sbit at 0xA5 A13  ;		//     A13.
sbit at 0xA4 A12  ;		//     A12.
sbit at 0xA3 A11  ;		//     A11.
sbit at 0xA2 A10  ;		//     A10.
sbit at 0xA1 A9   ;		//     A9.
sbit at 0xA0 A8   ;		//     A8.

sbit at 0xA7 P27  ;
sbit at 0xA6 P26  ;
sbit at 0xA5 P25  ;
sbit at 0xA4 P24  ;
sbit at 0xA3 P23  ;
sbit at 0xA2 P22  ;
sbit at 0xA1 P21  ;
sbit at 0xA0 P20  ;

/*-------------------------------------------------------------------*/
/* P3 -    3.												*/
sbit at 0xB7 RD   ;		//     .
sbit at 0xB6 WR   ;		//     .
sbit at 0xB5 T1   ;		//   / 1.
sbit at 0xB4 T0   ;		//   / 0.
sbit at 0xB3 INT1 ;		//    1.
sbit at 0xB2 INT0 ;		//    2.
sbit at 0xB1 TXD  ;		//   UART.
sbit at 0xB0 RXD  ;		//   UART.

sbit at 0xB7 P37  ;
sbit at 0xB6 P36  ;
sbit at 0xB5 P35  ;
sbit at 0xB4 P34  ;
sbit at 0xB3 P33  ;
sbit at 0xB2 P32  ;
sbit at 0xB1 P31  ;
sbit at 0xB0 P30  ;

/*-------------------------------------------------------------------*/
/* SCON -   UART.												*/
sbit at 0x9F SM0  ;		//     UART.
sbit at 0x9E SM1  ;
sbit at 0x9D SM2  ;		//    .
sbit at 0x9C REN  ;		//    UART.
sbit at 0x9B TB8  ;		//     .
sbit at 0x9A RB8  ;		//     .
sbit at 0x99 TI   ;		//   .
sbit at 0x98 RI   ;		//   .

/*-------------------------------------------------------------------*/
/* T2CON -   . 								*/
sbit at 0xC8 CP_RL2;		//   /  2.
sbit at 0xC9 C_T2  ;		//   /  2.
sbit at 0xCA TR2	 ;		//   / 2.
sbit at 0xCB EXEN2 ;		//    EX2.
sbit at 0xCC TCLK  ;		//    UART  T2.
sbit at 0xCD RCLK  ;
sbit at 0xCE EXF2  ;		//
sbit at 0xCF TF2   ;		//   / 2.

/*-------------------------------------------------------------------*/
/* TMOD -     0  1.									*/
#define T0_M0   0x01		/*      0.		*/
#define T0_M1   0x02
#define T0_CT   0x04		/*    /  0.	*/
#define T0_GATE 0x08		/*      0.*/
#define T1_M0   0x10		/*      1.		*/
#define T1_M1   0x20
#define T1_CT   0x40		/*    /  1.	*/
#define T1_GATE 0x80		/*      0.*/

/*-------------------------------------------------------------------*/
/* PCON -   .											*/
#define IDL     0x01		/*      .	*/
#define STOP    0x02		/*     .*/
#define GF0     0x04		/*   .						*/
#define GF1     0x08
#define SMOD    0x80		/*    UART.					*/

/*-------------------------------------------------------------------*/
/* T2MOD -     2.										*/
#define DCEN    0x01		/*      2.	*/
#define T2OE    0x02		/*    T2.						*/

/*-------------------------------------------------------------------*/
/* WMCON -   WatchDog .							*/
#define WDTEN   0x01		/*   WatchDog .				*/
#define WDTRST  0x02		/*   WatchDog .					*/
#define DPS     0x04		/*    DPTR.						*/
#define EEMEN   0x08		/*    EEPROM.					*/
#define EEMWE   0x10		/*    EEPROM.					*/
#define PS0		 0x20		/*    WatchDog .			*/
#define PS1		 0x40
#define PS2		 0x80

/*-------------------------------------------------------------------*/
/* SPCR -   SPI.												*/
#define SPR0	 0x01		/*    .					*/
#define SPR1	 0x02
#define CPHA	 0x04		/*    SCK.								*/
#define CPOL	 0x08		/*    SCK.						*/
#define MSTR	 0x10		/*   Master/Slave.						*/
#define DORD	 0x20		/*    .				*/
#define SPE     0x40		/*   SPI.								*/
#define SPIE	 0x80		/*     SPI.			*/

/*-------------------------------------------------------------------*/
/* SPSR -   SPI.													*/
#define SPIF    0x80		/*    SPI.							*/
#define WCOL	 0x40		/*     SPI.						*/

#endif
