/************************************************************************/
/*								       														*/
/*	  		     1.5.4	         */
/*							 2.0  2000 .		       					*/
/*								       														*/
/************************************************************************/
#include "tester.h"

/*======================================================================*/
/*   .													*/
/*======================================================================*/

/*----------------------------------------------------------------------*/
/*     .										*/
/*     EEPROM .							*/
at 0x0000 xdata char nParam;

/*----------------------------------------------------------------------*/
/*   " M1.5.4".												*/
code char Title_0[]=
               { 0xa5, 0xbd, 0xe3, 0xb8, 0xba, 0x61, 0xbf, 0x6f,
					  0x70, 0x20, 0x4d, 0x31, 0x2e, 0x35, 0x2e, 0x34, 0x00 };

/*----------------------------------------------------------------------*/
/*  " *   *".															*/
code char Title_1[]=
					{ 0x20, 0x2a, 0x20, 0x48, 0x65, 0xbf, 0x20,
					  0x43, 0xb3, 0xc7, 0xb7, 0xb8, 0x20, 0x2a, 0x00 };

/*----------------------------------------------------------------------*/
/*  "..  ".																*/
code char Title_2[]=
					{ 0x54, 0x65, 0xbc, 0xbe, 0x2e, 0x4f, 0x78, 0xbb,
					  0x2e, 0x20,  '%',  'd', 0x20, 0x43, 0x00 };

/*----------------------------------------------------------------------*/
/*  "...  %".																*/
code char Title_3[]=
					{ 0xa8, 0x6f, 0xbb, 0x2e, 0xe0, 0x70, 0x2e, 0xa4,
					  0x2e, 0x20,  '%',  'u', 0x20,  '%',  '%', 0x00 };

/*----------------------------------------------------------------------*/
/*  "  ".																*/
code char Title_4[]=
					{ 0x4f, 0xb2, 0x6f, 0x70, 0x6f, 0xbf, 0xc3, 0x20,
					   '%',  'u', 0x20, 0x6f, 0xb2, 0xbc, 0x00 };

/*----------------------------------------------------------------------*/
/*  "...".																	*/
code char Title_5[]=
					{ 0xa3, 0x65, 0xbb, 0x2e, 0x4f, 0xb2, 0x2e, 0x58,
					  0x58, 0x2e, 0x20,  '%',  'u', 0x00 };

/*----------------------------------------------------------------------*/
/*  ".. ".																*/
code char Title_6[]=
					{ 0xa8, 0x6f, 0xbb, 0x2e, 0x50, 0x58, 0x58, 0x2e,
					  0x20,  '%',  'u', 0x20, 0xc1, 0x61, 0xb4, 0x00 };

/*----------------------------------------------------------------------*/
/*  "...".																*/
code char Title_7[]=
					{ 0xa3, 0x65, 0xbb, 0x2e, 0xa8, 0x6f, 0xbb, 0x2e,
					  0x50, 0x58, 0x58, 0x2e, 0x20,  '%',  'u', 0x00 };

/*----------------------------------------------------------------------*/
/*  " ..".																	*/
code char Title_8[]=
					{ 0xa9, 0x4f, 0xa4, 0x20,  '%',  'u', 0x20,
					  0xb4, 0x70, 0x2e, 0xba, 0xb3, 0x2e, 0x00 };

/*----------------------------------------------------------------------*/
/*  " /".																*/
code char Title_9[]=
					{ 0x43, 0xba, 0x6f, 0x70, 0x6f, 0x63, 0xbf, 0xc4,
					  0x20,  '%',  'u', 0x20, 0xba, 0xbc, 0x2f, 0xc0, 0x00 };

/*----------------------------------------------------------------------*/
/*  " ".																*/
code char Title_10[]=
					{ 0x48, 0x61, 0xbe, 0x70, 0xc7, 0xb6, 0x65, 0xbd,
					  0xb8, 0x65, 0x20,  '%',  'u', 0x20, 0x42, 0x00 };

/*----------------------------------------------------------------------*/
/*  ". m".																*/
code char Title_11[]=
					{ 0x42, 0x70, 0x2e, 0x42, 0xbe, 0x70, 0xc3, 0x63,
					  0xba, 0x61, 0x20,  '%',  'u', 0x20, 0x6d, 0x63, 0x00 };

/*----------------------------------------------------------------------*/
/*  " /".																*/
code char Title_12[]=
					{ 0x42, 0x6f, 0xb7, 0xe3, 0x79, 0x78, 0x20,
					  '%',  'u', 0x20, 0xba, 0xb4, 0x2f, 0xc0, 0x00 };

/*----------------------------------------------------------------------*/
/*  " /".																*/
code char Title_13[]=
					{ 0x54, 0x6f, 0xbe, 0xbb, 0xb8, 0xb3, 0x6f, 0x20,
					   '%',  'u', 0x20, 0xbb, 0x2f, 0xc0, 0x61, 0x63, 0x00 };

/*----------------------------------------------------------------------*/
/*  " /100".																*/
code char Title_141[]=
					{ 0x54, 0x6f, 0xbe, 0xbb, 0xb8, 0xb3, 0x6f, 0x20,
					   '%',  'u', 0x20, 0xbb, 0x2f, 0x31, 0x30, 0x30, 0x00 };

/*----------------------------------------------------------------------*/
/*  " -- /100".															*/
code char Title_142[]=
					{ 0x54, 0x6f, 0xbe, 0xbb, 0xb8, 0xb3, 0x6f, 0x20,
					  0x2d, 0x2d, 0x20, 0xbb, 0x2f, 0x31, 0x30, 0x30, 0x00 };

/*----------------------------------------------------------------------*/
/*  " - ".															*/
code char Title_151[]=
					{ 0xe0, 0x65, 0xbf, 0x6f, 0xbd, 0x61, 0xe5, 0xb8, 0xc7,
					  0x20, 0x2d, 0x20, 0xe0, 0x41, 0x00 };

/*----------------------------------------------------------------------*/
/*  " - ".															*/
code char Title_152[]=
					{ 0xe0, 0x65, 0xbf, 0x6f, 0xbd, 0x61, 0xe5, 0xb8, 0xc7,
					  0x20, 0x2d, 0x20, 0x48, 0x45, 0x54, 0x00 };

/*----------------------------------------------------------------------*/
/*  ".. - ".															*/
code char Title_161[]=
					{ 0xa0, 0xbb, 0x6f, 0xba, 0x2e, 0x54, 0x6f, 0xbe, 0xbb,
					  0x2e, 0x20, 0x2d, 0x20, 0xe0, 0x41, 0x00 };

/*----------------------------------------------------------------------*/
/*  ".. - ".															*/
code char Title_162[]=
					{ 0xa0, 0xbb, 0x6f, 0xba, 0x2e, 0x54, 0x6f, 0xbe, 0xbb,
					  0x2e, 0x20, 0x2d, 0x20, 0x48, 0x45, 0x54, 0x00 };

/*----------------------------------------------------------------------*/
/*  ". - ".																*/
code char Title_171[]=
					{ 0x58, 0x6f, 0xbb, 0x2e, 0x58, 0x6f, 0xe3,
					  0x20, 0x2d, 0x20, 0xe0, 0x41, 0x00 };

/*----------------------------------------------------------------------*/
/*  ". - ".																*/
code char Title_172[]=
					{ 0x58, 0x6f, 0xbb, 0x2e, 0x58, 0x6f, 0xe3,
					  0x20, 0x2d, 0x20, 0x48, 0x45, 0x54, 0x00 };

/*----------------------------------------------------------------------*/
/*  " - ".															*/
code char Title_181[]=
					{ 0x4f, 0xb2, 0x6f, 0xb4, 0x61, 0xe6, 0x65, 0xbd, 0xb8,
					  0x65, 0x20, 0x2d, 0x20, 0xe0, 0x41, 0x00 };

/*----------------------------------------------------------------------*/
/*  " - ".															*/
code char Title_182[]=
					{ 0x4f, 0xb2, 0x6f, 0xb4, 0x61, 0xe6, 0x65, 0xbd, 0xb8,
					  0x65, 0x20, 0x2d, 0x20, 0x48, 0x45, 0x54, 0x00 };

/*----------------------------------------------------------------------*/
/*  " ".																		*/
code char Title_19[]=
					{ 0x4f, 0xc1, 0xb8, 0xb2, 0x6f, 0xba,
					  0x20, '%', 'u', 0x00 };

/*----------------------------------------------------------------------*/
/*  "[] ".																	*/
code char Title_20[]=
					{ 0x4f, 0xc1, 0xb8, 0xb2, 0xba, 0x61, 0x5b,  '%',  'u',
					  0x5d, 0x3d,  '%',  'x', 0x20,  '%',  'x', 0x00 };


/*======================================================================*/
/*																								*/
/*							  .									*/
/*																								*/
/*======================================================================*/
void main(void)
{
  /*--------------------------------------------------------------------*/
  /*    :													*/
  /* "1" -   ,   ;				*/
  /* "0" -    ,   .				*/
  bit bMode;

  /*--------------------------------------------------------------------*/
  /*      .										*/
  /* "1" -     ;									*/
  /* "0" -   ( ) .			*/
  bit bConnect;

  /*--------------------------------------------------------------------*/
  /*          .			*/
  /*  3-   ( ) 				*/
  /*      .							*/
  data char ErrCntr;

  /*--------------------------------------------------------------------*/
  /*    "", ""  "".						*/
  /* "1" -  .															*/
  /* "0" -  .																*/
  bit Left_Key_Prev_State, Right_Key_Prev_State, Enter_Key_Prev_State;

  /*--------------------------------------------------------------------*/
  /* ,    ,   .		*/
  idata char String[20];

  /*--------------------------------------------------------------------*/
  /* 						  .						*/
  /*--------------------------------------------------------------------*/
  /*    - .														*/
  P0=P1=P2=P3=0xff;

  /*      .						*/
  bMode=1;

  /*    EEPROM    .								*/
  WMCON|=EEMEN|EEMWE;

  /*      .				*/
  IE=0x00;
  Init_Sys_Timer();
  Init_UART();
  EA=1;

  /*       50 .					*/
  Start_Time_Out(5); while(!Time_Out_End) PCON|=IDL;

  /*     .									*/
  LCD_Backlight(OFF);
  Init_LCD();
  sprintf(&String, &Title_0); Write_String_To_LCD(&String);
  LCD_Backlight(ON);

  /*      .												*/
  bConnect=0;

  /*      .							*/
  Left_Key_Prev_State=Left_Key;
  Right_Key_Prev_State=Right_Key;
  Enter_Key_Prev_State=Enter_Key;

  /*   3       .			*/
  /*        K-Line	 	*/
  /*   .     		*/
  /*  ,    ,      .*/
  Start_Time_Out(150); while(!Time_Out_End) PCON|=IDL;
  Start_Time_Out(150); while(!Time_Out_End) PCON|=IDL;

  /*--------------------------------------------------------------------*/
  /* 							  .								*/
  /*--------------------------------------------------------------------*/
  for(;;)
     {
       /*---------------------------------------------------------------*/
       /*		      100 .				*/
       /*---------------------------------------------------------------*/
		 Start_Time_Out(10); while(!Time_Out_End) PCON|=IDL;

       /*---------------------------------------------------------------*/
       /*			    ,  .					*/
       /*---------------------------------------------------------------*/
		 if(!bConnect)
         {
           /*  testerPresent    .			*/
		     Message[0]=0x3e; Message[1]=0x01; Start_UART_Tx(2);
		     while(!UART_Ready) PCON|=IDL;

		     /*   100     .	*/
			  Start_Time_Out(10);	//  -  .
			  while(!Time_Out_End)
				 {
	  		      Start_UART_Rx();	//     .
               while((!Time_Out_End) && (!UART_Ready))	PCON|=IDL;

			      /*       .			*/
		         if((UART_Ready) && (Message[0] == 0x7e))
		           {
		             /*     testerPresent.		*/
		             Stop_Time_Out;	//   -.
		             bConnect=1;		//    .
		             ErrCntr=0;			//   .
		             break;
		           }
             }

           if(Time_Out_End) 
             {
               /*  testerPresent    .		*/
			      /*   " ".										*/
			      sprintf(&String, &Title_1); Write_String_To_LCD(&String);

			      /*     startCommunication.	*/
               /*    Wake-Up .						*/
		         TXD=0;    					//   30 .
				   Start_Time_Out(3);  while(!Time_Out_End) PCON|=IDL;
               TXD=1;    					//   150 .
					Start_Time_Out(15); while(!Time_Out_End) PCON|=IDL;
    
               /*      startCommunication.	*/
               Message[0]=0x81; Start_UART_Tx(1);
               while(!UART_Ready) PCON|=IDL;

				   /*    ,    		*/
				   /*   testerPresent   .			*/
			    }
			  continue;
         }

       /*---------------------------------------------------------------*/
       /*      readDataByLocalIndentifier.    */
       /*---------------------------------------------------------------*/
       if((bConnect) && (bMode))
         {
           /*     readDataByLocalIndentifier.*/
		     Message[0]=0x21; Message[1]=0x01; Start_UART_Tx(2);
		     while(!UART_Ready) PCON|=IDL;

		     /*   200     .	*/
			  Start_Time_Out(20);  	//  -  .
			  while(!Time_Out_End)
				 {
			  		Start_UART_Rx();	//     .
		     		while((!Time_Out_End) && (!UART_Ready)) PCON|=IDL;

			      /*       .			*/
               if((UART_Ready) && (Message[0] == 0x61) && (Message[1] == 0x01))
                 {
                   /*     .				*/
						 Stop_Time_Out; //   -.
                   ErrCntr=0;		 //    .
                
                   /*        nParam.	*/
					    LCD_Clear;
					    switch(nParam)
					      {
					        case 1:
					          {
								   //      .
		                     sprintf(&String, &Title_3, (unsigned char)Message[12]);
		                     Write_String_To_LCD(&String);
					            break;
					          }

					        case 2:
					          {
								   //      .
                           sprintf(&String, &Title_2, (signed char)Message[10]-40);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 3:
					          {
								   //     .
                           sprintf(&String, &Title_4, ((unsigned int)Message[13])*40);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 4:
					          {                      
								   //       .
                           sprintf(&String, &Title_5, ((unsigned int)Message[21])*10);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 5:
					          {
								   //      .
                           sprintf(&String, &Title_8, (unsigned char)Message[18]>>1);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 6:
					          {
								   //     .
                           sprintf(&String, &Title_9, (unsigned char)Message[19]);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 7:
					          {
								   //       ..
                           sprintf(&String, &Title_6, (unsigned char)Message[16]);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 8:
					          {
								   //       ..
                           sprintf(&String, &Title_7, (unsigned char)Message[15]);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 9:
					          {
								   //      .
                           sprintf(&String, &Title_10, ((unsigned char)Message[20]/20)+5);
								   Write_String_To_LCD(&String);
					            break;
					          }

					        case 10:
					          {
								   //      .
                           sprintf(&String, &Title_11,
                             (((unsigned int)Message[23]<<8)|(unsigned char)Message[22])/125);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 11:
					          {
								   //      .
                           sprintf(&String, &Title_12,
                              (((unsigned int)Message[25]<<8)|(unsigned char)Message[24])/10);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 12:
					          {
								   //      .
                           sprintf(&String, &Title_13,
                              (((unsigned int)Message[29]<<8)|(unsigned char)Message[28])/50);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 13:
					          {
								   //      .
									if(((((unsigned int)Message[31]<<8)|(unsigned char)Message[30])/128) < 50)
									  {
									    //       .
                              sprintf(&String, &Title_141,
                                   (((unsigned int)Message[31]<<8)|(unsigned char)Message[30])/128);
                             }
                           else
                             {
                               //    ,     .
                               sprintf(&String, &Title_142);
                             }
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 14:
					          {
								   //      .
								   if((Message[5]&0x20) != 0x00)
                              sprintf(&String, &Title_151);
                           else
                              sprintf(&String, &Title_152);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 15:
					          {
								   //      .
								   if((Message[4]&0x08) != 0x00)
                              sprintf(&String, &Title_161);
                           else
                              sprintf(&String, &Title_162);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 16:
					          {
								   //      .
								   if((Message[4]&0x02) != 0x00)
                              sprintf(&String, &Title_171);
                           else
                              sprintf(&String, &Title_172);
									Write_String_To_LCD(&String);
					            break;
					          }

					        case 17:
					          {
								   //       .
								   if((Message[4]&0x04) != 0x00)
                              sprintf(&String, &Title_181);
                           else
                              sprintf(&String, &Title_182);
									Write_String_To_LCD(&String);
					            break;
					          }

					        //     -    1.
					        default: nParam=1;
					      }
		             break;
                 }
			    }

           if(Time_Out_End)
             {
               /*      .				*/
               /*      -  .	*/
			      if(++ErrCntr >= 3) bConnect=0;
			    }

           /*      .    								*/
           /*   ""   "".				*/
           if((!Left_Key) && (Left_Key_Prev_State))
             {
               /*    "".							*/
               /*       .*/
			      if(nParam-1 == 0) nParam=17;
			      else nParam--;
             }
           Left_Key_Prev_State=Left_Key;

           /*   ""   "".			*/
           if((!Right_Key) && (Right_Key_Prev_State))
             {
               /*    "".							*/
               /*       .*/
			      if(nParam+1 == 18) nParam=1;
			      else nParam++;
             }
           Right_Key_Prev_State=Right_Key;

           /*   ""    .			*/
           if((!Enter_Key) && (Enter_Key_Prev_State))
             {
               /*    "".							*/
					bMode=0;
             }
           Enter_Key_Prev_State=Enter_Key;
         }

       /*---------------------------------------------------------------*/
       /*     readDiagnosticTroublesCodesByStatus.     */
       /*---------------------------------------------------------------*/
       if((bConnect) && (!bMode))
         {
           /*     read...TroublesCodes...		*/
           Message[0]=0x18; Message[1]=0x00; Message[2]=0x00;
           Message[3]=0x00; Start_UART_Tx(4);
           while(!UART_Ready) PCON|=IDL;

		     /*   200     .	*/
			  Start_Time_Out(20);  	//  -  .
			  while(!Time_Out_End)
				 {
			  		Start_UART_Rx();	//     .
		     		while((!Time_Out_End) && (!UART_Ready)) PCON|=IDL;

			      /*       .			*/
               if((UART_Ready) && (Message[0] == 0x58))
                 {
                   /*     .				*/
						 Stop_Time_Out; //   -.
                   break;
                 }
             }

           if(Time_Out_End)
             {
               /*      .				*/
               /*       .*/
			      bConnect=0;
			    }
			  else
			    {
			      /*      .	*/
			      LCD_Clear;
			      sprintf(&String, &Title_19, Message[1]);
			      Write_String_To_LCD(&String);

					/*    "".							*/
					while(!Enter_Key); Enter_Key_Prev_State=Enter_Key;

               ErrCntr=1;
               while(Enter_Key)
                 {
                   Start_Time_Out(10); while(!Time_Out_End) PCON|=0x01;
                   if(Message[1] != 0)
                     {
                       LCD_Clear;
                       sprintf(&String, &Title_20, ErrCntr, Message[2+(ErrCntr-1)*3], Message[3+(ErrCntr-1)*3]);
                       Write_String_To_LCD(&String);
                     }

                   if((!Left_Key) && (Left_Key_Prev_State))
                     {
                       /*    "".							*/
                       if(--ErrCntr <= 0) ErrCntr=Message[1];
                     }
                   Left_Key_Prev_State=Left_Key;

                   if((!Right_Key) && (Right_Key_Prev_State))
                     {
                       /*    "".							*/
                       if(++ErrCntr > Message[1]) ErrCntr=1;
                     }
                   Right_Key_Prev_State=Right_Key;

                   if((!Enter_Key) && (Enter_Key_Prev_State)) break;
                 }
			      bMode=1;
			    }
		   }
     }
  return;
}










