; /*************************************************************************/
; /*								       														*/
; /*		         .				*/
; /*																								*/
; /*************************************************************************/

						NAME    SYS_TIMER_DRIVER

SYS_TIMER_DRIVER	SEGMENT	CODE
SYS_TIMER_DATA		SEGMENT	DATA
SYS_TIMER_FLAG		SEGMENT	BIT

						PUBLIC  Init_Sys_Timer
						PUBLIC  _Start_Time_Out
						PUBLIC  Time_Out_End


TCON   				DATA    088H			;  .
TMOD   				DATA    089H			;   .
TL0    				DATA    08AH			;    .
TH0    				DATA    08CH			;    .
IE     				DATA    0A8H			;   .

TR0    				BIT     08CH			;    0.
TF0    				BIT     08DH			;    0.
ET0    				BIT     0A9H			;      0.
EA						BIT	  0AFH			;    .


						CSEG	AT	0000BH		;     0.
						LJMP	Sys_Timer


						RSEG  SYS_TIMER_FLAG
Time_Out_End:		DBIT	1					;    .

						RSEG  SYS_TIMER_DATA
Sys_Timer_nTick:	DS    1					;    10  .

						RSEG	SYS_TIMER_DRIVER
						USING   0

; /*************************************************************************/
; /*								       														*/
; /*			 	   .						*/
; /*																								*/
; /* void Init_Sys_Timer(void)															*/
; /* :		  .												*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
Init_Sys_Timer:
		  CLR		 TR0					;  .
		  CLR		 TF0					;   .
		  CLR		 Time_Out_End		;    .
		  
		  ANL		 TMOD,#0F0H			;  0   1.
		  ORL		 TMOD,#001H

		  SETB	 ET0					;    0 .
		  
		  RET


; /*************************************************************************/
; /*																								*/
; /*        0 -   10 .   */
; /*																								*/
; /*************************************************************************/
Sys_Timer:

  ;      .
        PUSH    ACC
        PUSH    PSW

  ;   .
        CLR     TR0

  ;   10   ?
        MOV     A,Sys_Timer_nTick
		  JZ		 End_Time_Out

  ;   10    .
  ;      .
        DEC     Sys_Timer_nTick
        MOV     TH0,#0D8H
        MOV     TL0,#0F0H
        SETB    TR0
		  SJMP	 Sys_Timer_End

  ;   10   .
  ;      .
End_Time_Out:
        SETB    Time_Out_End

  ;      .
Sys_Timer_End:
        POP     PSW
        POP     ACC
        RETI    


; /*************************************************************************/
; /*								       														*/
; /*							    -.							*/
; /*																								*/
; /* void Start_Time_Out(unsigned char )												*/
; /* :		    10  .		*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
_Start_Time_Out:
		  CLR		 EA

  ;   .
        DEC     R7
        MOV     Sys_Timer_nTick,R7

  ;        10 .
        MOV     TH0,#0D8H
        MOV     TL0,#0F0H

  ;     .
        CLR     Time_Out_End

  ;   .
  		  CLR		 TF0
        SETB    TR0

		  SETB	 EA
        RET     


; /*************************************************************************/
         END












































