; /*************************************************************************/
; /*								       														*/
; /*	            K-Line.				*/
; /*																								*/
; /*************************************************************************/

						NAME    UART_DRIVER

UART_DRIVER			SEGMENT	CODE
UART_DATA			SEGMENT	DATA
UART_IDATA			SEGMENT	IDATA
UART_FLAG			SEGMENT	BIT

        				PUBLIC  Message
						PUBLIC  Init_UART
						PUBLIC  UART_Ready
        				PUBLIC  Start_UART_Rx
        				PUBLIC  _Start_UART_Tx


TCON   				DATA    088H			;  .
TMOD   				DATA    089H			;   .
TL1    				DATA    08BH			;     .
TH1    				DATA    08DH			;     .
PCON					DATA    087H			;      UART.
SCON					DATA    098H			;   UART.
SBUF					DATA    099H			;   UART.
IE     				DATA    0A8H			;   .

TR1    				BIT     08EH			;    1.
TF1    				BIT     08FH			;    1.
RI     				BIT     098H			;     UART.
TI     				BIT     099H			;     UART.
REN    				BIT     09CH			;    UART.
ET1    				BIT     0ABH			;      1.
ES     				BIT     0ACH			;     UART.
EA						BIT	  0AFH			;    .


						CSEG  AT	00023H		;    UART.
				      LJMP    UART

						RSEG  UART_FLAG
UART_Ready:			DBIT	1					;   UART.

						RSEG  UART_DATA
Message_Ptr:		DS    1					;      .
Message_Len:		DS		1					;  .

						RSEG  UART_IDATA
Message:				DS    100				;  -.

						RSEG	UART_DRIVER
						USING   0


; /*************************************************************************/
; /*								       														*/
; /*			 	   .				*/
; /*																								*/
; /* void Init_UART(void)																	*/
; /* :		  .												*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
Init_UART:
  ;    1   .
		  CLR		 TR1					;  .
		  CLR		 TF1					;   .
		  
		  ANL		 TMOD,#00FH			;  1   2.
		  ORL		 TMOD,#020H

		  MOV		 TL1,#253			;   10400 /.
		  MOV		 TH1,#253

		  CLR	 	 ET1					;    1 .

  ;       .
  		  ANL		 PCON,#0EFH			; SMOD = 0.
		  MOV		 SCON,#060H			;  1,  .
		  SETB	 ES					;   UART .

  ;  ,   UART.
  		  SETB	 TR1
		  
		  RET


; /************************************************************************/
; /*																							  */
; /*              .          */
; /*																							  */
; /* void UART(void) interrupt 4														  */
; /*																							  */
; /************************************************************************/
UART:
  ;      .
		  PUSH	 PSW
        PUSH    ACC
        PUSH    B
        MOV		 A,R0
        PUSH	 ACC
        MOV		 A,R1
        PUSH	 ACC

  ;    -   .
is_Tx:  JB      TI,Transmitter_Irq
is_Rx:  JB      RI,Receiver_Irq
		  AJMP	 UART_End

  ; ------------------------------------------------------
  ;    UART.
Transmitter_Irq:
        CLR     TI			;   .

        MOV     A,Message_Len
        JNZ     Transmit_Next_Byte

  ;  .    UART.
        SETB    UART_Ready
        SJMP    is_Rx

  ;   .   .
Transmit_Next_Byte:
        MOV     R0,Message_Ptr
        INC     Message_Ptr			;  .
        DEC     Message_Len			;   .
        MOV     SBUF,@R0				;   .
        SJMP	 is_Rx

  ; ------------------------------------------------------
  ;    UART.
Receiver_Irq:
        CLR     RI						;   .

  ;     .
        MOV     R0,Message_Ptr
        MOV     @R0,SBUF        
        INC     Message_Ptr
        INC     Message_Len

  ; ,    .
        MOV     A,Message_Len
        CJNE    A,#005H,$+3
        JC      UART_End

  ;    .
  ;    (3  4 ).
        MOV     R0,#Message
        MOV     A,@R0
        ANL     A,#03FH
        JZ      Four_Byte_Header_Receive

  ;     .
  ;       0 - 5  0.
  ;    4 .
Three_Byte_Header_Receive:
		  ADD		 A,#004H			;   .
		  SJMP	 is_All_Bytes_Receive

  ;     .
  ;         3.
  ;    5 .
Four_Byte_Header_Receive:
		  MOV		 R0,#Message+003H
		  MOV		 A,@R0
		  ADD		 A,#005H			;   .

  ; ,    .  
is_All_Bytes_Receive:
		  CJNE	 A,Message_Len,UART_End

  ;    .
All_Bytes_Receive:
  ;       .
  ;   0xf1 -  .
        MOV     R0,#Message+01H
        CJNE    @R0,#0F1H,Ignore_Message
  ;   0x10 -   .
        MOV     R0,#Message+02H
        CJNE    @R0,#010H,Ignore_Message

  ;   -   .
  ;     .
  		  MOV		 B,Message_Len
  		  DEC		 B					;     .
        MOV     R0,#Message	;    .
        CLR		 A
Computate_CRC:
        ADD     A,@R0
		  INC		 R0
		  DJNZ	 B,Computate_CRC

  ;      .
  		  MOV		 B,@R0			;   .
		  CJNE	 A,B,Bad_CRC	;    .

  ;   .
  ;       .
  ;    (3  4 ).
        MOV     R0,#Message
        MOV     A,@R0
        ANL     A,#03FH
        JZ      Four_Byte_Header_Copy_Data

  ;     
  ;     .
Three_Byte_Header_Copy_Data:
		  MOV		 R0,#Message+003H
		  MOV		 A,Message_Len
		  ADD		 A,#-4
		  MOV		 B,A			;    .
		  SJMP	 Copy_Data

  ;     
  ;     .
Four_Byte_Header_Copy_Data:
		  MOV		 R0,#Message+004H
		  MOV		 A,Message_Len
		  ADD		 A,#-5
		  MOV		 B,A			;    .

Copy_Data:
		  MOV		 R1,#Message
Copy_Data_Loop:
		  MOV		 A,@R0
		  MOV		 @R1,A
		  INC		 R0
		  INC		 R1
		  DJNZ	 B,Copy_Data_Loop

  ;  .    UART.
        CLR     REN
        SETB    UART_Ready
        SJMP    UART_End

  ;     .
  ;      .
Bad_CRC:
		  CLR		 REN
		  CLR		 UART_Ready
		  SJMP	 UART_End

  ;      .
Ignore_Message:
		  MOV		 Message_Ptr,#Message
		  MOV		 Message_Len,#00

  ;     .
UART_End:
		  POP		 ACC
		  MOV		 R1,A
		  POP		 ACC
		  MOV		 R0,A
        POP     B
        POP     ACC
        POP		 PSW
        RETI    


; /*************************************************************************/
; /*								       														*/
; /*		               UART.							*/
; /*																								*/
; /* void Start_UART_Tx(char )															*/
; /* :		  .								*/
; /*					       						*/
; /* 					     Message   .						*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
_Start_UART_Tx:
		  CLR		 EA					;  .

  ;        95 .
  ; -     128 ,       100 .
		  CJNE	 R7,#96,$+3
		  JNC		 Start_UART_Tx_End

  ;     95 .
  ;       .
  		  MOV		 A,#Message
  		  ADD		 A,R7
  		  DEC		 A
  		  MOV		 R1,A					;      .
  		  
  		  CJNE	 R7,#31,$+3			;   =  .
  		  JC		 $+6
		  ADD		 A,#004				;   4-  .
		  SJMP	 $+4
		  ADD		 A,#003				;   3-  .
		  MOV		 R0,A					;   .

		  MOV		 B,R7					;   .
Shift_Data_Field_Loop:
		  MOV		 A,@R1				;  .
		  MOV		 @R0,A			   ;  .
		  DEC		 R0
		  DEC		 R1
		  DJNZ	 B,Shift_Data_Field_Loop

  ;   .
		  CJNE	 R7,#31,$+3
		  JC		 $+5
		  MOV		 A,R7					;  4-   
		  MOV		 @R0,A				;    4- .
		  DEC		 R0

		  MOV		 A,#0F1H				;   - .
		  MOV		 @R0,A
		  DEC		 R0

		  MOV		 A,#010H				;   - .
		  MOV		 @R0,A
		  DEC		 R0

		  CJNE	 R7,#31,$+3
		  JC		 $+5
		  CLR		 A						;  4-   
		  SJMP	 $+3					;      .
		  MOV		 A,R7					;  3-   
											;     .
		  ORL		 A,#080H
		  MOV		 @R0,A

  ;         .
		  MOV		 A,R7					;      ..
		  CJNE	 R7,#31,$+3
		  JC		 $+6
		  ADD		 A,#004
		  SJMP	 $+4
		  ADD		 A,#003
		  MOV		 B,A					;     .
		  MOV		 R7,A					;   .

		  MOV		 R0,#Message
		  CLR		 A
Computate_CRC_Loop:
		  ADD		 A,@R0
		  INC		 R0
		  DJNZ	 B,Computate_CRC_Loop
		  MOV		 @R0,A				;  CRC.

Start_Transmitter:
		  CLR		 TI					;   .
        CLR     REN					;    .
        CLR     UART_Ready			;    UART.

        MOV     R0,#Message		;  .
        MOV     SBUF,@R0

		  INC		 R0					;    .
		  MOV		 Message_Ptr,R0
		  
        MOV     Message_Len,R7	;     .


Start_UART_Tx_End:
		  SETB	 EA
        RET     


; /*************************************************************************/
; /*								       														*/
; /*		               UART.							*/
; /*																								*/
; /* void Start_UART_Rx(void)																*/
; /* :		  .												*/
; /* :		  .											*/
; /*								       														*/
; /*************************************************************************/
Start_UART_Rx:

		  CLR		 EA

		  CLR		 RI								;   .
        MOV     Message_Ptr,#Message		;    .
        MOV		 Message_Len,#00				;    .
        CLR     UART_Ready						;    UART.
        SETB    REN								;    UART.

		  SETB	 EA
        RET     

; /*************************************************************************/
        END



































