; /******************************************************************************/
; /*										*/
; /*		     		 .				*/
; /*										*/
; /******************************************************************************/

			NAME    KEYBOARD_DRIVER

KEYBOARD_CODE		SEGMENT	CODE
KEYBOARD_DATA		SEGMENT	DATA
KEYBOARD_BIT		SEGMENT	BIT


			PUBLIC	Scan_Keyboard
			PUBLIC  Init_Keyboard
			PUBLIC  Left_Key_State
			PUBLIC  Right_Key_State
			PUBLIC  Enter_Key_State
			PUBLIC	Mode_Key_State


   ;----------------------------------------------------------------------------;
   ;     .		;
Left_Key_Port		BIT	P0.0	;   "".			;
Right_Key_Port		BIT	P0.1	;   "".			;
Enter_Key_Port		BIT	P0.2	;   "".			;
Mode_Key_Port		BIT	P0.3	;   "".			;
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
   ;       .			;
   ; = "0" -      .				;
			RSEG  KEYBOARD_BIT
Left_Key_Prev_State:	DBIT	1	;    "".	;
Right_Key_Prev_State:	DBIT	1	;    "".	;
Enter_Key_Prev_State:	DBIT	1	;    "".	;
Mode_Key_Prev_State:	DBIT	1	;    "".	;
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
   ;   ,    .			;
   ;   enum KEY_STATE.						;
			RSEG  KEYBOARD_DATA
Left_Key_State:		DS	1	;    "".	;
Right_Key_State:	DS	1	;    "".	;
Enter_Key_State:	DS	1	;    "".	;
Mode_Key_State:		DS	1	;    "".	;
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
   ;   .						;
   ;  enum KEY_STATE.						;
KEY_NO_CHANGE		EQU	0	;    .	;
KEY_PRESSED		EQU	1	;   .			;
KEY_RELEASED		EQU	2	;   .			;
KEY_LONG_PRESSED	EQU	3	;   .		;
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
   ;      .			 	;
   ;    - 15*100  = 1,5 .			;
			RSEG  KEYBOARD_DATA
Left_Key_Pressed_Counter:	DS	1	;    "".
Right_Key_Pressed_Counter:	DS	1	;    "".
Enter_Key_Pressed_Counter:	DS	1	;    "".
Mode_Key_Pressed_Counter:	DS	1	;    "".
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
			RSEG	KEYBOARD_CODE
			USING   0


; /******************************************************************************/
; /*								       		*/
; /*		        .		*/
; /*										*/
; /* void Init_Keyboard(void)							*/
; /* :		  .					*/
; /* :	  .					*/
; /*										*/
; /******************************************************************************/
Init_Keyboard:

   ;       .				;
        SETB    Left_Key_Port
        SETB    Right_Key_Port
        SETB    Enter_Key_Port
        SETB    Mode_Key_Port

   ;     (  ,   ).	;
	SETB	Left_Key_Prev_State
	SETB	Right_Key_Prev_State
	SETB	Enter_Key_Prev_State
	SETB	Mode_Key_Prev_State

	MOV	A,#KEY_NO_CHANGE
   	MOV	Left_Key_State,A
     	MOV	Right_Key_State,A
   	MOV	Enter_Key_State,A
   	MOV	Mode_Key_State,A
	  
	RET


; /******************************************************************************/
; /*										*/
; /*                  .   		*/
; /*	              100   .		*/
; /*										*/
; /******************************************************************************/
Scan_Keyboard:
        PUSH    ACC

   ;----------------------------------------------------------------------------;
   ; ,     "".				;
is_Left_Key:
	JNB	Left_Key_Port,Left_Key_Pressed

   ;  ""  .							;
Left_Key_Not_Pressed:
	JB	Left_Key_Prev_State,Left_Key_Save_State
   ;  ""          .	;
   ;     "KEY_RELEASED".				;
	MOV	Left_Key_State,#KEY_RELEASED
	SJMP	Left_Key_Save_State

   ;  "" .							;
Left_Key_Pressed:
	JNB	Left_Key_Prev_State,Left_Key_Pressed_Counter_Inc
   ;  ""          .	;
   ;     "KEY_PRESSED".				;
	MOV	Left_Key_State,#KEY_PRESSED
	MOV	Left_Key_Pressed_Counter,#15-2	;    -2.
	SJMP	Left_Key_Save_State

   ;  ""         .		;
Left_Key_Pressed_Counter_Inc:
   ;      "".			;
	MOV	A,Left_Key_Pressed_Counter
	JZ	$+6
   ;      ""			;
	DEC	Left_Key_Pressed_Counter
	SJMP	Left_Key_Save_State
   ;     "KEY_LONG_PRESSED".			;
	MOV	Left_Key_State,#KEY_LONG_PRESSED

   ;    "".						;
Left_Key_Save_State:
	MOV	C,Left_Key_Port
	MOV	Left_Key_Prev_State,C

   ;----------------------------------------------------------------------------;
   ; ,     "".				;
is_Right_Key:
	JNB	Right_Key_Port,Right_Key_Pressed

   ;  ""  .							;
Right_Key_Not_Pressed:
	JB	Right_Key_Prev_State,Right_Key_Save_State
   ;  ""          .	;
   ;     "KEY_RELEASED".				;
	MOV	Right_Key_State,#KEY_RELEASED
	SJMP	Right_Key_Save_State

   ;  "" .							;
Right_Key_Pressed:
	JNB	Right_Key_Prev_State,Right_Key_Pressed_Counter_Inc
   ;  ""          .	;
   ;     "KEY_PRESSED".				;
	MOV	Right_Key_State,#KEY_PRESSED
	MOV	Right_Key_Pressed_Counter,#15-2	;    -2.
	SJMP	Right_Key_Save_State

   ;  ""         .		;
Right_Key_Pressed_Counter_Inc:
   ;      "".			;
	MOV	A,Right_Key_Pressed_Counter
	JZ	$+6
   ;      ""			;
	DEC	Right_Key_Pressed_Counter
	SJMP	Right_Key_Save_State
   ;     "KEY_LONG_PRESSED".			;
	MOV	Right_Key_State,#KEY_LONG_PRESSED

   ;    "".					;
Right_Key_Save_State:
	MOV	C,Right_Key_Port
	MOV	Right_Key_Prev_State,C

   ;----------------------------------------------------------------------------;
   ; ,     "".				;
is_Enter_Key:
	JNB	Enter_Key_Port,Enter_Key_Pressed

   ;  ""  .							;
Enter_Key_Not_Pressed:
	JB	Enter_Key_Prev_State,Enter_Key_Save_State
   ;  ""          .	;
   ;     "KEY_RELEASED".				;
	MOV	Enter_Key_State,#KEY_RELEASED
	SJMP	Enter_Key_Save_State

   ;  "" .							;
Enter_Key_Pressed:
	JNB	Enter_Key_Prev_State,Enter_Key_Pressed_Counter_Inc
   ;  ""          .	;
   ;     "KEY_PRESSED".				;
	MOV	Enter_Key_State,#KEY_PRESSED
	MOV	Enter_Key_Pressed_Counter,#15-2	;    -2.
	SJMP	Enter_Key_Save_State

   ;  ""         .		;
Enter_Key_Pressed_Counter_Inc:
   ;      "".			;
	MOV	A,Enter_Key_Pressed_Counter
	JZ	$+6
   ;      ""			;
	DEC	Enter_Key_Pressed_Counter
	SJMP	Enter_Key_Save_State
   ;     "KEY_LONG_PRESSED".			;
	MOV	Enter_Key_State,#KEY_LONG_PRESSED

   ;    "".						;
Enter_Key_Save_State:
	MOV	C,Enter_Key_Port
	MOV	Enter_Key_Prev_State,C

   ;----------------------------------------------------------------------------;
   ; ,     "".				;
is_Mode_Key:
	JNB	Mode_Key_Port,Mode_Key_Pressed

   ;  ""  .							;
Mode_Key_Not_Pressed:
	JB	Mode_Key_Prev_State,Mode_Key_Save_State
   ;  ""          .	;
   ;     "KEY_RELEASED".				;
	MOV	Mode_Key_State,#KEY_RELEASED
	SJMP	Mode_Key_Save_State

   ;  "" .							;
Mode_Key_Pressed:
	JNB	Mode_Key_Prev_State,Mode_Key_Pressed_Counter_Inc
   ;  ""          .	;
   ;     "KEY_PRESSED".				;
	MOV	Mode_Key_State,#KEY_PRESSED
	MOV	Mode_Key_Pressed_Counter,#15-2	;    -2.
	SJMP	Mode_Key_Save_State

   ;  ""         .		;
Mode_Key_Pressed_Counter_Inc:
   ;      "".			;
	MOV	A,Mode_Key_Pressed_Counter
	JZ	$+6
   ;      ""			;
	DEC	Mode_Key_Pressed_Counter
	SJMP	Mode_Key_Save_State
   ;     "KEY_LONG_PRESSED".			;
	MOV	Mode_Key_State,#KEY_LONG_PRESSED

   ;    "".						;
Mode_Key_Save_State:
	MOV	C,Mode_Key_Port
	MOV	Mode_Key_Prev_State,C

Keyboard_End:
        POP     ACC
        RET


; /******************************************************************************/
        END

