/********************************************************************************/
/*                                                                              */
/*                       .                    */
/*                                                                              */
/********************************************************************************/
#ifndef _KEYBOARD_DRIVER_H
#define _KEYBOARD_DRIVER_H


/*------------------------------------------------------------------------------*/
/*    .                                       */
/*------------------------------------------------------------------------------*/
enum KEY_STATE
  {
    KEY_NO_CHANGE       = 0,    //    .
    KEY_PRESSED         = 1,    //   .
    KEY_RELEASED        = 2,    //   .
    KEY_LONG_PRESSED    = 3     //     1,5 .
  };

/*------------------------------------------------------------------------------*/
/*    .					        */
/*------------------------------------------------------------------------------*/
extern enum KEY_STATE Left_Key_State;
extern enum KEY_STATE Right_Key_State;
extern enum KEY_STATE Enter_Key_State;
extern enum KEY_STATE Mode_Key_State;

/*------------------------------------------------------------------------------*/
/*    .					*/
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
void Init_Keyboard(void);

/*------------------------------------------------------------------------------*/
/*     "".                                */
/* :     .                                            */
/* :  TRUE,   ""  .                          */
/*------------------------------------------------------------------------------*/
#define is_Left_Key_Pressed() (Left_Key_State == KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                             */
/* :     .                                            */
/* :  TRUE,   ""   .                       */
/*------------------------------------------------------------------------------*/
#define is_Left_Key_Not_Pressed() (Left_Key_State != KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                             */
/* :     .                                            */
/* :  TRUE,   ""  .                        */
/*------------------------------------------------------------------------------*/
#define is_Left_Key_Released() (Left_Key_State == KEY_RELEASED)

/*------------------------------------------------------------------------------*/
/*     "".                              */
/* :     .                                            */
/* :  TRUE,   "" .                         */
/*------------------------------------------------------------------------------*/
#define is_Left_Key_Long_Pressed() (Left_Key_State == KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                           */
/* :     .                                            */
/* :  TRUE,   ""  .                      */
/*------------------------------------------------------------------------------*/
#define is_Left_Key_Not_Long_Pressed() (Left_Key_State != KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                                */
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
#define Reset_Left_Key_State() Left_Key_State=KEY_NO_CHANGE

/*------------------------------------------------------------------------------*/
/*     "".                               */
/* :     .                                            */
/* :  TRUE,   ""  .                         */
/*------------------------------------------------------------------------------*/
#define is_Right_Key_Pressed() (Right_Key_State == KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                            */
/* :     .                                            */
/* :  TRUE,   ""   .                      */
/*------------------------------------------------------------------------------*/
#define is_Right_Key_Not_Pressed() (Right_Key_State != KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                            */
/* :     .                                            */
/* :  TRUE,   ""  .                       */
/*------------------------------------------------------------------------------*/
#define is_Right_Key_Released() (Right_Key_State == KEY_RELEASED)

/*------------------------------------------------------------------------------*/
/*     "".                             */
/* :     .                                            */
/* :  TRUE,   "" .                        */
/*------------------------------------------------------------------------------*/
#define is_Right_Key_Long_Pressed() (Right_Key_State == KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                          */
/* :     .                                            */
/* :  TRUE,   ""  .                     */
/*------------------------------------------------------------------------------*/
#define is_Right_Key_Not_Long_Pressed() (Right_Key_State != KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                               */
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
#define Reset_Right_Key_State() Right_Key_State=KEY_NO_CHANGE

/*------------------------------------------------------------------------------*/
/*     "".                                */
/* :     .                                            */
/* :  TRUE,   ""  .                          */
/*------------------------------------------------------------------------------*/
#define is_Enter_Key_Pressed() (Enter_Key_State == KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                             */
/* :     .                                            */
/* :  TRUE,   ""   .                       */
/*------------------------------------------------------------------------------*/
#define is_Enter_Key_Not_Pressed() (Enter_Key_State != KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                             */
/* :     .                                            */
/* :  TRUE,   ""  .                        */
/*------------------------------------------------------------------------------*/
#define is_Enter_Key_Released() (Enter_Key_State == KEY_RELEASED)

/*------------------------------------------------------------------------------*/
/*     "".                              */
/* :     .                                            */
/* :  TRUE,   "" .                         */
/*------------------------------------------------------------------------------*/
#define is_Enter_Key_Long_Pressed() (Enter_Key_State == KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                           */
/* :     .                                            */
/* :  TRUE,   ""  .                      */
/*------------------------------------------------------------------------------*/
#define is_Enter_Key_Not_Long_Pressed() (Enter_Key_State != KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                                */
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
#define Reset_Enter_Key_State() Enter_Key_State=KEY_NO_CHANGE

/*------------------------------------------------------------------------------*/
/*     "".                                */
/* :     .                                            */
/* :  TRUE,   ""  .                          */
/*------------------------------------------------------------------------------*/
#define is_Mode_Key_Pressed() (Mode_Key_State == KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                             */
/* :     .                                            */
/* :  TRUE,   ""   .                       */
/*------------------------------------------------------------------------------*/
#define is_Mode_Key_Not_Pressed() (Mode_Key_State != KEY_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                             */
/* :     .                                            */
/* :  TRUE,   ""  .                        */
/*------------------------------------------------------------------------------*/
#define is_Mode_Key_Released() (Mode_Key_State == KEY_RELEASED)

/*------------------------------------------------------------------------------*/
/*     "".                              */
/* :     .                                            */
/* :  TRUE,   "" .                         */
/*------------------------------------------------------------------------------*/
#define is_Mode_Key_Long_Pressed() (Mode_Key_State == KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*      "".                           */
/* :     .                                            */
/* :  TRUE,   ""  .                      */
/*------------------------------------------------------------------------------*/
#define is_Mode_Key_Not_Long_Pressed() (Mode_Key_State != KEY_LONG_PRESSED)

/*------------------------------------------------------------------------------*/
/*     "".                                */
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
#define Reset_Mode_Key_State() Mode_Key_State=KEY_NO_CHANGE

/*------------------------------------------------------------------------------*/
#endif

