/********************************************************************************/
/*									        */
/*	  		   KEYWORD2000.	                        */
/*								       		*/
/********************************************************************************/
#include "keyword.h"

/*------------------------------------------------------------------------------*/
/*     .					*/
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Start_Communication(void)
{
  /*    Wake-Up .					*/
  TXD=0;        //   25 .
  Start_Time_Out(25/TIMER_TICK); while(is_Timer_Count()) IDLE();
  TXD=1;	//   25 .
  Start_Time_Out(25/TIMER_TICK); while(is_Timer_Count()) IDLE();

  /*      startCommunication.		        */
  Message[0]=0x81;
  Start_UART_Tx(1); while(is_UART_Tx_Busy()) IDLE();

  /*   100     .	                */
  Start_Time_Out(100/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0xc1))
        {
          /*     startCommunication.		        */
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

/*------------------------------------------------------------------------------*/
/*     .					        */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Tester_Present(void)
{
  /*     testerPresent     .  */
  Message[0]=0x3e; Message[1]=0x01;
  Start_UART_Tx(2); while(is_UART_Tx_Busy()) IDLE();

  /*   100     .	                */
  Start_Time_Out(100/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0x7e))
        {
          /*     testerPresent.		        */
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

/*------------------------------------------------------------------------------*/
/*      .				*/
/*        UART,       */
/*    2 (Message[2]  ).                                  */
/* :     .                                   */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Read_ECU_Identification(unsigned char ID_Option)
{
  /*     readECUIdentification.			*/
  Message[0]=0x1a; Message[1]=ID_Option;
  Start_UART_Tx(2); while(is_UART_Tx_Busy()) IDLE();

  /*   100     .	                */
  Start_Time_Out(100/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0x5a) && (Message[1] == ID_Option))
        {
          /*     testerPresent.		        */
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

/*------------------------------------------------------------------------------*/
/*      .				        */
/*        UART,                   */
/*    2 (Message[2]  ).                                  */
/* :      .                               */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Read_Data_By_Local_Identifier(unsigned char Data_Identifier)
{
  /*     readDataByLocalIdentifier.			*/
  Message[0]=0x21; Message[1]=Data_Identifier;
  Start_UART_Tx(2); while(is_UART_Tx_Busy()) IDLE();

  /*   150     .	                */
  Start_Time_Out(150/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0x61) && (Message[1] == Data_Identifier))
        {
          /*     testerPresent.		        */
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

/*------------------------------------------------------------------------------*/
/*         .	                */
/*        UART,            */
/*    1 (Message[1]  ).                                  */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Read_Diagnostic_Trouble_Codes(void)
{
  /*     readDiagnosticTroubleCodesByStatus.		*/
  Message[0]=0x18; Message[1]=0x00;
  Message[2]=0x00; Message[3]=0x00;
  Start_UART_Tx(4); while(is_UART_Tx_Busy()) IDLE();

  /*   100     .	                */
  Start_Time_Out(100/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0x58))
        {
          /*     readDiagnosticTroubleCodes.		*/
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

/*------------------------------------------------------------------------------*/
/*         .	                */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Clear_Diagnostic_Information(void)
{
  /*     clearDiagnosticInformation.		        */
  Message[0]=0x14; Message[1]=0x00; Message[2]=0x00;
  Start_UART_Tx(3); while(is_UART_Tx_Busy()) IDLE();

  /*   100     .	                */
  Start_Time_Out(100/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0x54))
        {
          /*     clearDiagnosticInformation.		*/
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

/*------------------------------------------------------------------------------*/
/*      .	                */
/* :     /;                      */
/*                ;                                    */
/*               ,    .      */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT
io_Control_By_Local_Identifier(unsigned char ioLocalIdentifier,
                               unsigned char ioControlParameter,
                               unsigned char ioControlState)
{
  /*     inputOutputControlByLocalIdentifier.        */
  Message[0]=0x30; Message[1]=ioLocalIdentifier;
  Message[2]=ioControlParameter; Message[3]=ioControlState;
  if((ioControlParameter == 0x00) || (ioControlParameter == 0x01))
        Start_UART_Tx(3);
  else  Start_UART_Tx(4);
  while(is_UART_Tx_Busy()) IDLE();

  /*   130     .	                */
  Start_Time_Out(130/TIMER_TICK);	//  -  .
  for(;;)
     {
      Start_UART_Rx();	//     .
      while((is_Timer_Count()) && (is_UART_Rx_Busy())) IDLE();
      if(is_Timer_Stopt())
        {
          //      .
          //       .
          return ERROR;
        }

      if((is_UART_Rx_Ready()) && (Message[0] == 0x70) &&
         (Message[1] == ioLocalIdentifier) &&  (Message[2] == ioControlParameter))
        {
          /*     inputOutputControlByLocalIdentifier.	*/
	  Stop_Time_Out;	//   -.
          return OK;
	}
    }
}

