/********************************************************************************/
/*                                                                              */
/*                       KEYWORD2000.                   */
/*                                                                              */
/********************************************************************************/
#ifndef _KEYWORD2000_DRIVER_H
#define _KEYWORD2000_DRIVER_H


#include "..\main\s8252.h"
#include "..\uart\uart.h"       //   UART   .
#include "..\timer\timer.h"     //     .

/*------------------------------------------------------------------------------*/
/*     KEYWORD2000.                          */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT
  {
    OK		= 0,	//     .
    ERROR       = 1	//      .
  };

/*------------------------------------------------------------------------------*/
/*     .					*/
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Start_Communication(void);

/*------------------------------------------------------------------------------*/
/*     .					        */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Tester_Present(void);

/*------------------------------------------------------------------------------*/
/*      .				*/
/*        UART,       */
/*    2 (Message[2]  ).                                  */
/* :     .                                   */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Read_ECU_Identification(unsigned char );

/*------------------------------------------------------------------------------*/
/*       .   */
/*   : M1V13O59.                                       */
/*        UART.       */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
#define Read_Vehicle_Manufacturer_ECU_Identifier() Read_ECU_Identification(0x9a)

/*------------------------------------------------------------------------------*/
/*      .				        */
/*        UART,                   */
/*    2 (Message[2]  ).                                  */
/* :      .                               */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Read_Data_By_Local_Identifier(unsigned char );

/*------------------------------------------------------------------------------*/
/*       .   */
/*   : M1V13O59.                                       */
/*        UART.       */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
#define Read_After_Sales_Service_Data() Read_Data_By_Local_Identifier(0x01)

/*------------------------------------------------------------------------------*/
/*      .              */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :    .                                 */
/*------------------------------------------------------------------------------*/
#define Get_THR() (Message[12])

/*------------------------------------------------------------------------------*/
/*     .                     */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :    .                               */
/*------------------------------------------------------------------------------*/
#define Get_TWAT() (signed char)Message[10]-40

/*------------------------------------------------------------------------------*/
/*    .                                   */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :    .                                    */
/*------------------------------------------------------------------------------*/
#define Get_FREQ() (unsigned int)(Message[13]*40)

/*------------------------------------------------------------------------------*/
/*       .                  */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :       .                   */
/*------------------------------------------------------------------------------*/
#define Get_FREQX() (unsigned int)(Message[14]*10)

/*------------------------------------------------------------------------------*/
/*        .         */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :        .          */
/*------------------------------------------------------------------------------*/
#define Get_JUFRXX() (unsigned int)(Message[21]*10)

/*------------------------------------------------------------------------------*/
/*      .                   */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :     .                             */
/*------------------------------------------------------------------------------*/
#define Get_UOZ() (Message[18]>>1)

/*------------------------------------------------------------------------------*/
/*      .                */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :     .                          */
/*------------------------------------------------------------------------------*/
#define Get_JSPEED() (Message[19])

/*------------------------------------------------------------------------------*/
/*      .                      */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :     .                                */
/*------------------------------------------------------------------------------*/
#define Get_FSM() (Message[16])

/*------------------------------------------------------------------------------*/
/*      .                     */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :     .                               */
/*------------------------------------------------------------------------------*/
#define Get_SSM() (Message[15])

/*------------------------------------------------------------------------------*/
/*      * 100.                   */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :     * 100.                             */
/*------------------------------------------------------------------------------*/
#define Get_JAUACC() ((unsigned int)(Message[20]*5))+520

/*------------------------------------------------------------------------------*/
/*     / * 100.            */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :    / * 100.                      */
/*------------------------------------------------------------------------------*/
#define Get_VALF() (((((unsigned int)Message[11])+128)*100)>>8)*147/10

/*------------------------------------------------------------------------------*/
/*    .    * 100.       */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :   .    * 100.                 */
/*------------------------------------------------------------------------------*/
#define Get_COEFFF() ((((unsigned int)Message[17])+128)*100)>>8

/*------------------------------------------------------------------------------*/
/*        * 100.       */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :       * 100.                 */
/*------------------------------------------------------------------------------*/
#define Get_JALAM() ((unsigned int)(Message[22]*125))>>8

/*------------------------------------------------------------------------------*/
/*        .          */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE    .                             */
/*------------------------------------------------------------------------------*/
#define is_Lambda_Present() (Message[2]&0x01)

/*------------------------------------------------------------------------------*/
/*      .                 */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE   .                                */
/*------------------------------------------------------------------------------*/
#define is_Detonation_Present() ((Message[4]&0x20)&&(Message[5]&0x20))

/*------------------------------------------------------------------------------*/
/*       .             */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE    .                             */
/*------------------------------------------------------------------------------*/
#define is_Injector_Blocking() (Message[4]&0x08)

/*------------------------------------------------------------------------------*/
/*      .                        */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE      .                     */
/*------------------------------------------------------------------------------*/
#define is_Idle_Step() (Message[4]&0x02)

/*------------------------------------------------------------------------------*/
/*      .                */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE   .                                 */
/*------------------------------------------------------------------------------*/
#define is_Power_Mode() (Message[4]&0x04)

/*------------------------------------------------------------------------------*/
/*     .                     */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE   .                                 */
/*------------------------------------------------------------------------------*/
#define is_Engine_OFF() (Message[4]&0x01)

/*------------------------------------------------------------------------------*/
/*     .                      */
/*      Read_After_Sales_Service_Data().*/
/* :     .                                            */
/* :  TRUE   .                                  */
/*------------------------------------------------------------------------------*/
#define is_Engine_ON() ((Message[4]&0x01) == 0)

/*------------------------------------------------------------------------------*/
/*         .	                */
/*        UART,            */
/*    1 (Message[1]  ).                                  */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Read_Diagnostic_Trouble_Codes(void);

/*------------------------------------------------------------------------------*/
/*     .                  */
/*      Read_Diagnostic_Trouble_Codes().*/
/* :     .                                            */
/* :    .                              */
/*------------------------------------------------------------------------------*/
#define nErrors() (Message[1])

/*------------------------------------------------------------------------------*/
/*         .	                */
/* :     .                                            */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT Clear_Diagnostic_Information(void);

/*------------------------------------------------------------------------------*/
/*      .	                */
/* :     /;                      */
/*                ;                                    */
/*               ,    .      */
/* :    .                                   */
/*------------------------------------------------------------------------------*/
enum KEYWORD_RESULT io_Control_By_Local_Identifier(
                                                    unsigned char ,
                                                    unsigned char ,
                                                    unsigned char
                                                  );

/*------------------------------------------------------------------------------*/
/*     Check Engine.                            */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Get_CE_Lamp_State() io_Control_By_Local_Identifier(0x0c, 0x01, 0x00)

/*------------------------------------------------------------------------------*/
/*     Check Engine.                          */
/*      io_Control_By_Local_Identifier()*/
/* :     .                                            */
/* :  TRUE,   Check Engine .                            */
/*------------------------------------------------------------------------------*/
#define is_CE_Lamp_ON() (Message[3] != 0)

/*------------------------------------------------------------------------------*/
/*    Check Engine.                                   */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_CE_Lamp_ON() io_Control_By_Local_Identifier(0x0c, 0x06, 0x01)

/*------------------------------------------------------------------------------*/
/*    Check Engine.                                  */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_CE_Lamp_OFF() io_Control_By_Local_Identifier(0x0c, 0x06, 0x00)

/*------------------------------------------------------------------------------*/
/*     Check Engine .                    */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Return_Control_CE_Lamp_To_ECU() io_Control_By_Local_Identifier(0x0c, 0x00, 0x00)

/*------------------------------------------------------------------------------*/
/*       .      */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Get_Cooling_Fan_State() io_Control_By_Local_Identifier(0x0a, 0x01, 0x00)

/*------------------------------------------------------------------------------*/
/*       .    */
/*      io_Control_By_Local_Identifier()*/
/* :     .                                            */
/* :  TRUE,      .     */
/*------------------------------------------------------------------------------*/
#define is_Cooling_Fan_ON() (Message[3] != 0)

/*------------------------------------------------------------------------------*/
/*      .             */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Cooling_Fan_ON() io_Control_By_Local_Identifier(0x0a, 0x06, 0x01)

/*------------------------------------------------------------------------------*/
/*       .  */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Cooling_Fan_OFF() io_Control_By_Local_Identifier(0x0a, 0x06, 0x00)

/*------------------------------------------------------------------------------*/
/*       .       */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Return_Control_Cooling_Fan_To_ECU() io_Control_By_Local_Identifier(0x0a, 0x00, 0x00)

/*------------------------------------------------------------------------------*/
/*    .                                   */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Get_Fuel_Pump_State() io_Control_By_Local_Identifier(0x09, 0x01, 0x00)

/*------------------------------------------------------------------------------*/
/*    .                                 */
/*      io_Control_By_Local_Identifier()*/
/* :     .                                            */
/* :  TRUE,   .                                  */
/*------------------------------------------------------------------------------*/
#define is_Fuel_Pump_ON() (Message[3] != 0)

/*------------------------------------------------------------------------------*/
/*   .                                          */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Fuel_Pump_ON() io_Control_By_Local_Identifier(0x09, 0x06, 0x01)

/*------------------------------------------------------------------------------*/
/*   .                                         */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Fuel_Pump_OFF() io_Control_By_Local_Identifier(0x09, 0x06, 0x00)

/*------------------------------------------------------------------------------*/
/*     .                           */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Return_Control_Fuel_Pump_To_ECU() io_Control_By_Local_Identifier(0x09, 0x00, 0x00)

/*------------------------------------------------------------------------------*/
/*     CO.                               */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Get_CO_Trimmer_State() io_Control_By_Local_Identifier(0x61, 0x01, 0x00)

/*------------------------------------------------------------------------------*/
/*       CO.               */
/* :       CO.                       */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_RCO_Value(Byte) io_Control_By_Local_Identifier(0x61, 0x08, ##Byte)

/*------------------------------------------------------------------------------*/
/*       .             */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Return_Control_CO_Trimmer_To_ECU() io_Control_By_Local_Identifier(0x61, 0x00, 0x00)

/*------------------------------------------------------------------------------*/
/*       .            */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Get_Idle_Step_Motor_Position() io_Control_By_Local_Identifier(0x41, 0x01, 0x00)

/*------------------------------------------------------------------------------*/
/*       .           */
/* :      .                                   */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Idle_Step_Motor_Position(Byte) io_Control_By_Local_Identifier(0x41, 0x07, ##Byte)

/*------------------------------------------------------------------------------*/
/*      .                         */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Return_Control_Idle_Step_Motor_To_ECU() io_Control_By_Local_Identifier(0x41, 0x00, 0x00)

/*------------------------------------------------------------------------------*/
/*      .                        */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Get_Idle_Engine_Speed() io_Control_By_Local_Identifier(0x42, 0x01, 0x00)

/*------------------------------------------------------------------------------*/
/*      .                     */
/* :      .                                     */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Idle_Engine_Speed(Byte) io_Control_By_Local_Identifier(0x42, 0x07, ##Byte)

/*------------------------------------------------------------------------------*/
/*      .                           */
/* :     .                                            */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Return_Control_Idle_Engine_Speed_To_ECU() io_Control_By_Local_Identifier(0x42, 0x00, 0x00)

/*------------------------------------------------------------------------------*/
/*    n.                                            */
/* :      (0 - 1).                               */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Ignition_ON(Ignition) io_Control_By_Local_Identifier(##Ignition+0x05, 0x06, 0x01)

/*------------------------------------------------------------------------------*/
/*    n.                                           */
/* :      (0 - 3).                              */
/* :     io_Control_By_Local_Identifier.    */
/*------------------------------------------------------------------------------*/
#define Set_Injector_ON(Injector) io_Control_By_Local_Identifier(##Injector+0x01, 0x06, 0x01)


/*------------------------------------------------------------------------------*/
#endif

