; /******************************************************************************/
; /*								      		*/
; /*	  	  DV-16110    .		*/
; /*										*/
; /******************************************************************************/

			NAME    LCD_DRIVER

LCD_DRIVER		SEGMENT	CODE

			PUBLIC  Init_LCD
			PUBLIC  _Write_String_To_LCD
			PUBLIC  _Write_Data_To_LCD
			PUBLIC  _Write_Code_To_LCD

   ;----------------------------------------------------------------------------;
   ;     .		;
LCD_Data_Bus		DATA	P2		; P2   -    .
LCD_Backlight		BIT	P0.4		; P0.4 -   .
LCD_Enable		BIT	P0.5		; P0.5 -   E.
LCD_Read_Write		BIT	P0.6		; P0.6 -  / RW.
LCD_Reg_Select		BIT	P0.7		; P0.7 -    RS.
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
			RSEG	LCD_DRIVER
			USING   0

; /******************************************************************************/
; /*										*/
; /*	              .		*/
; /*										*/
; /* void Write_Code_To_LCD(char Byte)						*/
; /* :		    R7.				*/
; /* :	  .					*/
; /*										*/
; /******************************************************************************/
_Write_Code_To_LCD:

   ;      .					;
        MOV     LCD_Data_Bus,#0FFH

   ;       .			;
        CLR     LCD_Reg_Select
        SETB    LCD_Read_Write
Write_Code_To_LCD_Wait_Ready:
        SETB    LCD_Enable
        MOV     ACC,LCD_Data_Bus
        CLR     LCD_Enable
        JB      ACC.7,Write_Code_To_LCD_Wait_Ready

   ;      .					;
        CLR     LCD_Read_Write
        SETB    LCD_Enable
        MOV     LCD_Data_Bus,R7
        CLR     LCD_Enable

        RET     

; /******************************************************************************/
; /*								       		*/
; /*	             .		*/
; /*										*/
; /* void Write_Data_To_LCD(char Byte)						*/
; /* :		  .				*/
; /* :	  .					*/
; /*								       		*/
; /******************************************************************************/
_Write_Data_To_LCD:

   ;      .					;
        MOV     LCD_Data_Bus,#0FFH

   ;       .			;
        CLR     LCD_Reg_Select
        SETB    LCD_Read_Write
Write_Data_To_LCD_Wait_Ready:
        SETB    LCD_Enable
        MOV     ACC,LCD_Data_Bus
        CLR     LCD_Enable
        JB      ACC.7,Write_Data_To_LCD_Wait_Ready

  ;      .						;
        SETB    LCD_Reg_Select
        CLR     LCD_Read_Write
        SETB    LCD_Enable
        MOV     LCD_Data_Bus,R7
        CLR     LCD_Enable

        RET     


; /******************************************************************************/
; /*										*/
; /*		      .		*/
; /*										*/
; /* void Init_LCD(void)							*/
; /* :		  .					*/
; /* :	  .					*/
; /*								       		*/
; /******************************************************************************/
Init_LCD:

   ;   .							;
	SETB	LCD_Backlight

   ;      .				;
        CLR     LCD_Reg_Select
        CLR     LCD_Read_Write
        SETB    LCD_Enable
        MOV     LCD_Data_Bus,#030H
        CLR     LCD_Enable

   ;   .						;
        CLR     A
	DJNZ	ACC,$

   ;    - 2 ,   5 x 7.		;
        MOV     R7,#038H
        LCALL   _Write_Code_To_LCD

   ;   ,  .			;
        MOV     R7,#006H
        LCALL   _Write_Code_To_LCD

   ;        .			;
        MOV     R7,#001H
        LCALL   _Write_Code_To_LCD

   ;  ,   . 				;
        MOV     R7,#00CH
        LCALL   _Write_Code_To_LCD

        RET     


; /******************************************************************************/
; /*								       		*/
; /*		       ASCIIZ   .			*/
; /*										*/
; /* void Display(unsigned char idata *ptr)					*/
; /* :		     .			*/
; /* :	  .					*/
; /*								       		*/
; /******************************************************************************/
_Write_String_To_LCD:

   ;      .				;
	PUSH	IE
	CLR	EA

   ;      .				;
	MOV	R0,AR7

   ;  ,  -   .				;
        MOV     R7,#001H
        LCALL   _Write_Code_To_LCD

   ;    8    00h .			;
        MOV     B,#008H
Put_First_Half_String:
        MOV     A,@R0			;   .		;
        JZ      End_Put_String		;     - .	;
        MOV     R7,A			;    .		;
        LCALL   _Write_Data_To_LCD
        INC     R0			;  .			;
        DJNZ    B,Put_First_Half_String

   ;        .		;
        MOV     R7,#0C0H
        LCALL   _Write_Code_To_LCD

   ;    8    40h .			;
        MOV     B,#008H
Put_Second_Half_String:
        MOV     A,@R0			;   .		;
        JZ      End_Put_String		;     - .	;
        MOV     R7,A			;    .		;
        LCALL   _Write_Data_To_LCD
        INC     R0			;  .			;
        DJNZ    B,Put_Second_Half_String

   ;   .   .				;
End_Put_String:
	POP	IE
        RET     


; /******************************************************************************/
	END

