; /******************************************************************************/
; /*								      		*/
; /*	  	                 RTC DS1307.		                */
; /*										*/
; /******************************************************************************/

			NAME    RTC_DRIVER

RTC_DRIVER		SEGMENT	CODE
RTC_IDATA		SEGMENT	IDATA

			PUBLIC  Init_RTC
			PUBLIC  _Write_Data_To_RTC
			PUBLIC  _Read_Data_From_RTC

   ;----------------------------------------------------------------------------;
   ;      RTC.				;
   ;  enum RTC_RESULT.						;
RTC_OK			EQU	0	;   RTC  .	;
RTC_ERROR		EQU	1	;     RTC.	;
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
   ;     .		;
SCL		       BIT	P1.3		; P1.3 -   .   ;
SDA		       BIT	P1.2		; P1.2 -  .          ;
   ;----------------------------------------------------------------------------;

   ;----------------------------------------------------------------------------;
   ;  ,    RTC.			;
			RSEG  	RTC_IDATA
Work_Byte:		DS	1
   ;----------------------------------------------------------------------------;

   ;----------------------------------------------------------------------------;
			RSEG	RTC_DRIVER
			USING   0

; /******************************************************************************/
; /*										*/
; /*	                     RTC.		                */
; /*										*/
; /* enum RTC_RESULT Init_RTC(void)						*/
; /* :	    .				        	*/
; /* :     (== 0).                           */
; /*										*/
; /******************************************************************************/
Init_RTC:

   ;        .			;
        CLR     SCL
        SETB    SDA

   ;    RTC (  0x00  7 ..  ).		;
	MOV	R7,#Work_Byte		;      0x00.	;
	MOV	R5,#001H		;  1 .			;
	MOV	R3,#000H		;     RTC.		;
	LCALL	_Read_Data_From_RTC
	CJNE	R7,#000H,RTC_Init_Error	; ,   .		;

   ;  .   7 -  .			;
	MOV	R0,#Work_Byte
	MOV	A,@R0
	ANL	A,#07FH
	MOV	@R0,A

   ;     RTC.						;
	MOV	R7,#Work_Byte		;      0x00.	;
	MOV	R5,#001H		;  1 .			 	;
	MOV	R3,#000H		;     RTC.	;
	LCALL	_Write_Data_To_RTC
	CJNE	R7,#000H,RTC_Init_Error	; ,   .		;

   ;  .   SQW    1 .		;
	MOV	R0,#Work_Byte
	MOV	@R0,#010H		;     SQW 1 .;
	MOV	R7,#Work_Byte		;      0x07.	;
	MOV	R5,#001H		;  1 .			 	;
	MOV	R3,#007H		;     RTC.	;
	LCALL	_Write_Data_To_RTC
	CJNE	R7,#000H,RTC_Init_Error	; ,   .		;

   ;  RTC  .    .		;
RTC_Init_OK:
	MOV	R7,#RTC_OK		;   .		;
	SJMP	RTC_Init_End

   ;  RTC  .    .		 	;
RTC_Init_Error:
	MOV	R7,#RTC_ERROR		;   .		;

RTC_Init_End:
        RET

; /******************************************************************************/
; /*										*/
; /*	                I2C.		*/
; /*										*/
; /* :		  .                             	*/
; /* :	  .					*/
; /*										*/
; /******************************************************************************/
Put_Stop_to_I2C_Bus:
	NOP
        CLR     SDA		;    .				;
        NOP
        NOP
        NOP
        NOP
        SETB    SCL             ;  .				 	;
        NOP
        NOP
        NOP
        NOP
        SETB    SDA             ;   .			;
        NOP
        NOP
        NOP
        NOP
        CLR     SCL             ;  .				;
        NOP
        NOP
        NOP
        NOP
	NOP
	RET

; /******************************************************************************/
; /*										*/
; /*	                I2C.		*/
; /*										*/
; /* :		  .                             	*/
; /* :	  .					*/
; /*										*/
; /******************************************************************************/
Put_Start_to_I2C_Bus:
	NOP
        SETB    SDA		;    .			;
        NOP
        NOP
        NOP
        NOP
        SETB    SCL             ;  .					;
        NOP
        NOP
        NOP
        NOP
        CLR	SDA             ;   .			;
        NOP
        NOP
        NOP
        NOP
        CLR     SCL             ;  .				;
        NOP
        NOP
        NOP
        NOP
	NOP
	RET

; /******************************************************************************/
; /*										*/
; /*	                I2C.			*/
; /*										*/
; /* :		    CY.                             	*/
; /* :	  .					*/
; /*										*/
; /******************************************************************************/
Put_Bit_to_I2C_Bus:
	NOP
        MOV     SDA,C           ;    .		;
        NOP
        NOP
        NOP
        NOP
        SETB    SCL             ;  .					;
        NOP
        NOP
        NOP
        NOP
	NOP
        NOP
        NOP
        NOP
        CLR     SCL             ;  .				;
        NOP
        NOP
        NOP
        NOP
	NOP
	RET

; /******************************************************************************/
; /*										*/
; /*	                    I2C.			*/
; /*										*/
; /* :		  .                             	*/
; /* :	     CY.			*/
; /*										*/
; /******************************************************************************/
Get_Ack_from_I2C_Bus:
Get_Bit_from_I2C_Bus:
	NOP
        SETB    SDA             ;     .		;
        NOP
        NOP
        NOP
        NOP
        NOP
        SETB    SCL             ;  .					;
        NOP
        NOP
        NOP
        MOV     C,SDA           ;   .			;
        NOP
        NOP
        NOP
        CLR     SCL             ;  .				;
        NOP
        NOP
        NOP
        NOP
	NOP
	RET


; /******************************************************************************/
; /*										*/
; /*	                  RTC.		        */
; /*										*/
; /* enum RTC_RESULT Write_Data_To_RTC()		                        */
; /* :		   IDATA   R7,                     */
; /*                         R5,		        */
; /*                        RTC   R3.                */
; /* :          :                          */
; /*                    R7 == 0 -  ,  - .            */
; /*										*/
; /******************************************************************************/
_Write_Data_To_RTC:
   ;----------------------------------------------------------------------------;
   ;   .						;
        PUSH    ACC
        PUSH    B
        PUSH    AR0

   ;----------------------------------------------------------------------------;
   ;       .			;
	LCALL	Put_Stop_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;       .				;
	LCALL	Put_Start_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;   RTC   .					;
        MOV     A,#11010000B    ;  RTC = 1101000B.				;
        MOV     B,#08H          ;    .			;
_WDRTC_Send_Dev_Addr_Loop:
        RLC     A               ;    .		;
	LCALL	Put_Bit_to_I2C_Bus
        DJNZ    B,_WDRTC_Send_Dev_Addr_Loop

   ;     RTC.						;
	LCALL	Get_Ack_from_I2C_Bus

   ;   ,    .			;
        JNC     $+5
        LJMP    _WDRTC_Error

   ;----------------------------------------------------------------------------;
   ;  .    .		;
        MOV     A,R3
        MOV     B,#08H          ;    .			;
_WDRTC_Send_Addr_Loop:
        RLC     A               ;    .		;
	LCALL	Put_Bit_to_I2C_Bus
        DJNZ    B,_WDRTC_Send_Addr_Loop

   ;     RTC.						;
	LCALL	Get_Ack_from_I2C_Bus

   ;   ,    .			;
        JNC     $+5
        LJMP    _WDRTC_Error

   ;----------------------------------------------------------------------------;
   ;   .						;
   ;       .					;
	MOV	R0,AR7		; R0 -    .		;

_WDRTC_Send_Data_Flow_Loop:
   ;   RTC     .				;
        MOV     A,@R0           ;   .			;
        INC     R0              ;  -   .		;
        MOV     B,#08H          ;    .			;
_WDRTC_Send_Byte_Loop:
        RLC     A               ;    .		;
	LCALL	Put_Bit_to_I2C_Bus
        DJNZ    B,_WDRTC_Send_Byte_Loop

   ;     RTC.						;
	LCALL	Get_Ack_from_I2C_Bus

   ;   ,    .			;
        JNC     $+5
        LJMP    _WDRTC_Error

   ;     .						;
        DJNZ    R5,_WDRTC_Send_Data_Flow_Loop

   ;----------------------------------------------------------------------------;
   ;  .    .		;
	LCALL	Put_Stop_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;    RTC .     .	 	;
_WDRTC_OK:
	MOV	R7,#RTC_OK
	SJMP	_WDRTC_End

   ;----------------------------------------------------------------------------;
   ;    RTC .     .	;
_WDRTC_Error:
	MOV	R7,#RTC_ERROR

   ;----------------------------------------------------------------------------;
   ;     .			 	;
_WDRTC_End:
        POP     AR0
        POP     B
        POP     ACC
        RET

; /******************************************************************************/
; /*										*/
; /*	                  RTC.		        */
; /*										*/
; /* enum RTC_RESULT Read_Data_From_RTC()		                        */
; /* :		   IDATA   R7,                     */
; /*                         R5,		        */
; /*                        RTC   R3.                */
; /* :          :                          */
; /*                    R7 == 0 -  ,  - .            */
; /*                                                                            */
; /******************************************************************************/
_Read_Data_From_RTC:
   ;----------------------------------------------------------------------------;
   ;   .						;
        PUSH    ACC
        PUSH    B
        PUSH    AR0

   ;----------------------------------------------------------------------------;
   ;       .			;
	LCALL	Put_Stop_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;       .				;
	LCALL	Put_Start_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;   RTC   .					;
        MOV     A,#11010000B    ;  RTC = 1101000B.				;
        MOV     B,#08H          ;    .			;
_RDRTC_Send_Dev_Addr_Loop_1:
        RLC     A               ;    .		;
	LCALL	Put_Bit_to_I2C_Bus
        DJNZ    B,_RDRTC_Send_Dev_Addr_Loop_1

   ;     RTC.						;
	LCALL	Get_Ack_from_I2C_Bus

   ;   ,    .			;
        JNC     $+5
        LJMP    _RDRTC_Error

   ;----------------------------------------------------------------------------;
   ;  .    .			;
        MOV     A,R3
        MOV     B,#08H          ;    .			;
_RDRTC_Set_Addr_Loop:
        RLC     A               ;    .		;
	LCALL	Put_Bit_to_I2C_Bus
        DJNZ    B,_RDRTC_Set_Addr_Loop

   ;     RTC.						;
	LCALL	Get_Ack_from_I2C_Bus

   ;   ,    .			;
        JNC     $+5
        LJMP    _RDRTC_Error

   ;----------------------------------------------------------------------------;
   ;  .    .		 	;
	LCALL	Put_Stop_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;    RTC.						;
   ;       .			 	;
	LCALL	Put_Start_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;   RTC   .					;
        MOV     A,#11010001B    ;  RTC = 1101000B.				;
        MOV     B,#08H          ;    .			;
_RDRTC_Send_Dev_Addr_Loop:
        RLC     A               ;    .		;
	LCALL	Put_Bit_to_I2C_Bus
        DJNZ    B,_RDRTC_Send_Dev_Addr_Loop

   ;     RTC.						;
	LCALL	Get_Ack_from_I2C_Bus

   ;   ,    .			;
        JNC     $+5
        LJMP    _RDRTC_Error

   ;----------------------------------------------------------------------------;
   ;   .						;
        MOV     R0,AR7		; R0 -    .		;

   ;     1  -  .			;
        DJNZ    R5,_RDRTC_Read_Data_Flow_Loop
        LJMP    _RDRTC_Get_Last_Byte

   ;       .					;
_RDRTC_Read_Data_Flow_Loop:
        CLR     A
        MOV     B,#08H          ;    .			;
_RDRTC_Get_Byte_Loop:
	LCALL	Get_Bit_from_I2C_Bus
        RLC     A               ;    .			;
        DJNZ    B,_RDRTC_Get_Byte_Loop
	MOV	@R0,A
        INC     R0

   ;  .   (ACK)  RTC.				;
        CLR     C
	LCALL	Put_Bit_to_I2C_Bus

   ;     .						;
        DJNZ    R5,_RDRTC_Read_Data_Flow_Loop

   ;----------------------------------------------------------------------------;
   ;        (No ACK)  RTC.;
_RDRTC_Get_Last_Byte:
        CLR     A
        MOV     B,#08H          ;    .			;
_RDRTC_Get_Last_Byte_Loop:
	LCALL	Get_Bit_from_I2C_Bus
        RLC     A               ;    .			;
        DJNZ    B,_RDRTC_Get_Last_Byte_Loop
	MOV	@R0,A

        SETB    C
	LCALL	Put_Bit_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;    .					;
	LCALL	Put_Stop_to_I2C_Bus

   ;----------------------------------------------------------------------------;
   ;    RTC .     .	 	;
_RDRTC_OK:
	MOV	R7,#RTC_OK
	SJMP	_RDRTC_End

   ;----------------------------------------------------------------------------;
   ;    RTC .     .	;
_RDRTC_Error:
	MOV	R7,#RTC_ERROR

   ;----------------------------------------------------------------------------;
   ;     .			 	;
_RDRTC_End:
        POP     AR0
        POP     B
        POP     ACC
        RET

;-------------------------------------------------------------------------------;
        END