; /******************************************************************************/
; /*										*/
; /*		      .		*/
; /*										*/
; /******************************************************************************/

			NAME    SYS_TIMER_DRIVER

SYS_TIMER_DRIVER	SEGMENT	CODE
SYS_TIMER_DATA		SEGMENT	DATA
SYS_TIMER_FLAG		SEGMENT	BIT

			PUBLIC  Init_Sys_Timer
			PUBLIC  _Start_Time_Out
			PUBLIC  Time_Out_End
			EXTRN	CODE(Scan_Keyboard)

   ;----------------------------------------------------------------------------;
   ;         ;
SYSTEM_FREQ		EQU	24000		;    .		;
SYSTEM_TIMER_TICK	EQU	5		;      ;
TIMER0_DIVIDER		EQU	65536-(SYSTEM_TIMER_TICK*(SYSTEM_FREQ/12))
   ;----------------------------------------------------------------------------;
   ;       .	;
KEYBOARD_SCAN_INTERVAL	EQU	100/SYSTEM_TIMER_TICK
   ;----------------------------------------------------------------------------;

   ;----------------------------------------------------------------------------;
   ;     0.                                            ;
			CSEG	AT	0000BH
			LJMP	Timer0_Interrupt
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
   ;   . "1" -    .           ;
			RSEG	SYS_TIMER_FLAG
Time_Out_End:		DBIT	1
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
			RSEG	SYS_TIMER_DATA
   ;----------------------------------------------------------------------------;
   ;        .	;
Sys_Timer_nTick:	DS	1
   ;----------------------------------------------------------------------------;
   ;      .	 		;
Keyboard_Timer_nTick:	DS	1
   ;----------------------------------------------------------------------------;


   ;----------------------------------------------------------------------------;
			RSEG	SYS_TIMER_DRIVER
			USING   0

; /******************************************************************************/
; /*										*/
; /*		       .			*/
; /*										*/
; /* void Init_Sys_Timer(void)							*/
; /* :		  .					*/
; /* :	  .					*/
; /*								       		*/
; /******************************************************************************/
Init_Sys_Timer:
	CLR	TR0			;  .
	CLR	TF0			;   .

   ;----------------------------------------------------------------------------;
   ;   0   1 .					;
   ;     SYSTEM_TIMER_TICK .		 	;
	ANL	TMOD,#0F0H
	ORL	TMOD,#001H
	MOV	TL0,#LOW(TIMER0_DIVIDER)
        MOV     TH0,#HIGH(TIMER0_DIVIDER)

   ;----------------------------------------------------------------------------;
   ;     .				;
	MOV	Keyboard_Timer_nTick,#KEYBOARD_SCAN_INTERVAL

   ;----------------------------------------------------------------------------;
   ;     .				;
	CLR	Time_Out_End

   ;----------------------------------------------------------------------------;
   ;     0   .			 	;
	SETB	ET0			;    0 .
	SETB	TR0			;  .
		  
	RET


; /******************************************************************************/
; /*										*/
; /*            0 -   .   	*/
; /*										*/
; /******************************************************************************/
Timer0_Interrupt:

   ;----------------------------------------------------------------------------;
   ;      .				;
        PUSH    PSW

   ;----------------------------------------------------------------------------;
   ;   .						;
	MOV	TL0,#LOW(TIMER0_DIVIDER)
        MOV     TH0,#HIGH(TIMER0_DIVIDER)

   ;----------------------------------------------------------------------------;
   ; ,    .					;
	DJNZ	Keyboard_Timer_nTick,Keyboard_Scan_End
   ;     .				;
   ;   .						;
        MOV	Keyboard_Timer_nTick,#KEYBOARD_SCAN_INTERVAL
	LCALL	Scan_Keyboard
Keyboard_Scan_End:

   ;----------------------------------------------------------------------------;
   ; ,     .					;
	JB	Time_Out_End,Time_Out_Forming_End

   ;    . ,    ?	;
	DJNZ	Sys_Timer_nTick,Time_Out_Forming_End

   ;    .						;
   ;      .			;
        SETB    Time_Out_End
Time_Out_Forming_End:

   ;----------------------------------------------------------------------------;
   ;      .			;
Sys_Timer_End:
        POP     PSW
        RETI    


; /******************************************************************************/
; /*										*/
; /*         .	*/
; /*										*/
; /* void Start_Time_Out(unsigned char )					*/
; /* :		     .	        */
; /* :	  .					*/
; /*										*/
; /******************************************************************************/
_Start_Time_Out:

   ;      .				;
	CLR	EA

   ;     .			;
        MOV	Sys_Timer_nTick,R7

   ;     .					;
        CLR     Time_Out_End

   ;      .				;
	SETB	EA
        RET     


; /******************************************************************************/
	END

