/********************************************************************************/
/*										*/
/*                  .             */
/*										*/
/********************************************************************************/
#ifndef _UART_DRIVER_H
#define _UART_DRIVER_H

/*------------------------------------------------------------------------------*/
/*   /   .     		*/
/*    ,    .			*/
/* "1" - /  .					*/
/* "0" - / / .			*/
/*------------------------------------------------------------------------------*/
extern bit UART_Ready;

/*------------------------------------------------------------------------------*/
/*  /   . 		                */
/*------------------------------------------------------------------------------*/
extern idata unsigned char Message[50];

/*------------------------------------------------------------------------------*/
/*    .				*/
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
void Init_UART(void);

/*------------------------------------------------------------------------------*/
/*    UART.						*/
/* :     .						*/
/* :	  .					        */
/*------------------------------------------------------------------------------*/
void Start_UART_Rx(void);

/*------------------------------------------------------------------------------*/
/*    UART.					        */
/* :	    .				*/
/* 		    				*/
/*  		  Message   .				*/
/* :	  .						*/
/*------------------------------------------------------------------------------*/
void Start_UART_Tx(unsigned char );

/*------------------------------------------------------------------------------*/
/*     UART.                          */
/* :     .                                            */
/* :  TRUE,   .                                 */
/*------------------------------------------------------------------------------*/
#define is_UART_Tx_Ready() UART_Ready

/*------------------------------------------------------------------------------*/
/*     UART.                            */
/* :     .                                            */
/* :  TRUE,   .                                    */
/*------------------------------------------------------------------------------*/
#define is_UART_Tx_Busy() !UART_Ready

/*------------------------------------------------------------------------------*/
/*     UART.                             */
/* :     .                                            */
/* :  TRUE,    .                           */
/*------------------------------------------------------------------------------*/
#define is_UART_Rx_Ready() UART_Ready

/*------------------------------------------------------------------------------*/
/*     UART.                              */
/* :     .                                            */
/* :  TRUE,      .                    */
/*------------------------------------------------------------------------------*/
#define is_UART_Rx_Busy() !UART_Ready


/********************************************************************************/
#endif
