/********************************************************************************/
/*									        */
/*                    AT89S8252.		*/
/*										*/
/********************************************************************************/
#ifndef _REG_AT89S8252
#define _REG_AT89S8252

/*==============================================================================*/
/*                    .  			*/
/*==============================================================================*/
sfr P0          = 0x80;	        //  0.
sfr SP          = 0x81;	        //  .
sfr DPL         = 0x82;	        //   DPTR.
sfr DPH         = 0x83;	        //   DPTR.
sfr DPL1        = 0x84;	        //    DPTR.
sfr DPH1        = 0x85;	        //    DPTR.
sfr SPDR        = 0x86;	        //   SPI.
sfr PCON        = 0x87;	        //   .
sfr TCON        = 0x88;	        //  .
sfr TMOD        = 0x89;	        //    0  1.
sfr TL0         = 0x8A;	        //     0.
sfr TL1         = 0x8B;	        //     1.
sfr TH0         = 0x8C;	        //     0.
sfr TH1         = 0x8D;	        //     1.
sfr P1          = 0x90;	        //  1.
sfr WMCON       = 0x96;	        //   Watch Dog .
sfr SCON        = 0x98;	        //   UART.
sfr SBUF        = 0x99;	        //   UART.
sfr P2          = 0xA0;	        //  2.
sfr IE          = 0xA8;	        //   .
sfr SPSR        = 0xAA;	        //   SPI.
sfr P3          = 0xB0;	        //  3.
sfr IP          = 0xB8;	        //   .
sfr T2CON       = 0xC8;	        //   .
sfr T2MOD       = 0xC9;	        //    2.
sfr RCAP2L      = 0xCA;	        //      2.
sfr RCAP2H      = 0xCB;	        //      2.
sfr TL2         = 0xCC;	        //     2.
sfr TH2         = 0xCD;	        //     2.
sfr PSW         = 0xD0;	        //  .
sfr SPCR        = 0xD5;	        //   SPI.
sfr ACC         = 0xE0;	        // .
sfr B           = 0xF0;	        //  B.

/*==============================================================================*/
/*                     .  		*/
/*==============================================================================*/

/*------------------------------------------------------------------------------*/
/* PSW -   .   						*/
/*------------------------------------------------------------------------------*/
sbit CY         = 0xD7;	        //  .
sbit AC         = 0xD6;	        //   .
sbit F0         = 0xD5;	        //  .
sbit RS1        = 0xD4;	        //    .
sbit RS0        = 0xD3;
sbit OV         = 0xD2;	        //  .
sbit P          = 0xD0;	        //  .

/*------------------------------------------------------------------------------*/
/* TCON -  . 							*/
/*------------------------------------------------------------------------------*/
sbit TF1        = 0x8F;		//   / 1.
sbit TR1        = 0x8E;		//   / 1.
sbit TF0        = 0x8D;		//   / 0.
sbit TR0        = 0x8C;		//   / 0.
sbit IE1        = 0x8B;		//     INT1.
sbit IT1        = 0x8A;		//      INT1.
sbit IE0        = 0x89;		//     INT0.
sbit IT0        = 0x88;		//      INT0.

/*------------------------------------------------------------------------------*/
/* IE -   .  					*/
/*------------------------------------------------------------------------------*/
sbit EA         = 0xAF;		//    .
sbit ET2        = 0xAD;		//      2.
sbit ES         = 0xAC;		//     UART.
sbit ET1        = 0xAB;		//      1.
sbit EX1        = 0xAA;		//      INT1.
sbit ET0        = 0xA9;		//      0.
sbit EX0        = 0xA8;		//      INT0.

/*------------------------------------------------------------------------------*/
/* IP -   . 					*/
/*------------------------------------------------------------------------------*/
sbit PT2        = 0xBD;		//      2.
sbit PS         = 0xBC;		//     UART.
sbit PT1        = 0xBB;		//      1.
sbit PX1        = 0xBA;		//     INT1.
sbit PT0        = 0xB9;		//      0.
sbit PX0        = 0xB8;		//     INT0.

/*------------------------------------------------------------------------------*/
/* P0 -    0.					        */
/*------------------------------------------------------------------------------*/
sbit AD7        = 0x87;		//  /   AD7.
sbit AD6        = 0x86;		//  /   AD6.
sbit AD5        = 0x85;		//  /   AD5.
sbit AD4        = 0x84;		//  /   AD4.
sbit AD3        = 0x83;		//  /   AD3.
sbit AD2        = 0x82;		//  /   AD2.
sbit AD1        = 0x81;		//  /   AD1.
sbit AD0        = 0x80;		//  /   AD0.

sbit P07        = 0x87;
sbit P06        = 0x86;
sbit P05        = 0x85;
sbit P04        = 0x84;
sbit P03        = 0x83;
sbit P02        = 0x82;
sbit P01        = 0x81;
sbit P00        = 0x80;

/*------------------------------------------------------------------------------*/
/* P1 -    1.						*/
/*------------------------------------------------------------------------------*/
sbit SCK        = 0x97;		//   SPI.
sbit MISO       = 0x96;		//  MISO SPI.
sbit MOSI       = 0x95;		//  MOSI SPI.
sbit SS         = 0x94;		//  SS SPI.
sbit T2EX       = 0x91;		//   .
sbit T2         = 0x90;		//   / 2.

sbit P17        = 0x97;
sbit P16        = 0x96;
sbit P15        = 0x95;
sbit P14        = 0x94;
sbit P13        = 0x93;
sbit P12        = 0x92;
sbit P11        = 0x91;
sbit P10        = 0x90;

/*------------------------------------------------------------------------------*/
/* P2 -    2.						*/
/*------------------------------------------------------------------------------*/
sbit A15        = 0xA7;		//     A15.
sbit A14        = 0xA6;		//     A14.
sbit A13        = 0xA5;		//     A13.
sbit A12        = 0xA4;		//     A12.
sbit A11        = 0xA3;		//     A11.
sbit A10        = 0xA2;		//     A10.
sbit A9         = 0xA1;		//     A9.
sbit A8         = 0xA0;		//     A8.

sbit P27        = 0xA7;
sbit P26        = 0xA6;
sbit P25        = 0xA5;
sbit P24        = 0xA4;
sbit P23        = 0xA3;
sbit P22        = 0xA2;
sbit P21        = 0xA1;
sbit P20        = 0xA0;

/*------------------------------------------------------------------------------*/
/* P3 -    3.						*/
/*------------------------------------------------------------------------------*/
sbit RD         = 0xB7;		//     .
sbit WR         = 0xB6;		//     .
sbit T1         = 0xB5;		//   / 1.
sbit T0         = 0xB4;		//   / 0.
sbit INT1       = 0xB3;		//    1.
sbit INT0       = 0xB2;		//    2.
sbit TXD        = 0xB1;		//   UART.
sbit RXD        = 0xB0;		//   UART.

sbit P37        = 0xB7;
sbit P36        = 0xB6;
sbit P35        = 0xB5;
sbit P34        = 0xB4;
sbit P33        = 0xB3;
sbit P32        = 0xB2;
sbit P31        = 0xB1;
sbit P30        = 0xB0;

/*------------------------------------------------------------------------------*/
/* SCON -   UART.						*/
/*------------------------------------------------------------------------------*/
sbit SM0        = 0x9F;		//     UART.
sbit SM1        = 0x9E;
sbit SM2        = 0x9D;		//    .
sbit REN        = 0x9C;		//    UART.
sbit TB8        = 0x9B;		//     .
sbit RB8        = 0x9A;		//     .
sbit TI         = 0x99;		//   .
sbit RI         = 0x98;		//   .

/*------------------------------------------------------------------------------*/
/* T2CON -   . 				        */
/*------------------------------------------------------------------------------*/
sbit CP_RL2     = 0xC8;		//   /  2.
sbit C_T2       = 0xC9;		//   /  2.
sbit TR2        = 0xCA;		//   / 2.
sbit EXEN2      = 0xCB;		//    EX2.
sbit TCLK       = 0xCC;		//    UART  T2.
sbit RCLK       = 0xCD;
sbit EXF2       = 0xCE;
sbit TF2        = 0xCF;		//   / 2.

/*------------------------------------------------------------------------------*/
/* TMOD -     0  1.					*/
/*------------------------------------------------------------------------------*/
#define T0_M0   0x01		/*      0.		*/
#define T0_M1   0x02
#define T0_CT   0x04		/*    /  0.	*/
#define T0_GATE 0x08		/*      0.   */
#define T1_M0   0x10		/*      1.		*/
#define T1_M1   0x20
#define T1_CT   0x40		/*    /  1.	*/
#define T1_GATE 0x80		/*      0.   */

/*------------------------------------------------------------------------------*/
/* PCON -   .						*/
/*------------------------------------------------------------------------------*/
#define IDL     0x01		/*      .	*/
#define STOP    0x02		/*     .   */
#define GF0     0x04		/*   .			*/
#define GF1     0x08
#define POF	0x10		/*  "" .			*/
#define SMOD    0x80		/*    UART.			*/

/*------------------------------------------------------------------------------*/
/* T2MOD -     2.					*/
/*------------------------------------------------------------------------------*/
#define DCEN    0x01		/*      2.	*/
#define T2OE    0x02		/*    T2.			*/

/*------------------------------------------------------------------------------*/
/* WMCON -   WatchDog .				*/
/*------------------------------------------------------------------------------*/
#define WDTEN   0x01		/*   WatchDog .		*/
#define WDTRST  0x02		/*   WatchDog .			*/
#define DPS     0x04		/*    DPTR.			*/
#define EEMEN   0x08		/*    EEPROM.		*/
#define EEMWE   0x10		/*    EEPROM.		*/
#define PS0	0x20	        /*    WatchDog .	        */
#define PS1	0x40
#define PS2	0x80

/*------------------------------------------------------------------------------*/
/* SPCR -   SPI.						*/
/*------------------------------------------------------------------------------*/
#define SPR0	0x01		/*    .			*/
#define SPR1	0x02
#define CPHA	0x04		/*    SCK.				*/
#define CPOL	0x08		/*    SCK.			*/
#define MSTR	0x10		/*   Master/Slave.			*/
#define DORD	0x20		/*    .		*/
#define SPE     0x40		/*   SPI.				*/
#define SPIE	0x80		/*     SPI.	        */

/*------------------------------------------------------------------------------*/
/* SPSR -   SPI.							*/
/*------------------------------------------------------------------------------*/
#define SPIF    0x80		/*    SPI.			*/
#define WCOL	0x40		/*     SPI.			*/

/*------------------------------------------------------------------------------*/
/*       .            */
/* :             .                                    */
/* :            .                                   */
/*------------------------------------------------------------------------------*/
#define IDLE()  PCON|=IDL



/********************************************************************************/
#endif

