/********************************************************************************/
/*										*/
/*	        - 	        */
/*			     1.01  2001 .		   		*/
/*								   		*/
/********************************************************************************/
#include "mk.h"

/*==============================================================================*/
/*                        .			*/
/*==============================================================================*/
  /*----------------------------------------------------------------------------*/
  /* ,    ,   .		*/
  /*----------------------------------------------------------------------------*/
  unsigned char idata String[20];

  /*----------------------------------------------------------------------------*/
  /*    .                                       */
  /*----------------------------------------------------------------------------*/
  struct TRIP_PARAMS idata Trip_Params;

  /*----------------------------------------------------------------------------*/
  /*       32,768-  .          */
  /*----------------------------------------------------------------------------*/
  unsigned char Speed_Interval;

  /*----------------------------------------------------------------------------*/
  /*     /.                                     */
  /*----------------------------------------------------------------------------*/
  unsigned char Speed;

/*==============================================================================*/
/*									        */
/*			     .				*/
/*										*/
/*==============================================================================*/
void main(void)
{
  /*----------------------------------------------------------------------------*/
  /*   .		                                        */
  /*----------------------------------------------------------------------------*/
  enum MODE Mode=FIRST_MODE;

  /*----------------------------------------------------------------------------*/
  /* 			   .			        */
  /*----------------------------------------------------------------------------*/
  /*    - .							*/
  P0=P1=P2=P3=0xff;                      

  /*   .                                        */
  IE=0x00;
  Init_Sys_Timer();             //   .
  Init_Keyboard();              //   .
  Init_Beeper();                //    .
  Init_RTC();                   //   RTC.
  Init_UART();

  /*   RTC   .                           */
  Restore_Trip_Params(Trip_Params);

  /*      RTC.                         */
  T2EX=1;                       //  T2EX -  .
  EXEN2=1;                      //    T2EX.
  ET2=1;                        //     T2EX.

  /*        .     */
  IT1=1;                        //  INT1  .
  EX1=1;                        //     INT1.

  /*       .            */
  TCON|=0x01;                   //  INT0  .
  EX0=1;                        //     INT0.

  /*  1       .         */
  TMOD&=0x0f; TMOD|=0x10;       //  1   1 .
  TL1=TH1=0; Speed_Interval=0;
  Speed=0;
  ET1=1; TR1=0;                 //  1 ,  .

  EA=1;

  /*       50 .			*/
  Pause(50);

  /*        .           */
  Init_LCD();
  sprintf(&String, &Title_Device_Name);
  LCD_Clear(); Write_String_To_LCD(&String);
  LCD_BackLight_ON();           //  .

  /*       0.5 				*/
  Sound_ON(); Pause(500); Sound_OFF();

  /*    "",       . */
  if(is_Mode_Key_Pressed())
    {
      Reset_Mode_Key_State();
      Mode=ABOUT_MODE;
    }

  /*      0.5 .                                    */
  Pause(500);

  /*----------------------------------------------------------------------------*/
  /* 			       .				*/
  /*----------------------------------------------------------------------------*/
  for(;;)
     {
       /*************************************************************************/
       /*                                                                       */
       /*                .                */
       /*                                                                       */
       /*************************************************************************/
       if(Mode == TRIP_COMPUTER_MODE)
         {
           /*-------------------------------------------------------------------*/
           /*      .   */
           /*-------------------------------------------------------------------*/
           enum TRIP_VARIABLES Num_Trip_Variable;
           Restore_Trip_Variable_Num(Num_Trip_Variable);

           /*-------------------------------------------------------------------*/
           /*      ""   .  */
           /*-------------------------------------------------------------------*/
           while(is_Mode_Key_Not_Pressed())
             {
               Pause(120);      //      120 .
               Sound_OFF();     //  .

               /*---------------------------------------------------------------*/
               /*              */
               /*           .        */
               /*---------------------------------------------------------------*/
               switch(Num_Trip_Variable)
                 {
                   /*-----------------------------------------------------------*/
                   case TOTAL_WAY:
                     {
                       //     .
                       unsigned long int Tmp_Way=Trip_Params.Passed_Distance;
                       sprintf(&String, &Title_TOTAL_WAY,
                                        (unsigned int)(Tmp_Way/6000),
                                        (unsigned int)(Tmp_Way%6000)/10);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case TOTAL_WAY

                   /*-----------------------------------------------------------*/
                   case TOTAL_TIME:
                     {
                       //       .
                       unsigned long int Time=Trip_Params.Time_in_Trip;
                       sprintf(&String, &Title_TOTAL_TIME,
                                        (unsigned int)(Time/3600),
                                        (unsigned char)(((unsigned int)(Time%3600))/60),
                                        (unsigned char)(((unsigned int)(Time%3600))%60));
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case TOTAL_TIME

                   /*-----------------------------------------------------------*/
                   case TIME_IN_GO:
                     {
                       //      .
                       unsigned long int Time=Trip_Params.Time_in_Go;
                       sprintf(&String, &Title_TIME_IN_GO,
                                        (unsigned int)(Time/3600),
                                        (unsigned char)(((unsigned int)(Time%3600))/60),
                                        (unsigned char)(((unsigned int)(Time%3600))%60));
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case TIME_IN_GO

                   /*-----------------------------------------------------------*/
                   case CUR_SPEED:
                     {
                       //      .
                       sprintf(&String, &Title_CUR_SPEED, (unsigned char)Speed);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case CUR_SPEED

                   /*-----------------------------------------------------------*/
                   case AVER_SPEED:
                     {
                       //      .
                       unsigned long int Speed_AV;
                       //   <= 6000  (1 )   .
                       if(Trip_Params.Passed_Distance <= 6000) Speed_AV=0;
                       else
                         {
                           //    /.
                           Speed_AV=Trip_Params.Passed_Distance/Trip_Params.Time_in_Go;
                           //    / * 10.
                           Speed_AV=Speed_AV*36/6;
                           //   /,    .
                           if((Speed_AV%10)>=5) Speed_AV=(Speed_AV/10)+1;
                           else Speed_AV/=10;
                         }
                       sprintf(&String, &Title_AVER_SPEED, (unsigned char)Speed_AV);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case AVER_SPEED

                   /*-----------------------------------------------------------*/
                   case TOTAL_FUEL:
                     {
                       //      .
                       unsigned long int Fuel=Trip_Params.Consumed_Fuel/16;
                       sprintf(&String, &Title_TOTAL_FUEL,
                                        (unsigned int)(Fuel/1000),
                                        (unsigned int)(Fuel%1000));
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case TOTAL_FUEL

                   /*-----------------------------------------------------------*/
                   case AVER_FUEL:
                     {
                       //        .
                       unsigned long int Fuel_AV;
                       //   <= 6000  (1 )    .
                       if(Trip_Params.Passed_Distance <= 6000) Fuel_AV=0;
                       else Fuel_AV=((Trip_Params.Consumed_Fuel/16)*1000)/(Trip_Params.Passed_Distance/6);
                       sprintf(&String, &Title_AVER_FUEL,
                                        (unsigned char)(Fuel_AV/10),
                                        (unsigned char)(Fuel_AV%10));
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case AVER_FUEL

                   /*-----------------------------------------------------------*/
                   default:
                     {
                       //   .
                       //    FIRST     RTC.
                       Num_Trip_Variable=FIRST_TRIP_VARIABLE;
                       Store_Trip_Variable_Num(Num_Trip_Variable);
                     }
                 }          // switch  .

               /*---------------------------------------------------------------*/
               /*        . .    */
               /*---------------------------------------------------------------*/
               /*   ""    .		*/
               if(is_Left_Key_Pressed())
                 {
                   //    "".
                   Reset_Left_Key_State();
                   //        .
                   if(Num_Trip_Variable-- == FIRST_TRIP_VARIABLE) Num_Trip_Variable=LAST_TRIP_VARIABLE;
                   Store_Trip_Variable_Num(Num_Trip_Variable);
	           //     .
                   Sound_ON();
                   continue;
                 }

               /*---------------------------------------------------------------*/
               /*   ""    .		*/
               if(is_Right_Key_Pressed())
                 {
                   //    "".
                   Reset_Right_Key_State();
                   //        .
                   if(Num_Trip_Variable++ >= LAST_TRIP_VARIABLE) Num_Trip_Variable=FIRST_TRIP_VARIABLE;
                   Store_Trip_Variable_Num(Num_Trip_Variable);
	           //     .
	           Sound_ON();
                   continue;
                 }

               /*---------------------------------------------------------------*/
               /*    "" / .	*/
               if(is_Enter_Key_Pressed())
                 {
                   //    "".
                   Reset_Enter_Key_State();
                   //      .
                   Trip_Params.State^=0x01;
                   //   RTC  .
                   EA=0; Store_Trip_Params(Trip_Params); EA=1;
	           //    .
	           Sound_ON();
                   continue;
                 }

               /*---------------------------------------------------------------*/
               /*    ""   .	        */
               if(is_Enter_Key_Long_Pressed())
                 {
                   //    .
                   Trip_Params.Time_in_Trip=Trip_Params.Time_in_Go=0;
                   Trip_Params.Passed_Distance=0;
                   Trip_Params.Consumed_Fuel=0;
                   Trip_Params.State=0x01;
                   Speed=0;
                   //   RTC  .
                   EA=0; Store_Trip_Params(Trip_Params); EA=1;
                   //     .
                   Sound_ON();
                   //    "".
                   while(is_Enter_Key_Long_Pressed()) IDLE();
                 }
             }          //    .
         }              //     .


       /*************************************************************************/
       /*                                                                       */
       /*                 .              */
       /*                                                                       */
       /*************************************************************************/
       if(Mode == ECU_VARIABLES_MODE)
         {
           bit UpDownList=UP;   //    .

           /*-------------------------------------------------------------------*/
           /*      .            */
           /*-------------------------------------------------------------------*/
           enum ECU_VARIABLES Num_ECU_Variable;
           Restore_ECU_Variable_Num(Num_ECU_Variable);

           /*-------------------------------------------------------------------*/
           /*      ""   .      */
           /*-------------------------------------------------------------------*/
           while(is_Mode_Key_Not_Pressed())
             {
               Pause(120);      //      120 .
               Sound_OFF();     //  .

               /*---------------------------------------------------------------*/
               /*      readDataByLocalIndentifier.    */
               /*---------------------------------------------------------------*/
               //      -  .
               if(Read_After_Sales_Service_Data() != OK) Connect_To_ECU();
               else
                 {
                   /*-----------------------------------------------------------*/
                   /*          */
                   /*           .    */
                   /*-----------------------------------------------------------*/
                   switch(Num_ECU_Variable)
                     {
                       /*-------------------------------------------------------*/
                       case PASP:
                         {
                           //    .
                           Pause(120);
                           if(Read_Vehicle_Manufacturer_ECU_Identifier() == OK)
                             {
                               //    .
                               Message[10]=0x00;
                               sprintf(&String, &Title_PASP, &Message[2]);
                               LCD_Clear(); Write_String_To_LCD(&String);
                             }
                           else Connect_To_ECU();
                           break;
                         }      // case PASP.

                       /*-------------------------------------------------------*/
                       case THR:
                         {
                           //      .
                           sprintf(&String, &Title_THR, Get_THR());
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case THR.

                       /*-------------------------------------------------------*/
                       case TWAT:
                         {
                           //     .
                           signed char Byte=Get_TWAT();
                           //      .
                           sprintf(&String, &Title_TWAT, Byte);
                           LCD_Clear(); Write_String_To_LCD(&String);
		           //    110  - .
		           if(Byte >= 110) Sound_ON();
                           break;
                         }      // case TWAT.

                       /*-------------------------------------------------------*/
                       case FREQ:
                         {
                           //    .
                           //   2550    10,  - 40.
                           unsigned int Word=Get_FREQ();
			   if(Word < 2550) Word=Get_FREQX();
                           //      .
                           sprintf(&String, &Title_FREQ, Word);
                           LCD_Clear(); Write_String_To_LCD(&String);
		           //    5550 - .
		           if(Word > 5500) Sound_ON();
                           break;
                         }      // case FREQ.

                       /*-------------------------------------------------------*/
                       case JUFRXX:
                         {
                           //      .
                           sprintf(&String, &Title_JUFRXX, Get_JUFRXX());
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case JUFRXX.

                       /*-------------------------------------------------------*/
                       case UOZ:
                         {
                           //      .
                           sprintf(&String, &Title_UOZ, Get_UOZ());
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case UOZ.

                       /*-------------------------------------------------------*/
                       case JSPEED:
                         {
                           //      .
                           sprintf(&String, &Title_JSPEED, Get_JSPEED());
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case JSPEED.

                       /*-------------------------------------------------------*/
                       case FSM:
                         {
                           //      .
                           sprintf(&String, &Title_FSM, Get_FSM());
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case FSM.

                       /*-------------------------------------------------------*/
                       case SSM:
                         {
                           //      .
                           sprintf(&String, &Title_SSM, Get_SSM());
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case SSM.

                       /*-------------------------------------------------------*/
                       case JAUACC:
                         {
                           //      .
                           unsigned int Word=Get_JAUACC();
                           sprintf(&String, &Title_JAUACC, (unsigned char)(Word/100), (unsigned char)(Word%100));
                           LCD_Clear(); Write_String_To_LCD(&String);
                           //    10   15 - .
                           if((Word <= 1000) || (Word >= 1500)) Sound_ON();
                           break;
                         }      // case JAUACC.

                       /*-------------------------------------------------------*/
                       case RCO:
                         {
                           //   CO  
                           //     .
                           if(is_Lambda_Present())
                             {
                               //    .
                               //   .
                               if(UpDownList == DOWN) Num_ECU_Variable--;
                               else Num_ECU_Variable++;
                             }
                           else
                             {
                               //     .
                               //      CO.
                               if((signed char)Message[11] < 0)
                                 {
                                   unsigned int Word=(((unsigned int)(-Message[11]))*1000)>>8;
                                   sprintf(&String, &Title_RCO, '-', Word);
                                 }
                               else
                                 {
                                   unsigned int Word=(((unsigned int)Message[11])*1000)>>8;
                                   sprintf(&String, &Title_RCO, '+', Word);
                                 } 
                               LCD_Clear(); Write_String_To_LCD(&String);
                             }
                           break;
                         }      // case RCO.

                       /*-------------------------------------------------------*/
                       case VALF:
                         {
                           //  /  
                           //     .
                           if(is_Lambda_Present())
                             {
                               //    .
                               //     /.
			       unsigned int Word=Get_VALF();
			       sprintf(&String, &Title_VALF, (unsigned char)(Word/100), (unsigned char)(Word%100));
                               LCD_Clear(); Write_String_To_LCD(&String);
                             }
                           else
                             {
                               //     .
                               //   .
                               if(UpDownList == DOWN) Num_ECU_Variable--;
                               else Num_ECU_Variable++;
                             }
                           break;
                         }      // case VALF.

                       /*-------------------------------------------------------*/
                       case COEFFF:
                         {
                           //    .  .
                           unsigned int Word=Get_COEFFF();
		           sprintf(&String, &Title_COEFFF, (unsigned char)(Word/100), (unsigned char)(Word%100));
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case COEFFF.

                       /*-------------------------------------------------------*/
                       case JALAM:
                         {
                           //     
                           //      .
                           if(is_Lambda_Present())
                             {
                               //    .
                               //      .
                               unsigned char Byte=Get_JALAM();
			       sprintf(&String, &Title_JALAM, (unsigned char)(Byte/100), (unsigned char)(Byte%100));
                               LCD_Clear(); Write_String_To_LCD(&String);
                             }
                           else
                             {
                               //     .
                               //   .
                               if(UpDownList == DOWN) Num_ECU_Variable--;
                               else Num_ECU_Variable++;
                             }
                           break;
                         }      // case JALAM.

                       /*-------------------------------------------------------*/
                       case INJ:
                         {
                           //      .
                           unsigned int Word;
                           if(is_Lambda_Present())
                             Word=((((unsigned int)Message[25]<<8)|Message[24])*10)>>7;
                           else
                             Word=((((unsigned int)Message[23]<<8)|Message[22])*10)>>7;
		           sprintf(&String, &Title_INJ, (unsigned char)(Word/10), (unsigned char)(Word%10));
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case INJ.

                       /*-------------------------------------------------------*/
                       case JGBC:
                         {
                           //      .
                           unsigned int Word;
                           if(is_Lambda_Present())
                             Word=(((unsigned int)Message[29]<<8)|Message[28])/6;
                           else
                             Word=(((unsigned int)Message[27]<<8)|Message[26])/6;
		           sprintf(&String, &Title_JGBC, Word);
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case JGBC.

                       /*-------------------------------------------------------*/
                       case JAIR:
                         {
                           //      .
                           unsigned int Word;
                           if(is_Lambda_Present())
		             Word=((unsigned int)Message[27]<<8)|Message[26];
                           else
		             Word=((unsigned int)Message[25]<<8)|Message[24];
			   sprintf(&String, &Title_JAIR, (unsigned char)(Word/10),(unsigned char)(Word%10));
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case JAIR.

                       /*-------------------------------------------------------*/
                       case JQT:
                         {
                           //      .
                           unsigned int Word;
                           if(is_Lambda_Present())
                             Word=(((unsigned int)Message[31]<<8)|Message[30])/5;
                           else
                             Word=(((unsigned int)Message[29]<<8)|Message[28])/5;
		           sprintf(&String, &Title_JQT, (unsigned char)(Word/10),(unsigned char)(Word%10));
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case JQT.

                       /*-------------------------------------------------------*/
                       case JQD:
                         {
                           //      .
                           unsigned char Byte;
                           if(is_Lambda_Present())
                             Byte=(((unsigned int)Message[33]<<8)|Message[32])>>7;
                           else
                             Byte=(((unsigned int)Message[31]<<8)|Message[30])>>7;

                           //   40/100  .
			   if(Byte < 40)
                             sprintf(&String, &Title_JQD, Byte);
                           else
                             sprintf(&String, &Title_Non_JQD);
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case JQD.

                       /*-------------------------------------------------------*/
                       case DET:
                         {
                           //      .
                           if(is_Detonation_Present())
                             {
                               sprintf(&String,&Title_DET,&Title_YES);
                               Sound_ON();     //  .
                             }
                           else
                             {
                               sprintf(&String,&Title_DET,&Title_NO);
                             }
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case DET.

                       /*-------------------------------------------------------*/
                       case BLKINJ:
                         {
                           //      .
                           if(is_Injector_Blocking())
                             {
                               sprintf(&String,&Title_BLKINJ,&Title_YES);
                               Sound_ON();     //  .
                             }
                           else
                             {
                               sprintf(&String,&Title_BLKINJ,&Title_NO);
                             }
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case BLKINJ.

                       /*-------------------------------------------------------*/
                       case RXX:
                         {
                           //      .
                           if(is_Idle_Step())
                             sprintf(&String,&Title_RXX,&Title_YES);
                           else
                             sprintf(&String,&Title_RXX,&Title_NO);
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case RXX.

                       /*-------------------------------------------------------*/
                       case BITPOW:
                         {
                           //      .
                           if(is_Power_Mode())
                             {
                               sprintf(&String,&Title_BITPOW,&Title_YES);
                               Sound_ON();
                             }
                           else
                             {
                               sprintf(&String,&Title_BITPOW,&Title_NO);
                             }
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }      // case BITPOW.

                       /*-------------------------------------------------------*/
                       default:
                         {
			   //     -    FIRST
                           //     .
                           Num_ECU_Variable=FIRST_ECU_VARIABLE;
                           Store_ECU_Variable_Num(Num_ECU_Variable);
                         }
                     }          // switch  .
                 }              //   .

               /*---------------------------------------------------------------*/
               /*        . .    */
               /*---------------------------------------------------------------*/
               /*   ""    .		*/
               if(is_Left_Key_Pressed())
                 {
                   //    "".
                   Reset_Left_Key_State();
                   //        .
                   if(Num_ECU_Variable-- == FIRST_ECU_VARIABLE) Num_ECU_Variable=LAST_ECU_VARIABLE;
                   Store_ECU_Variable_Num(Num_ECU_Variable);
                   //     .
                   UpDownList=DOWN;
		   //     .
	           Sound_ON();
                   continue;
                 }

               /*---------------------------------------------------------------*/
               /*   ""    .		*/
               if(is_Right_Key_Pressed())
                 {
                   //    "".
                   Reset_Right_Key_State();
                   //        .
                   if(Num_ECU_Variable++ >= LAST_ECU_VARIABLE) Num_ECU_Variable=FIRST_ECU_VARIABLE;
                   Store_ECU_Variable_Num(Num_ECU_Variable);
                   //     .
                   UpDownList=UP;
		   //     .
	           Sound_ON();
                 }
             }          //    .
         }              //      .

       /*************************************************************************/
       /*                                                                       */
       /*                .      */
       /*                                                                       */
       /*************************************************************************/
       if(Mode == ECU_TROUBLES_CODE_MODE)
         {
           unsigned char CurError=0;      //    .

           /*-------------------------------------------------------------------*/
           /*           .    */
           /*-------------------------------------------------------------------*/
           while(is_Mode_Key_Not_Pressed())
             {
               /*      120 .	                */
               Pause(120);      //      120 .
               Sound_OFF();     //  .

               /*      .            */
               /*      -  .                 */
               if(Read_Diagnostic_Trouble_Codes() != OK) Connect_To_ECU();
               else
                 {
                   /*     .                       */
                   /*     .                            */
                   sprintf(&String, &Title_ERRORS, nErrors());
                   LCD_Clear(); Write_String_To_LCD(&String);

                   /*    -     .      */
                   if((nErrors() != 0) && (is_Left_Key_Pressed() ||
                       is_Right_Key_Pressed() || is_Enter_Key_Pressed()))
                      {
                        Sound_ON();
                        Reset_Left_Key_State();
                        Reset_Right_Key_State();
                        Reset_Enter_Key_State();
                        break;
                      }
                 }
             }          //     .

           /*-------------------------------------------------------------------*/
           /*      .              */
           /*-------------------------------------------------------------------*/
           /*       "" -  ,       */
           /*     "" -   . */
           while(is_Mode_Key_Not_Pressed() && is_Enter_Key_Not_Long_Pressed())
             {
               /*---------------------------------------------------------------*/
               /*      120 .	                */
               Pause(120);      //      120 .
               Sound_OFF();     //  .

               /*---------------------------------------------------------------*/
               /*      .                 */
               sprintf(&String, &Title_CUR_ERROR, CurError,
                        Message[2+CurError*3], Message[3+CurError*3]);
               LCD_Clear(); Write_String_To_LCD(&String);

               /*---------------------------------------------------------------*/
               /*   ""    .		*/
               if(is_Left_Key_Pressed())
                 {
                   //    "".
                   Reset_Left_Key_State();
                   //      .
		   if(CurError-- == 0) CurError=nErrors()-1;
		   //     .
	           Sound_ON();
                 }

               /*---------------------------------------------------------------*/
               /*   ""    .		*/
               if(is_Right_Key_Pressed())
                 {
                   //    "".
                   Reset_Right_Key_State();
                   //      .
		   if(CurError++ >= (nErrors()-1)) CurError=0;
		   //     .
	           Sound_ON();
                 }
             }          //     .

           /*-------------------------------------------------------------------*/
           /*       .*/
           /*-------------------------------------------------------------------*/
           if(is_Mode_Key_Pressed())
             {
               /*     "".                         */
               /*    .	                        */
             }
           else
             {
               /*       "".            */
               /*    ""   .     */
               /*       .             */
               while(is_Enter_Key_Long_Pressed())
                 {
                   /*      120 .      */
                   Pause(120);

                   /*      .          */
                   /*      -  .             */
                   if(Clear_Diagnostic_Information() != OK) Connect_To_ECU();
                   else
                     {
                       /*   .                           */
                       break;
                     }
                 }      //    .
             }

           Sound_ON();  //     .
         }              //       .

       /*************************************************************************/
       /*                                                                       */
       /*           .   */
       /*                                                                       */
       /*************************************************************************/
       if(Mode == ECU_IO_CONTROL_MODE)
         {
           bit UpDownList=UP;   //    .

           /*-------------------------------------------------------------------*/
           /*      .         */
           /*-------------------------------------------------------------------*/
           enum ECU_IO_PARAMETERS Num_ECU_IOParameter;
           Restore_ECU_IOControl_Num(Num_ECU_IOParameter);

           /*-------------------------------------------------------------------*/
           /*      ""  . . .      */
           /*-------------------------------------------------------------------*/
           while(is_Mode_Key_Not_Pressed())
             {
               Pause(120);      //      120 .
               Sound_OFF();     //  .

               /*---------------------------------------------------------------*/
               /*            .          */
               /*---------------------------------------------------------------*/
               switch(Num_ECU_IOParameter)
                 {
                   /*-----------------------------------------------------------*/
                   case CHECK_ENGINE:
                     {
                       /*-------------------------------------------------------*/
                       /*     Check Engine.      */
                       /*-------------------------------------------------------*/
                       if(Get_CE_Lamp_State() != OK) { Connect_To_ECU(); break; }
                       if(is_CE_Lamp_ON())
                         sprintf(&String, &Title_CHECK_ENGINE, &Title_YES);
                       else
                         sprintf(&String, &Title_CHECK_ENGINE, &Title_NO);
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""    .  */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .
                       //       Check Engine.
                       Sound_ON();
                       Reset_Enter_Key_State();
                       while(is_Enter_Key_Not_Pressed())
                         {
                           //    - 120 .
                       	   Pause(120);
                           Sound_OFF();         //  .

                           //     Check Engine.
                           if(Get_CE_Lamp_State() != OK) { Connect_To_ECU(); continue; }
                           if(is_CE_Lamp_ON())
                             sprintf(&String+1, &Title_CHECK_ENGINE, &Title_YES);
                           else
                             sprintf(&String+1, &Title_CHECK_ENGINE, &Title_NO);
                           String[0]='*';       //    .
                           LCD_Clear(); Write_String_To_LCD(&String);

                           //   ""   Check Engine.
                           if(is_Left_Key_Pressed())
                             {
                               //    "".
                               Reset_Left_Key_State();
                               //   Check Engine.
                               Pause(120); Set_CE_Lamp_OFF();
      		               //     .
                               Sound_ON();
                               continue;
                             }

                           //   ""   Check Engine.
                           if(is_Right_Key_Pressed())
                             {
                               //    "".
                               Reset_Right_Key_State();
                               //   Check Engine.
	                       Pause(120); Set_CE_Lamp_ON();
                               //     .
	                       Sound_ON();
                               continue;
                             }
                         }              //    Check Engine.

                       //    Check Engine .
                       Reset_Enter_Key_State();

                       //    Check Engine .    
                       while(Return_Control_CE_Lamp_To_ECU() != OK)
                         {
                           Connect_To_ECU(); Pause(120);
                         }
                       Sound_ON();
                       break;
                     }                  // case CHECK_ENGINE.

                   /*-----------------------------------------------------------*/
                   case COOLING_FAN_RELAY:
                     {
                       /*-------------------------------------------------------*/
                       /*     .  */
                       /*-------------------------------------------------------*/
                       if(Get_Cooling_Fan_State() != OK) { Connect_To_ECU(); break; }
                       if(is_Cooling_Fan_ON())
                         sprintf(&String, &Title_ENGINE_COOLER, &Title_YES);
                       else
                         sprintf(&String, &Title_ENGINE_COOLER, &Title_NO);
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""    .  */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .
                       //      .
                       Sound_ON();
                       Reset_Enter_Key_State();
                       while(is_Enter_Key_Not_Pressed())
                         {
                           //    - 120 .
                       	   Pause(120);
                           Sound_OFF();             //  .

                           //    .
                           if(Get_Cooling_Fan_State() != OK) { Connect_To_ECU(); continue; }
                           if(is_Cooling_Fan_ON())
                             sprintf(&String+1, &Title_ENGINE_COOLER, &Title_YES);
                           else
                             sprintf(&String+1, &Title_ENGINE_COOLER, &Title_NO);
                           String[0]='*';       //    .
                           LCD_Clear(); Write_String_To_LCD(&String);

                           //   ""  .
                           if(is_Left_Key_Pressed())
                             {
                               //    "".
                               Reset_Left_Key_State();
                               //    .
	                       Pause(120); Set_Cooling_Fan_OFF();
          		       //     .
	                       Sound_ON();
                               continue;
                             }

                           //   ""  .
                           if(is_Right_Key_Pressed())
                             {
                               //    "".
                               Reset_Right_Key_State();
                               //    .
	                       Pause(120); Set_Cooling_Fan_ON();
		               //     .
	                       Sound_ON();
                               continue;
                             }
                         }              //     .

                       //    .
                       Reset_Enter_Key_State();

                       //    .
                       while(Return_Control_Cooling_Fan_To_ECU() != OK)
                         {
                           Connect_To_ECU(); Pause(120);
                         }
                       Sound_ON();
                       break;
                     }                  // case COOLING_FAN_RELAY.

                   /*-----------------------------------------------------------*/
                   case FUEL_PUMP_RELAY:
                     {
                       /*-------------------------------------------------------*/
                       /*    -   .   */
                       /*-------------------------------------------------------*/
                       if(Read_After_Sales_Service_Data() != OK) { Connect_To_ECU(); break; }
                       if(is_Engine_ON())
                         {
                           sprintf(&String, &Title_FUEL_PUMP, "--");
                           LCD_Clear(); Write_String_To_LCD(&String);
                           break;
                         }

                       /*-------------------------------------------------------*/
                       /*    .             */
                       /*-------------------------------------------------------*/
               	       Pause(120);
                       if(Get_Fuel_Pump_State() != OK) { Connect_To_ECU(); break; }
                       if(is_Fuel_Pump_ON())
                          sprintf(&String, &Title_FUEL_PUMP, &Title_YES);
                       else
                          sprintf(&String, &Title_FUEL_PUMP, &Title_NO);
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""    .  */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .
                       //      .
                       Sound_ON();
                       Reset_Enter_Key_State();
                       while(is_Enter_Key_Not_Pressed())
                         {
                           //    - 120 .
                       	   Pause(120);
                           Sound_OFF();             //  .

                           //    .
                           //    -   .
                           if(Read_After_Sales_Service_Data() != OK) { Connect_To_ECU(); continue; }
                           if(is_Engine_ON()) break;

                           //  .
                           //    .
                       	   Pause(120);
                           if(Get_Fuel_Pump_State() != OK) { Connect_To_ECU(); continue; }
                           if(is_Fuel_Pump_ON())
                             sprintf(&String+1, &Title_FUEL_PUMP, &Title_YES);
                           else
                             sprintf(&String+1, &Title_FUEL_PUMP, &Title_NO);
                           String[0]='*';       //    .
                           LCD_Clear(); Write_String_To_LCD(&String);

                           //   ""  .
                           if(is_Left_Key_Pressed())
                             {
                               //    "".
                               Reset_Left_Key_State();
                               //  .
	                       Pause(120); Set_Fuel_Pump_OFF();
          		       //     .
	                       Sound_ON();
                               continue;
                             }

                           //   ""  .
                           if(is_Right_Key_Pressed())
                             {
                               //    "".
                               Reset_Right_Key_State();
                               //  .
                               Pause(120); Set_Fuel_Pump_ON();
		               //     .
	                       Sound_ON();
                               continue;
                             }
                         }              //   .

                       //     
                       //   "",   .
                       if(is_Enter_Key_Not_Pressed()) break;

                       //     .
                       //    .
                       Reset_Enter_Key_State();
                       while(Return_Control_Fuel_Pump_To_ECU() != OK)
                         {
                           Connect_To_ECU(); Pause(120);
                         }
                       Sound_ON();
                       break;
                     }                  // case FUEL_PUMP_RELAY

                   /*-----------------------------------------------------------*/
                   case IGNITION_1:
                   case IGNITION_2:
                     {
                       /*-------------------------------------------------------*/
                       /*     .        */
                       /*-------------------------------------------------------*/
                       unsigned char Ignition=(unsigned char)(Num_ECU_IOParameter-IGNITION_1);

                       /*-------------------------------------------------------*/
                       /*     .                         */
                       /*-------------------------------------------------------*/
                       if(Tester_Present() != OK) { Connect_To_ECU(); break; }

                       /*-------------------------------------------------------*/
                       /*   "[n].                        */
                       /*-------------------------------------------------------*/
                       sprintf(&String, &Title_IGNITION, Ignition+1, "\0");
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""  .          */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .  .
                       Reset_Enter_Key_State();

                       //    .
                       Pause(120);      //   Tester_Present.
                       if(Set_Ignition_ON(Ignition) != OK) break;

                       //     
                       //      .
                       sprintf(&String, &Title_IGNITION, Ignition+1, "***");
                       LCD_Clear(); Write_String_To_LCD(&String);
                       Sound_ON();              //   .
                       break;
                     }                  // case IGNITION_1
                                        // case IGNITION_2

                   /*-----------------------------------------------------------*/
                   case INJECTOR_1:
                   case INJECTOR_2:
                   case INJECTOR_3:
                   case INJECTOR_4:
                     {
                       /*-------------------------------------------------------*/
                       /*    .                 */
                       /*-------------------------------------------------------*/
                       unsigned char Injector=(unsigned char)(Num_ECU_IOParameter-INJECTOR_1);

                       /*-------------------------------------------------------*/
                       /*     .                         */
                       /*-------------------------------------------------------*/
                       if(Tester_Present() != OK) { Connect_To_ECU(); break; }

                       /*-------------------------------------------------------*/
                       /*   "[n].                       */
                       /*-------------------------------------------------------*/
                       sprintf(&String, &Title_INJECTOR, Injector+1, "\0");
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""  .         */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .  .
                       Reset_Enter_Key_State();

                       //    .
                       Pause(120);      //   Tester_Present.
                       if(Set_Injector_ON(Injector) != OK) break;

                       //     
                       //      .
                       sprintf(&String, &Title_INJECTOR, Injector+1, "***");
                       LCD_Clear(); Write_String_To_LCD(&String);
                       Sound_ON();              //   .
                       break;
                     }                  // case INJECTOR_1
                                        // case INJECTOR_2
                                        // case INJECTOR_3
                                        // case INJECTOR_4

                   /*-----------------------------------------------------------*/
                   case CO_TRIMMING:
                     {
                       /*      . */
                       if(Read_After_Sales_Service_Data() != OK) { Connect_To_ECU(); break; }
                       if(is_Lambda_Present())
                         {
                           //    .
                           //     .
                           if(UpDownList == DOWN) Num_ECU_IOParameter--;
                           else Num_ECU_IOParameter++;
                           break;
                         }

                       /*-------------------------------------------------------*/
                       /*     .           */
                       /*      .*/
                       /*-------------------------------------------------------*/
               	       Pause(120);
                       if(Get_CO_Trimmer_State() != OK) { Connect_To_ECU(); break; }
                       if((signed char)Message[3] < 0)
                         {
                           unsigned int Word=(((unsigned int)(-Message[3]))*1000)>>8;
                           sprintf(&String, &Title_RCO, '-', Word);
                         }
                       else
                         {
                           unsigned int Word=(((unsigned int)Message[3])*1000)>>8;
                           sprintf(&String, &Title_RCO, '+', Word);
                         } 
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""    .  */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .
                       //      .  .
                       Sound_ON();
                       Reset_Enter_Key_State();
                       while(is_Enter_Key_Not_Pressed())
                         {
                           //    - 120 .
                       	   Pause(120);
                           Sound_OFF();             //  .

                           //    .  CO.
                           if(Get_CO_Trimmer_State() != OK) { Connect_To_ECU(); continue; }
                           if((signed char)Message[3] < 0)
                             {
                               unsigned int Word=(((unsigned int)(-Message[3]))*1000)>>8;
                               sprintf(&String+1, &Title_RCO, '-', Word);
                             }
                           else
                             {
                               unsigned int Word=(((unsigned int)Message[3])*1000)>>8;
                               sprintf(&String+1, &Title_RCO, '+', Word);
                             } 
                           String[0]='*';       //    CO.
                           LCD_Clear(); Write_String_To_LCD(&String);

                           //   ""  .  CO.
                           if(is_Left_Key_Pressed())
                             {
                               //    "".
                               Reset_Left_Key_State();

                               //    CO.
	                       Pause(120); Set_RCO_Value(Message[3]-1);

          		       //    .
	                       Sound_ON();
                               continue;
                             }

                           //    "" 
                           // .  CO  5 .
                           if(is_Left_Key_Long_Pressed())
                             {
                               //   5   CO.
                               Pause(120); Set_RCO_Value(Message[3]-5);
          		       //    .
	                       Sound_ON();
                               continue;
                             }

                           //   ""  .  CO.
                           if(is_Right_Key_Pressed())
                             {
                               //    "".
                               Reset_Right_Key_State();
                               //    CO.
                               Pause(120); Set_RCO_Value(Message[3]+1);
		               //    .
	                       Sound_ON();
                               continue;
                             }

                           //    "" 
                           // .  CO  5 .
                           if(is_Right_Key_Long_Pressed())
                             {
                               //   5   CO.
                               Pause(120); Set_RCO_Value(Message[3]+5);
          		       //    .
	                       Sound_ON();
                               continue;
                             }
                         }              //   CO.

                       //   CO .
                       Reset_Enter_Key_State();

                       //   .   .
                       while(Return_Control_CO_Trimmer_To_ECU() != OK)
                         {
                           Connect_To_ECU(); Pause(120);
                         }
                       Sound_ON();
                       break;
                     }                  // case CO_TRIMMING

                   /*-----------------------------------------------------------*/
                   case IDLE_ENGINE_SPEED:
                     {
                       /*-------------------------------------------------------*/
                       /*     .              */
                       /*-------------------------------------------------------*/
                       if(Get_Idle_Engine_Speed() != OK) { Connect_To_ECU(); break; }
                       sprintf(&String, &Title_FREQX, (unsigned int)(Message[5]*10));
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""    .  */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .
                       //       .
                       Sound_ON();
                       Reset_Enter_Key_State();
                       while(is_Enter_Key_Not_Pressed())
                         {
                           //    - 120 .
                       	   Pause(120);
                           Sound_OFF();             //  .

                           //     .
                           if(Get_Idle_Engine_Speed() != OK) { Connect_To_ECU(); continue; }
                           sprintf(&String+1, &Title_FREQX, (unsigned int)(Message[5]*10));
                           String[0]='*';       //     .
                           LCD_Clear(); Write_String_To_LCD(&String);

                           //   ""   .
                           if(is_Left_Key_Pressed())
                             {
                               //    "".
                               Reset_Left_Key_State();
                               //   .
                               if(Message[6] != 0) Message[6]--;
                               Pause(120); Set_Idle_Engine_Speed(Message[6]);
          		       //     .
	                       Sound_ON();
                               continue;
                             }

                           //    "" 
                           //    50 /.
                           if(is_Left_Key_Long_Pressed())
                             {
                               //   50  .
                               if(Message[6] >= 10) Message[6]-=5;
                               Pause(120); Set_Idle_Engine_Speed(Message[6]);
          		       //     .
	                       Sound_ON();
                               continue;
                             }

                           //   ""   .
                           if(is_Right_Key_Pressed())
                             {
                               //    "".
                               Reset_Right_Key_State();
                               //   .
                               if(Message[6] != 255) Message[6]++;
                               Pause(120); Set_Idle_Engine_Speed(Message[6]);
		               //     .
	                       Sound_ON();
                               continue;
                             }

                           //    "" 
                           //    50 /.
                           if(is_Right_Key_Long_Pressed())
                             {
                               //   50  .
                               if(Message[6] <= 245) Message[6]+=5;
                               Pause(120); Set_Idle_Engine_Speed(Message[6]);
          		       //     .
	                       Sound_ON();
                               continue;
                             }
                         }              //    .

                       //     .
                       Reset_Enter_Key_State();

                       //     .
                       while(Return_Control_Idle_Engine_Speed_To_ECU() != OK)
                         {
                           Connect_To_ECU(); Pause(120);
                         }
                       Sound_ON();
                       break;
                     }                  // case IDLE_ENGINE_SPEED.

                   /*-----------------------------------------------------------*/
                   case IDLE_STEP_MOTOR:
                     {
                       /*-------------------------------------------------------*/
                       /*     .           */
                       /*-------------------------------------------------------*/
                       if(Get_Idle_Step_Motor_Position() != OK) { Connect_To_ECU(); break; }
                       sprintf(&String, &Title_FSM,Message[4]);
                       LCD_Clear(); Write_String_To_LCD(&String);

                       /*-------------------------------------------------------*/
                       /*    ""    .  */
                       /*-------------------------------------------------------*/
                       if(is_Enter_Key_Not_Pressed()) break;

                       //  "" .
                       //       .
                       Sound_ON();
                       Reset_Enter_Key_State();
                       while(is_Enter_Key_Not_Pressed())
                         {
                           //    - 120 .
                           Pause(120);
                           Sound_OFF();             //  .

                           //     .
                           if(Get_Idle_Step_Motor_Position() != OK) { Connect_To_ECU(); continue; }
                           sprintf(&String+1, &Title_FSM, Message[4]);
                           String[0]='*';       //    .
                           LCD_Clear(); Write_String_To_LCD(&String);

                           //   ""   .
                           if(is_Left_Key_Pressed())
                             {
                               //    "".
                               Reset_Left_Key_State();
                               //   .
                               if(Message[4] != 0) Message[4]--;
                               Pause(120); Set_Idle_Step_Motor_Position(Message[4]);
          		       //     .
	                       Sound_ON();
                               continue;
                             }

                           //    "" 
                           //    5 .
                           if(is_Left_Key_Long_Pressed())
                             {
                               //   5   .
                               if(Message[4] >= 10) Message[4]-=5;
                               Pause(120); Set_Idle_Step_Motor_Position(Message[4]);
          		       //     .
	                       Sound_ON();
                               continue;
                             }

                           //   ""   .
                           if(is_Right_Key_Pressed())
                             {
                               //    "".
                               Reset_Right_Key_State();
                               //   .
                               if(Message[4] != 255) Message[4]++;
                               Pause(120); Set_Idle_Step_Motor_Position(Message[4]);
		               //     .
	                       Sound_ON();
                               continue;
                             }

                           //    "" 
                           //    5 .
                           if(is_Right_Key_Long_Pressed())
                             {
                               //   5  .
                               if(Message[4] <= 245) Message[4]+=5;
                               Pause(120); Set_Idle_Step_Motor_Position(Message[4]);
          		       //     .
	                       Sound_ON();
                               continue;
                             }
                         }              //    .

                       //     .
                       Reset_Enter_Key_State();

                       //     .
                       while(Return_Control_Idle_Step_Motor_To_ECU() != OK)
                         {
                           Connect_To_ECU(); Pause(120);
                         }
                       Sound_ON();
                       break;
                     }                  // case IDLE_STEP_MOTOR.

                   /*-----------------------------------------------------------*/
                   default:
                     {
		       //     -    FIRST.
                       //     .
                       Num_ECU_IOParameter=FIRST_ECU_IO_PARAMETER;
                       Store_ECU_IOControl_Num(Num_ECU_IOParameter);
                     }
                 }         // switch   .

               /*---------------------------------------------------------------*/
               /*        . .    */
               /*---------------------------------------------------------------*/
               /*   ""    .		        */
               if(is_Left_Key_Pressed())
                 {
                   //    "".
                   Reset_Left_Key_State();
                   //    .
		   if(Num_ECU_IOParameter-- == FIRST_ECU_IO_PARAMETER) Num_ECU_IOParameter=LAST_ECU_IO_PARAMETER;
                   //     .
                   UpDownList=DOWN;
		   //     .
	           Sound_ON();
                 }

               /*---------------------------------------------------------------*/
               /*   ""    .		        */
               if(is_Right_Key_Pressed())
                 {
                   //    "".
                   Reset_Right_Key_State();
                   //    .
		   if(Num_ECU_IOParameter++ >= LAST_ECU_IO_PARAMETER) Num_ECU_IOParameter=FIRST_ECU_IO_PARAMETER;
                   //     .
                   UpDownList=UP;
		   //     .
	           Sound_ON();
                 }
             }          //     .
         }              //      . .


       /*************************************************************************/
       /*                                                                       */
       /*                .       */
       /*                                                                       */
       /*************************************************************************/
       if(Mode == ABOUT_MODE)
         {
           enum ABOUT_INFO Num_About_Info=FIRST_ABOUT_INFO;

           /*-------------------------------------------------------------------*/
           /*      ""    .   */
           /*-------------------------------------------------------------------*/
           while(is_Mode_Key_Not_Pressed())
             {
               Pause(120);      //      120 .
               Sound_OFF();     //  .

               /*---------------------------------------------------------------*/
               /*                 .           */
               /*---------------------------------------------------------------*/
               switch(Num_About_Info)
                 {
                   /*-----------------------------------------------------------*/
                   case DEVICE_NAME:
                     {
                       //     .
                       sprintf(&String, &Title_Device_Name);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case DEVICE_NAME

                   /*-----------------------------------------------------------*/
                   case HARDWARE_VERSION:
                     {
                       //       .
                       sprintf(&String, &Title_HW_Version_Num);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case HARDWARE_VERSION

                   /*-----------------------------------------------------------*/
                   case SOFTWARE_VERSION:
                     {
                       //       .
                       sprintf(&String, &Title_SW_Version_Num);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case SOFTWARE_VERSION

                   /*-----------------------------------------------------------*/
                   case AUTOR_1:
                     {
                       //       .
                       sprintf(&String, &Title_Autor_1);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case AUTOR_1

                   /*-----------------------------------------------------------*/
                   case AUTOR_2:
                     {
                       //       .
                       sprintf(&String, &Title_Autor_2);
                       LCD_Clear(); Write_String_To_LCD(&String);
                       break;
                     }          // case AUTOR_2

                   /*-----------------------------------------------------------*/
                   default:
                     {
                       //   .
                       //    FIRST.
                       Num_About_Info=FIRST_ABOUT_INFO;
                     }
                 }          // switch  .

               /*---------------------------------------------------------------*/
               /*        . .    */
               /*---------------------------------------------------------------*/
               /*   ""    . .      */
               if(is_Left_Key_Pressed())
                 {
                   //    "".
                   Reset_Left_Key_State();
                   //      .
                   if(Num_About_Info-- == FIRST_ABOUT_INFO) Num_About_Info=LAST_ABOUT_INFO;
	           //    .
                   Sound_ON();
                   continue;
                 }

               /*---------------------------------------------------------------*/
               /*   ""    . .      */
               if(is_Right_Key_Pressed())
                 {
                   //    "".
                   Reset_Right_Key_State();
                   //      .
                   if(Num_About_Info++ == LAST_ABOUT_INFO) Num_About_Info=FIRST_ABOUT_INFO;
	           //    .
	           Sound_ON();
                   continue;
                 }
             }          //      .
         }              //       .

       /*************************************************************************/
       /*                                                                       */
       /*                "".              */
       /*                                                                       */
       /*************************************************************************/
       if(is_Mode_Key_Pressed())
         {
           //    "".
           Reset_Mode_Key_State();
           //   .
           if(Mode++ >= LAST_MODE) Mode=FIRST_MODE;
           //    .
           Sound_ON();
         }

       /*=======================================================================*/
     }			//   .
  return;
}                       //   .

/*------------------------------------------------------------------------------*/
/*     INT0 -    .             */
/*------------------------------------------------------------------------------*/
void IRQ_Speedometer_Lable(void) interrupt 0
{
  //         0.5 .
  union LONG_INT
    {
      unsigned long int Long;
      unsigned char Byte[4];
    };
  union LONG_INT Interval;
  unsigned int Tmp;

  TR1=0;
  Interval.Byte[3]=TL1; Interval.Byte[2]=TH1;
  Interval.Byte[1]=Speed_Interval; Interval.Byte[0]=0;
  TH1=TL1=0;
  Speed_Interval=0;
  TR1=1;

  //    .
  Tmp=((16666666/Interval.Long)*72)/100;
  Speed=Tmp/10;
  if((Tmp%10) >= 5) Speed++;

  // ,     .
  if((Trip_Params.State&0x01) != 0)
    {
      //    .
      Trip_Params.Passed_Distance++;
    }

  return;
}

/*------------------------------------------------------------------------------*/
/*     INT1 -     .      */
/*------------------------------------------------------------------------------*/
void IRQ_Fuel_Lable(void) interrupt 2
{
  // ,     .
  if((Trip_Params.State&0x01) != 0)
    {
      //     .
      Trip_Params.Consumed_Fuel++;
    }

  return;
}

/*------------------------------------------------------------------------------*/
/*     T2EX -    RTC.                */
/*------------------------------------------------------------------------------*/
void IRQ_1sec_Lable(void) interrupt 5
{
  if(EXF2)
    {
      //    RTC.
      EXF2=0;

      // ,     .
      if((Trip_Params.State&0x01) != 0)
        {
          //      1 .
          Trip_Params.Time_in_Trip++;

          //   ,     .
          if(Speed != 0) Trip_Params.Time_in_Go++;

          //   RTC  .
          Store_Trip_Params(Trip_Params);
        }
    }

  return;
}

/*------------------------------------------------------------------------------*/
/*      1.                             */
/*------------------------------------------------------------------------------*/
void Timer1_Overflow_Interrupt(void) interrupt 3
{
  //   500  -  .
  if(Speed_Interval <= 16) Speed_Interval++;
  else Speed=0;

  return;
}

/*------------------------------------------------------------------------------*/
/*           -5  154.   */
/*   5     ,     -     */
/*     " ".   ,         */
/*     M1  J5,     "  ". */
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
void Connect_To_ECU(void)
{
  /*----------------------------------------------------------------------------*/
  /*      .                                  */
  /*  5      " ".      */
  register unsigned char nReConnect;

  /*----------------------------------------------------------------------------*/
  /*           .       */
  for(nReConnect=5; nReConnect!=0; nReConnect--)
     {
       Pause(120);      //   120 .

       //       .
       if((is_Mode_Key_Pressed()) || (is_Enter_Key_Pressed()) ||
          (is_Left_Key_Pressed()) || (is_Right_Key_Pressed())) break;

       //     testerPresent.
       if(Tester_Present() == OK)
         {
           //    testerPresent.
           //      .
           Pause(120);
           if(Read_Vehicle_Manufacturer_ECU_Identifier() == OK)
             {
               /*      M1  J5.				*/
               if(((Message[2] == 'M') && (Message[3] == '1')) ||
	          ((Message[2] == 'J') && (Message[3] == '5')))
	           {
		     /*    .				*/
		     /*     .				*/
                     break;
		   }
	       else
                   {
		     /*     ( 1.5.4   -5).	*/
		     /*   "  ".			*/
	             sprintf(&String, &Title_Error_ECU_Type);
		     LCD_Clear(); Write_String_To_LCD(&String);
	             continue;
		   }
             }
         }

       //     testerPresent.
       //     startCommunucation.
       Pause(120);
       if(Start_Communication() == OK) break;
     }

  /*  5   ,   " ".      */
  if(nReConnect == 0)
    {
      sprintf(&String, &Title_Not_Connect);
      LCD_Clear(); Write_String_To_LCD(&String);
    }

  return;
}

