/********************************************************************************/
/*										*/
/*	               .		*/
/*										*/
/********************************************************************************/
#ifndef _MK_H
#define _MK_H

#include "s8252.h"
#include "timer\timer.h"        //   .
#include "uart\uart.h"          //   .
#include "lcd\lcd.h"            //  .
#include "keyboard\keyboard.h"  //  .
#include "beeper\beeper.h"      //   .
#include "messages\messages.h"  //     .
#include "rtc\rtc.h"            //  RTC DS1307.
#include "keyword\keyword.h"    //   KEYWORD2000.
#include <stdio.h>              //   spintf().

/*------------------------------------------------------------------------------*/
/*    "".                                                */
/*------------------------------------------------------------------------------*/
enum MODE
    {
      TRIP_COMPUTER_MODE     = 0, //   .
      ECU_VARIABLES_MODE     = 1, //     .
      ECU_TROUBLES_CODE_MODE = 2, //      .
      ECU_IO_CONTROL_MODE    = 3, //    .
      ABOUT_MODE             = 4  //     .
    };

#define FIRST_MODE  TRIP_COMPUTER_MODE
#define LAST_MODE   ECU_IO_CONTROL_MODE

/*------------------------------------------------------------------------------*/
/*    .                                        */
/*------------------------------------------------------------------------------*/
enum ECU_VARIABLES
    {
      PASP    = 0,              //   .
      THR     = 1,              //   .
      TWAT    = 2,              //   .
      FREQ    = 3,              //  .
      JUFRXX  = 4,              //   ..
      UOZ     = 5,              //   .
      JSPEED  = 6,              //   .
      FSM     = 7,              //    ..
      SSM     = 8,              //    ..
      JAUACC  = 9,              //   .      
      RCO     = 10,             //   .
      VALF    = 11,             //  /.
      COEFFF  = 12,             //    .
      JALAM   = 13,             //    .
      INJ     = 14,             //   .
      JGBC    = 15,             //   .
      JAIR    = 16,             //   .
      JQT     = 17,             //   .
      JQD     = 18,             //   .
      DET     = 19,             //   .
      BLKINJ  = 20,             //    .
      RXX     = 21,             //   .
      BITPOW  = 22              //    .
    };

#define FIRST_ECU_VARIABLE  PASP
#define LAST_ECU_VARIABLE   BITPOW

/*--------------------------------------------------------------------------*/
/*     .                      */
/*--------------------------------------------------------------------------*/
enum ECU_IO_PARAMETERS
    {
      CHECK_ENGINE      = 0,    //  Check Engine.
      COOLING_FAN_RELAY = 1,    //     .
      FUEL_PUMP_RELAY   = 2,    //   .
      IGNITION_1        = 3,    //   1.
      IGNITION_2        = 4,    //   2.
      INJECTOR_1        = 5,    //  1.
      INJECTOR_2        = 6,    //  2.
      INJECTOR_3        = 7,    //  3.
      INJECTOR_4        = 8,    //  4.
      CO_TRIMMING       = 9,    //   .
      IDLE_ENGINE_SPEED = 10,   //   .
      IDLE_STEP_MOTOR   = 11    //   .
    };

#define FIRST_ECU_IO_PARAMETER  CHECK_ENGINE
#define LAST_ECU_IO_PARAMETER   IDLE_STEP_MOTOR

/*------------------------------------------------------------------------------*/
/*    .                                   */
/*------------------------------------------------------------------------------*/
enum TRIP_VARIABLES
    {
      TOTAL_WAY     = 0,        //  .
      TOTAL_TIME    = 1,        //   ( ).
      TIME_IN_GO    = 2,        //   .
      CUR_SPEED     = 3,        //   .
      AVER_SPEED    = 4,        //     .
      TOTAL_FUEL    = 5,        //   .
      AVER_FUEL     = 6         //     .
    };

#define FIRST_TRIP_VARIABLE  TOTAL_WAY
#define LAST_TRIP_VARIABLE   AVER_FUEL

/*------------------------------------------------------------------------------*/
/*     .                              */
/*------------------------------------------------------------------------------*/
enum ABOUT_INFO
    {
      DEVICE_NAME       = 0,    //  .
      HARDWARE_VERSION  = 1,    //    .
      SOFTWARE_VERSION  = 2,    //    .
      AUTOR_1           = 3,    //    .
      AUTOR_2           = 4
    };

#define FIRST_ABOUT_INFO  DEVICE_NAME
#define LAST_ABOUT_INFO   AUTOR_2

/*------------------------------------------------------------------------------*/
/*   .                                               */
/*------------------------------------------------------------------------------*/
struct TRIP_PARAMS
  {
    /*--------------------------------------------------------------------------*/
    /*   .                                                */
    /*--------------------------------------------------------------------------*/
    unsigned char State;        //  0 == 1 -   .

    /*--------------------------------------------------------------------------*/
    /*        .                 */
    /*--------------------------------------------------------------------------*/
    unsigned long int Time_in_Trip;

    /*--------------------------------------------------------------------------*/
    /*        .                  */
    /*--------------------------------------------------------------------------*/
    unsigned long int Time_in_Go;

    /*--------------------------------------------------------------------------*/
    /*      1/6 .                             */
    /*--------------------------------------------------------------------------*/
    unsigned long int Passed_Distance;

    /*--------------------------------------------------------------------------*/
    /*      1/16 .                     */
    /*--------------------------------------------------------------------------*/
    unsigned long int Consumed_Fuel;
  };

/*------------------------------------------------------------------------------*/
/*      .               */
/*------------------------------------------------------------------------------*/
#define UP      1
#define DOWN    0

/*------------------------------------------------------------------------------*/
/*      .         */
/*------------------------------------------------------------------------------*/
#define Restore_Trip_Variable_Num(Var) \
    { EA=0; Read_Data_From_RTC((unsigned char *)&##Var, 1, 0x08); EA=1; }

/*------------------------------------------------------------------------------*/
/*      .             */
/*------------------------------------------------------------------------------*/
#define Store_Trip_Variable_Num(Var) \
    { EA=0; Write_Data_To_RTC((unsigned char *)&##Var, 1, 0x08); EA=1; }

/*------------------------------------------------------------------------------*/
/*      .              */
/*------------------------------------------------------------------------------*/
#define Restore_ECU_Variable_Num(Var) \
    { EA=0; Read_Data_From_RTC((unsigned char *)&##Var, 1, 0x09); EA=1; }

/*------------------------------------------------------------------------------*/
/*      .                  */
/*------------------------------------------------------------------------------*/
#define Store_ECU_Variable_Num(Var) \
    { EA=0; Write_Data_To_RTC((unsigned char *)&##Var, 1, 0x09); EA=1; }

/*------------------------------------------------------------------------------*/
/*      .            */
/*------------------------------------------------------------------------------*/
#define Restore_ECU_IOControl_Num(Var) \
    { EA=0; Read_Data_From_RTC((unsigned char *)&##Var, 1, 0x0a); EA=1; }

/*------------------------------------------------------------------------------*/
/*      .                */
/*------------------------------------------------------------------------------*/
#define Store_ECU_IOControl_Num(Var) \
    { EA=0; Write_Data_To_RTC((unsigned char *)&##Var, 1, 0x0a); EA=1; }

/*------------------------------------------------------------------------------*/
/*    .                           */
/*------------------------------------------------------------------------------*/
#define Restore_Trip_Params(Var) \
      Read_Data_From_RTC((unsigned char *)&##Var, sizeof(struct TRIP_PARAMS), 0x10)

/*------------------------------------------------------------------------------*/
/*      .                */
/*------------------------------------------------------------------------------*/
#define Store_Trip_Params(Var) \
      Write_Data_To_RTC((unsigned char *)&##Var, sizeof(struct TRIP_PARAMS), 0x10)

/*------------------------------------------------------------------------------*/
/*           -5  154.   */
/* :     .                                            */
/* :    .                                           */
/*------------------------------------------------------------------------------*/
void Connect_To_ECU(void);


/********************************************************************************/
#endif

