;**********************************************************************
;    Filename:  forum.asm
;    :  2001 .
;    : 1.0
;    : ..
;    :     .
;    -  ""
;
;         ""
;	 PIC16F84 
;	      LCD-10 ( "")
;    Fosc=32768 Hz         
;**********************************************************************


        list      p=16F84
        #include <p16F84.inc>	
       __CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _LP_OSC
        

;*****  


porta_cfg	equ	b'00000000'		;   
portb_cfg	equ	b'11111111'		;   
on_time_ee	equ	0x00			;  .  EEPROM
off_time_ee	equ	0x01			;    EEPROM

option_setup    equ     b'00000100'	;TMR0 - 
						;  TMR0
                                	;  INT,
                                	;   
                                	;     INT 
                                	;  32
intcon_setup    equ     b'10100000'     ;    TMR0
                                	;	     (GIE)
                                	;.   . RB
                                	;  INT 
                                	;.     EEPROM
eecon1_setup    equ     b'00000000'     ;   EEPROM ( 2)



;*****  

#define s1	portb,0 ; S1
#define S2      portb,1 ; S2
#define S3      portb,2 ; S3
#define S4	portb,3 ; S4
#define s5	portb,4 ; S5 (  / START)
#define s6	portb,5 ; S6
#define s7	portb,6 ; S7 
#define s8	portb,7 ; S8 



#define clk     porta,0 ;  
#define di      porta,1 ;   
#define rele	porta,2 ; 
#define rele1	porta,3 ; 
#define opto	porta,4 ; 


;***** 

#define	refr_flag      	flags,0		;   
#define	count_flag 	flags,1		;   
#define	end_flag 	flags,2		;   
#define	key_flag 	flags,3		;  
#define	ee_flag	 	flags,4		;    EEPROM
#define	on_flag	 	flags,5		;   
#define	off_flag 	flags,6		;   

;*****  

        cblock  0ch	;  
        
        w_temp          ;variable used for context saving
        status_temp     ;variable used for context saving
	clk_hr		; 
	clk_min		; 
	clk_sec		; 
        count0          ;
        count1          ;
        count2          ;
        count3          ;
        count4          ;
	count5
        R4              ;
        R3              ;  
        R2			; 
        R1			; 
        R0			;
        rotate          ; DATA
	sec_on		; 
	sec_off		; 
        d_secon_hi	;  . 
        d_secon_lo	;  .
        d_secoff_hi	;   
        d_secoff_lo	;   
        temp		;
	temp_on		;   
	temp_off	;
	l_mulplr	;
	h_mulplr	;
        mulplr          ;8- 
        H_byte          ;
        L_byte          ;
	flags		;
	flags1		;
	tr0		;  - 
	tr1		;
	tr2		;

        endc


;***** 

BANK0   MACRO
        BCF     STATUS,RP0
        ENDM

BANK1   MACRO
        BSF     STATUS,RP0
        ENDM

jnz     macro   metka
        btfss   status,2
        goto    metka
        endm

jz      macro   metka
        btfsc   status,2
        goto    metka
        endm

jnc     macro   metka
        btfss   status,0
        goto    metka
        endm

jc      macro   metka
        btfsc   status,0
        goto    metka
        endm

;*****  .  ;) 
        ORG     0x000           ;  
        GOTO    init            ;  

;*****  
        ORG     0x004           ; interrupt vector location
        movwf   w_temp          ; save off current W register contents
        movf    STATUS,w        ; move status register into W register
        movwf   status_temp     ; save off contents of STATUS register
        btfsc   intcon,t0if
        goto    rtcc_serv
        movf    status_temp,w   ; retrieve copy of STATUS register
        movwf   STATUS          ; restore pre-isr STATUS register contents
        swapf   w_temp,f
        swapf   w_temp,w        ;restore pre-isr W register contents
        retfie                  ;return from interrupt

;*****  0.3 
; 2557 , 312,13 
pause
        movlw   .1
        movwf   count2
        movlw   .255
        movwf   count0
pause1
        movlw   .2		;
        movwf   count1		;
pause2                          ;
        decfsz  count1,f
        goto    pause2
        decfsz  count0,f
        goto    pause1          ;
        decfsz  count2,f
        goto    pause1
        return			;   /.
        
;
;*****  44 . ()
; 361 
pause_1
        movlw   .120
        movwf   count0
paus1                          ;

        decfsz  count0,f
        goto    paus1		;
        return			;   /.

;
;*****  
;    ,   -  
start
	bsf	rele		; 
	bcf	opto		; 
	movf	sec_on,w	;  
	movwf	clk_sec		;      
	movf	sec_off,w	;   
	movwf	temp_off	;
start_1
	btfss	s5		;  ?
	goto	start_1		; 
	bsf	count_flag	;  
	bsf	on_flag		; , 
	bcf	off_flag	;   
	return

;
;*****  
;     
stop
	bcf	rele		; 
	bsf	opto		; 
	movf	sec_on,w	;  
	movwf	temp_on		;  
	movf	sec_off,w	;  
	movwf	temp_off	;  
	bcf	off_flag	;   
	bcf	on_flag		;     
	bcf	count_flag	;  
	return

;
;*****      
;
reverse
	btfsc	on_flag		;  
	goto	rev_1		;
	btfsc	off_flag	;  
	goto	rev_2		;
	return

;***** 
rev_1
	movf	clk_sec,w	;    .
	movwf	temp_on		;       
	decf	temp_on,f	;  1, .. .    1
	btfss	end_flag	; ?
	return

	movf	sec_on,w	;  
	movwf	temp_on		; 	   
	bcf	on_flag		;  
	bcf	rele		; 
	movf	sec_off,w	;  
	movwf	clk_sec		;
	bsf	off_flag	;  
	bcf	end_flag	;   
	return

;*****   
rev_2
	movf	clk_sec,w	;    .
	movwf	temp_off	;       
	decf	temp_off,f	;
	btfss	end_flag	; ?
	return	
	bcf	end_flag	;   
	call	start		;
	return
	
;
;*****   
;
on_up
	btfsc	on_flag		;   ,   
	goto	dis_change	;  
	incf	sec_on,f	;  
	movf	sec_on,w	;    
	movwf	temp_on		; 
	return

;
;*****   
;
on_down
	btfsc	on_flag		;   ,   
	goto	dis_change	;  
	decf	sec_on,f	;  
	movf	sec_on,w	;    
	movwf	temp_on		; 
	return

;
;*****   
;
off_up
	btfsc	off_flag	;   ,   
	goto	dis_change	;  
	incf	sec_off,f	;  
	movf	sec_off,w	;    
	movwf	temp_off	; 
	return
	
;
;*****   
;
off_down
	btfsc	off_flag	;   ,   
	goto	dis_change	;  
	decf	sec_off,f	;  
	movf	sec_off,w	;    
	movwf	temp_off	; 
	return

;        EEPROM
dis_change
	bcf	ee_flag		;  (  )
	return			;
	

;
;*****   
;
s_7

	return
	
s_8

	return


;
;*****     EEPROM
;
wr_memory
	movlw	on_time_ee	;  
	movwf	eeadr		;  EEPROM
	movf	sec_on,w	;    W
	call	eeprom_wr	;
	movlw	off_time_ee	;  
	movwf	eeadr		;  EEPROM
	movf	sec_off,w	;    W
	call	eeprom_wr	;	
	return

;
;*****         0
; 
displey_0
	movf	d_secon_hi,w	;   .
	movwf	r4		; 9-10 .
	movf	d_secon_lo,w	;     .
	movwf	r3		; 7-8 .
	clrf	r2		;5-6 . 
	movf	d_secoff_hi,w	;   
	movwf	r1		; 4-3 .
	movf	d_secoff_lo,w	;     
	movwf	r0		; 1-2 .
	return


;*****   EEPROM
;   /     
;  
;   EEADR  
eeprom_wr
        bcf     intcon,gie      ;   
        movwf   eedata          ;     EEDATA
        bank1
        bsf     eecon1,wren     ;    EEPROM
        bank0

ee_wr0
        bank1
        movlw   55h             ;  
        movwf   eecon2          ; 
        movlw   0xaa            ; 
        movwf   eecon2          ; 
        bsf     eecon1,wr       ;   WR   
ee_wr1
        btfsc   eecon1,wrerr    ;       
        goto    ee_wr0          ;   
        btfss   eecon1,eeif     ;   
        goto    ee_wr1          ;   
        nop
        nop
        bcf     eecon1,wren     ;  
        bcf	eecon1,eeif	;    
        bank0
        bsf     intcon,gie      ;  
        return                  ; 

;
;*****   EEPROM
;   /      
eeprom_rd
        movwf   eeadr           ;    
        bank1
        bsf     eecon1,rd       ;  
        bank0
        movf    eedata,w        ;     
        return                  ;  

;
;*****   
;
refresh
	btfss	refr_flag	;  ?
	return			;,  
        movf    r4,w    	; 10  9 
        call    displ   	; 
        movf    r3,w  		; -//- 7  8 -//-
        call    displ   	;
        movf    r2,w    	; -//- 5  6 -//-
        call    displ   	;
        movf    r1,w    	; -//- 3  4 -//-
        call    displ   	;
        movf    r0,w    	; -//- 1  2 -//-
        call    displ   	;
	bcf	refr_flag	;           
	return

;	
;*****    
;  /     .

displ
        movwf   rotate          ;  W   rotate
        clrf    count0          ; 8
        bsf     count0,3        ;	  .
        bcf     status,0        ; cary
displ1
        clrf    status
        rlf     rotate,f        ; rotate   C
        btfsc   status,0        ; Cary=0 skip
        bsf     di	        ;   =1
        btfss   status,0        ; ary=1 skip
        bcf     di	        ;.   =0
        nop
        bsf     clk   	        ;CLK=1 _-
        nop
        bcf     clk  	        ;CLK=0 -_  
        decfsz  count0,f        ;  .
        goto    displ1          ;  0.  .
        return	          	;  /.

;
;*****      
;
dis_conv

	movf	temp_on,w	;    W
	movwf	l_byte		;   
	call	b2_bcd		;
	movf	tr0,w		;
	movwf	d_secon_hi	; .-. 
	movf	tr1,w		;
	movwf	d_secon_lo	;
	
	movf	temp_off,w	;    W
	movwf	l_byte		;   
	call	b2_bcd		;
	movf	tr0,w		;
	movwf	d_secoff_hi	; .-. 
	movf	tr1,w		;
	movwf	d_secoff_lo	;
	return

;
;*****  bin to BCD
; 8  -> 3 . 
;   /     L_byte

b2_bcd
        bcf     status,0    ; clear the carry bit
        movlw   .8	
        movwf   count0
        clrf    tr0
        clrf    tr1
loop16  rlf     L_byte,f
        rlf     tr1,f
        rlf     tr0,f
        decfsz  count0,f
        goto    adjDEC
;    0xA  LCD 
next2
        movlw   0x0F
        andwf   tr1,0
        jnz     next3   ;1- 
        movlw   0x0A
        iorwf   tr1,f
next3
        movlw   0xF0
        andwf   tr1,0
        jnz     next4   ;2- 
        movlw   0xA0
        iorwf   tr1,f
next4
        movlw   0x0F
        andwf   tr0,0
        jnz     next5   ;3- 
        movlw   0x0A
        iorwf   tr0,f
next5
        return
adjDEC
       movlw   tr1
        movwf   fsr
        call    adjBCD
        movlw   tr0
        movwf   fsr
        call    adjBCD
        goto    loop16
adjBCD
        movlw   3
        addwf   0,W
        movwf   count1
        btfsc   count1,3  ; test if result > 7
        movwf   0
        movlw   30
        addwf   0,W
        movwf   count1
        btfsc   count1,7  ; test if result > 7
        movwf   0         ; save as MSD
        return


;***********   ***********************************

;*****     TMR0
rtcc_serv
	btfss	count_flag	;  ?
	goto	rtcc_end	; ,  
        decfsz	clk_sec,f	;    1
	goto	rtcc_end	;
        bsf	end_flag	;   
rtcc_end
        bsf	refr_flag	;  
        movf    status_temp,w   ;  STATUS
        movwf   STATUS          ;  STATUS
        swapf   w_temp,f
        swapf   w_temp,w        ; W
        bcf     intcon,t0if     ;  
        bsf     intcon,gie      ; 
        retfie                  ;   


;***********   *************************************
main
  	call	dis_conv	; 
	call	displey_0	;
	call	refresh		; ?
	call	reverse		;
	call	pause		; 

;*****   
key_on
        bcf     key_flag        ;   
        movf    portb,w         ;     .
        andlw   b'11111111'     ;  
        xorlw   b'11111111'     ;  ?
        btfsc   status,z        ;
        goto    check           ;
        call    pause_1         ; 
                ;  
        movf    portb,w         ;     .
        andlw   portb_cfg       ;  
        xorlw   portb_cfg       ;  ?
        btfsc   status,z        ;
        goto    check           ;    

;*****   
        movf    portb,w         ;     .
        movwf   rotate          ;  rotate
        bsf     key_flag        ;   
        movlw   0x0f            ;    
        movwf   count5          ;
        bcf     status,c        ;  

        rrf     rotate,f        ;  S1 ?
        btfss   status,c        ;
        call	on_up	        ;    

        rrf     rotate,f        ;  S2 ?
        btfss   status,c        ;
        call	on_down	        ;   

        rrf     rotate,f        ;  S3 ?
        btfss   status,c        ;
        call	off_up		;   

        rrf     rotate,f        ;  S4 ?
        btfss   status,c        ;
        call	off_down	;   
        
        rrf     rotate,f        ;  S5 ?
        btfss   status,c        ;
        call    start	        ;
        
        rrf     rotate,f        ;  S6 ?
        btfss   status,c        ;
        call    stop	        ;

        rrf     rotate,f        ;  S7 ?
        btfss   status,c        ;
        call    s_7	        ;
        
        rrf     rotate,f        ;  S8 ?
        btfss   status,c        ;
        call    s_8	        ;
        
        bsf     ee_flag         ;   EEPROM

;      EEPROM
check
        btfsc   key_flag        ;   
        goto    check_1	        ;    
        decfsz  count5,f        ;   
        goto    check_1         ;
        btfsc   ee_flag		; ?
        call    wr_memory       ;   EEPROM
check_1
	btfsc	key_flag	;   ?
	bsf	refr_flag	;  

	goto	main


;****************************************
;   
;****************************************
init 
	clrf	tmr0
        MOVLW   OPTION_SETUP    ;   OPTION  W
        BANK1
        movwf   OPTION_REG      ;   OPTION
        BANK0
        MOVLW   INTCON_SETUP    ;   INTCON  W
        MOVWF   INTCON          ;   INTCON
        movlw   eecon1_setup    ;
        bank1
        movwf   eecon1  	;  EECON1
        bank0

	clrf	porta		;   
	clrf	portb		;   
	movlw	porta_cfg	;
	bank1
	movwf	trisa		;  A
	bank0
	movlw	portb_cfg	;
	bank1
	movwf	trisb		;  B
	bank0
;*****  
init3
        movlw   0ch     	;     W
        movwf   fsr     	;   FSR
clear_mem
        CLRF    INDF		;     INDF
        INCF    FSR,F   	; 
        BTFSS   FSR,4		;  
        GOTO    clear_mem       ;
        BTFSS   FSR,6		;    
        GOTO    clear_mem       ;
        BTFSC   FSR,5		;
        GOTO    clear_mem       ;
        call	pause		; 1.2 .
        call	pause		;     
        call	pause		;
        call	pause		;
;*****   "" 
test
	movlw	0x05		;
	movwf	count4		;
	movlw	0x88		; 
	movwf	r0		;
test1
	movf	r0,w		;
	call	displ		;  
	call	pause		;
	decfsz	count4,f	;   1
	goto	test1		;
test2
	movlw	0x05		;
	movwf	count4		;
test3				; 
	clrw			; 
	call	displ		;  
	call	pause		;
	decfsz	count4,f	;   1
	goto	test3		;
;*****   
	movlw	on_time_ee	;    
	call	eeprom_rd	;  EEPROM
	movwf	sec_on		;  
	movwf	temp_on		;
	movlw	off_time_ee	;    
	call	eeprom_rd	;  EEPROM
	movwf	sec_off		;  .
	movwf	temp_off	;
	clrf	r0		;
	bcf	on_flag		;
	bcf	off_flag	;
	bsf	refr_flag	;
	call	refresh		; 
	bsf	opto		; 
	goto	main		; 

                END     ;  . !!! :)

