unit DS1821_Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls, Menus, Inifiles;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    MPort: TMenuItem;
    MCOM1: TMenuItem;
    MCOM2: TMenuItem;
    MCOM3: TMenuItem;
    MCOM4: TMenuItem;
    Panel1: TPanel;
    N1: TMenuItem;
    MClosePort: TMenuItem;
    MHelp: TMenuItem;
    MAbout: TMenuItem;
    Panel3: TPanel;
    Label4: TLabel;
    Panel2: TPanel;
    TEd1: TLabel;
    TEd2: TLabel;
    N3: TMenuItem;
    MExit: TMenuItem;
    TEd0: TLabel;
    N2: TMenuItem;
    MCircuit: TMenuItem;
    Label7: TLabel;
    Label8: TLabel;
    EUsr1: TEdit;
    EUsr2: TEdit;
    StartB: TSpeedButton;
    ExitB: TButton;
    MUtilites: TMenuItem;
    M1Wire: TMenuItem;
    Timer1: TTimer;
    MRecall: TMenuItem;
    N4: TMenuItem;
    MStart: TMenuItem;
    N5: TMenuItem;
    ETh: TEdit;
    ETl: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    MThermo: TMenuItem;
    ThB: TButton;
    WireB: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MCOM1Click(Sender: TObject);
    procedure MClosePortClick(Sender: TObject);
    procedure MExitClick(Sender: TObject);
    procedure StartBClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure M1WireClick(Sender: TObject);
    procedure MAboutClick(Sender: TObject);
    procedure EUsr1Exit(Sender: TObject);
    procedure EUsr1KeyPress(Sender: TObject; var Key: Char);
    procedure EUsr2Exit(Sender: TObject);
    procedure EUsr2KeyPress(Sender: TObject; var Key: Char);
    procedure MCircuitClick(Sender: TObject);
    procedure MRecallClick(Sender: TObject);
    procedure MStartClick(Sender: TObject);
    procedure EThExit(Sender: TObject);
    procedure EThKeyPress(Sender: TObject; var Key: Char);
    procedure ETlExit(Sender: TObject);
    procedure ETlKeyPress(Sender: TObject; var Key: Char);
    procedure ThBClick(Sender: TObject);
  private
    { Private declarations }
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
    function  ReadParams:Boolean;
    procedure PClear;
    procedure Open_COM(n:Integer);
    procedure DisableControls;
    procedure ReadConfig;
    procedure SaveConfig;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  Usr1,Usr2,B1,B2: Byte;

  function HConvert(E:TEdit; var H:Byte):Boolean;
  function TConvert(E:TEdit; var H:Byte):Boolean;
  function Tc(n:Byte):Shortint;

implementation

uses DS1821_Sch;

{$R *.DFM}

Const
//  ResBR=10473;   //Reset Baud Rate (non-standard, to speed up)
  ResBR=9600;    //Reset Baud Rate
  SltBR=115200;  //Time slot Baud Rate

var
  WM_COMChange: DWord;
  UsedCOM, InitCOM: Integer;
  Ph,CRC: Byte;
  Present: Boolean;
  CurrentPath: String;

function AccessCOM(P:PChar):boolean;
 stdcall; external 'comapi32.dll';
function OpenCOM(P:PChar):boolean;
 stdcall; external 'comapi32.dll';
function CloseCOM:boolean;
 stdcall; external 'comapi32.dll';
function SetCOM(baud:DWORD;
                bsize,parity,
                sbits:BYTE):boolean;
 stdcall; external 'comapi32.dll';
function SetModCOM(baud:DWORD;bsize,parity,
                sbits:BYTE;DTR,
                RTS:boolean):boolean;
 stdcall; external 'comapi32.dll';
function SetCOMTo(RdIvl,RdTotM,RdTotC,
          WrTotM,WrTotC:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function SetCOMBuff(RdBuff,
                    WrBuff:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function EscFuncCOM(F:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function GetModem(var lpD:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function PurgeCOM:boolean;
 stdcall; external 'comapi32.dll';
function FlushCOM:boolean;
 stdcall; external 'comapi32.dll';
function TxByteCOM(data:byte):boolean;
 stdcall; external 'comapi32.dll';
function TxDataCOM(const Buffer; N:DWORD;
                   var lpNDone:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function RxDataCOM(var Buffer; N:DWORD;
                   var lpNDone:DWORD):boolean;
 stdcall; external 'comapi32.dll';
function ClrErrCOM(var lpE:DWORD):boolean;
 stdcall; external 'comapi32.dll';

//--------------Open COM-------------

procedure TMainForm.Open_COM(n:Integer);
var i: Integer;
begin
 CloseCom; UsedCOM:=0;
 PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
 for i:=1 to 4 do MainMenu1.Items[0].Items[i-1].Checked:=false;
 DisableControls;
 if n=0 then exit;
 if OpenCom(PChar('COM'+Chr(n+$30)))
  then
   begin
    UsedCOM:=n;
    MainMenu1.Items[0].Items[n-1].Checked:=true;
    MClosePort.Enabled:=true;
    PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
    Caption:=Application.Title+' on COM'+Chr(n+$30);
    SetCOMTo(MAXDWORD,0,0,0,0);
    MRecall.Enabled:=true;
    MStart.Enabled:=true;
    StartB.Enabled:=true;
    M1Wire.Enabled:=true;
    WireB.Enabled:=true;
    MThermo.Enabled:=true;
    ThB.Enabled:=true;
    Screen.Cursor:=crHourGlass;
    if not ReadParams
     then
      begin
       Screen.Cursor:=crDefault;
       MessageDlg('Device is not found on COM'+Chr(n+$30)+'.',
                mtError,[mbOk],0);
       PClear;
      end;
    Screen.Cursor:=crDefault;
   end
  else
    MessageDlg('Port COM'+Chr(n+$30)+' is not available.',
                mtError,[mbOk],0);
end;

procedure TMainForm.DisableControls;
begin
 Timer1.Enabled:=false;
 StartB.Enabled:=false;
 StartB.Down:=false;
 WireB.Enabled:=false;
 ThB.Enabled:=false;
 EUsr1.Enabled:=false;
 EUsr2.Enabled:=false;
 ETh.Enabled:=false;
 ETl.Enabled:=false;
 MClosePort.Enabled:=false;
 MRecall.Enabled:=false;
 MStart.Enabled:=false;
 M1Wire.Enabled:=false;
 MThermo.Enabled:=false;
 Caption:=Application.Title;
end;

//--------------Init----------------

procedure TMainForm.FormShow(Sender: TObject);
var n: Integer;
begin
 CurrentPath:=ExtractFilePath(ParamStr(0));
 WM_COMChange:=RegisterWindowMessage('COM_Change');
 Application.OnMessage:=AppMessage;
 Caption:=Application.Title;
 ReadConfig;
 for n:=1 to 4 do
   MainMenu1.Items[0].Items[n-1].Enabled:=
        AccessCom(PChar('COM'+Chr(n+$30)));
 Present:=false; PClear;
 Open_COM(InitCOM);
end;

//--------------Exit-----------------

procedure TMainForm.MExitClick(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Timer1.Enabled:=False;
 InitCOM:=UsedCOM;
 SaveConfig;
 CloseCOM; UsedCOM:=0;
 PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
end;

//----------Look for COM change--------


procedure TMainForm.AppMessage(var Msg: TMsg; var Handled: Boolean);
var n: Integer;
begin
  if Msg.message = WM_COMChange then
  begin
   for n:=1 to 4 do
    if UsedCOM<>n then
     MainMenu1.Items[0].Items[n-1].Enabled:=
       AccessCom(PChar('COM'+Chr(n+$30)));
  end;
end;

//--------------Menu "Port"-----------------

//Menu "Port Open"

procedure TMainForm.MCOM1Click(Sender: TObject);
var n:Integer;
begin
 n:=0;
 if Sender=MainMenu1.Items[0].Items[0] then n:=1;
 if Sender=MainMenu1.Items[0].Items[1] then n:=2;
 if Sender=MainMenu1.Items[0].Items[2] then n:=3;
 if Sender=MainMenu1.Items[0].Items[3] then n:=4;
 if UsedCOM<>n
  then Open_COM(n);
end;

//Menu "Port Close"

procedure TMainForm.MClosePortClick(Sender: TObject);
var i:Integer;
begin
 CloseCom; UsedCOM:=0;
 PostMessage(HWND_BROADCAST,WM_COMChange,0,0);
 for i:=1 to 4 do MainMenu1.Items[0].Items[i-1].Checked:=false;
 DisableControls;
 PClear;
end;

//----------1-Wire I/O----------------------;


//TouchReset:

function TReset:Boolean;
var
 B:Byte;
 D,time:DWord;
begin
 Result:=False;
 SetModCom(ResBR,8,NOPARITY,ONESTOPBIT,true,false);
 PurgeCom;
 TxByteCOM($F0);
 time:=GetTickCount+50;
 repeat RxDataCOM(B,1,D)
  until (D=1) or (time<GetTickCount);
 if D=1
  then Result:=(B<>$F0);
 Present:=Result;
end;

//TouchByte:

function TByte(X:Byte):Byte;
var
 n:Integer;
 B:Byte;
 D,time:DWord;
begin
 Result:=$FF;
 SetModCom(SltBR,8,NOPARITY,ONESTOPBIT,true,false);
 PurgeCom;
 time:=GetTickCount+50;
 for n:=1 to 8 do
  begin
   if Odd(X) then TxByteCOM($FF) else TxByteCOM($00);
   X:=X shr 1;
   repeat RxDataCOM(B,1,D)
   until (D=1) or (time<GetTickCount);
   if D<>1 then exit;
   if Odd(B) then X:=X or $80;
   if Odd(B xor CRC)
    then CRC:=((CRC xor $18) shr 1) or $80
    else CRC:=CRC shr 1;
  end;
  Result:=X;
end;

//Toggle mode

procedure Toggle;
var A: array [0..3] of byte;
    ND:DWORD;
begin
 A[0]:=$55; A[1]:=$55; A[2]:=$55; A[3]:=$0;
 SetModCom(SltBR,8,NOPARITY,ONESTOPBIT,true,true);  //Vcc off
 Sleep(10);
 SetModCom(SltBR,8,NOPARITY,ONESTOPBIT,true,false); //Vcc on
 Sleep(10);
 if TReset then exit;
 SetModCom(SltBR,8,NOPARITY,ONESTOPBIT,true,true);  //Vcc off
 PurgeCom;
 Sleep(10);
 TxDataCOM(A,4,ND); //16 pulses on DQ
 Sleep(10);
 SetModCom(ResBR,8,NOPARITY,ONESTOPBIT,true,false); //Vcc on
 Sleep(10);
end;

//Clear device ID, serial number, user bytes;

procedure TMainForm.PClear;
begin
 EUsr1.Text:='';  EUsr1.Refresh;
 EUsr2.Text:='';  EUsr2.Refresh;
 ETh.Text:='';    ETh.Refresh;
 ETl.Text:='';    ETl.Refresh;
 TEd0.Caption:='';
 TEd1.Caption:='-';
 TEd2.Caption:='-';
 Panel3.Refresh;
end;

//Read device;

function TMainForm.ReadParams:Boolean;
var Stat,temp:byte;
begin
 Result:=false;
 PClear; //Clear controls
 if not TReset then exit;
 TByte($A1); //Read TH
 Usr1:=TByte($FF);
 if not TReset then exit;
 TByte($A2); //Read TL
 Usr2:=TByte($FF);
 if not TReset then exit;
 TByte($AC); //Read Status
 Stat:=TByte($FF);
 if (Stat and 2)=0 then begin temp:=Usr1; Usr1:=Usr2; Usr2:=temp; end;
 EUsr1.Text:=Format('%.2xH',[Usr1]);
 EUsr2.Text:=Format('%.2xH',[Usr2]);
 ETh.Text:=Format('%d',[Tc(Usr1)]);
 ETl.Text:=Format('%d',[Tc(Usr2)]);
 EUsr1.Enabled:=true;
 EUsr2.Enabled:=true;
 ETh.Enabled:=true;
 ETl.Enabled:=true;
 M1Wire.Enabled:=true;
 MThermo.Enabled:=true;
 WireB.Enabled:=true;
 ThB.Enabled:=true;
 Result:=true;
end;

//Start:

procedure TMainForm.StartBClick(Sender: TObject);
begin
 StartB.Refresh;
 MStart.Checked:=StartB.Down;
 MThermo.Enabled:=not StartB.Down;
 ThB.Enabled:=not StartB.Down;
 if StartB.Down then begin Ph:=0; Timer1.Enabled:=True; end
                else Timer1.Enabled:=False;
end;

//Timer Event:

procedure TMainForm.Timer1Timer(Sender: TObject);
var T:Shortint;
begin
 Ph:=Ph+1;
 case Ph of
    1: if not TReset
        then
         begin
          TEd0.Caption:='';
          TEd1.Caption:='-';
          TEd2.Caption:='-';
          Ph:=0;
         end;
    2: begin
        TByte($EE); //Start T Convert
       end;
    5: if (not Present) or (not TReset)
        then
         begin
          TEd0.Caption:='';
          TEd1.Caption:='-';
          TEd2.Caption:='-';
          Ph:=0;
         end;
    6: begin
        TByte($AA); //Read T
        T:=TByte($FF);
        if T<0 then TEd0.Caption:='-'
               else TEd0.Caption:='';
        if T>99 then T:=99;
        TEd1.Caption:=IntToStr(abs(T) div 10);
        TEd2.Caption:=IntToStr(abs(T) mod 10);
        Ph:=0;
       end;
 end;
end;

//Edit User Bytes:

function ConvD(Ch:Char):Integer;
begin
 case Ch of
 '0'..'9': Result:=Ord(Ch)-$30;
 'A'..'F': Result:=Ord(Ch)-$37;
 else Result:=-1;
 end;
end;

function HConvert(E:TEdit; var H:Byte):Boolean;
var Hp:Byte; S:String; Error:Boolean;
begin
 Hp:=H; Result:=true;
 Error:=false;
 S:=UpperCase(E.Text);
 case length(S) of
 1: if ConvD(S[1])>=0 then H:=ConvD(S[1])
                     else Error:=true;
 2: begin
    if ConvD(S[1])>=0 then H:=ConvD(S[1])
                     else Error:=true;
    if S[2]<>'H'
     then if ConvD(S[2])>=0
           then H:=16*H+ConvD(S[2])
           else Error:=true;
    end;
 3: begin
    if ConvD(S[1])>=0 then H:=ConvD(S[1])
                     else Error:=true;
    if ConvD(S[2])>=0 then H:=16*H+ConvD(S[2])
                     else Error:=true;
    if S[3]<>'H' then Error:=true;
    end;
 else Error:=True;
 end;
 if Error
  then
   begin
   MessageBeep(MB_IconError);
   MessageDlg('Invalid HEX value !',mtError,[mbOK],0);
   H:=Hp;
   E.SetFocus; E.SelectAll;
   Result:=false;
   end;
   E.Text:=Format('%.2xH',[H]);
end;

function Tc(n:Byte):Shortint;
begin
 Result:=n;
end;

function TConvert(E:TEdit; var H:Byte):Boolean;
var Hp:Byte; Msg:String; T:Integer;
begin
 Hp:=H; Result:=true;
 try
 begin
  T := StrToInt(E.Text);
  if (T<-128) or (T>127) then raise EConvertError.Create('');
  H:=T-$100;
 end;
 except
 on EConvertError do
  begin
   Msg:='Value must be between -128 and +127';
   MessageBeep(MB_IconError);
   MessageDlg(Msg,mtError,[mbOK],0);
   H:=Hp; E.Text:=IntToStr(Tc(H));
   E.SetFocus; E.SelectAll;
   Result:=false;
  end;
 end;
end;

procedure TMainForm.EUsr1Exit(Sender: TObject);
begin
 HConvert(EUsr1,Usr1);
 ETh.Text:=IntToStr(Tc(Usr1));
end;

procedure TMainForm.EUsr1KeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then
  begin
   HConvert(EUsr1,Usr1);
   ETh.Text:=IntToStr(Tc(Usr1));
   Key:=#0;
   EUsr1.SelectAll;
  end;
 if Key=#27 then
  begin
   EUsr1.Text:=Format('%.2xH',[Usr1]);
   Key:=#0;
   EUsr1.SelectAll;
  end;
end;

procedure TMainForm.EThExit(Sender: TObject);
begin
 TConvert(ETh,Usr1);
 EUsr1.Text:=Format('%.2xH',[Usr1]);
end;

procedure TMainForm.EThKeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then
  begin
   TConvert(ETh,Usr1);
   EUsr1.Text:=Format('%.2xH',[Usr1]);
   Key:=#0;
   ETh.SelectAll;
  end;
 if Key=#27 then
  begin
   ETh.Text:=Format('%d',[Tc(Usr1)]);
   Key:=#0;
   ETh.SelectAll;
  end;
end;

procedure TMainForm.EUsr2Exit(Sender: TObject);
begin
 HConvert(EUsr2,Usr2);
 ETl.Text:=IntToStr(Tc(Usr2));
end;

procedure TMainForm.EUsr2KeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then
  begin
   HConvert(EUsr2,Usr2);
   ETl.Text:=IntToStr(Tc(Usr2));
   Key:=#0;
   EUsr2.SelectAll;
  end;
 if Key=#27 then
  begin
   EUsr2.Text:=Format('%.2xH',[Usr2]);
   Key:=#0;
   EUsr2.SelectAll;
  end;
end;

procedure TMainForm.ETlExit(Sender: TObject);
begin
 TConvert(ETl,Usr2);
 EUsr2.Text:=Format('%.2xH',[Usr2]);
end;

procedure TMainForm.ETlKeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then
  begin
   TConvert(ETl,Usr2);
   EUsr2.Text:=Format('%.2xH',[Usr2]);
   Key:=#0;
   ETl.SelectAll;
  end;
 if Key=#27 then
  begin
   ETl.Text:=Format('%d',[Tc(Usr2)]);
   Key:=#0;
   ETl.SelectAll;
  end;
end;

//Menu "Recall NVM"

procedure TMainForm.MRecallClick(Sender: TObject);
begin
 Screen.Cursor:=crHourGlass;
 if not ReadParams then begin
  Screen.Cursor:=crDefault;
  MessageDlg('Device is not found on COM'+Chr(UsedCOM+$30)+'.',
            mtError,[mbOk],0);
  PClear;               end;
 Ph:=0;
 Screen.Cursor:=crDefault;
end;

//Menu "Start Conv."

procedure TMainForm.MStartClick(Sender: TObject);
begin
 StartB.Down:=not StartB.Down;
 StartBClick(nil);
end;

//Menu "1-Wire"

procedure TMainForm.M1WireClick(Sender: TObject);
var mask:byte;
begin
 if MessageDlg('Return to 1-Wire mode?'
               ,mtConfirmation,[mbYes,mbNo],0) = mrYes
  then
   begin
    MainForm.Refresh;
    Screen.Cursor:=crHourGlass;
    Toggle;

    if not TReset
     then
      begin
       Screen.Cursor:=crDefault;
       MessageDlg('Device is not found on COM'+
                 Chr(UsedCOM+$30)+'.',mtError,[mbOk],0);
       PClear;
       exit;
      end;

    if Usr1>Usr2 then mask:=2 else mask:=0;
    TByte($0C); //Write status
    TByte(mask);

    ReadParams;

    Ph:=0;
    Screen.Cursor:=crDefault;
   end;
end;

//Menu "Thermostat"

procedure TMainForm.ThBClick(Sender: TObject);
var temp,mask:byte;
begin
 if MessageDlg('Write NVM and enter thermostat mode ?'
               ,mtConfirmation,[mbYes,mbNo],0) = mrYes
  then
   begin
    MainForm.Refresh;
    Screen.Cursor:=crHourGlass;
    Toggle;

    if not TReset
     then
      begin
       Screen.Cursor:=crDefault;
       MessageDlg('Device is not found on COM'+
                 Chr(UsedCOM+$30)+'.',mtError,[mbOk],0);
       PClear;
       exit;
      end;

    if Usr1>Usr2
     then mask:=2
     else
      begin
       mask:=0;
       temp:=Usr1; Usr1:=Usr2; Usr2:=temp;
      end;

    TByte($01); //Write TH
    TByte(Usr1);
    Sleep(15);
    TReset;
    TByte($02); //Write TL
    TByte(Usr2);
    Sleep(15);
    TReset;
    TByte($0C); //Write status
    TByte(mask or 4);
    Sleep(15);

    ReadParams;

    Ph:=0;
    Screen.Cursor:=crDefault;
   end;
end;

//Menu "Circuit"

procedure TMainForm.MCircuitClick(Sender: TObject);
begin
 SchForm.ShowModal;
end;

//Menu "About"

procedure TMainForm.MAboutClick(Sender: TObject);
begin
 MessageDlg('DALLAS DS1821 thermometer programmer.'+#13+
            'E-mail: wubblick@yahoo.com.'
               ,mtInformation,[mbOk],0);
end;

// ------------.INI file R/W:-------------------

procedure TMainForm.SaveConfig;
var
 RegKey: TIniFile;
begin
 RegKey := TIniFile.Create(CurrentPath+Application.Title+'.INI');
 with RegKey do
  begin
   WriteInteger('General','Left',MainForm.Left);
   WriteInteger('General','Top',MainForm.Top);
   WriteInteger('General','COM port',InitCOM);
   Free;
  end;
end;

procedure TMainForm.ReadConfig;
var
 RegKey: TIniFile;
begin
 RegKey := TIniFile.Create(CurrentPath+Application.Title+'.INI');
 with RegKey do
  begin
   MainForm.Left:=ReadInteger('General','Left',221);
   MainForm.Top :=ReadInteger('General','Top',180);
   InitCOM      :=ReadInteger('General','COM port',2);
   Free;
  end;
end;

end.
