        page  59,132
;***********************************************************************
;*  IDE2LPT - MS-DOS device driver for IDE2LPT(R) adaptor              *
;*          v2.04 at 19.04.99 (c) Leonid Slobodchikov AKA Curvex       *
;*          Tested by Yuri Golicow                                     *
;*          Original code by Eugene Kuleshov                           *
;***********************************************************************
.286c
;======================================================================
HDX     equ     1       ; ࠡ⠥  譨 HD

IO_IDEBASE equ  170h
IO_IDECMD  equ  177h
IO_IDECONT equ  3f6h

        .lall
INP     macro   DATA,ADDR ;    HD
 IF     HDX
  IFIDNI <DATA>,<ax>
        call    InW
  ELSEIFIDNI <DATA>,<al>
        call    InB
  ELSE  ERR
  ENDIF
 ELSE
        in      DATA,ADDR
 ENDIF
        endm

OUTP    macro   ADDR,DATA ; 뢮   HD
 IF     HDX
  IFIDNI <DATA>,<ax>
        call    OutW
  ELSEIFIDNI <DATA>,<al>
        call    OutB
  ELSE  ERR
  ENDIF
 ELSE
        out     ADDR,DATA
 ENDIF
        endm

INPSW   macro           ;  ப ᫮  
local   m0
 IF     HDX
        pushf
        cli
m0:     call    InW
        stosw
        loop    m0
        popf
 ELSE
        rep     insw
 ENDIF
        endm

OUTPSW  macro
local   m0
 IF     HDX
        pushf
        cli
m0:     lodsw
        call    OutW
        loop    m0
        popf
 ELSE
        rep     outsw
 ENDIF
        endm

AC_NOP  macro
        mov     al,00000100b
;                      HRESET = 0
;                      RHWR = 0
;                      -RLWR = 1
;                      RCWR = 0
;                     DIR
        mov     dx,word ptr cs:[pwLPTbase]
        add     dx,2
        out     dx,al
        jmp     short $+2
        endm

AC_WRRH macro   DATA
        mov     dx,word ptr cs:[pwLPTbase]
 IFDIFI <al>,<DATA>
        mov     al,DATA
 ENDIF
        out     dx,al
        jmp     short $+2
        mov     al,00000110b
;                       HRESET = 0
;                       RHWR = 1
;                       -RLWR = 1
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2

        endm

AC_WRRL macro   DATA
        mov     dx,word ptr cs:[pwLPTbase]
 IFDIFI <al>,<DATA>
        mov     al,DATA
 ENDIF
        out     dx,al
        jmp     short $+2
        mov     al,00000000b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 0
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        endm

AC_WRRC macro   DATA
        mov     dx,word ptr cs:[pwLPTbase]
 IFDIFI <al>,<DATA>
        mov     al,DATA
 ENDIF
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        endm

AC_HDRESET macro
        mov     dx,word ptr cs:[pwLPTbase]
        mov     al,10011000b
;                    HA2..HA0 = 000b
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        add     dx,2
        mov     al,00000101b
;                       HRESET = 1
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        endm

AC_RDTET macro NO
        mov     al,NO
        mov     dx,word ptr cs:[pwLPTbase]
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
 IF NO EQ 0
        shr     al,4
 ELSEIF NO EQ 2
        shr     al,4
 ENDIF
        endm


CYCEND  macro
        AC_WRRC 10011111b
;                 HA2..HA0 = 111b
;                 -CS3FX = 1
;                 -CS1FX = 1
;                 RCW = 0
;                 TRW = 0
        endm

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

_TEXT           segment byte public
                assume cs:_TEXT,ds:_TEXT,ss:_TEXT

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;                        ࠩ
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ide2lpt         proc    far
                dd      -1
attributes      dw      2002h
pointers        dw      offset strategy
                dw      offset interrupt
block_dev       db      0
                db      7 dup (0)
pRequestHeader  dd      00000h
ide2lpt         endp

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+  Read Sector -   ᥪ                                    +
;+  室:bh -                                              +
;+       bl -  ᥪ                                            +
;+       cx -  樫                                           +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

ReadSector      proc    near
                mov     ah,20h          ; Read Sector
                call    RWSector
                INPSW
                retn
ReadSector      endp


;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+  WriteSector -  ᥪ                                      +
;+ 室: bh -                                              +
;+       bl -  ᥪ                                            +
;+       cx -  樫                                           +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

WriteSector     proc    near
                mov     ah,30h          ; Write Sector
                call    RWSector
                OUTPSW
                retn
WriteSector     endp


;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+ RWSector - 믮   ᥪ஬                            +
;+ 室: ah -  樨                                             +
;+       bh -                                              +
;+       bl -  ᥪ                                            +
;+       cx -  樫                                           +
;+ 室:                                                              +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

RWSector        proc    near
                cld
                call    WaitHDDforBusy
                dec     dx
                mov     al,bh
                or      al,cs:[bDHRsnap]
               OUTP    dx,al                   ; port 1F6h, hdsk0-siz/drv/head
                jmp     short $+2
                sub     dx,4
                mov     al,1
               OUTP    dx,al                   ; port 1F2h, hdsk0-sector count
                jmp     short $+2
                inc     dx
                mov     al,bl
               OUTP    dx,al                   ; port 1F3h, hdsk0-sector numbr
                jmp     short $+2
                inc     dx
                mov     al,cl
               OUTP    dx,al                   ; port 1F4h, hdsk0-cylr,lo byte
                jmp     short $+2
                inc     dx
                mov     al,ch
               OUTP    dx,al                   ; port 1F5h, hdsk0-cylr,hi byte
                jmp     short $+2
                inc     dx
                inc     dx
                xchg    ah,al
               OUTP    dx,al                   ; port 1F7h, hdsk0-command reg
                jmp     short $+2
                mov     ah,0FFh
loc_1:
                mov     cx,0FFFFh

locloop_2:
               INP     al,dx                   ; port 1F7h, hdsk0-status reg
                jmp     short $+2

                test    al,8
                jnz     loc_3
                loop    locloop_2
                dec     ah
                or      ah,ah
                jnz     loc_1
loc_3:
                mov     cx,100h
                and     dl,0F0h
                retn
RWSector        endp


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+  WaitHDDforBusy -  ⮢ HDD                               +
;+ 室: -                                                                +
;+ 室: Z=0 - ⮢                                                     +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

WaitHDDforBusy  proc    near
                push    cx
                mov     cx,0FFFFh

locloop_4:
                mov     dx,IO_IDECMD
                INP     al,dx                 ; port 177h, hdsk0-status reg
                jmp     short $+2
                nop
                jmp     short $+2
                nop
                jmp     short $+2
                nop
                jmp     short $+2
                test    al,80h
                jz      loc_5
                loop    locloop_4

loc_5:
                test    al,80h
                pop     cx
                retn
WaitHDDforBusy  endp

;==========================================================================
bDHRsnap        db      0A0h ; ઠ IO_IDECONT
pwLPTbase       dw      0    ;   LPT
;==========================================================================

;
;
;                       External Entry Point
;
;

strategy        proc    far
                mov     word ptr cs:[pRequestHeader],bx
                mov     word ptr cs:[pRequestHeader+2],es
                retf

strategy        endp


;
;                          Done
;

Done            proc    near
                mov     byte ptr es:[bx+0Eh],1
                clc
                retn
Done            endp


;
;                          BuildBPB
;

BuildBPB        proc    near
                mov     cl,es:[bx+1]
                mov     ax,offset EndOfCode+4
loc_6:
                or      cl,cl
                jz      loc_7
                dec     cl
                add     ax,1Dh                  ; BPBSize+4
                jmp     short loc_6
loc_7:
                mov     es:[bx+12h],ax
                mov     es:[bx+14h],cs
                clc
                retn
BuildBPB        endp


;
;
;                       External Entry Point
;
;

interrupt       proc    far
                cld
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es
                mov     di,offset cmdRet

                push    di
                les     bx,cs:[pRequestHeader]  ; (3708:0012=0)
                mov     al,es:[bx+2]
                or      al,al
                jnz     loc_8
                jmp     Initialize              ; (0992)
loc_8:
                dec     al
                jz      Done
                dec     al
                jz      BuildBPB
                sub     al,2
                jz      Input
                sub     al,4
                jz      Output
                dec     al
                jz      Output
Exit3:
                mov     ax,8003h
                stc
                retn
interrupt       endp

cmdRet:
                jc      loc_9
                mov     ax,100h
loc_9:
                les     bx,cs:[pRequestHeader]
                mov     es:[bx+3],ax
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                retf

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+                                                                    +
;+ Input - ࠡ  04h                                      +
;+                                                                    +
;+ 室: es:bx - 㪠⥫    ᮬ                        +
;+                                                                    +
;+       +-   -------------------------------------+  +
;+       !Offset!Size!  Content                                    !  +
;+       !  +0h ! 1  ! bLen       20h -                 !  +
;+       !  +1h ! 1  ! bUnitNo     ன⢠                 !  +
;+       !  +2h ! 1  ! bCmd       04h -   - ⥭        !  +
;+       !  +3h ! 2  !                                             !  +
;+       !  +5h ! 8  ! reserved                                    !  +
;+       ! +0dh ! 1  ! bMediaID   ⨯ FAT                          !  +
;+       ! +0eh ! 4  ! pfBuffer   㪠⥫                 !  +
;+       ! +12h ! 2  ! wReadSize  - ᥪ஢  ⥭       !  +
;+       ! +16h ! 2  ! wStartSect 砫 ᥪ  ⥭      !  +
;+       !      !    !            (=0ffffh - ᯮ lBigSect)!  +
;+       ! +18h ! 4  !                                             !  +
;+       ! +1ch ! 4  ! lBigSect   砫 ᥪ              !  +
;+       !      !    !            wStartSect=0ffffh                !  +
;+       +------+----+---------------------------------------------+  +
;+ 室:                                                             +
;+       +-   -------------------------------------+  +
;+       !Offset!Size!  Content                                    !  +
;+       !  +0h ! 1  ! bLen       20h -                 !  +
;+       !  +1h ! 1  ! bUnitNo     ன⢠                 !  +
;+       !  +2h ! 1  ! bCmd       04h -   - ⥭        !  +
;+       !  +3h ! 2  ! rStatusWord ᫮ ﭨ ࠩ        !  +
;+       !  +5h ! 8  ! reserved                                    !  +
;+       ! +0dh ! 1  ! bMediaID   ⨯ FAT                          !  +
;+       ! +0eh ! 4  ! pfBuffer   㪠⥫   (DTA)         !  +
;+       ! +12h ! 2  ! wReadSize  - ⠭ ᥪ஢      !  +
;+       ! +16h ! 2  ! wStartSect 砫 ᥪ  ⥭      !  +
;+       !      !    !            (=0ffffh - ᯮ lBigSect)!  +
;+       ! +18h ! 4  ! pfVolID     ⪨ ⮬                 !  +
;+       ! +1ch ! 4  ! lBigSect   砫 ᥪ              !  +
;+       !      !    !            wStartSect=0ffffh                !  +
;+       +------+----+---------------------------------------------+  +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Input           proc    near
                call    DefTransfPars
                les     di,dword ptr es:[bx+0Eh] ;    (DTA)
                add     ax,cs:[si]               ; 砫 ᥪ
                adc     dx,cs:[si+2]
                mov     bx,si

locloop_10:
                push    cx
                push    es

                push    bx
                push    ax
                push    dx
                call    AbsoluteSector
                call    ReadSector
                pop     dx
                pop     ax
                pop     bx
                pop     es
                pop     cx
                inc     ax
                or      ax,ax
                jnz     loc_11
                inc     dx
loc_11:
                loop    locloop_10

                clc
                retn
Input           endp


;
;                          Output
;

Output          proc    near
                call    DefTransfPars
                xchg    si,di
                lds     si,dword ptr es:[bx+0Eh]
                mov     bx,di
                add     ax,cs:[bx]
                adc     dx,cs:[bx+2]

locloop_12:
                push    cx
                push    es
                push    bx
                push    ax
                push    dx
                call    AbsoluteSector
                call    WriteSector
                pop     dx
                pop     ax
                pop     bx
                pop     es
                pop     cx
                inc     ax
                or      ax,ax
                jnz     loc_13
                inc     dx
loc_13:
                loop    locloop_12

                clc
                retn

Output          endp


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+ DefTransfPars - । ࠬ                         +
;+ 室:  bx - 㪠⥫                            +
;+       +-   -------------------------------------+  +
;+       !Offset!Size!  Content                                    !  +
;+       !  +0h ! 1  ! bLen       20h -                 !  +
;+       !  +1h ! 1  ! bUnitNo     ன⢠                 !  +
;+       !  +2h ! 1  ! bCmd       04h/08h -              !  +
;+       !  +3h ! 2  !                                             !  +
;+       !  +5h ! 8  ! reserved                                    !  +
;+       ! +0dh ! 1  ! bMediaID   ⨯ FAT                          !  +
;+       ! +0eh ! 4  ! pfBuffer   㪠⥫                 !  +
;+       ! +12h ! 2  ! wReadSize  - ᥪ஢  ⥭/!  +
;+       ! +16h ! 2  ! wStartSect 砫 ᥪ  ⥭/  +
;+       !      !    !            (=0ffffh - ᯮ lBigSect)!  +
;+       ! +18h ! 4  !                                             !  +
;+       ! +1ch ! 4  ! lBigSect   砫 ᥪ              !  +
;+       !      !    !            wStartSect=0ffffh                !  +
;+       +------+----+---------------------------------------------+  +
;+ 室: cx - - ᥪ஢  ।,                          +
;+        dx,ax -  ᥪ                                       +
;+        si - BPB                                                    +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

DefTransfPars   proc    near
                mov     ax,es:[bx+14h]          ; 砫 ᥪ
                sub     dx,dx
                cmp     ax,0FFFFh
                jne     loc_14
                mov     ax,es:[bx+1Ah]          ;  ᥪ  65536
                mov     dx,es:[bx+1Ch]

loc_14:         mov     si,offset EndOfCode
                mov     cl,es:[bx+1]            ;  ன⢠

loc_15:         or      cl,cl
                jz      loc_16
                add     si,1Dh                  ; ࠧ  BPB+4
                dec     cl
                jmp     short loc_15
loc_16:
                mov     cx,es:[bx+12h]          ; - ᥪ஢  ।
                retn
DefTransfPars   endp


;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+ AbsoluteSector - ८ࠧ c  ᥪ  䨧᪨+
;+ 室: dx:ax - ᮫ 砫 ᪨  ᥪ         +
;+       bx    - 㪠⥫  BPB-4                                    +
;+ 室:bh -                                              +
;+       bl -  ᥪ                                            +
;+       cx -  樫                                           +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

AbsoluteSector  proc    near
                test    cs:[bDHRsnap],40h
                jz      loc_18          ; LBA-mode
loc_17:
                mov     bl,al           ; bl=LBA[7..0]
                mov     cl,ah           ; cl=LBA[15..8]
                mov     ch,dl           ; ch=LBA[23..16]
                mov     bh,dh           ; bh=LBA[27..24]
                retn
loc_18:
                push    bx
                mov     cx,cs:[bx+0dh+4] ; Sector per track
                call    DivDXAX_CX
                inc     cl               ; cl -  ᥪ
                pop     bx
                push    cx
                mov     cx,cs:[bx+0fh+4] ; head qty
                call    DivDXAX_CX
                pop     bx
                mov     bh,cl

                mov     cx,ax
                retn
AbsoluteSector  endp


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+           dx:ax = dx:ax / cx ; cl = dx:ax % cx                     +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

DivDXAX_CX      proc    near
                push    ax
                sub     ah,ah
                call    DivDX_CX
                pop     dx
                push    bx
                call    DivDX_CX
                mov     cl,dl
                xchg    bx,ax
                pop     dx
                retn
DivDXAX_CX      endp


DivDX_CX        proc    near
                push    dx
                mov     al,dh
                sub     dx,dx
                div     cx                      ; ax=(ah*256+dh)/cx; dx=dg%cx
                mov     bh,al                   ; bh = (ah*256+dh)/cx
                mov     ah,dl                   ; ah = (ah*256+dh)%cx
                pop     dx
                mov     al,dl                   ; al = dl
                sub     dx,dx                   ; dx:ax = [((ah*256+dh)%cx)*256]+dl
                div     cx                      ; ax={[((ah*256+dh)%cx)*256]+dl}/cx; dx={[((ah*256+dh)%cx)*256]+dl}%cx
                mov     bl,al                   ; bl = (dh%cx*256 + dl) / cx
                mov     ah,dl                   ; ah = (dh%cx*256+dl)%cx
                retn
DivDX_CX        endp


;-------------------------------------------------------
; 室: al -   뢮   dx
OutB    proc    near
        pushf
        cli

        cmp     dx,IO_IDECONT
        jne     oub1fx
        jmp     oub3F6

oub1fx:
  push  dx                      ;**my** .. si 
        push    ax
        push    si
        mov     si,dx
        and     si,7
; AC_WRRL begin -----------------
        mov     dx,word ptr cs:[pwLPTbase]
        out     dx,al
        jmp     short $+2
        mov     al,00000000b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 0        ; ⠢塞 HD7..HD0
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2
; end ---------------------
        mov     ax,si
        or      al,10001000b
;                    HA2..HA0 = xxx ; ⠢塞 -CS1FX  HA2..HA0
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0
; AC_WRRC begin -----------------
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2
; end ---------------------

        mov     ax,si
        or      al,11001000b
;                    HA2..HA0 = xxx
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 1       ; ⠢塞 -HWR
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     ax,si
        or      al,10001000b
;                    HA2..HA0 = xxx
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0       ; ᭨ -HWR
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     ax,si
        or      al,10011000b
;                    HA2..HA0 = xxx ; ᭨ -CS1FX  HA2..HA0
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
;        mov     dx,si          ;**my**  pp⭮
        pop     si
        pop     ax
  pop   dx                      ;**my** ⠪ p쭥
        popf
        ret

oub3F6: push    ax
        push    dx
        mov     dx,word ptr cs:[pwLPTbase]
        out     dx,al                           ; ⠢塞 HD7..HD0
        jmp     short $+2
        mov     al,00000000b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 0
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,11010110b
;                   HA2..HA0 = 110b
;                   -CS3FX = 0
;                   -CS1FX = 1
;                   RCW = 0
;                   TRW = 1
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10011111b
;                    HA2..HA0 = 111b
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2

        pop     dx
        pop     ax
        popf
        ret
OutB    endp


;-------------------------------------------------------
; 室: dx -    ⥭
InB     proc
        pushf
        cli
        push    dx
        push    bx
        and     dl,7
        mov     al,dl
   mov  bl,al                           ;**my** p p
        or      al,10001000b
;                    HA2..HA0 = xxx ; ⠢塞 -CS1FX  HA2..HA0
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0
        mov     dx,word ptr cs:[pwLPTbase]
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

;        mov     al,dl                  ;??????
   mov  al,bl                           ;**my**
        or      al,10101000b
;                    HA2..HA0 = xxx ; ⠢塞 -HRD
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 1
;                    TRW = 0
        mov     dx,word ptr cs:[pwLPTbase]
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

;        mov     al,dl                  ;??????
   mov  al,bl                           ;**my**
        or      al,10001000b
;                    HA2..HA0 = xxx ; ᭨ -HRD
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10011111b                      ; ᭨ -CS1FX  HA2..HA0
;                    HA2..HA0 = 111b
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        xor     al,al                           ; 뢠 
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        shr     al,4
        mov     bl,al
        dec     dx
        mov     al,1
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        or      al,bl

        pop     bx
        pop     dx
        popf
        ret

InB     endp

;-------------------------------------------------------
; 室: ax - ᫮  뢮   dx              ??????
;  p⮬ dx p㬥 HDD p X=0  17X  **my**
;  p 襬 ᫮  pp  HDD      **my**
; p 室 dx= LPT p                   **my**
OutW    proc    near
        pushf
        cli
        push    ax
        mov     dx,word ptr cs:[pwLPTbase]      ; ⠢塞 HD7..HD0
        out     dx,al
        jmp     short $+2
        mov     al,00000000b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 0
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2


        mov     al,ah                           ; ⠢塞 HD15..HD8
        out     dx,al
        jmp     short $+2
        mov     al,00000110b
;                       HRESET = 0
;                       RHWR = 1
;                       -RLWR = 1
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2

        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10001000b
;                    HA2..HA0 = 000b ; ⠢塞 HA2..HA0, -CS1FX
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,11001000b
;                    HA2..HA0 = 000b ; ⠢塞 -HWR
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 1
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

;        push    cx
;        mov     cx,1000
;mm:     jmp     short $+2
;        loop    mm
;        pop     cx

        mov     al,10001000b                    ; ᭨ -HRW
;                    HA2..HA0 = 000b
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10011111b                    ; ᭨ -CS1FX  HA2..HA0
;                    HA2..HA0 = 111b
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2

        pop     ax
        mov     dx,IO_IDEBASE
        popf
        ret
OutW    endp

;-------------------------------------------------------
; 室: dx -    ⥭                 ??????
; ᥣ ⠥ HDD p X=0  17X               **my**
;  p ⠥ ᫮  pp  HDD  **my**
; p 室 dx= LPT p                  **my**
InW     proc
        pushf
        cli
        push    bx
        mov     al,10001000b   ; 롨ࠥ ॣ   HDD
;                    HA2..HA0 = 000b ; ⠢塞 -CS1FX  HA2..HA0
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0
;                    TRW = 0
        mov     dx,word ptr cs:[pwLPTbase]
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10101000b
;                    HA2..HA0 = 000b
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 1       ; ⠢塞 -HRD
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10001000b
;                    HA2..HA0 = 000b
;                    -CS3FX = 1
;                    -CS1FX = 0
;                    RCW = 0       ; ᭨ HRD
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,10011111b                    ; ᭨ -CS1FX  HA2..HA0
;                    HA2..HA0 = 111b
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        xor     al,al
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        shr     al,4
        dec     dx
        mov     bl,al

        mov     al,1
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        dec     dx
        or      bl,al

        mov     al,2
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        shr     al,4
        dec     dx
        mov     bh,al

        mov     al,3
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        dec     dx
        or      bh,al

        mov     ax,bx

        pop     bx
        mov     dx,IO_IDEBASE
        popf
        ret

InW     endp

EndOfCode       equ     $

;
;         ८ࠧ ASCII ।⠢ HEX-᫠  ds:[si]
;

Hex2Bin         proc    near
                lodsb
                cmp     al,':'
                jne     h2bErr
                sub     bx,bx

loc_20:
                call    isDelimited
                jz      d2bRet
                cmp     al,'0'
                jb      h2bErr
                cmp     al,'9'
                jbe     loc_21
                or      al,20h
                sub     al,27h
                cmp     al,39h
                jbe     h2bErr
                cmp     al,3Fh
                ja      h2bErr
loc_21:
                sub     al,'0'
                shl     bx,4
                or      bl,al
                jmp     short loc_20
h2bErr:
                pop     bx
                stc
                retn
Hex2Bin         endp


;
;         ८ࠧ ASCII ।⠢ DEC-᫠  ds:[si]
;

Dec2Bin         proc    near
                lodsb
                cmp     al,':'
                jne     h2bErr
                sub     bx,bx
loc_22:
                call    isDelimited
                jz      d2bRet
                mov     cx,0ah
                cmp     al,'0'
                jb      h2bErr
                cmp     al,'9'
                ja      h2bErr
                sub     al,'0'
                sub     ah,ah
                xchg    bx,ax
                mul     cx
                add     bx,ax
                jmp     short loc_22
d2bRet:
                dec     si
                clc
                retn
Dec2Bin         endp



;
;                          isDelimited
;

isDelimited     proc    near
                lodsb
                cmp     al,':'
                je      loc_ret_23
                cmp     al,' '
                je      loc_ret_23
                cmp     al,0ah
                je      loc_ret_23
                cmp     al,0dh
                je      loc_ret_23
                or      al,al

loc_ret_23:
                retn
isDelimited     endp


;
;          AX  HEX-।⠢
;

ShowHexAX       proc    near
                call    ShowHexAL               ; (0249)
ShowHexAX       endp


;
;                          ShowHexAL
;

ShowHexAL       proc    near
                call    ShowHexDigit            ; (024C)
ShowHexAL       endp


;
;                          ShowHexDigit
;

ShowHexDigit    proc    near
                rol     ax,4
                mov     dl,al
                and     dl,0Fh
                cmp     dl,9
                jbe     loc_24
                add     dl,7
loc_24:
                add     dl,30h                  ; '0'
                jmp     PutChar                 ; (0B1B)

ShowHexDigit    endp

sTitle1         db      0dh,0ah,  'IDE2LPT(R) - External IDE HD driver by Leonid Slobodchikov AKA Curvex'
                db      0dh,0ah,  'Version 0.04 at 12.04.99 requires I2L-adapter v2.01$'
sTitle2         db      0dh,0ah,  'Contact me at curvex@afti.nsu.ru, ICQ 16452452, 2:5000/72.40@fidonet.'
                db      0dh,0ah,  'See more info at http://curvex.hypermart.net/ide2lpt/index.html'
                db      0dh,0ah,  'Special thanks to A.Yakovlev, R.Bryguin, Y.Golicow, E.Kuleshov and others.'
                db      0dh,0ah
                db      0dh,0ah,  'Instalable in CONFIG.SYS: DEVICE = IDE2LPT.EXE {opt}'
                db      0dh,0ah,  '{opt}:'
                db              9,'/L:LPT - LPT port base address (378h/278h/...)'
                db      0dh,0ah,9,'/G:SEC:HEAD - set HDD geometry (not Get IDE info)'
                db      0dh,0ah,9,'/L - set LBA mode'
                db      0dh,0ah,9,'/V - verbose mode'
                db      0dh,0ah,9,'/T - test I2L-adapter'
                db      0dh,0ah,  'Example: DEVICE=IDE2LPT.EXE /P:378 /G:63:64 /L /V$'

sSearchI2L      db      0dh,0ah,  'Looking for I2L adapter... $'
sLptPort        db      0dh,0ah,  'Parallel Port: $'
sHDD            db      0dh,0ah,  'HDD:$'
sCDROM          db      0dh,0ah,  'CDROM:$'
sAdapterFound   db                ' - I2L-adapter detected$'
sNoAdapter      db                ' - no I2L-adapter detected$'
sError1         db      0dh,0ah,  'Error. Can`t get IDE-ATA info.$'
sError2         db      0dh,0ah,  'Error. Can`t set drive geometry.$'
sError3         db      0dh,0ah,  'Error. Not supported device.$'
sError5         db      0dh,0ah,  'Error. Invalid Argument.$'
sTestI2L        db      0dh,0ah,  'Testing I2L adapter... $'
sOK             db                'OK',0dh,0ah,'$'
sTestFail1      db      0dh,0ah,  'Data mismatched, write: $'
sTestFail2      db                ' read: $ '

sTypeTable      db      0dh,0ah,  'Type   B Sect Head Cyl Sect Head Cyl   Offset      Total   Size  Drv'
                db      0dh,0ah,'$'
bFileSystem1    db      7
sFileSystem1    db      'HPFS  $'
bFileSystem2    db      1
sFileSystem2    db      'DOS-12$'
bFileSystem3    db      4
sFileSystem3    db      'DOS-16$'
bFileSystem4    db      6
sFileSystem4    db      'BIGDOS$'
bFileSystem5    db      5
sFileSystem5    db      'EXTEND$'
bFileSystem6    db      0ah
sFileSystem6    db      'BM-OS2$'
bFileSystem7    db      0
sFileSystem7    db      '------$'
fTestI2L        db      0       ; 䫠 ࠧ襭 ஢ 

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ParseArg - ࠧ 㬥⮢  ப
; 室: si - 㪠⥫   ப
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ParseArg        proc    near
loc_26:         lodsb                           ; 㦠 ᨬ   ப
                or      al,al
                jz      praOK
                cmp     al,0dh
                je      praOK
                cmp     al,0ah
                je      praOK
                cmp     al,'/'
                jne     loc_26

                lodsb
                or      al,20h

                cmp     al,'g'
                jne     loc_28                  ;  /G - ⠭  HDD

                call    Dec2Bin                 ; ।塞 - ᥪ஢
                mov     cs:[wSectQty],bx
                call    Dec2Bin                 ; ।塞 - 
                mov     cs:[wHeadQty],bx
                jmp     short loc_26
loc_28:
                cmp     al,'l'                  ;  /L - ० LBA
                jne     loc_29
                or      cs:[bDHRsnap],40h       ; ⠭ ० LBA
                jmp     short loc_26
loc_29:
                cmp     al,'p'                  ;  /P -  ࠫ쭮 
                jne     loc_31
loc_30:
                call    Hex2Bin
                mov     word ptr cs:[pwLPTbase],bx
                jmp     short loc_26
loc_31:
                cmp     al,'v'                  ;  /V - ⮡ࠦ .ଠ
                jne     pra20
                mov     byte ptr cs:[fVerbosely],1
                jmp     loc_26

praOK:          clc
                retn

pra20:          cmp     al,'t'                  ;  /T - ஢ I2L - 
                jne     praErr
                mov     byte ptr cs:[fTestI2L],1
                jmp     loc_26

praErr:
                mov     dx,offset sTitle2
                stc                             ; 室  訡
                retn

                endp

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; DetectI2L - । 稥 i2l-
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
DetectI2L       proc    near
                cmp     word ptr cs:[pwLPTbase],0
                jnz     dil50

                mov     dx,offset sSearchI2L
                call    StrPrint
                xor     ax,ax
                mov     ds,ax
                mov     si,0408h                ; ᯨ᮪ ᮢ ࠫ ⮢ DOS

dil30:          lodsw
                or      ax,ax
                jz      dil40
                mov     word ptr cs:[pwLPTbase],ax
                call    isAttached
                jnc     dil50
dil40:          cmp     si,0410h
                jne     dil30

dilErr:         mov     dx,offset sNoAdapter
                stc
                ret

dil50:          mov     dx,offset sLptPort
                call    StrPrint
                mov     ax,[pwLPTbase]
                call    ShowHexAX

                call    isAttached
                jc      dilErr

                call    StrPrint

                clc
                ret
                endp

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ஢ 
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
testI2L proc
        mov     dx,offset sTestI2L
        call    StrPrint

;        AC_HDRESET

        mov     bx,0h
        mov     si,0

til10:  mov     dx,word ptr cs:[pwLPTbase]
        mov     al,bh
        out     dx,al
        jmp     short $+2
        mov     al,00000110b
;                       HRESET = 0
;                       RHWR = 1
;                       -RLWR = 1
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,bl
        out     dx,al
        jmp     short $+2
        mov     al,00000000b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 0
;                       RCWR = 0
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        mov     al,11111000b
;                    HA2..HA0 = 000b
;                    -CS1FX = 1
;                    -CS3FX = 1
;                    RCW = 1
;                    TRW = 1
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        xor     al,al
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        shr     al,4
        dec     dx
        mov     cl,al

        mov     al,1
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        dec     dx
        or      cl,al

        mov     al,2
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        shr     al,4
        dec     dx
        mov     ch,al

        mov     al,3
        out     dx,al
        jmp     short $+2
        inc     dx
        in      al,dx
        and     al,0f0h
        xor     al,80h
        dec     dx
        or      ch,al

        mov     al,10011111b
;                    HA2..HA0 = 111b
;                    -CS3FX = 1
;                    -CS1FX = 1
;                    RCW = 0
;                    TRW = 0
        out     dx,al
        jmp     short $+2
        mov     al,00001100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 1
        add     dx,2
        out     dx,al
        jmp     short $+2
        mov     al,00000100b
;                       HRESET = 0
;                       RHWR = 0
;                       -RLWR = 1
;                       RCWR = 0
        out     dx,al
        jmp     short $+2
        sub     dx,2

        cmp     cx,bx
        jz      til20

        mov     dx,offset sTestFail1
        call    StrPrint
        mov     ax,bx
        call    ShowHexAX
        mov     dx,offset sTestFail2
        call    StrPrint
        mov     ax,cx
        call    ShowHexAX
        call    NewLine

til20:
        inc     bx
        cmp     bx,0
        jz      tilOK
til30:  jmp     til10

tilOK:  clc
        or      si,si
        jz      tilRet
        stc
tilRet: ret

testI2L endp

;-------------------------------------------------------
; ஢ઠ  
; 室: ZF=0 - ᫨  㦥
isAttached proc near
        AC_HDRESET
isa10:
        AC_WRRL 0aah
        AC_WRRH 55h
        AC_WRRC 11111000b
;                 HA2..HA0 = 000b
;                 -CS1FX = 1
;                 -CS3FX = 1
;                 RCW = 1
;                 TRW = 1
        AC_RDTET 0
        mov     bl,al
        AC_RDTET 1
        or      bl,al
        AC_RDTET 2
        mov     bh,al
        AC_RDTET 3
        or      bh,al
        CYCEND
        cmp     bx,55aah
        jne     isaErr

        mov     dx,offset sAdapterFound
        clc
        ret

isaErr: mov     dx,offset sNoAdapter
        stc
        ret
isAttached endp

;

;                          DetectHDD
;

DetectHDD       proc    near

                push    cs
                push    cs
                pop     es
                pop     ds

                mov     dx,IO_IDECONT
                INP     al,dx
                jmp     short $+2
                or      al,4
                OUTP    dx,al                   ; 뢠 ஫ IDE
                jmp     short $+2
                mov     cx,0FFFFh

locloop_34:
                jmp     short $+2
                loop    locloop_34

                and     al,0FBh
                OUTP    dx,al
                jmp     short $+2
                mov     ah,0
                int     1Ah                     ;  get system timer count cx,dx
                mov     bx,dx
loc_35:
                mov     ah,0
                int     1Ah                     ;  get system timer count cx,dx
                sub     dx,bx
                cmp     dx,18*5                 ;  ᥪ㭤 
                jb      loc_35
loc_36:
                cmp     [wSectQty],0
                je      loc_37
                cmp     [wHeadQty],0
                jne     dhd60                   ; 䨣  १ /G:HEAD:SEC
dhdErr:
                stc                             ; 室  訡
                retn

dhd60:          call    NewLineIfVerb
                jmp     loc_43
loc_37:
                mov     dx,IO_IDECMD
                mov     al,[bDHRsnap]
                dec     dx
                OUTP    dx,al                   ; port 1F6h, hdsk0-siz/drv/head
                jmp     short $+2
                mov     bl,2
                inc     dx
                mov     al,0A1h                 ; ATAPI IDENTIFY DEVICE
loc_38:
                mov     cx,0FFFFh
                OUTP    dx,al                   ; port 1F7h, hdsk0-command reg
                jmp     short locloop_39

locloop_39:
                INP     al,dx                   ; port 1F7h, hdsk0-status reg
                cmp     al,58h
                je      loc_40
                loop    locloop_39

                dec     bl
                mov     al,0ECh                 ; ⥭ ଥ஢ HDD
                jnz     loc_38
                mov     dx,offset sError1
                stc
                retn
loc_40:
                and     dl,0F0h
                mov     cx,100h
                mov     di,offset rHDDInfo
                rep     INPSW
                mov     dx,offset sHDD
                test    byte ptr [wGenCnfHDD],80h       ; ।,   - HDD  CD-ROM
                jz      loc_41
                mov     dx,offset sCDROM
loc_41:
                call    StrPrint
                mov     si,offset sModelNo
                mov     cx,14h

locloop_42:     lodsw                                   ;  
                mov     dl,ah
                call    PutChar
                mov     dl,al
                call    PutChar
                loop    locloop_42

                mov     dx,offset sError3
                test    byte ptr [wGenCnfHDD],80h
                jnz     loc_45                  ; CD-ROM -  ন

                sub     bx,bx
                mov     ax,[wLogCylQty]
                mov     byte ptr [fArrangeFigure],2
                call    ShowDec1
                mov     ax,[wLogHeadQty]
                mov     [wHeadQty],ax
                mov     byte ptr [fArrangeFigure],2
                call    ShowDec3
                mov     ax,[wLogSecQty]
                mov     [wSectQty],ax
                mov     byte ptr [fArrangeFigure],2
                call    ShowDec3
                call    NewLineIfVerb
loc_43:
                mov     dx,IO_IDECMD
                mov     ax,[wHeadQty]
                dec     ax
                or      al,[bDHRsnap]
                dec     dx
                OUTP    dx,al                   ; port 1F6h, hdsk0-siz/drv/head
                call    WaitHDDforBusy
                jz      loc_46
loc_44:
                mov     dx,offset sError2
loc_45:
                stc
                retn
loc_46:
                sub     dl,5
                mov     al,byte ptr [wSectQty]
                OUTP    dx,al                   ; port 1F2h, hdsk0-sector count
                call    WaitHDDforBusy
                jnz     loc_44
                mov     al,91h                  ; ⠢塞 ࠬ HDD
                OUTP    dx,al                   ; port 1F2h, hdsk0-sector count
                call    WaitHDDforBusy
                jnz     loc_44
                push    cs
                push    cs
                pop     ds
                pop     es
                cmp     byte ptr [fVerbosely],1
                jne     loc_47
                mov     dx,offset sTypeTable
                call    StrPrint
loc_47:
                mov     di,offset EndOfCode
                push    0                       ; Cylinder
                push    0                       ; Head
                push    1                       ; Sector
                call    AnalyzePartition
                mov     al,[block_dev]
                or      al,al
                mov     dx,offset sError4
                jz      loc_45
                mov     dx,offset sInstalled

                clc
                retn
DetectHDD       endp


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+ AnalyzePartition -  ᥪ  樥  ந BPB           +
;+   ⮬                                                     +
;+ 室: di - 㪠⥫    BPB                                  +
;+       [sp+4] -  ᥪ                                           +
;+       [sp+6] -                                             +
;+       [sp+8] -  樫                                          +
;+ 室:                                                                 +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

AnalyzePartition proc   near

Sector          =       4                       ; bp+4
Head            =       6                       ; bp+6
Cylinder        =       8                       ; bp+8

                enter   0,0
                mov     si,offset rPrtnInfo1
loc_48:
                mov     cx,12Ch

locloop_49:
                push    cx
                push    di
                mov     cx,[bp+Cylinder]
                mov     bh,[bp+Head]
                mov     bl,[bp+Sector]
                mov     di,offset rSectBuf
                call    CHS2LBA
                call    ReadSector
                pop     di
                pop     cx
                cmp     [wLastWord1],0AA55h
                je      loc_51                  ; partition table is OK
                loop    locloop_49

anpRet:
                leave
                retn    6
loc_51:
                push    si
                mov     al,[si+4]               ; ।塞 ⨯ 䠩 ⥬
                                                ;   partition'
                or      al,al
                jnz     loc_52
                jmp     short loc_58
loc_52:
                cmp     byte ptr [fVerbosely],1 ;
                jne     loc_56
                push    ax
                push    si
                xchg    dx,si
                xchg    ah,al
                mov     si,offset bFileSystem1
loc_53:

                lodsb
                or      al,al
                jz      loc_54
                cmp     ah,al
                je      loc_54
                add     si,7
                jmp     short loc_53
loc_54:
                xchg    si,dx
                call    StrPrint
                call    PrintSpace
                mov     dl,'Y'
                lodsb                           ; ਧ 㦠 設
                cmp     al,80h
                je      loc_55
                mov     dl,'-'
loc_55:
                call    PutChar
                call    PrintPrtnInfo
                lodsb
                call    PrintPrtnInfo
                call    PrintLongDec
                call    PrintLongDec
                pop     si
                pop     ax
loc_56:
                cmp     [block_dev],43
                je      anpRet                  ; ᫨誮  ன
                cmp     al,1                    ; DOS 12-bit FAT
                je      loc_59
                cmp     al,4                    ; DOS 16-bit FAT
                je      loc_59
                cmp     al,6                    ; DOS 16-bit FAT
                je      loc_59
                cmp     al,5                    ; Extended DOS partiton
                je      loc_63
loc_57:
                call    NewLineIfVerb
loc_58:
                pop     si
                cmp     si,offset rPrtnInfo4
                jae     anpRet
                add     si,10h
                jmp     loc_48
loc_59:
                cmp     byte ptr [fVerbosely],1
                jne     loc_61
                mov     byte ptr [fArrangeFigure],2
                mov     ax,[si+0Ch]             ; ।塞  뢠 ࠧ 設
                mov     bx,[si+0Eh]             ; axbx - ࠧ 設  ᥪ
                mov     cx,0Bh
locloop_60:     shr     bx,1                    ; lTotalSects/4096
                rcr     ax,1
                loop    locloop_60

                mov     byte ptr [fArrangeFigure],2
                call    ShowDec1
                mov     dl,'M'
                call    PutChar
                mov     dl,'b'
                call    PutChar
loc_61:
                mov     bx,[si+2]               ; rBeginSecCyl
                mov     ch,bl
                mov     cl,bh
                shr     ch,6
                and     bl,3Fh
                mov     bh,[si+1]               ; bBeginHead
                mov     [wFirstCylOfPartition],cx
                mov     [bFirstHdOfPartition],bh
                mov     [bFirstSecOfPartition],bl
                push    di
                mov     di,offset rHDDInfo
                call    CHS2LBA
                call    ReadSector              ; 뢠 boot-ᥪ ᪨
                                                ;  ᪮
                pop     di
                cmp     [wLastWord2],0AA55h
                jne     loc_62
                cmp     byte ptr [bExtBootSig],29h ; BootSector+26h - ਧ ७ boot-ᥪ
                je      loc_64
                mov     dl,7
                call    PutChar
loc_62:         jmp     short loc_57

loc_63:         mov     ax,[si+2]               ; ७ 設
                mov     cl,[si+1]
                xchg    ah,al
                mov     bl,ah
                and     bl,3Fh
                shr     ah,6
                call    NewLineIfVerb
                push    ax                      ; Cylinder
                push    cx                      ; Head
                push    bx                      ; Sector
                call    AnalyzePartition
                jmp     loc_58

loc_64:         mov     ax,[wFirstCylOfPartition]  ; ax=砫 樫 樨
                mov     bl,byte ptr [wHeadQty]     ; bx=- 
                sub     bh,bh
                imul    bx                         ; dx,ax = wFirstCylOfPartition * wHeadQty
                add     al,[bFirstHdOfPartition]
                adc     ah,0
                adc     dx,0
                mov     cx,dx                      ; cx,ax = wFirstCylOfPartition * wHeadQty + bFirstHdOfPartition; dx,ax = wFirstCylOfPartition * wHeadQty + bFirstHdOfPartition
                sub     bh,bh
                mov     bl,byte ptr [wSectQty]

                imul    bx                         ; dx,ax = ( wFirstCylOfPartition * wHeadQty + bFirstHdOfPartition; dx,ax = wFirstCylOfPartition * wHeadQty + bFirstHdOfPartition ) * wSectQty
                push    ax
                push    dx
                mov     ax,cx
                imul    bx
                xchg    dx,ax
                pop     ax
                add     dx,ax
                pop     ax
                sub     al,[bFirstSecOfPartition]
                sbb     ah,0
                sbb     dx,0
                add     ax,1
                adc     dx,0
                stosw
                xchg    dx,ax
                stosw
                mov     si,offset rBPB
                mov     cx,19h
                rep     movsb           ; ஢ BPB  ⮬
                cmp     byte ptr [fVerbosely],1
                jne     loc_65
                call    PrintSpace
                sub     ah,ah
                mov     byte ptr [fArrangeFigure],2
                mov     dl,[block_dev]
                add     dl,[cFirstLetter]
                call    PutChar
                mov     dl,':'
                call    PutChar

loc_65:         inc     [block_dev]             ; 㢥稢 稪 ᮢ
                jmp     loc_57
AnalyzePartition endp

;
;         ⠥  , 樫  ᥪ 砫 
;

PrintPrtnInfo   proc    near
                lodsb                           ;  砫쭮 
                sub     ah,ah
                mov     byte ptr [fArrangeFigure],2

                call    ShowDec2
                lodsw                           ;  砫 樫  ᥪ
                mov     bh,al
                mov     bl,ah
                and     al,3Fh
                mov     byte ptr [fArrangeFigure],2
                sub     ah,ah
                call    ShowDec2
                xchg    bx,ax
                shr     ah,6
                mov     byte ptr [fArrangeFigure],2
                sub     bx,bx
                call    ShowDec1
                jmp     short PrintSpace
PrintPrtnInfo   endp


;
;                          PrintLongDec
;

PrintLongDec    proc    near
                lodsw
                xchg    dx,ax
                lodsw
                xchg    dx,ax
                mov     byte ptr [fArrangeFigure],2
                call    ShowDec0
PrintLongDec    endp


;
;                          PrintSpace
;

PrintSpace      proc    near
                mov     dl,20h                  ; ' '
                call    PutChar                 ; (0B1B)

loc_ret_66:
                retn
PrintSpace      endp


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+ CHS2LBA - ८ࠧ CHS- ᥪ  LBA                    +
;+ 室: cx -  樤                                          +
;+       bh -                                             +
;+       bl -  ᥪ                                           +
;+ 室:  bl=LBA[7..0]                                               +
;+         cl=LBA[15..8]                                              +
;+         ch=LBA[23..16]                                             +
;+         bh=LBA[27..24]                                             +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

CHS2LBA  proc    near
        test    [bDHRsnap],40h
        jz      loc_ret_66              ; not LBA

        xchg    cx,ax
        sub     cx,cx
        sub     dx,dx
        mul     [wHeadQty]              ; dx,ax = Cylinder*headQty

        add     al,bh
        adc     ah,cl
        adc     dx,cx                   ; dx,ax=Cylinder*headQty+Head
        mul     [wSectQty]              ; dx,ax=(Cylinder*headQty+Head)*sectPerTrack
        add     al,bl
        adc     ah,cl
        adc     dx,cx
        dec     ax
        sbb     dx,cx                   ; dx,ax=(Cylinder*headQty+Head)*sectPerTrack+(Sector-1)
        jmp     loc_17
CHS2LBA       endp


;
;                          NewLineIfVerb
;

NewLineIfVerb   proc    near
                cmp     byte ptr [fVerbosely],1 ; (3708:0B40=0)
                jne     loc_ret_67
NewLineIfVerb   endp


;
;                          NewLine
;

NewLine         proc    near
                mov     dx,offset sCRLF         ; (3708:0A2E='')
                call    StrPrint                ; (0B22)

loc_ret_67:
                retn
NewLine         endp

;
;
;                       External Entry Point
;
;

start           proc    far
                mov     dx,offset sTitle1       ; (3708:0262='')
                call    StrPrint                ; (0B22)
                mov     ah,62h
                int     21h                     ; DOS Services  ah=function 62h
                                                ;  get Program Segment Prefix bx
                push    bx
                pop     ds

                mov     si,81h
                call    ParseArg
                jc      s20

                call    DetectI2L
                jc      s20

                mov     al,byte ptr cs:[fTestI2L]
                or      al,al
                jz      s15

                call    testI2L                 ; 㥬 
                jc      loc_68
                mov     dx,offset sOK
                call    StrPrint

s15:            call    DetectHDD               ; (0598)
                jnc     loc_68

s20:            call    StrPrint                ; (0B22)
loc_68:
                call    NewLine                 ; (0963)
                mov     ax,4C00h
                int     21h                     ; DOS Services  ah=function 4Ch
                                                ;  terminate with al=return code
                                                ; now data because: does not return
start           endp



;
;                          Initialize
;

Initialize      proc    near
                mov     dx,offset sTitle1
                call    StrPrint
                les     bx,cs:[pRequestHeader]
                lds     si,dword ptr es:[bx+12h] ; 㦠 㪠⥫   ப
                mov     dx,offset sTitle2
                mov     al,es:[bx+16h]          ; 㦠  㯭 ਢ
                add     al,'A'
                mov     cs:[cFirstLetter],al
                call    ParseArg
                jc      ini20
                call    DetectI2L
                jc      ini20
                call    DetectHDD
ini20:          pushf
                call    StrPrint
                call    NewLine
                popf
                jnc     loc_69
ini30:          les     bx,cs:[pRequestHeader]
                mov     byte ptr es:[bx+0dh],0
                mov     word ptr es:[bx+0Eh],0
                mov     es:[bx+10h],cs
                jmp     Exit3
loc_69:
                les     bx,[pRequestHeader]
                mov     es:[bx+0dh],al
                mov     es:[bx+12h],di
                mov     es:[bx+14h],cs
                mov     cl,al
                sub     ch,ch
                mov     ax,offset EndOfCode+4

locloop_70:
                mov     [di],ax
                inc     di
                inc     di
                add     ax,1Dh
                loop    locloop_70

                mov     es:[bx+0Eh],di
                mov     es:[bx+10h],cs
                clc

                retn
Initialize      endp

sInstalled      db      0dh, 0ah, 'Installed.$'
sError4         db      0dh, 0ah, 'Error. Unsupported partition type.$'
sCRLF           db      0dh, 0ah, '$'

;
;                          ShowDec0
;

ShowDec0        proc    near
                sub     dl,dl
                jmp     short loc_72            ; (0A3E)
loc_71:
                inc     dl
                sub     ax,0CA00h
                sbb     bx,3B9Ah
loc_72:
                cmp     bx,3B9Ah
                ja      loc_71
                jc      loc_73
                cmp     ax,0CA00h
                jae     loc_71
loc_73:
                call    ShowDigit               ; (0AFE)
                sub     dl,dl
                jmp     short loc_75            ; (0A5B)
loc_74:
                inc     dl
                sub     ax,0E100h
                sbb     bx,5F5h
loc_75:
                cmp     bx,5F5h
                ja      loc_74
                jc      loc_76
                cmp     ax,0E100h
                jae     loc_74
loc_76:
                call    ShowDigit               ; (0AFE)
                sub     dl,dl
                jmp     short loc_78            ; (0A78)
loc_77:
                inc     dl
                sub     ax,9680h

                sbb     bx,98h
loc_78:
                cmp     bx,98h
                ja      loc_77
                jc      loc_79
                cmp     ax,9680h
                jae     loc_77
loc_79:
                call    ShowDigit               ; (0AFE)
                sub     dl,dl
                jmp     short loc_81            ; (0A94)
loc_80:
                inc     dl
                sub     ax,4240h
                sbb     bx,0Fh
loc_81:
                cmp     bx,0Fh
                ja      loc_80
                jc      loc_82
                cmp     ax,4240h
                jae     loc_80
loc_82:
                call    ShowDigit               ; (0AFE)
                sub     dl,dl
                jmp     short loc_84            ; (0AAF)
loc_83:
                inc     dl
                sub     ax,86A0h
                sbb     bx,1
loc_84:
                cmp     bx,1
                ja      loc_83
                jc      loc_85
                cmp     ax,86A0h
                jae     loc_83
loc_85:
                call    ShowDigit               ; (0AFE)
ShowDec0        endp


;
;                          ShowDec1
;

ShowDec1        proc    near
                sub     dl,dl
                jmp     short loc_87            ; (0ACA)
loc_86:
                inc     dl
                sub     ax,2710h
                sbb     bx,0
loc_87:
                cmp     bx,0
                ja      loc_86

                cmp     ax,2710h
                jae     loc_86
                call    ShowDigit               ; (0AFE)
ShowDec1        endp


;
;                          ShowDec2
;

ShowDec2        proc    near
                sub     dx,dx
                mov     cx,3E8h
                div     cx
                xchg    dx,ax
                call    ShowDigit               ; (0AFE)
ShowDec2        endp


;
;                          ShowDec3
;

ShowDec3        proc    near
                mov     cl,64h                  ; 'd'
                div     cl
                mov     dl,al
                call    ShowDigit               ; (0AFE)
                mov     al,ah
                cbw
                mov     cl,0ah
                div     cl
                mov     dl,al
                call    ShowDigit               ; (0AFE)
                mov     dl,ah
                mov     byte ptr [fArrangeFigure],1     ; (3708:0D48=0)
ShowDec3        endp


;
;                          ShowDigit
;

ShowDigit       proc    near
                cmp     byte ptr [fArrangeFigure],1     ; (3708:0D48=0)
                je      loc_88
                or      dl,dl
                jnz     loc_88
                cmp     byte ptr [fArrangeFigure],2     ; (3708:0D48=0)
                jne     loc_ret_89
                jmp     PrintSpace              ; (0930)
loc_88:
                mov     byte ptr [fArrangeFigure],1     ; (3708:0D48=0)
                add     dl,30h                  ; '0'
ShowDigit       endp



;
;                          PutChar
;

PutChar         proc    near
                push    ax
                mov     ah,2
                int     21h                     ; DOS Services  ah=function 02h
                                                ;  display char dl
                pop     ax

loc_ret_89:
                retn
PutChar         endp


;
;                          StrPrint
;

StrPrint        proc    near
                push    si
                push    cs
                pop     ds
                xchg    si,dx
loc_90:
                mov     dl,[si]
                nop
                nop
                nop
                cmp     dl,'$'
                je      loc_91
                call    PutChar
                inc     si
                jmp     short loc_90
loc_91:
                pop     si
                retn
StrPrint        endp

                db      0
wSectQty        dw      0
wHeadQty        dw      0
fVerbosely      db      0
cFirstLetter    db      30h
                db      0, 0
wFirstCylOfPartition    dw      0
bFirstHdOfPartition     db      0
bFirstSecOfPartition    db      0
rSectBuf        dw      0
                db      444 dup (0)
rPrtnInfo1      db      0
                db      15 dup (0)
rPrtnInfo2      db      0
                db      15 dup (0)
rPrtnInfo3      db      0
                db      15 dup (0)
rPrtnInfo4      db      0
                db      15 dup (0)
wLastWord1      dw      0
fArrangeFigure  db      0
rHDDInfo        db      0
wGenCnfHDD      db      0                       ; ᫮ 䨣樨
wLogCylQty      dw      0                       ; - ᪨ 樫஢
                db      0, 0
wLogHeadQty     dw      0
                db      0, 0, 0
rBPB            db      0
wLogSecQty      dw      0
                db      24 dup (0)
bExtBootSig     db      0
                db      15 dup (0)
sModelNo        db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      0
                db      392 dup (0)
wLastWord2      dw      0
                db      0, 0, 0, 0, 0, 0
                db      0

_TEXT           ends


                end start
