unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs, ShellApi,
  StdCtrls, ExtCtrls, Menus, AMixer, CoolTray, INIfiles, ComDrv32, MMsystem,
  ComCtrls;

type
  TFormTermo = class(TForm)
    Panel1: TPanel;
    Temperature: TLabel;
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    Exit1: TMenuItem;
    Hideheader1: TMenuItem;
    JoyPort: TLabel;
    Mixer: TAudioMixer;
    CDADmixsync1: TMenuItem;
    CoolTrayIcon1: TCoolTrayIcon;
    Minimizetotray1: TMenuItem;
    N2: TMenuItem;
    NCrit_T: TMenuItem;
    N451: TMenuItem;
    N501: TMenuItem;
    N551: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    Alertbeep1: TMenuItem;
    N701: TMenuItem;
    CommPortDriver1: TCommPortDriver;
    IRControl1: TMenuItem;
    N5: TMenuItem;
    Ir_data: TLabel;
    tst200: TLabel;
    N1: TMenuItem;
    View1: TMenuItem;
    Debuginfo1: TMenuItem;
    TimerFEscan: TTimer;
    VolumeBar: TTrackBar;
    Image1: TImage;
    batarey: TImage;
    vilka: TImage;
    ShutdownPoweroff1: TMenuItem;
    iPhone: TImage;
    procedure ScanSensor(Sender: TObject);
    procedure ExitPrg(Sender: TObject);
    procedure ToggleTitleBar(Sender: TObject);
    procedure MixerControlChange(Sender: TObject; MixerH, ID: Integer);
    procedure cddamix(Sender: TObject);
    procedure tray_proc(Sender: TObject);
    procedure sel_cr_temp45(Sender: TObject);
    procedure sel_cr_temp50(Sender: TObject);
    procedure sel_cr_temp55(Sender: TObject);
    procedure GetIniParameters(Sender: TObject);
    procedure FirstTimeShowHidden(Sender: TObject);
    procedure ToggleAlertBeep(Sender: TObject);
    procedure sel_cr_temp70(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CommPortDriver1ReceiveData(Sender: TObject; DataPtr: Pointer;
      DataSize: Integer);
    procedure xDbgInfo(Sender: TObject);
    procedure F2_FEscan(Sender: TObject);
    procedure Image1Click(Sender: TObject);

    procedure MixerInit(Sender: TObject);
    procedure VolumeBarChange(Sender: TObject);
    procedure ShutdownPoweroff1Click(Sender: TObject);
    procedure iPhoneClick(Sender: TObject);

  private
    { Private declarations }
    procedure WMNCHitTest(var M: TWMNCHitTest); message wm_NCHitTest;
    procedure OnWinExit(Var Msg:TWMQueryEndSession); message WM_QueryEndSession;
    procedure wmF2golded(Var M: TMessage); message WM_HOTKEY;

  public
    { Public declarations }


  end;

var
  FormTermo: TFormTermo;

  JP_Average    : word;
  Sample_Cntr   : word;
  Critical_T    : word;
  {/////////////////////////////}
  Tm_X, Tm_Y    : Integer;
  isMixSync     : Integer;
  isHideTBar    : Integer;
  isMin2Tray    : Integer;
  isMin2Tray1   : Integer;
  inif          : TINIfile;
  exe_path      : ShortString;
  exe_name      : ShortString;

  AltTab_Flg    : Boolean;

  FEtimer       : word;
  _F2flag       : Word;


implementation

uses watchdog;


{$R *.DFM}



const
  ExtendedKeys: set of Byte = [  // incomplete list
    VK_INSERT, VK_DELETE, VK_HOME,   VK_END,    VK_PRIOR,   VK_NEXT,
    VK_LEFT,   VK_UP,     VK_RIGHT,  VK_DOWN,   VK_NUMLOCK, VK_MENU,
    VK_NEXT,   VK_TAB,    VK_SPACE,  VK_F2
  ];


procedure SimulateKeyDown(Key : byte);
var
  flags: DWORD;
begin
  if Key in ExtendedKeys then flags := KEYEVENTF_EXTENDEDKEY else flags := 0;
  keybd_event(Key, MapVirtualKey(Key, 0), flags, 0);
end;

procedure SimulateKeyUp(Key : byte);
var
  flags: DWORD;
begin
  if Key in ExtendedKeys then flags := KEYEVENTF_EXTENDEDKEY else flags := 0;
  keybd_event(Key, MapVirtualKey(Key, 0), KEYEVENTF_KEYUP or flags, 0);
end;

procedure SimulateKeystroke(Key : byte);
var
  flags: DWORD;
  scancode: BYTE;
begin
  if Key in ExtendedKeys then flags := KEYEVENTF_EXTENDEDKEY else flags := 0;
  scancode := MapVirtualKey(Key, 0);
  keybd_event(Key,
              scancode,
              flags,
              0);
  keybd_event(Key,
              scancode,
              KEYEVENTF_KEYUP or flags,
              0);
end;





procedure WriteINI(sect,vari: string; valu: integer);
begin
  {}
  inif:=TINIfile.Create(exe_path+'T_MONITOR.INI');
  inif.WriteInteger(sect,vari,valu);
  inif.free;
end;

procedure TFormTermo.MixerInit(Sender: TObject);
var L,R,M:Integer;
    VD,MD:Boolean;
begin
  If Mixer.MixerCount>0 then begin
                   { 0,-1 -   }
    Mixer.GetVolume (0,-1,L,R,M,VD,MD);
    {Setting:=True;}
    VolumeBar.Enabled:=L<>-1;
    If VolumeBar.Enabled then VolumeBar.Position:=65535-L;
    {Setting:=False;}
  end
  Else VolumeBar.OnChange:=nil;
end;


{================================}
{     }
{================================}
procedure TFormTermo.GetIniParameters(Sender: TObject);
var s: string;
    i: integer;

    L,R,M:Integer;
    VD,MD:Boolean;
    _year: string;

begin
  AltTab_Flg:=False;

  CommPortDriver1.ToggleDTR(True);
  CommPortDriver1.ToggleRTS(True);

  CommPortDriver1.Connect;

  CommPortDriver1.ToggleDTR(True);
  CommPortDriver1.ToggleRTS(True);

  sleep(50);
  s:='I';
  CommPortDriver1.SendData(pchar(s),1);
  sleep(50);
  s:='R';
  CommPortDriver1.SendData(pchar(s),1);

  {~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

  exe_path:=ExtractFilePath(Application.ExeName);
  exe_name:=ExtractFileName(Application.ExeName);

  inif:=TINIfile.Create(exe_path+'T_MONITOR.INI');
  {}

  With inif Do Begin

      {    }
      _year:=DateToStr(Date);
      Delete(_year,1,length(_year)-4);
      if ReadInteger('main','year',2000)<>StrToInt(_year) Then
        Temperature.Font.Color:=clGreen;
      {   }
      WriteString('main','time1',
         ReadString('main','time','----  ----'));

      WriteString('main','time',DateToStr(Date)+'  '+TimeToStr(Time));



      {  X  }
      Tm_X:=ReadInteger('main','x',620);
      FormTermo.Left:=Tm_X;

      {  Y }
      Tm_Y:=ReadInteger('main','y',440);
      FormTermo.Top:=Tm_Y;

      {      CD-Rom   }
      isMixSync:=ReadInteger('main','cddamix',0);
      If isMixSync=1 Then cdadmixsync1.checked:=True Else
                          cdadmixsync1.checked:=False;

      {   }
      Critical_T:=ReadInteger('main','crtemp',70);
      Case Critical_T of
         45: N451.Checked:=True;
         50: N501.Checked:=True;
         55: N551.Checked:=True;
         70: N701.Checked:=True;
      End;


      {   }
      isHideTBar:=ReadInteger('main','hideheader',1);
      If isHideTBar=1 Then begin
        SetWindowLong(FormTermo.Handle, GWL_STYLE,
        GetWindowLong(FormTermo.Handle, GWL_STYLE) and not WS_CAPTION);
        FormTermo.Height := FormTermo.ClientHeight+6;
        Hideheader1.Checked:=True;
      End;


      {      }
      isMin2Tray:=ReadInteger('main','min2tray',0);

      isMin2Tray1:=isMin2Tray;

      If isMin2Tray=1 Then Begin
        Hideheader1.Enabled:=False;

        Minimizetotray1.Caption:='Restore from tray';

        ShowWindow(Application.MainForm.Handle, SW_Hide);
        Application.MainForm.Hide;
      End;

  End;

  inif.Free;


  RegisterHotKey(FormTermo.Handle,$F2DED,0,VK_F2);
  FEtimer:=0;
  _F2flag:=0;


  {
  Mixer.GetVolume (0,8,L,R,M,VD,MD);
  ScrollBar1.Position:=100-L;
  Tst200.Caption:=IntToStr(l);
  }
   VolumeBar.Visible:=False;
   panel1.left:=panel1.left-32;
   FormTermo.Width:=FormTermo.Width-32;
   FormTermo.left:=FormTermo.left+32;

   MixerInit(nil);

   {   
   ShowWindow(FormPWD.Handle,SW_SHOWNORMAL);
    }

end;


procedure TFormTermo.FirstTimeShowHidden(Sender: TObject);
begin
{}
  If isMin2Tray1=1 then begin
    FormTermo.Visible:=False;
    isMin2Tray1:=0;
  end;

end;




{    1    }
PROCEDURE TFormTermo.ScanSensor(Sender: TObject);
VAR xa: word;
    current_t: word;
    {  }
    myjoy: tjoyinfo;

BEGIN
  {   }
  joygetpos(joystickid1,@myjoy);
  xa := round(myjoy.wxpos/31.5);


  JP_Average:=JP_Average+xa;
  Inc(Sample_Cntr);

  If Sample_Cntr=5 Then begin
    JP_Average:=Round(JP_Average/5);

    { 650 ... 970 } { 0 ... 36.6 }
    If (JP_Average>=650) AND (JP_Average<=970) Then begin
      current_t:=Round((970-JP_Average)*0.114375);
    end;

    { 270 ... 650 } { 36.6 ... 100 }
    If (JP_Average>=0) AND (JP_Average<650) Then begin
      current_t:=36+Round((650-JP_Average)*0.166842);
    end;


    If current_t>=Critical_T Then begin
      Temperature.Font.Color:=clRed;
      If Minimizetotray1.Caption='Restore from tray' Then begin
        Hideheader1.Enabled:=True;
        ShowWindow(FormTermo.Handle,sw_Restore);
        Minimizetotray1.Caption:='Minimize to tray';
        FormTermo.Visible:=True;
      end;
      if AlertBeep1.Checked=True then beep;
    end Else Temperature.Font.Color:=clBlack;

    Temperature.Caption:=IntToStr(current_t)+Chr(176)+'C';
    CoolTrayIcon1.Hint:=IntToStr(current_t)+Chr(176)+'C';
    JP_Average:=0;
    Sample_Cntr:=0;
  end;

  JoyPort.Caption:=IntToStr(xa)+' ';
END;



procedure TFormTermo.ExitPrg(Sender: TObject);
begin
  Halt(0);
end;

procedure TFormTermo.ToggleTitleBar(Sender: TObject);
begin

  If Not HideHeader1.Checked Then begin
    SetWindowLong(FormTermo.Handle, GWL_STYLE,
    GetWindowLong(FormTermo.Handle, GWL_STYLE) and not WS_CAPTION);
    FormTermo.Height := FormTermo.ClientHeight+6;
    WriteINI('main','hideheader',1);
  end Else begin
    SetWindowLong(FormTermo.Handle, GWL_STYLE,
    GetWindowLong(FormTermo.Handle, GWL_STYLE) or WS_CAPTION);
    FormTermo.Height := FormTermo.ClientHeight+25;
    WriteINI('main','hideheader',0);
  end;

  Hideheader1.Checked:=Not Hideheader1.Checked;

end;


procedure TFormTermo.WMNCHitTest(var M: TWMNCHitTest);
begin
  inherited;                    {   p      }
  if  M.Result = htClient then  {    ?                    }
    M.Result := htCaption;       {   -   Windows ,  }
  {else M.Result :=htNowhere;    {   caption bar                    }
end;


procedure TFormTermo.MixerControlChange(Sender: TObject; MixerH, ID: Integer);
var L,R,M:Integer;
    VD,MD:Boolean;
begin
  (*
  if cdadmixsync1.checked=true then begin
    Mixer.GetVolume (0,0,L,R,M,VD,MD);
                       {0=CD Audio}
    {Setting:=True;}
    Mixer.SetVolume (0,8,L,-1,1);
                       {8=CD Digital}
    {Setting:=False;}
  end;
  *)
    Mixer.GetVolume (0,-1,L,R,M,VD,MD);
    VolumeBar.Position:=65535-L;

end;

procedure TFormTermo.cddamix(Sender: TObject);
begin
{}
  cdadmixsync1.checked:=not cdadmixsync1.checked;
end;

procedure TFormTermo.tray_proc(Sender: TObject);
begin
{}
  If Minimizetotray1.Caption='Minimize to tray' Then begin

    Hideheader1.Enabled:=False;
    {
    ShowWindow(FormTermo.Handle,sw_Minimize);
    FormTermo.Visible:=False;
    }

    Minimizetotray1.Caption:='Restore from tray';

    ShowWindow(Application.MainForm.Handle, SW_Hide);
    Application.MainForm.Hide;

  end Else begin

    Hideheader1.Enabled:=True;
    {
    ShowWindow(FormTermo.Handle,sw_Restore);
    FormTermo.Visible:=True;
    }

    Minimizetotray1.Caption:='Minimize to tray';

    ShowWindow(Application.MainForm.Handle, SW_Show);
    Application.MainForm.Show;

  end;


end;



procedure TFormTermo.OnWinExit(Var Msg:TWMQueryEndSession);
begin
  inherited;
  ExitWindowsEx(EWX_Reboot Or EWX_Force,0);
  Msg.Result := 1;

  Halt(0);
end;






Procedure Uncheck_CT;
begin
   Case Critical_T of
     45: FormTermo.N451.Checked:=False;
     50: FormTermo.N501.Checked:=False;
     55: FormTermo.N551.Checked:=False;
     70: FormTermo.N701.Checked:=False;
   End;
end;

procedure TFormTermo.sel_cr_temp45(Sender: TObject);
begin
   Uncheck_CT;
   Critical_T:=45;
   N451.Checked:=True;
   WriteINI('main','crtemp',45);
end;

procedure TFormTermo.sel_cr_temp50(Sender: TObject);
begin
   Uncheck_CT;
   Critical_T:=50;
   N501.Checked:=True;
   WriteINI('main','crtemp',50);
end;

procedure TFormTermo.sel_cr_temp55(Sender: TObject);
begin
   Uncheck_CT;
   Critical_T:=55;
   N551.Checked:=True;
   WriteINI('main','crtemp',55);
end;

procedure TFormTermo.sel_cr_temp70(Sender: TObject);
begin
   Uncheck_CT;
   Critical_T:=70;
   N701.Checked:=True;
   WriteINI('main','crtemp',70);
end;

procedure TFormTermo.ToggleAlertBeep(Sender: TObject);
begin
  AlertBeep1.Checked:=Not AlertBeep1.Checked;

end;


procedure TFormTermo.FormClose(Sender: TObject; var Action: TCloseAction);
begin


  CommPortDriver1.ToggleDTR(False);
  CommPortDriver1.ToggleRTS(False);

  CommPortDriver1.DisConnect;

  CommPortDriver1.ToggleDTR(False);
  CommPortDriver1.ToggleRTS(False);


  {  2 }
  UnregisterHotKey(FormTermo.Handle,$F2DED);

end;


function ExecuteFile(const FileName, Params, DefaultDir: string;
           ShowCmd: Integer): THandle;
var
   zFileName, zParams, zDir: array[0..79] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;


procedure TFormTermo.CommPortDriver1ReceiveData(Sender: TObject;
  DataPtr: Pointer; DataSize: Integer);

  var i: array[0..10] of byte;
      ir_code_lo: word;
      ir_code_hi: word;
      _handle: thandle;
      _handle_DeluxeCD: thandle;
      _handle_DCD_button: thandle;
      SearchRec: TSearchRec;
      fni: word;
      wa_chdir: string;


begin

 move(DataPtr^,i,DataSize);

 ir_code_lo:=i[2]+$FF*i[3];

 ir_code_hi:=i[0]+$FF*i[1];

 Ir_data.caption:=IntToHex(ir_code_lo,4)+' '+IntToHex(ir_code_hi,4);

 _handle:=FindWindow('WinAmp v1.x',nil);
 _handle_DeluxeCD:=FindWindow('MMFRAME_MAIN',nil);

 CASE ir_code_lo OF

   44705:  begin   { Winamp Play }
             SendMessage(_handle,WM_Command,40045,0);

             {DeluxeCD}
             If _handle_DeluxeCD<>0 Then begin
               _handle_DCD_button:=
                   FindWindowEx(_handle_DeluxeCD,0,'Button','');
               PostMessage(_handle_DCD_button,WM_LBUTTONDOWN,MK_LBUTTON,10+5*$FFFF);
               PostMessage(_handle_DCD_button,WM_LBUTTONUP,MK_LBUTTON,10+5*$FFFF);
             end;


           end;

   12193:  begin   { Winamp Pause }
             {WinAmp}
             SendMessage(_handle,WM_Command,40046,0);
             {DeluxeCD}
             If _handle_DeluxeCD<>0 Then begin
               _handle_DCD_button:=
                   FindWindowEx(_handle_DeluxeCD,0,'Button','');
               if _handle_DCD_button=0 Then _handle_DCD_button:=
                   FindWindowEx(_handle_DeluxeCD,0,'Button','');

               PostMessage(_handle_DCD_button,WM_LBUTTONDOWN,MK_LBUTTON,10+5*$FFFF);
               PostMessage(_handle_DCD_button,WM_LBUTTONUP,MK_LBUTTON,10+5*$FFFF);
             end;
           end;

    4065:  begin   { Winamp Stop }
             SendMessage(_handle,WM_Command,40047,0);

             {DeluxeCD}
             If _handle_DeluxeCD<>0 Then begin
               _handle_DCD_button:=
                   FindWindowEx(_handle_DeluxeCD,0,'Button','');
               PostMessage(_handle_DCD_button,WM_LBUTTONDOWN,MK_LBUTTON,10+5*$FFFF);
               PostMessage(_handle_DCD_button,WM_LBUTTONUP,MK_LBUTTON,10+5*$FFFF);
             end;
           end;

   15749:  begin   { Winamp Next }
             SendMessage(_handle,WM_Command,40048,0);
             {DeluxeCD}
             If _handle_DeluxeCD<>0 Then begin
               _handle_DCD_button:=
                   FindWindowEx(_handle_DeluxeCD,0,'Button',' ');
               PostMessage(_handle_DCD_button,WM_LBUTTONDOWN,MK_LBUTTON,10+5*$FFFF);
               PostMessage(_handle_DCD_button,WM_LBUTTONUP,MK_LBUTTON,10+5*$FFFF);
             end;


           end;

   56389:  begin   { Winamp Previous }
             SendMessage(_handle,WM_Command,40044,0);
             {DeluxeCD}
             If _handle_DeluxeCD<>0 Then begin
               _handle_DCD_button:=
                   FindWindowEx(_handle_DeluxeCD,0,'Button',' ');
               PostMessage(_handle_DCD_button,WM_LBUTTONDOWN,MK_LBUTTON,10+5*$FFFF);
               PostMessage(_handle_DCD_button,WM_LBUTTONUP,MK_LBUTTON,10+5*$FFFF);
             end;

           end;

   52833:  begin   { Winamp Volume Up }
             SendMessage(_handle,WM_Command,40058,0);
           end;

   20321:  begin   { Winamp Volume Down }
             SendMessage(_handle,WM_Command,40059,0);
           end;

   38609:  begin   { Winamp Fast Forward 5s }
             SendMessage(_handle,WM_Command,40060,0);
           end;
   36577:  begin   { Winamp Rewinds 5s }
             SendMessage(_handle,WM_Command,40061,0);
           end;

   {======================================================}
   65025:  begin   { Winamp Playlist Pos #1 }
             SendMessage(_handle,WM_USER,0,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   32513:  begin   { Winamp Playlist Pos #2 }
             SendMessage(_handle,WM_USER,1,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   48769:  begin   { Winamp Playlist Pos #3 }
             SendMessage(_handle,WM_USER,2,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   16257:  begin   { Winamp Playlist Pos #4 }
             SendMessage(_handle,WM_USER,3,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   56897:  begin   { Winamp Playlist Pos #5 }
             SendMessage(_handle,WM_USER,4,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   24385:  begin   { Winamp Playlist Pos #6 }
             SendMessage(_handle,WM_USER,5,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   40641:  begin   { Winamp Playlist Pos #7 }
             SendMessage(_handle,WM_USER,6,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

    8129:  begin   { Winamp Playlist Pos #8 }
             SendMessage(_handle,WM_USER,7,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   60961:  begin   { Winamp Playlist Pos #9 }
             SendMessage(_handle,WM_USER,8,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;

   28449:  begin   { Winamp Playlist Pos #10 }
             SendMessage(_handle,WM_USER,9,121);
             SendMessage(_handle,WM_Command,40047,0);
             SendMessage(_handle,WM_Command,40045,0);
           end;
   {======================================================}

   10161:  begin   { Simulate Space Button }

             SimulateKeyDown(32);
             SimulateKeyUp(32);


           end;

   62993:  begin   { Simulate Alt-Tab switch }

             If AltTab_Flg=False Then begin
               SimulateKeyDown(18);
               SimulateKeyDown(VK_TAB);
               SimulateKeyUp(VK_TAB);
               AltTab_Flg:=True;
             end
             Else begin
               SimulateKeyDown(VK_TAB);
               SimulateKeyUp(VK_TAB);
             end;

           end;

   30481:  begin   { Simulate Alt-Tab select }

             If AltTab_Flg=True Then begin
               SimulateKeyUp(18);
               AltTab_Flg:=False;
             end;

           end;

   46737:  begin   { Start WinAmp & load playlist for CD }

             ExecuteFile('winamp.exe','',
                         'c:\program files\winamp\',SW_SHOW);

                {
                Application.ProcessMessages;
                }
               {
               Sleep(2500);
               }

              (*
              Repeat
                _handle:=FindWindow('WinAmp v1.x',nil);
              Until SendMessage(_handle,WM_User,0,0)=8736;



             {   }
             SendMessage(_handle,WM_User,0,101);

             {      }
             wa_chdir:='g:\';
             For fni:=1 to Length(wa_chdir) do begin
               SendMessage(_handle,WM_User,Ord(wa_chdir[fni]),103);
             end;
             SendMessage(_handle,WM_User,0,103);

             {    }
             FindFirst('g:\*.*', faAnyFile, SearchRec);

             For fni:=1 to Length(SearchRec.Name) do begin
               SendMessage(_handle,WM_User,Ord(SearchRec.Name[fni]),100);
             end;
             SendMessage(_handle,WM_User,0,100);

             While FindNext(SearchRec)=0 do begin;
               SearchRec.Name:='G:\'+SearchRec.Name;
               For fni:=1 to Length(SearchRec.Name) do begin
                 SendMessage(_handle,WM_User,Ord(SearchRec.Name[fni]),100);
               end;
               SendMessage(_handle,WM_User,0,100);
             end;
             *)
           end;

   14225:  begin   { Switch to desktop }

               SimulateKeyDown(18);
               SimulateKeyDown(VK_SPACE);
               SimulateKeyUp(VK_SPACE);
               SimulateKeyUp(18);
               SimulateKeyDown(27);
               SimulateKeyUp(27);


           end;


   62485:  begin   { PgUp }

               SimulateKeyDown(33);
               SimulateKeyUp(33);

           end;


   42673:  begin   { PgDn }

               SimulateKeyDown(34);
               SimulateKeyUp(34);

           end;


   34545:  begin   { * }

               SimulateKeyDown(106);
               SimulateKeyUp(106);

           end;

    6097:  begin   { View Time }

             Temperature.Caption:=
               Copy(TimeToStr(Time),1,5);

           end;

   58929:  begin   { Toggle cd a/d  mix sync }

             cdadmixsync1.checked:=not cdadmixsync1.checked;
             formtermo.update;

           end;

   $D651:  begin   { Add CD to playlist }

             SendMessage(_handle,WM_User,0,101);


             {      }
             wa_chdir:='g:\';
             For fni:=1 to Length(wa_chdir) do begin
               SendMessage(_handle,WM_User,Ord(wa_chdir[fni]),103);
             end;
             SendMessage(_handle,WM_User,0,103);


             FindFirst('g:\*.*', faAnyFile, SearchRec);
             For fni:=1 to Length(SearchRec.Name) do begin
               SendMessage(_handle,WM_User,Ord(SearchRec.Name[fni]),100);
             end;
             SendMessage(_handle,WM_User,0,100);

             While FindNext(SearchRec)=0 do begin;
               For fni:=1 to Length(SearchRec.Name) do begin
                 SendMessage(_handle,WM_User,Ord(SearchRec.Name[fni]),100);
               end;
               SendMessage(_handle,WM_User,0,100);
             end;
           end;



 END;



end;


procedure TFormTermo.xDbgInfo(Sender: TObject);
begin
  tst200.Visible:=NOT tst200.Visible;
  joyport.Visible:=NOT joyport.Visible;
  ir_data.Visible:=NOT ir_data.Visible;
  DebugInfo1.Checked:=NOT DebugInfo1.Checked;
end;


procedure TFormTermo.wmF2golded(Var M: TMessage);
begin
    if FEtimer=0 then TimerFEscan.Enabled:=True;
    if _F2flag=0 then _F2flag:=1;

end;

procedure TFormTermo.F2_FEscan(Sender: TObject);
var goldhead: string;
    goldh:array[0..12] of char;
begin
  Inc(FEtimer);

  If _F2flag=2 Then begin
    UnregisterHotKey(FormTermo.Handle,$F2DED);
      SimulateKeyDown(VK_F2);
      SimulateKeyUp(VK_F2);
    RegisterHotKey(FormTermo.Handle,$F2DED,0,VK_F2);
    _F2flag:=0;
   end;

  If _F2flag=1 Then _F2flag:=2;

  If FEtimer=100 Then begin

    GetWindowText(GetForegroundWindow,@goldh,12);
    goldhead:=StrPas(goldh);

    {FormTermo.Caption:=goldhead;}

    If goldhead='GoldED+/W32' Then
      ExecuteFile('fastecho.exe','scan',
                  'd:\fido\fastecho\',SW_hide);

    TimerFEscan.Enabled:=False;
    FEtimer:=0;
  end;

end;

procedure TFormTermo.Image1Click(Sender: TObject);
begin
{}
 VolumeBar.Visible:=Not VolumeBar.Visible;
 If VolumeBar.Visible Then begin
   FormTermo.left:=FormTermo.left-32;
   FormTermo.Width:=FormTermo.Width+32;
   panel1.left:=panel1.left+32;
 end
 Else begin
   panel1.left:=panel1.left-32;
   FormTermo.Width:=FormTermo.Width-32;
   FormTermo.left:=FormTermo.left+32;
 end;



end;

procedure TFormTermo.VolumeBarChange(Sender: TObject);
begin
  Mixer.SetVolume (0,-1,65535-VolumeBar.Position,-1,1);

  {tst200.caption:=inttostr(VolumeBar.Position);}
end;

function SetPrivilege(privilegeName: string; enable: boolean): boolean;
var
  tpPrev,
  tp         : TTokenPrivileges;
  token      : THandle;
  dwRetLen   : DWord;
begin
  result := False;

  OpenProcessToken(GetCurrentProcess, TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY, @token);

  tp.PrivilegeCount := 1;
  if LookupPrivilegeValue(nil, pchar(privilegeName), tp.Privileges[0].LUID) then
  begin
    if enable then
      tp.Privileges[0].Attributes := SE_PRIVILEGE_ENABLED
    else
      tp.Privileges[0].Attributes := 0;

    dwRetLen := 0;
    result := AdjustTokenPrivileges(token, False, tp, SizeOf(tpPrev), tpPrev, dwRetLen);
  end;
  CloseHandle(token);
end;

procedure TFormTermo.ShutdownPoweroff1Click(Sender: TObject);
begin
  SetPrivilege('SeShutdownPrivilege', true);
  ExitWindowsEx(EWX_REBOOT, 0);
  Halt(0);
end;


function ReadINI(sect,vari: string): string;
begin
  {}
  inif:=TINIfile.Create(exe_path+'T_MONITOR.INI');
  ReadINI:=inif.ReadString(sect,vari,'---');

  inif.free;
end;


procedure TFormTermo.iPhoneClick(Sender: TObject);
var tmail_log: textfile;
    cids: string;
begin
{}
    FormPWD.Timer1.Enabled:=False;

    FormPWD.Show;
    FormPWD.lbProcessList.Clear;

    {        }

    FormPWD.btnKillP.Visible:=False;
    FormPWD.btnAuthorP.Visible:=False;
    FormPWD.Label1.Caption:='Found cID record(s) in T-MAIL.LOG';
    FormPWD.Label2.Visible:=False;
    FormPWD.Bevel1.Visible:=False;
    FormPWD.lblTotalP.Visible:=False;
    FormPWD.lbProcessList.Width:=280;


    FormPWD.Calendar1.Visible:=True;
    FormPWD.cobxMonthSel.Visible:=True;
    FormPWD.Height:=357;

    {}

    FormPWD.cobxMonthSel.Text:=
      FormPWD.cobxMonthSel.Items[StrToInt(Copy(DateToStr(Date),4,2))-1];

    If FormPWD.Calendar1.Day=StrToInt(Copy(DateToStr(Date),1,2)) Then begin
      AssignFile(tmail_log,'d:\fido\t-mail.26\t-mail.log');
      Reset(tmail_log);

      while not eof(tmail_log) do begin
        readln(tmail_log,cids);
        If pos('CallerID',cids)<>0 Then begin
          {        }
            If Copy(cids,1,2)+'.'+Copy(cids,4,2)=Copy(DateToStr(Date),1,5) Then begin
            Delete(cids,1,6);
            FormPWD.lbProcessList.Items.Add(cids+'     '+
             ReadINI('phonebook',Copy(cids,Length(cids)-7,6)));

          end;
        end;
      end;

      CloseFile(tmail_log);
    End
    Else FormPWD.Calendar1.Day:=StrToInt(Copy(DateToStr(Date),1,2));
    FormPWD.Caption:='Today Calls  ('+DateToStr(Date)+')';
    
end;



begin
  JP_Average:=0;
  Sample_Cntr:=0;
  ShowWindow(Application.Handle,SW_HIDE);


end.
