unit watchdog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, TLhelp32, IniFiles, Grids, Calendar;

type
  TFormPWD = class(TForm)
    lbProcessList: TListBox;
    Label1: TLabel;
    btnKillP: TButton;
    btnAuthorP: TButton;
    Label2: TLabel;
    Bevel1: TBevel;
    lblTotalP: TLabel;
    Timer1: TTimer;
    Calendar1: TCalendar;
    cobxMonthSel: TComboBox;
    procedure Timer1Timer(Sender: TObject);
    procedure btnKillPClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnAuthorPClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure cobxMonthSelChange(Sender: TObject);
    procedure Calendar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
   PROCESS_TERMINATE=$0001;

var
  FormPWD: TFormPWD;

  proc_list    : array[0..200] of string[100];
  proc_ids     : array[0..200] of longint;
  proc_hash    : array[0..200] of longint;
  proc_ptr     : word;
  authorized   : array[0..200] of longint;

  IniF         : TInifile;
  exe_path     : string;
  exe_name     : string;


implementation

{$R *.DFM}

procedure TFormPWD.Timer1Timer(Sender: TObject);
var
  hSnapshot: Integer;
  pe32     : TProcessEntry32;
  {=hash var=}
  i,l      : word;
  _hash    : longint;
  s        : string;
  auth_flg : boolean;

begin

  {    }
  proc_ptr:=0;

  lbProcessList.Clear;
  lblTotalP.Caption:='0';

  hSnapshot:=CreateToolHelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  If hSnapshot=-1 then Exit;
   pe32.dwSize:=sizeof(TProcessEntry32);
  If Process32First(hSnapshot, pe32) then
   repeat
     s:=ExtractFileName(pe32.szExeFile);
     {     }
     l:=Length(s);
     _hash:=0;
     For i:=1 to l do _hash:=_hash+i*(ORD(s[i]));
     _hash:=_hash*l;
     {      }
     auth_flg:=false;
     If authorized[0]<>0 Then begin
       for i:=1 to authorized[0] do
         if _hash=authorized[i] then auth_flg:=true;

     end;
     {    ,    }
     If auth_flg=false then begin
       inc(proc_ptr);
       proc_list[proc_ptr]:=s;
       proc_ids[proc_ptr]:=pe32.th32ProcessID;
       proc_hash[proc_ptr]:=_hash;
     end;

   until not Process32Next(hSnapshot, pe32);
  CloseHandle(hSnapShot);

  If proc_ptr<>0 Then begin
    beep;
    Timer1.Enabled:=False;

  {       }
    FormPWD.Caption:='Process watchdog';
    FormPWD.btnKillP.Visible:=True;
    FormPWD.btnAuthorP.Visible:=True;
    FormPWD.Label1.Caption:='Found nonauthorized process(es)';
    FormPWD.Label2.Visible:=True;
    FormPWD.Bevel1.Visible:=True;
    FormPWD.lblTotalP.Visible:=True;
    FormPWD.lbProcessList.Width:=161;

    FormPWD.Calendar1.Visible:=False;
    FormPWD.cobxMonthSel.Visible:=False;
    FormPWD.Height:=200;



   {}

    FormPWD.Show;
    lbProcessList.Clear;
    for i:=1 to proc_ptr do lbProcessList.Items.Add(proc_list[i]);
    lblTotalP.Caption:=IntToStr(proc_ptr);
    lbProcessList.Items.Add('    ');
  end;
end;

{   INI  }
procedure WriteINI(sect,vari: string; valu_i: integer; valu_s:string);
begin
  {}
  inif:=TINIfile.Create(exe_path+'watchdog.INI');

  if valu_s='' then inif.WriteInteger(sect,vari,valu_i);
  if valu_s<>'' then inif.WriteString(sect,vari,valu_s);

  inif.free;
end;



procedure TFormPWD.btnKillPClick(Sender: TObject);
var
   Ret : BOOL;
   ProcessID : integer;
   ProcessHndle : THandle;
   i: word;

begin
{}
for i:=1 to proc_ptr do
  if lbProcessList.Items[lbProcessList.ItemIndex]=proc_list[i] then
    ProcessID:=proc_ids[i];

 ProcessHndle:=OpenProcess(PROCESS_TERMINATE,BOOL(0),ProcessID);
 Ret:=TerminateProcess(ProcessHndle,0);
 if Integer(Ret)<>0 Then begin
   lbProcessList.Items.Delete(lbProcessList.ItemIndex);
   lblTotalP.Caption:=IntToStr(StrToInt(lblTotalP.Caption)-1);
 end;

  {     ,    }
  If lbProcessList.Items[0]='    ' Then begin
    Timer1.Enabled:=True;
    FormPWD.Hide;
  end;

end;




procedure TFormPWD.FormCreate(Sender: TObject);
var i: word;
begin
{}
  authorized[0]:=0;

  exe_path:=ExtractFilePath(Application.ExeName);
  exe_name:=ExtractFileName(Application.ExeName);

  IniF:=TINIfile.Create(exe_path+'watchdog.INI');
  With IniF Do begin
    authorized[0]:=ReadInteger('main','processes',0);

    If authorized[0]<>0 Then
      for i:=1 to authorized[0] do begin
        authorized[i]:=ReadInteger('main','_pr'+IntToStr(i),$FFFF)
      end;


  End;
  IniF.Free;



end;




procedure TFormPWD.btnAuthorPClick(Sender: TObject);
var __hash: longint;
    i: word;
begin
  {listbox}
  {edPassword.Text:=ProcessList.Items[ProcessList.ItemIndex];}
  __hash:=-1;
  for i:=1 to proc_ptr do
    if lbProcessList.Items[lbProcessList.ItemIndex]=proc_list[i] then
      __hash:=proc_hash[i];


  Inc(authorized[0]);
  {   .  }
  WriteINI('main','_pr'+IntToStr(authorized[0]),__hash,'');
  {    }
  WriteINI('log','_pr'+IntToStr(authorized[0]),0,
    IntToStr(__hash)+'  '+lbProcessList.Items[lbProcessList.ItemIndex]+
      '  '+DateToStr(Date)+'  '+TimeToStr(Time));


  lbProcessList.Items.Delete(lbProcessList.ItemIndex);
  {      }
  authorized[authorized[0]]:=__hash;


  WriteINI('main','processes',authorized[0],'');
  {     }
  lblTotalP.Caption:=IntToStr(StrToInt(lblTotalP.Caption)-1);
  {     ,    }
  If lbProcessList.Items[0]='    ' Then begin
    Timer1.Enabled:=True;
    FormPWD.Hide;
  end;

end;


procedure TFormPWD.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  Timer1.Enabled:=True;
end;

procedure TFormPWD.cobxMonthSelChange(Sender: TObject);
begin
  Calendar1.Month:=cobxMonthSel.ItemIndex+1;
end;


function ReadINI(sect,vari: string): string;
begin
  {}
  inif:=TINIfile.Create(exe_path+'T_MONITOR.INI');
  ReadINI:=inif.ReadString(sect,vari,'---');

  inif.free;
end;


procedure TFormPWD.Calendar1Change(Sender: TObject);
var strDate: string;
    tmail_log: textfile;
    cids: string;

begin
{}

FormPWD.lbProcessList.Clear;

strDate:=IntToStr(Calendar1.Day)+'.';
If Calendar1.Day<10 Then strDate:='0'+strDate;
If Calendar1.Month<10 Then strDate:=strDate+'0';
strDate:=strDate+IntToStr(Calendar1.Month)+'.'+IntToStr(Calendar1.Year);

FormPWD.Caption:='Calls on '+strDate;

    AssignFile(tmail_log,'d:\fido\t-mail.26\t-mail.log');
    Reset(tmail_log);

    while not eof(tmail_log) do begin
      readln(tmail_log,cids);
      If pos('CallerID',cids)<>0 Then begin
        {        }
        If Copy(cids,1,2)+'.'+Copy(cids,4,2)=Copy(strDate,1,5) Then begin
          Delete(cids,1,6);
          FormPWD.lbProcessList.Items.Add(cids+'     '+
           ReadINI('phonebook',Copy(cids,Length(cids)-7,6)));

        end;
      end;
    end;

    CloseFile(tmail_log);



end;

end.
