#include "io2313.h"
#include "logican.h"

unsigned char StateFlag;
unsigned char RxData;

void main(void);
#pragma vector=UART_RX_vect 
__interrupt void RX_command(void);

void Reset(void);
char PressButton(void);
unsigned char RecievD(unsigned char);
void Strobe(unsigned char);
void Trans(void);
void TransmitD(unsigned char);
void ResetSequencer(void);
void ResetMemoryController(void);

void main(void) 
{
unsigned char *data;
unsigned char pb;

SP=RAMEND;
Reset();
while(1)//
  {
  switch(StateFlag)
    {
    case(ResetSeq):
    ResetSequencer();
    StateFlag=0;
    break;
    case(ResetMC):
    ResetMemoryController();
    StateFlag=0;
    break;
    case(Wait):
    ResetMemoryController();
    data=(unsigned char*)RecievD(3);
    Strobe(*data);
    Strobe(*(data+1));
    while(!PressButton());
    Strobe(*(data+2));
    StateFlag=SeqWait;
    do
      pb=ReadBit(PIND,GLed);
    while((pb!=0)&(StateFlag!=StopWait));
    if(StateFlag!=StopWait)
      {
      TransmitD(Complete);
      StateFlag=Repeat;
      }
    break;
    case(ReadCmd):
    while(ReadBit(PIND,GLed));//  ,    .
    ResetMemoryController();
    Strobe(0x03);
    DDRB=initDDRBrd;
    do
      Trans();
    while(ReadBit(PIND,GLed));
    DDRB=initDDRBwr;
    StateFlag=0;
    break;
    case(StopWait):
    ResetSequencer();
    ResetMemoryController();
    TransmitD(HelloLogicAn);
    StateFlag=0;
    break;
    case(Repeat):
    pb=ReadBit(PIND,StartKey);
    if(pb==0)
      {
      ResetMemoryController();
      Strobe(*data);
      Strobe(*(data+1));
      while(!PressButton());
      Strobe(*(data+2));
      StateFlag=SeqWait;
      do
        pb=ReadBit(PIND,GLed);
      while((pb!=0)&(StateFlag!=StopWait));
      if(StateFlag!=StopWait)
          TransmitD(Complete);
      StateFlag=Repeat;
      }
    break;
    default:
    break;
    }
  }
}

void Reset(void)
{
//
PORTD=initPORTD;
DDRD=initDDRD;
PORTB=initPORTB;
DDRB=initDDRBwr;

//
SREG=0x80;// .   =GIMSK  ..     .

//UART
UCR=0x98;//   ;
UBRR=12;// 38400

//
StateFlag=UDR;// 
StateFlag=StopWait;
}

__interrupt void RX_command(void)//       UART
{
unsigned char TempData;

TempData=UDR;
if((StateFlag==0)||(StateFlag==Repeat))
  {
  StateFlag=TempData;
    if(StateFlag==HelloLogicAn)
      {
      TransmitD(~HelloLogicAn);
      StateFlag=0;
      }
  }
else
  {
  if((StateFlag==SeqWait)&&(TempData==StopWait))
    StateFlag=StopWait;
  else
    {
    if(TempData==ReadCmd)
      StateFlag=ReadCmd;
    else
      {
      RxData=TempData;
      StateFlag=Reciev;
      }
    }
  }
//TransmitD(TempData);
}

char PressButton(void)//    ,    .    .
{
unsigned char count=0,pb;
do  //   ( )
  {
  count++;
  pb=ReadBit(PIND,StartKey);
  if(ReadBit(PIND,StartKey))
    count=1;
  }while ((pb||(count!=0))&&(StateFlag!=0));

do  //  
  {
  count++;
  pb=ReadBit(PIND,StartKey);
  if(pb==0)
    count=1;
  }while (((pb==0)||(count!=0))&&(StateFlag!=0));
return(1);
}

unsigned char RecievD(unsigned char Num)//     .
{
unsigned char i;
unsigned char *data;

for(i=0;i<Num;i++)
  {
  while(StateFlag!=Reciev);
    *(data+i)=RxData;
    StateFlag=Empty;
  }
return((unsigned char)data);
}

void Strobe (unsigned char Indata)
{
PORTB=Indata;
SetBit(PORTD,StrobeP);
ClrBit(PORTD,StrobeP);
}

void Trans(void)
{
unsigned char CTxData;
char i;

SetBit(PORTD,StrobeP);
ClrBit(PORTD,StrobeP);
for(i=0;i<4;i++);//
CTxData=PINB;
TransmitD(CTxData);
}

void TransmitD(unsigned char TxData)
{
unsigned char pb;

do
  pb=ReadBit(USR,UDRE);
while(pb==0);//,     .
UDR=TxData;
}

void ResetSequencer(void)
{
ClrBit(PORTD,SResP);
SetBit(PORTD,SResP);
}

void ResetMemoryController(void)
{
ClrBit(PORTD,MResP);
SetBit(PORTD,MResP);
}
