//  ""

module logic_a(clk,reset,data_in,data_out,uc,we,led,strobe,over,origin,start_req,ccmp,read);

input reset;
input clk;
input [15:0] data_in;
input strobe;
input over,read;

output led;
output we;
output origin,start_req;
output ccmp;

inout [15:0] data_out;
inout [7:0] uc;

reg [15:0] data_latch;
reg [7:0] mask;
reg [7:0] condition;
reg [1:0] state;
reg [2:0] command;
reg ce_reg,sel;
reg strobe_del,strobe_del2,strobe_del3;
reg [7:0] regdata;

wire count_en;
wire start;
wire adrcnt_reset;
wire wait_in,read_data;
wire strobe_s;

assign data_out=we?16'hzzzz:data_latch;
assign uc=we?regdata:8'hzz;
assign start={&{~(data_latch[7:0]^condition[7:0])|mask[7:0]}};//   mask=0xfe,  condition[0]=data_in[0] 

assign led=start_req;
assign we=read_data&(state==2'b11);
assign ccmp=read_data?(strobe&~strobe_del):start;

assign origin=command[2]&(state==2'b11);//0-  , 1-  
assign start_req=wait_in&(state==2'b11);

always@(posedge clk or negedge reset)
if(!reset)
   data_latch<=0;
else
//   if(start_req)
   data_latch<=data_in;

always@(posedge clk or negedge reset)
if(!reset)
   regdata<=0;
else
   if(strobe_del2&~strobe_del3)
   regdata<=read? data_out[15:8] : data_out[7:0];

always@(posedge clk or negedge reset)
if(!reset)
   mask[7:0]<=0;
else
   if(state==2'b01)
      mask[7:0]<=uc[7:0];

always@(posedge clk or negedge reset)
if(!reset)
   condition[7:0]<=0;
else
   if(state==2'b10)
      condition[7:0]<=uc[7:0];

always@(posedge clk or negedge reset)
if(!reset)
   state<=0;
else
      state<=read_data?(over? 0 : 3 ):((strobe_s|(over&start_req))?state+1 : state);

always@(posedge clk or negedge reset)
if(!reset)
   command<=0;
else
   if((state==2'b00)&strobe&~strobe_del)
      command<=uc[2:0];
   else
      if(over)
         command<=0;

assign read_data=command[1];
assign wait_in=command[0];

always@(posedge clk or negedge reset)
if(!reset)
   ce_reg<=0;
else
   ce_reg<=~ce_reg;

always@(posedge clk or negedge reset)
if(!reset)
   begin
   strobe_del<=0;
   strobe_del2<=0;
   strobe_del3<=0;
   end
else
   begin
   strobe_del<=strobe;
   strobe_del2<=strobe_del;
   strobe_del3<=strobe_del2;
   end
assign strobe_s=~strobe&strobe_del;

always@(posedge clk or negedge reset)
if(!reset)
   sel<=0;
else
   if(ce_reg)
      sel<=~sel;

endmodule
