module sram_cnt(clk, reset, address, start_req, over, origin, ccmp, we, ce1, ce2, read, mem_we);
input clk,reset;
input we;//we      ,     .
input start_req, ccmp;
input origin;//0-   , 1-  ,     .
output [14:0] address;
output over,ce1,ce2;
output read,mem_we;

reg [15:0] addr_cnt;
reg cegen, access;
reg freeze, start_seq;
reg ce_read,ce_rdd,cycle_rep;

wire count_seq;

assign read=access;
assign mem_we=we;

always@(posedge clk or negedge reset)
	if(!reset)
		addr_cnt<=0;
	else
		addr_cnt<=(we? ccmp & count_seq : (start_seq & count_seq & cegen))? addr_cnt+1 :addr_cnt;
assign count_seq=~we|access;
assign address=addr_cnt;

assign over=we? freeze&read&ccmp : freeze&start_seq;

always@(posedge clk or negedge reset)
	if(!reset)
		cegen<=0;
	else
		if(start_seq)
		cegen<=~cegen;

always@(posedge clk or negedge reset)
	if(!reset)
		access<=0;
	else
		access<=start_seq? ((we & ccmp)?~access : access):1'b0;

always@(posedge clk or negedge reset)
	if(!reset)
		ce_read<=0;
	else
		ce_read<=ce_read? ~ce_rdd : ccmp ;

always@(posedge clk or negedge reset)
	if(!reset)
		ce_rdd<=0;
	else
		ce_rdd<=ce_read;

assign ce1=~(~we&cegen|we&~access&ce_rdd)|~start_seq ;
assign ce2=~(~we&cegen|we&access&ce_rdd)|~start_seq ;

always@(posedge clk or negedge reset)
	if(!reset)
		freeze<=0;
	else
		freeze<=origin? cycle_rep&{&{address[14:0]}} : {&{address[14:0]}};

always@(posedge clk or negedge reset)
	if(!reset)
		start_seq<=0;
	else
		start_seq<=start_seq?~over:((origin? start_req:ccmp&start_req));

always@(posedge clk or negedge reset)
	if(!reset)
		cycle_rep<=0;
	else
		cycle_rep<=start_req?(cycle_rep? ~over: ccmp):0;

endmodule
