;**********************************************************************
;                                                                     *
;    Filename:	    codelock.asm                                      *
;    Date:          9.11.99                                           *
;    File Version:  1.01                                              *
;                                                                     *
;    Author:        Dmitry Salikoff                                   *
;    Company:       My Flat                                           *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:    4                           *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:         .           *
;                .  -          *
;             .     .     *
;                 EEPROM                *
;                                                                     *
;**********************************************************************
;
;      4-  
; 1 -    .   EEPROM
; 2 -   .        
; 3 -    1
;        3- .
;      - 10 .
;       : 
;  .     1  2.
;      .    
;    .      ,
;  "#"    .


	list      p=16F84             ; list directive to define processor
	#include <p16F84.inc>         ; processor specific variable definitions
	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC
;      72 


; *********************************************************************
; *****   ****************************************
w_temp        EQU     0x0C      ; variable used for context saving 
status_temp   EQU     0x0D      ; variable used for context saving
	cblock 0x0E
 cnt0, cnt1, cnt2		;    
 key_tmp,scan			;     
 cnt_body0,cnt_body1		;   
 cnt_adc			;    
 flags				;   ( )
 cod0,cod1,cod2,cod3		;  
 tmp_snd,tmp_snd1		;   
 cnt10				;     

	endc

razr		equ 0		;    (1-) flags
sost		equ 1		;   (1-)
; *********************************************************************
; ***********    *********************************
addr_cod	equ 0		;   
addr_razr	equ 0x10	;   


; *********************************************************************
; **********   *************************************
psnd		equ PORTA	;   
snd		equ 4
prele		equ PORTA	;  
rele0		equ 0
rele1		equ 1
padc		equ PORTA	; 
adc		equ 2
tris_adc	equ TRISA
pkey		equ PORTB	;  
clop		equ 7		;     /
line0		equ 0		;   0
line1		equ 1		;   1
line2		equ 2		;   2
line3		equ 3		;   3
otkl0		equ 4		;   0
otkl1		equ 5		;   1
otkl2		equ 6		;   2



; *********************************************************************
; **********  **************************************************
snd_on		macro
		banksel psnd
		bsf psnd,snd
		nop
		endm
snd_off		macro
		banksel psnd
		bcf psnd,snd
		nop
		endm
rele_off	macro
		banksel prele
		bcf prele,rele0
		nop
		nop
		bcf prele,rele1
		nop
		endm
rele_open	macro
		banksel prele
		bsf prele,rele0
		nop
		nop
		bcf prele,rele1
		nop
		endm
rele_close	macro
		banksel prele
		bcf prele,rele0
		nop
		nop
		bsf prele,rele1
		nop
		endm
adc_off		macro			;  
		banksel tris_adc
		bcf tris_adc,adc	;  
		banksel padc
		nop
		bcf padc,adc		;  
		nop
		endm
adc_on		macro			;  
		banksel tris_adc
		bsf tris_adc,adc	;  
		banksel padc
		endm
		





;**********************************************************************
;*****************    ******************
;**********************************************************************
		ORG     0x000             ; processor reset vector
  		goto    main              ; go to beginning of program
		ORG     0x004             ; interrupt vector location
		movwf   w_temp            ; save off current W register contents
		movf	STATUS,w          ; move status register into W register
		movwf	status_temp       ; save off contents of STATUS register
; isr code can go here or be located as a call subroutine elsewhere

		movf    status_temp,w     ; retrieve copy of STATUS register
		movwf	STATUS            ; restore pre-isr STATUS register contents
		swapf   w_temp,f
		swapf   w_temp,w          ; restore pre-isr W register contents
		retfie                    ; return from interrupt



;**********************************************************************
;**************    ************************
;**********************************************************************

; /   ----------------------------------------
;     wreg
; : WREG -    
; 1  WREG  10 
delay
		movwf cnt0
delay1		movlw .12
		movwf cnt1
delay3		movlw .207
		movwf cnt2
delay2		clrwdt
		decfsz cnt2,f
		goto delay2
		decfsz cnt1,f
		goto delay3
		decfsz cnt0,f
		goto delay1
		return
		
;   -------------------------------------------------------
;      0,15 
; WREG -   .    : 1......10
;   !
; 1000  => 500  + 500 
;  0.15   150 
pisk
		movwf tmp_snd		; 
		bcf STATUS,C
		rlf tmp_snd,f		;   2
		movf tmp_snd,w
		movwf tmp_snd1
		movlw .100
		movwf cnt2		;    
		movlw .100		;   
		movwf cnt0		;   
pisk2		
		snd_on
		call pisks
		snd_off
		call pisks 
		movf tmp_snd,f		;   0
		btfsc STATUS,Z
		goto pisk3
		decf tmp_snd,f
		incf cnt2,f
pisk3		decfsz cnt0,f
		goto pisk2
		
		movlw .50
		movwf cnt0
pisk4
		snd_on
		call pisks
		snd_off
		call pisks 
		movf tmp_snd1,f		;   0
		btfsc STATUS,Z
		goto pisk5
		decf tmp_snd1
		decf cnt2,f
pisk5		decfsz cnt0,f
		goto pisk4
		return	

pisks					; \ 
		movf cnt2,w
		movwf cnt1
pisks1		clrwdt
		nop
		decfsz cnt1,f
		goto pisks1
		return

; ---------------------------------------------------------------------
; /   -----------------------------------------------
; : WREG  key_tmp -     0xFF,   
;       
;  
keyboard
		clrf key_tmp
		clrf scan
		movlw b'00001110'
		movwf pkey
		btfss pkey,otkl0
		goto kkk1
		btfss pkey,otkl1
		goto kkk2
		btfss pkey,otkl2
		goto kkk3
		movlw b'00001101'
		btfss pkey,otkl0
		goto kkk4
		btfss pkey,otkl1
		goto kkk5
		btfss pkey,otkl2
		goto kkk6
		movlw b'00001011'
		btfss pkey,otkl0
		goto kkk7
		btfss pkey,otkl1
		goto kkk8
		btfss pkey,otkl2
		goto kkk9
		movlw b'00000111'
		btfss pkey,otkl1
		goto kkk10
		btfss pkey,otkl2
		goto kkk11
		goto keyboard_no
kkk11		incf key_tmp,f
kkk9		incf key_tmp,f
kkk8		incf key_tmp,f
kkk7		incf key_tmp,f
kkk6		incf key_tmp,f
kkk5		incf key_tmp,f
kkk4		incf key_tmp,f
kkk3		incf key_tmp,f
kkk2		incf key_tmp,f
kkk1		incf key_tmp,f
kkk10		goto keyboard_end

keyboard_no	
		movlw 0x0F
		movwf pkey
		movlw .10
		call delay
		movlw 0xFF		;  
		movwf key_tmp		;  
		return
keyboard_end
		movf key_tmp,w		; 
		call pisk		;    
		movlw .15
		call delay
		movf key_tmp,w
		return
; ---------------------------------------------------------------------
; /   -------------------------------------------------------
; : EEADR -   
; : EEDATA -  
read_ee
		banksel EECON1
		bsf EECON1,RD
		banksel EEDATA
		return
; ---------------------------------------------------------------------
; /   -------------------------------------------------------
; : EEADR -   
;          EEDATA -  
write_ee
		banksel EECON2
		bsf EECON1,WREN
;		bcf INTCON,GIE		;  
		movlw 0x55
		movwf EECON2
		movlw 0xAA
		movwf EECON2
		bsf EECON1,WR
write_ee1	btfss EECON1,EEIF	;   
		goto write_ee1
		bcf EECON1,WREN
;		bsf INTCON,GIE		;  
		banksel EEDATA
		return
; ---------------------------------------------------------------------
; /   ------------------------------------------------
open
		movlw .10
		call pisk
		movlw .8
		call pisk
		movlw .6
		call pisk
		rele_open
		movlw .40
		call delay
		rele_off
		return
; ---------------------------------------------------------------------
; /   ------------------------------------------------
close
		movlw .10
		call pisk
		movlw .15
		call delay
		movlw .6
		call pisk
		rele_close
		movlw .40
		call delay
		rele_off
		return
		







;**********************************************************************
;*******************      *****************
;**********************************************************************
main
;   
; 1 - 
PORTA_NAPR	EQU B'00001000'
PORTB_NAPR	EQU B'11110000'
		BANKSEL PORTA
		CLRF PORTA
		BANKSEL TRISA
		MOVLW PORTA_NAPR
		MOVWF TRISA
		BANKSEL PORTA
		CLRF PORTA

;   
		CLRF PORTB
		BANKSEL TRISB
		MOVLW PORTB_NAPR
		MOVWF TRISB
		BANKSEL PORTB
		CLRF PORTB
; 
		CLRWDT
		BANKSEL OPTION_REG
		MOVLW B'01011111'	;   WDT c  1:128
		MOVWF OPTION_REG	;   
		BANKSEL TMR0
		clrf TMR0

;  		
		clrf cnt_body0
		clrf cnt_body1
		clrf flags
		snd_off
		rele_off
		adc_off
		clrf EEADR
		movlw 0xFF
		movwf pkey

;  
		movlw .10
		call pisk
		movlw .25
		call delay
		movlw .5
		call pisk
		movlw .25
		call delay
		movlw 1
		call pisk
		movlw 1
		call pisk
		movlw 1
		call pisk





;**********************************************************************
;***********************    **************************
;**********************************************************************
body
		banksel cnt_body0	;    
		incfsz cnt_body0,f	;  
		goto body1
		incf cnt_body1,f
body1		btfss cnt_body1,5	;    
		goto body3		;   (bit3)
		clrf cnt_body0
		clrf cnt_body1
		btfss flags,razr	;    
		goto body2		;  1,  . 
		movlw .3		;    
		call pisk
		movlw .25
		call delay
		movlw .3
		call pisk
		goto body3
body2
		clrf pkey		;   
		bcf INTCON,RBIF
		bcf INTCON,GIE
		bsf INTCON,RBIF
		sleep
		nop
body3					;    (1-)
		btfsc flags,sost	;     
		goto body4

		call keyboard		; ,    
		movwf key_tmp		;   - !
		incfsz key_tmp,f	;    
		goto body5
		btfsc pkey,clop		;    
		goto body10		;   
body5		call close		;  
		bsf flags,sost
		movlw .30
		call delay
		goto body10 

body4					; ,    
		btfss pkey,clop		;   
		goto body18

		movlw .40		
		movwf cnt10		;   
body6	 	call keyboard		;   
		addlw 1		
		btfss STATUS,Z
		goto body7
		decfsz cnt10,f
		goto body6
body8		movlw 1
		call pisk		;    
		movlw .15
		call delay
		movlw 6
		call pisk		;    
		movlw .15
		call delay
		movlw 1
		call pisk		;    
		movlw .15
		call delay
		goto body10
body7		movf key_tmp,w
		movwf cod0
		movlw .40
		movwf cnt10
body9		call keyboard		;  
		addlw 1		
		btfss STATUS,Z
		goto body11
		decfsz cnt10,f
		goto body9
		goto body8
body11		movf key_tmp,w
		movwf cod1
		movlw .40
		movwf cnt10
body13		call keyboard		;  
		addlw 1		
		btfss STATUS,Z
		goto body12
		decfsz cnt10,f
		goto body13
		goto body8
body12		movf key_tmp,w
		movwf cod2
		movlw .40
		movwf cnt10
body15		call keyboard		;  
		addlw 1		
		btfss STATUS,Z
		goto body14
		decfsz cnt10,f
		goto body15
		goto body8
body14		movf key_tmp,w
		movwf cod3

		movlw .4		;     
		movwf cnt10
		movlw cod0
		movwf FSR
		movlw addr_cod
		movwf EEADR
body16		
		call read_ee
		movf INDF,w
		subwf EEDATA,w
		btfss STATUS,Z
		goto body17		;      .
		incf FSR,f
		incf EEADR,f
		decfsz cnt10,f
		goto body16

body18		
		movlw .5
		call pisk
		movlw .5
		call pisk
		movlw .5
		call pisk
		call open		;  
		bcf flags,sost
		movlw .30
		call delay
		goto body10 

body17					;    ""
		movlw .1
		subwf cod0,w
		btfss STATUS,Z
		goto body19
		movlw .1
		subwf cod1,w
		btfss STATUS,Z
		goto body19
		movlw .2
		subwf cod2,w
		btfss STATUS,Z
		goto body19
		movlw .2
		subwf cod3,w
		btfss STATUS,Z
		goto body19
		goto body18

body19					;     
		movlw .1
		subwf cod0,w
		btfss STATUS,Z
		goto body20
		movlw .2
		subwf cod1,w
		btfss STATUS,Z
		goto body20
		movlw .3
		subwf cod2,w
		btfss STATUS,Z
		goto body20
		movlw .4
		subwf cod3,w
		btfss STATUS,Z
		goto body20
		movlw .1		;   
		call pisk
		movlw .2
		call pisk
		movlw .3
		call pisk
		movlw .4
		call pisk
		movlw .5
		call pisk
		movlw .6
		call pisk
		movlw .7
		call pisk
		movlw .8
		call pisk
		movlw .9
		call pisk
		movlw 4			;     
		movwf cnt10
		movlw addr_cod
		movwf EEADR
body22		call keyboard
		incf key_tmp,w
		btfsc STATUS,Z
		goto body22
		movf key_tmp,w
		movwf EEDATA
		call write_ee
		incf EEADR,f
		decfsz cnt10,f
		goto body22
		movlw .10
		call pisk
		movlw .9
		call pisk
		movlw .8
		call pisk
		movlw .7
		call pisk
		movlw .6
		call pisk
		movlw .5
		call pisk
		movlw .4
		call pisk
		movlw .3
		call pisk
		goto body10
body20					;   
		movlw .10
		call pisk
		movlw .9
		call delay
		movlw .8
		call pisk
		movlw .7
		call delay
		movlw .6
		call pisk
		movlw .10
		call pisk
		goto body10		;    




body10					;   
		clrf cnt10
		banksel tris_adc	;   
		bsf tris_adc,adc
		banksel padc
body23		incf cnt10,f
		nop
		btfss padc,adc
		goto body23
		movlw addr_razr		;    
		movwf EEADR
		call read_ee
		movf EEDATA,w		; 
		subwf cnt10,w
		bsf flags,razr
		btfsc STATUS,C
		bcf flags,razr
		goto body
		END                     ; directive 'end of program'

