unit Devsel;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, AdSelCom, AdTSel, IniFiles, 
  OoMisc, AdModDB;

{$i awdefine.inc}
type
  TfrmDeviceSelection = class(TForm)
    GroupBox1: TGroupBox;
    rgpDeviceType: TRadioGroup;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    cbxPort: TComboBox;
    cbxDevice: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    btnCancel: TButton;
    btnOK: TButton;
    ModemDB: TApdModemDBase;
    GroupBox4: TGroupBox;
    Label3: TLabel;
    cbxModem: TComboBox;
  private
    { Private declarations }
  public
    { Public declarations }
    ModemDBFile: String;
    ModemName: String;
    PortName: String;
    DeviceName: String;
    DeviceType: Byte;
    function Execute: Boolean;
  end;

var
  frmDeviceSelection: TfrmDeviceSelection;

implementation

{$R *.DFM}

function TfrmDeviceSelection.Execute: Boolean;
var
  E : TDeviceSelectionForm;
begin
  E := TDeviceSelectionForm.Create(Self);
  try
    { show all com ports in the Serial port drop down list }
    E.ShowTapiDevices := False;
    E.ShowPorts       := True;
    E.EnumAllPorts;
    cbxPort.Items := E.PortItemList;
    { show all TAPI devices in the Device drop down list }
    E.ShowTapiDevices := True;
    E.ShowPorts       := False;
    E.EnumAllPorts;
    cbxDevice.Items := E.PortItemList;
  finally;
    E.Free;
  end;

  {now show all modems from the ModemDB in the Modem drop down list }
  ModemDB.FileName := ModemDBFile;
  cbxModem.Items.Assign(ModemDB.Modems);
  cbxPort.ItemIndex := cbxPort.Items.IndexOf(PortName);
  cbxModem.ItemIndex := cbxModem.Items.IndexOf(ModemName);
  cbxDevice.ItemIndex := cbxDevice.Items.IndexOf(DeviceName);
  rgpDeviceType.ItemIndex := DeviceType;

  Result := ShowModal = mrOK;

  if Result then begin
    DeviceName := cbxDevice.Text;
    ModemName := cbxModem.Text;
    PortName := cbxPort.Text;
    DeviceType := rgpDeviceType.ItemIndex;
  end;                                    
end;

end.
