unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls, OoMisc,
  AdPort, Placemnt, TeEngine, Series, TeeProcs, Chart, RXSwitch, RXSpin,
  RXCtrls, RXSlider, ImgList, ToolWin, ActnList, ExtDlgs, VclUtils, Math;

const
  FREQ = 11059200;    //   
  MAXPOINTCOUNT = 500000; //     
type
  TMainForm = class(TForm)
    StatusLine: TStatusBar;
    Port: TApdComPort;
    FormStorage1: TFormStorage;
    Panel1: TPanel;
    rgrpDeflectOptions: TRadioGroup;
    swchStart: TRxSwitch;
    lblStart: TLabel;
    spedDeflectTime: TRxSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    spedSamplePeriod: TRxSpinEdit;
    Label5: TLabel;
    Panel2: TPanel;
    spedGridPeriod: TRxSpinEdit;
    Label6: TLabel;
    sldrGridOffset: TRxSlider;
    Label7: TLabel;
    Label8: TLabel;
    lblGridOffset: TLabel;
    Chart: TChart;
    Series1: TFastLineSeries;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ImageList1: TImageList;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    tbtMarker1: TToolButton;
    ToolButton9: TToolButton;
    OpenDialog: TOpenDialog;
    ActionList1: TActionList;
    actSave: TAction;
    actLoad: TAction;
    actCopy: TAction;
    actPrint: TAction;
    actPortSet: TAction;
    actViewGrid: TAction;
    ToolButton10: TToolButton;
    actSetMarker1: TAction;
    actSetMarker2: TAction;
    SavePictureDialog: TSavePictureDialog;
    SaveDialog: TSaveDialog;
    actSaveImage: TAction;
    ToolButton11: TToolButton;
    PrinterSetupDialog: TPrinterSetupDialog;
    tbtInvertLeftAxis: TToolButton;
    actInvertLeftAxis: TAction;
    ToolButton13: TToolButton;
    tbtMarker2: TToolButton;
    actViewMarkers: TAction;
    tbtMarkers: TToolButton;
    tbtCrossHair: TToolButton;
    actViewCursor: TAction;
    ToolButton8: TToolButton;
    chbTest: TCheckBox;  { &Contents }
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure swchStartClick(Sender: TObject);
    procedure spedSamplePeriodKeyPress(Sender: TObject; var Key: Char);
    procedure spedSamplePeriodExit(Sender: TObject);
    procedure spedDeflectTimeKeyPress(Sender: TObject; var Key: Char);
    procedure spedDeflectTimeExit(Sender: TObject);
    procedure ChartGetNextAxisLabel(Sender: TChartAxis;
      LabelIndex: Integer; var LabelValue: Double; var Stop: Boolean);
    procedure actPortSetExecute(Sender: TObject);
    procedure actViewGridExecute(Sender: TObject);
    procedure actSaveImageExecute(Sender: TObject);
    procedure actCopyExecute(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure actLoadExecute(Sender: TObject);
    procedure actPrintExecute(Sender: TObject);
    procedure ChartZoom(Sender: TObject);
    procedure ChartScroll(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actInvertLeftAxisExecute(Sender: TObject);
    procedure actViewMarkersExecute(Sender: TObject);
    procedure sldrGridOffsetChange(Sender: TObject);
    procedure sldrGridOffsetChanged(Sender: TObject);
    procedure ChartBeforeDrawAxes(Sender: TObject);
    procedure PortTriggerLineError(CP: TObject; Error: Word;
      LineBreak: Boolean);
    procedure actViewCursorExecute(Sender: TObject);
    procedure ChartMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Series1AfterDrawValues(Sender: TObject);
    procedure actSetMarker1Execute(Sender: TObject);
    procedure actSetMarker2Execute(Sender: TObject);
    procedure ChartClick(Sender: TObject);
  public
    procedure UpdateStatusPanels;
    function  GetNearConst(v:extended):Int64;
{    function  TimeToSamleN(v:extended):Int64;
}    function  SampleTimeCorrect(v:Extended):Extended;
{    function  GridPeriodCorrect(v:extended):extended;
}    function InitDevice:boolean;
    procedure ReceivingTurnOn;
    procedure ReceivingTurnOff;
    procedure InitDeviceAndOpen;
    procedure NotifyDeviceAndClose;
    procedure DataReceiving(CP: TObject; Count: Word);
    procedure DataReceiving_single(CP: TObject; Count: Word);
    procedure SetMarker;
  private
    TrigLE:word;
    PointCount:Longint;
    CurPointIndx:Longint;
    ChangeOccured: boolean;
    StartBit:boolean;
    oldbit:integer;
    Marker1:double;
    Marker2:double;
    MarkerColor:TColor;
    MarkerStyle:TPenStyle;

    AxisXCount:longint;
    AxisYCount:longint;

    OldX,OldY:Longint;
    CrossHairColor:TColor;
    CrossHairStyle:TPenStyle;

  end;

var
  MainForm: TMainForm;

implementation

uses PortCnfg;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  UpdateStatusPanels;
  spedSamplePeriod.MinValue:=1000*(6*16+12)/FREQ;
  spedSamplePeriod.MaxValue:=1000*(6*MAXWORD+12)/FREQ;
  spedSamplePeriod.Increment:=1000*6/FREQ;
  spedSamplePeriod.Value:=SampleTimeCorrect(spedSamplePeriod.MinValue);
  spedDeflectTime.MaxValue:=spedSamplePeriod.Value*MAXPOINTCOUNT/1000;
  marker1:=0;
  marker2:=0;
  MarkerColor:=clGreen;
  MarkerStyle:=psDash;
  OldX:=-1;                          { initialize variables }
  CrossHairColor:=clYellow;
  CrossHairStyle:=psSolid;
  actViewMarkersExecute(Self);
  actInvertLeftAxisExecute(Self);
  actViewCursorExecute(Self);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //  
  if port.Open then
    NotifyDeviceAndClose;
end;


procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.SimpleText := Application.Hint;
end;





procedure TMainForm.swchStartClick(Sender: TObject);
begin
  if swchStart.StateOn then
  begin
    ReceivingTurnOn;
    InitDeviceAndOpen;
  end
  else
  begin
    ReceivingTurnOff;
    NotifyDeviceAndClose;
  end;
end;

procedure TMainForm.ReceivingTurnOn;
var i:Longint;
begin
  Screen.Cursor := crHourGlass;
  try
  Series1.Clear;
  PointCount:= Round(spedDeflectTime.Value*1000/spedSamplePeriod.value)+1;
  Chart.BottomAxis.Maximum:=PointCount*spedSamplePeriod.value;
  Chart.BottomAxis.Minimum:=0;
  TeeDefaultCapacity:=PointCount;
  for i:=0 to PointCount-1 do
    //   LabelX,      
    Series1.AddXY(i*spedSamplePeriod.value,0,'',clTeeColor);
  Series1.Repaint;
  CurPointIndx:=0;

  Port.Open:=true;
  lblStart.Caption:='';
  spedSamplePeriod.enabled:=false;
  rgrpDeflectOptions.Enabled :=false;
  spedDeflectTime.Enabled :=false;
  Application.ProcessMessages;
  finally
  Screen.Cursor := crDefault;
  end;
end;

procedure TMainForm.ReceivingTurnOff;
begin
  lblStart.Caption:='';
  swchStart.StateOn:=false;
  spedSamplePeriod.enabled:=true;
  rgrpDeflectOptions.Enabled :=true;
  spedDeflectTime.Enabled :=true;

end;

procedure TMainForm.InitDeviceAndOpen;
begin
  Screen.Cursor := crHourGlass;
  TrigLE := Port.AddStatusTrigger(stLine);
  Port.SetStatusTrigger(TrigLE,lsParity or lsFraming or lsOverrun or lsBreak,true);

  try
  if not InitDevice then
  begin
    ReceivingTurnOff;
    NotifyDeviceAndClose;
    Abort;
  end;
  if rgrpDeflectOptions.ItemIndex=0 then
  begin
    ChangeOccured:=false;
    StartBit:=true;
    Port.OnTriggerAvail:= DataReceiving_single;
  end
  else Port.OnTriggerAvail:= DataReceiving;
  finally
  Screen.Cursor := crDefault;
  end;
end;

procedure TMainForm.NotifyDeviceAndClose;
begin

  Port.RemoveTrigger(TrigLE);
  Port.OnTriggerAvail:=nil;
  if not port.open then exit;
  Port.PutString(Chr($0D));
  repeat until Port.OutBuffUsed=0;
  Port.Open:=false;
end;

procedure TMainForm.spedSamplePeriodKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key=chr($0D) then
  begin
    spedSamplePeriod.Value:=SampleTimeCorrect(spedSamplePeriod.Value);
    spedDeflectTime.MaxValue:=spedSamplePeriod.Value*MAXPOINTCOUNT/1000;
    PointCount:= Round(spedDeflectTime.Value*1000/spedSamplePeriod.value)+1;
    Series1.GetHorizAxis.Maximum:=PointCount;
    spedGridPeriod.MinValue:= spedSamplePeriod.Value;
  end;
end;

procedure TMainForm.spedSamplePeriodExit(Sender: TObject);
begin
  spedSamplePeriod.Value:=SampleTimeCorrect(spedSamplePeriod.Value);
  spedDeflectTime.MaxValue:=spedSamplePeriod.Value*MAXPOINTCOUNT/1000;
  PointCount:= Round(spedDeflectTime.Value*1000/spedSamplePeriod.value)+1;
  Series1.GetHorizAxis.Maximum:=PointCount;
  spedGridPeriod.MinValue:= spedSamplePeriod.Value;

end;

procedure TMainForm.spedDeflectTimeKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key=chr($0D) then
  begin
    PointCount:= Round(spedDeflectTime.Value*1000/spedSamplePeriod.value)+1;
    Series1.GetHorizAxis.Maximum:=PointCount;
  end;
end;




procedure TMainForm.spedDeflectTimeExit(Sender: TObject);
begin
  PointCount:= Round(spedDeflectTime.Value*1000/spedSamplePeriod.value)+1;
  Series1.GetHorizAxis.Maximum:=PointCount;
end;



function TMainForm.SampleTimeCorrect(v:extended):extended;
var k:Int64;
begin
  k:=GetNearConst(v);
  SampleTimeCorrect:=1000*(6*k+12)/FREQ;
end;

function  TMainForm.GetNearConst(v:extended):Int64;
begin
  GetNearConst:=Round((((V/1000)*FREQ)-12)/6);
end;

function TMainForm.InitDevice:boolean;
var strCMD:string;
begin

  Port.PutChar(Chr($0D));
  if not Port.WaitForString(Chr($0D)+Chr($0A)+'>',10,false,false) then
  begin
    MessageDlg('    ',mtError,[mbAbort],0);
    InitDevice:=false;
    exit;
  end;
  if chbTest.Checked then strCmd:='RT '
                     else strCmd:='RP ';
  strCMD:=strCmd+Format('%.2x',[GetNearConst(spedSamplePeriod.Value)])+Chr($0D);
  Port.PutString(strCMD);
  if not Port.WaitForString(strCMD,10,false,false) then
  begin
    MessageDlg('   ',mtError,[mbAbort],0);
    InitDevice:=false;
    exit;
  end;

  InitDevice:=true;
end;

procedure TMainForm.sldrGridOffsetChange(Sender: TObject);
begin
  lblGridOffset.caption:='  = '+Format('%d',[sldrGridOffset.value])+'%';
end;

procedure TMainForm.sldrGridOffsetChanged(Sender: TObject);
begin
  chart.repaint;
end;


procedure TMainForm.SetMarker;
var X,Y:Double;
    f:string;
begin
  Series1.GetCursorValues(X,Y);
  if tbtMarkers.down then
  begin
    if tbtMarker1.down then
    begin
      Marker1:=X;
    end;
    if tbtMarker2.down then
    begin
      Marker2:=X;
    end;
    Chart.Title.Text.Clear;
    if  Marker1=Marker2 then
      f:='?'
    else
      f:=Format('%.6g',[1000/Abs(Marker1-Marker2)]);
    Chart.Title.Text.Add('t1='+Format('%.6g',[Marker1])+ ' '+
                   '   t2='+Format('%.6g',[Marker2])+ ' '+
                   '   dt='+Format('%.6g',[Abs(Marker1-Marker2)])+' '+
                   '   f=' + f + ' ');
    Chart.repaint;

  end;
end;

procedure TMainForm.UpdateStatusPanels;
  function ParityChar: Char;
  begin
    case Port.Parity of
      pNone : Result := 'N';
      pOdd  : Result := 'O';
      pEven : Result := 'E';
      pMark : Result := 'M';
      pSpace: Result := 'S';
      else Result := ' '
    end;
  end;
var
  S: String;
begin

  S := ComName(Port.ComNumber);

  StatusLine.Panels[0].Text := S;
  StatusLine.Panels[0].Width := Canvas.TextWidth(S) + 16;

  S :=S +' '+ IntToStr(Port.DataBits) + ParityChar + IntToStr(Port.StopBits) +
     ' ' + IntToStr(Port.Baud);
  StatusLine.Panels[0].Text:=S;
  StatusLine.Panels[0].Width := Canvas.TextWidth(S) + 16;
end;


{

**************************************************************************
      
**************************************************************************

}

procedure TMainForm.PortTriggerLineError(CP: TObject; Error: Word;
  LineBreak: Boolean);
var str:string;
begin
  case error of
  0:str:='No error, ordinal value matches ecOK';
  1:str:='Buffer overrun in COMM.DRV';
  2:str:='UART receiver overrun';
  3:str:='UART receiver parity error';
  4:str:='UART receiver framing error';
  5:str:='Transmit timeout waiting for CTS';
  6:str:='Transmit timeout waiting for DSR';
  7:str:='Transmit timeout waiting for RLSD';
  8:str:='Transmit queue is full';
  9:str:='Break condition received';
  end;
  MessageDlg('  : '+str,mtError,[mbAbort],0);
  Series1.Repaint;
  ReceivingTurnOff;
  NotifyDeviceAndClose;
end;

procedure TMainForm.DataReceiving(CP: TObject; Count: Word);
var i,j,bit,b:integer;

begin
  for i:=1 to Count do
  begin
    b:=Integer(Port.GetChar);
    for j:=7 downto 0 do
    begin
      bit:=(b shr j) and 1;
      if CurPointIndx<PointCount then
      begin
        Series1.YValues.Value[CurPointIndx]:=bit;
        Inc(CurPointIndx);
      end else begin
        Series1.Repaint;
        CurPointIndx:=0;
        Series1.YValues.Value[CurPointIndx]:=bit;
        Inc(CurPointIndx);
      end;
    end;
  end;
end;

procedure TMainForm.DataReceiving_single(CP: TObject; Count: Word);
var i,j,bit,b:integer;

begin
  for i:=1 to Count do
  begin
    b:=Integer(Port.GetChar);
    for j:=7 downto 0 do
    begin
      bit:=(b shr j) and 1;
      If StartBit then
      begin
        oldBit:=Bit;
        StartBit:=false;
      end else begin
        if ChangeOccured then
        begin
          if CurPointIndx<PointCount then
          begin
            Series1.YValues.Value[CurPointIndx]:=bit;
            Inc(CurPointIndx);
          end else begin
            Series1.Repaint;
            ReceivingTurnOff;
            NotifyDeviceAndClose;
            exit;
          end
        end else begin
          if bit<>oldbit then
          begin
            ChangeOccured:=true;
            Series1.YValues.Value[CurPointIndx]:=bit;
            Inc(CurPointIndx);
          end;
        end;
      end;
    end;
  end;
end;





{

**************************************************************************
      
**************************************************************************

}


procedure TMainForm.actPortSetExecute(Sender: TObject);
var
  PortConfig: TComPortOptions;
begin
  PortConfig := TComPortOptions.Create(Self);
  try
    PortConfig.ShowTapiDevices := False;
    PortConfig.ComPort := Port;
    if PortConfig.Execute then begin
      PortConfig.GetPortConfig(Port);
    end;
  finally
    PortConfig.Free;
  end;
  UpdateStatusPanels;
end;

procedure TMainForm.actViewGridExecute(Sender: TObject);
begin
  Chart.BottomAxis.Increment:=spedGridPeriod.Value;
  Chart.AxisVisible:=Not(Chart.AxisVisible);
  Series1.Repaint;
end;

procedure TMainForm.actSaveImageExecute(Sender: TObject);
begin

  if SavePictureDialog.Execute then
  begin
    if ExtractFileExt(SavePictureDialog.FileName)='.bmp'  then
      chart.SaveToBitmapFile(SavePictureDialog.FileName);
    if ExtractFileExt(SavePictureDialog.FileName)='.wmf'   then
      chart.SaveToMetafile(SavePictureDialog.FileName);
    if ExtractFileExt(SavePictureDialog.FileName)='.emf'   then
      chart.SaveToMetafileEnh(SavePictureDialog.FileName);

  end;
end;

procedure TMainForm.actCopyExecute(Sender: TObject);
begin
   Chart.CopyToClipboardMetafile(true);
end;


procedure TMainForm.actSaveExecute(Sender: TObject);
var F:TextFile;
    i,N:LongInt;
begin
  N:=Series1.YValues.Count;
  if  N=0 then
  begin
    MessageDlg('   ',mtError,[mbAbort],0);
    exit;
  end;

  if SaveDialog.Execute then
  begin
    AssignFile(F,SaveDialog.FileName);
    Rewrite(F);
    try
      for i:=0 to N-1 do
        Writeln(F,format('%g %g',[Series1.XValues[i],Series1.YValues[i]]));
    finally
      CloseFile(F);

    end;
  end;
end;


procedure TMainForm.actLoadExecute(Sender: TObject);
var F:TextFile;
    N:LongInt;
    X,Y,MaxX,MinX:double;
begin
  N:=0;
  MaxX:=0;
  MinX:=0;
  if OpenDialog.Execute then
  begin
    Screen.Cursor := crHourGlass;
    AssignFile(F,OpenDialog.FileName);
    Reset(F);
    try
      Series1.Clear;
      //      
      while (not EOF(F)) do
      begin
        Readln(F,X,Y);
        if MaxX<X then MaxX:=X;
        if MinX>X then MinX:=Y;
        Series1.AddXY(X,Y,'',clTeeColor);
        Inc(N);
        if N=MAXPOINTCOUNT then
        begin
          MessageDlg('   ',mtError,[mbAbort],0);
          break;
        end;
      end;
      //  

      Chart.BottomAxis.Minimum:=MinX;
      Chart.BottomAxis.Maximum:=MaxX;
      spedSamplePeriod.value:=(MaxX-MinX)/(N-1);
      spedDeflectTime.MaxValue:=spedSamplePeriod.Value*MAXPOINTCOUNT/1000;
      spedDeflectTime.value:=(MaxX-MinX)/1000;
      TeeDefaultCapacity:=N;
      Series1.repaint;
    finally
      CloseFile(F);
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TMainForm.actPrintExecute(Sender: TObject);
begin
  if PrinterSetupDialog.Execute then
    Chart.Print;
end;

procedure TMainForm.actInvertLeftAxisExecute(Sender: TObject);
begin
  Chart.LeftAxis.Inverted:=tbtInvertLeftAxis.down;
  Chart.repaint;
end;

procedure TMainForm.actViewMarkersExecute(Sender: TObject);
begin
  if tbtMarkers.down then
  begin
    chart.Title.Visible :=true;
    tbtMarker1.Enabled :=true;
    tbtMarker2.Enabled :=true;
  end
  else
  begin
    chart.Title.Visible :=false;
    tbtMarker1.Enabled :=false;
    tbtMarker2.Enabled :=false;
  end;
end;


procedure TMainForm.actViewCursorExecute(Sender: TObject);
begin
  if tbtCrossHair.down then
    Chart.Cursor:=crCross
  else
    Chart.Cursor:=crDefault;
  Chart.OriginalCursor:=Chart.Cursor;

  chart.repaint;
end;

procedure TMainForm.actSetMarker1Execute(Sender: TObject);
begin
  //
end;

procedure TMainForm.actSetMarker2Execute(Sender: TObject);
begin
  //
end;


{

**************************************************************************
     
}

procedure TMainForm.ChartGetNextAxisLabel(Sender: TChartAxis;
  LabelIndex: Integer; var LabelValue: Double; var Stop: Boolean);
var k:int64;
begin
  //    ,   
  if Sender=Chart.BottomAxis then
  begin
    if AxisXCount=0 then  LabelValue:=LabelValue;
    if AxisXCount=1 then
    begin
      //         
      k:=Floor((LabelValue+LabelValue/10000-(spedGridPeriod.value*sldrGridOffset.value/100))/spedGridPeriod.value);
      //          
      LabelValue:=(k+1)*spedGridPeriod.value+(spedGridPeriod.value*sldrGridOffset.value/100);
    end;
    if AxisXCount>1 then
      LabelValue:=LabelValue+spedGridPeriod.value;

    inc(AxisXCount);
  end;
  if Sender=Chart.LeftAxis then
  begin
    LabelValue:=Floor(LabelValue)+1;
    inc(AxisYCount);
  End;
  Stop:=false;
end;


procedure TMainForm.ChartZoom(Sender: TObject);
begin
  Chart.LeftAxis.Minimum:=-1;
  Chart.LeftAxis.Maximum:=2;
end;

procedure TMainForm.ChartScroll(Sender: TObject);
begin
  Chart.LeftAxis.Minimum:=-1;
  Chart.LeftAxis.Maximum:=2;
end;

procedure TMainForm.ChartBeforeDrawAxes(Sender: TObject);
begin
  AxisXCount:=0;
  AxisYCount:=0;
end;

procedure TMainForm.ChartMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);


  { This procedure draws the crosshair lines }
  Procedure DrawCross(AX,AY:Integer);
  begin
    With Chart,Canvas do
    begin
      Pen.Color:=CrossHairColor;
      Pen.Style:=CrossHairStyle;
      Pen.Mode:=pmXor;
      Pen.Width:=1;
      MoveTo(ax,ChartRect.Top-Height3D);
      LineTo(ax,ChartRect.Bottom-Height3D);
      MoveTo(ChartRect.Left+Width3D,ay);
      LineTo(ChartRect.Right+Width3D,ay);
    end;
  end;

Var tmpX,tmpY:Double;
begin
  if tbtCrossHair.Down then
  begin
    if (OldX<>-1) then
    begin
      DrawCross(OldX,OldY);  { draw old crosshair }
      OldX:=-1;
    end;

    { check if mouse is inside Chart rectangle }
    if PtInRect( Chart.ChartRect, Point(X-Chart.Width3D,Y+Chart.Height3D)  ) then
    begin
      DrawCross(x,y);  { draw crosshair at current position }
      { store old position }
      OldX:=x;
      OldY:=y;
      { set label text }
      With Series1 do
      begin
        GetCursorValues(tmpX,tmpY);  { <-- get values under mouse cursor }
        StatusLine.Panels[1].Text:=GetVertAxis.LabelValue(tmpY)+
                        ' '+
                        GetHorizAxis.LabelValue(tmpX);
      end;
    end;
  end else begin
    StatusLine.Panels[1].Text:='';
  end;
end;


procedure TMainForm.Series1AfterDrawValues(Sender: TObject);
  Procedure DrawMarker(Marker:Double);
  var MarkerPos:Integer;
  begin
    MarkerPos:=Series1.CalcXPosValue(Marker);
    With Chart,Canvas do
    begin
      Pen.Color:=MarkerColor;
      Pen.Style:=MarkerStyle;
      Pen.Mode:=pmCopy;
      Pen.Width:=1;
      MoveTo(MarkerPos,ChartRect.Top-Height3D);
      LineTo(MarkerPos,ChartRect.Bottom-Height3D);
    end;
  end;

begin
  OldX:=-1;  { Reset old mouse position }

  //     
  if tbtMarkers.Down then
  begin
    DrawMarker(Marker1);
    DrawMarker(Marker2);
  end;
end;


procedure TMainForm.ChartClick(Sender: TObject);
begin
  SetMarker;
end;


end.
