//#include "makeapp.h"
#include "io8535.h"
#include "inavr.h"
#include "uart.h"
#include "pgmspace.h"
#include "utilproc.h"  
#include "timer0.h" 
#include "main.h"  

const char __flash strErr[]="Err:"; 
const char __flash strCRLF[]="\r\n";
const char __flash strPrompt[]="\r\n>";
const char __flash strInit[]="AltProg v3.0"; 
__flash struct command_type command[]=
{
  {   
        "MD",   //   
        (void (*)(void)) MemoryDisplay, 
        Parameter_LONG, //  
        Parameter_LONG, //     16 
        Parameter_LONG, // 0 -  , 1 -  
        Parameter_UNUSED, 
        Parameter_UNUSED 
  },   
  {   
        "MF",   //     
        (void (*)(void)) FillMemory, 
        Parameter_LONG, //  
        Parameter_LONG, //  
        Parameter_LONG, //  
        Parameter_UNUSED, 
        Parameter_UNUSED 
  },   
  {   
        "PW",   //   PWM 
        (void (*)(void)) PWMProgramming, 
        Parameter_LONG, //  1
        Parameter_LONG, //  2
        Parameter_LONG, //     0
        Parameter_LONG, // 0 - , 1 -  
        Parameter_UNUSED 
  },   
  {   
        "AD",   //   ADC
        (void (*)(void)) ADCProgramming, 
        Parameter_LONG, //     (0-7)
        Parameter_LONG, //    ADC  
        //  0 - 425353, 1 - 425353, 2 - 212676, 3 - 106338
        //  4 - 53169 , 5 - 26584 , 6 - 13292,  7 - 6646
        Parameter_LONG, //    1/10800    
        Parameter_LONG, // 0 - 8  , 1 - 10 
        Parameter_UNUSED 
  },   
  {   
        "RP",   //    PA0
        (void (*)(void)) PinReading, 
        Parameter_LONG,  //  .      6*Parameter+12
        Parameter_UNUSED, 
        Parameter_UNUSED, 
        Parameter_UNUSED, 
        Parameter_UNUSED 
  },   
  {   
        "RT",   //  
        (void (*)(void)) TestReading, 
        Parameter_LONG,  //  .      6*Parameter+12
        Parameter_UNUSED, 
        Parameter_UNUSED, 
        Parameter_UNUSED, 
        Parameter_UNUSED 
  },   
}; 

  
unsigned int params[5];
unsigned char InBuf[UART_RX_BUFFER_SIZE];
unsigned char InBufCnt;


void SendErrToUART(char errN);

 

void  main ( void )
{

unsigned char i,l,k;
unsigned char error;  
unsigned char index;  
unsigned int  p_type;   //  
unsigned int  lex_value; 


//  
 PORTA = iniPORTA;
 DDRA  = iniDDRA;           
 PORTB = iniPORTB;               
 DDRB  = iniDDRB;
 PORTC = iniPORTC; 
 DDRC  = iniDDRC;
 PORTD = iniPORTD; 
 DDRD  = iniDDRD;

//   
 
 GIMSK = 0x00; //    INT1  INT0
 GIFR  = 0xC0; //  1    INT1  INT0
 
 MCUCR = 0x00; // 00000000  SLEEP,   
               //   
 TIMSK = 0x00; //     
 TIFR  = 0xFF; //                
 MCUSR = 0x03; //  1      
               //    

//   0 
 
 TCCR0  = 0x00; //  
 TCNT0  = 0x00; //                                      
                                     
//   1 
 
 TCCR1A = 0xA3; // 10100011 -   10-  PWM 
                //   
 TCCR1B = 0x00; // 00000000 - 
 TCNT1  = 0x0000; 
 OCR1A  = 0x01FF; // 50% 
 OCR1B  = 0x01FF; // 50% 
 TCCR1B = 0x01; // 00000001 -    
 DDRD |=pOC1B|pOC1A ;
 
                                     
//   2 
 
 TCCR2  = 0x00; //  
 TCNT2  = 0x00;
 ASSR   = 0x00;
 OCR2   = 0x00;

 
//  UART
 InitUART( 5 );  
 InBufCnt=0;
 
 __enable_interrupt(); 
 
 SendStrToUART(strInit);   
 SendStrToUART(strPrompt); 
 main_cycle:

    if (!DataInReceiveBuffer()) goto main_cycle;
    k=ReceiveByte();
    TransmitByte(k);
    InBuf[InBufCnt]=k;
    InBufCnt++;
    //     
    if ( k == '\r')
    { 
      //     
      for (k=0;k < (sizeof(command) / sizeof(command[0]));k++)
      {
        index = strlen_P((char __flash*)command[k].cmd_str);
        error=0;
        for (i = 0; i < index; i++)
        {
          if (command[k].cmd_str[i] != InBuf[i])
          {                       
            error=1; break;  
          }
        }
        if (!error) break; 
      } // for com_ptr
      if (error)
      {
        SendErrToUART(Err_Unknown_Command);
      } // if ( com_ptr ) 
      else
      {   
        //   ,    
        //   error = find_parameters( com_ptr );
        for ( i = 1; i < 6; i++)
        {   //    1-  5-
          for (; (InBuf[index] == ' '); index++)
          {//   
          }
          switch (i)
          {   //    
            case 1:
                p_type = command[k].p1; break;
            case 2:
                p_type = command[k].p2; break;
            case 3:
                p_type = command[k].p3; break;
            case 4:
                p_type = command[k].p4; break;
            case 5:
                p_type = command[k].p5; break;
            default:
                p_type = Parameter_UNUSED;   break;
          }
          error=0;
          switch (p_type & 0xff)
          {   // p_type is coded so just last 8 bits is needed here 
            case Parameter_LONG: 
                l=InBuf[index];
                if (!is_hex_digit(l))
                {   //    HEX 
                    error= i;
                    break;
                }         
                else
                {  
                    lex_value = 0;
                    while (is_hex_digit(l))
                    {   
                      lex_value = (lex_value << 4)+ ascii_to_hex(l);     
                      index++;
                      l=InBuf[index];
                    } 
                    if      (i == 1) params[0] = lex_value;
                    else if (i == 2) params[1] = lex_value;
                    else if (i == 3) params[2] = lex_value;
                    else if (i == 4) params[3] = lex_value;
                    else if (i == 5) params[4] = lex_value;
                } // if
                break;
            case Parameter_UNUSED: break;
            default: break;
          } // Switch  (p_type & 0xff)
          if (error) break;
        }   // for  
        if (error)
        {
          SendErrToUART(Err_parameter);
        }
        else
        { 
          InBufCnt=0;    
          command[k].func();   
        } // if (error)           
      } 
    } // if ( k == '\r')
  goto main_cycle;
}

// ==========================================================
//        
// ==========================================================
void SendErrToUART(char errN)
{ 
 InBufCnt=0; 
 SendStrToUART(strCRLF); 
 SendStrToUART(strErr);
 TransmitByte(hex_to_ascii((errN >> 4)));
 TransmitByte(hex_to_ascii((errN)));
 SendStrToUART(strPrompt);
}


// ==========================================================
//      (0)  (1)
// ==========================================================
void MemoryDisplay(void)
{
 unsigned char i,d;
 unsigned int addr;
 unsigned int length;

 addr = params[0];
 length =  params[1];
 for (;  length > 0; length--)
 {
   //  
   SendStrToUART(strCRLF); 
   TransmitByte(hex_to_ascii((unsigned char)(addr >> 12)));
   TransmitByte(hex_to_ascii((unsigned char)(addr >> 8)));
   TransmitByte(hex_to_ascii((unsigned char)(addr >> 4)));
   TransmitByte(hex_to_ascii((unsigned char)(addr)));
   TransmitByte(' ');
   TransmitByte(' ');
                    
   for (i = 0; i < 16; i++)
   {      
     if (params[2]==0)  
       d = *(unsigned char __flash*) addr;
     else
       d = *(unsigned char*) addr; 
     
     TransmitByte(hex_to_ascii(( char)(d >> 4)));
     TransmitByte(hex_to_ascii(d));
     TransmitByte(' ');
     addr++;
   } 
 }
 SendStrToUART(strPrompt);
}

// ==========================================================
//     
// ==========================================================
void FillMemory(void)
{
 unsigned int addr;
 SendStrToUART(strCRLF); 
 for (addr=params[0];addr<=params[1];addr++)
 {
   *(char*)addr = (char)params[2];
 }                          
 SendStrToUART(strPrompt);  
}



// ==========================================================
//    PWM
// ==========================================================
void PWMProgramming(void)
{
 SetTimer0Func(PWMProcessing);
 SendStrToUART(strPrompt);
}

// ==========================================================
//    ADC
// ==========================================================
void ADCProgramming(void)
{
 SetTimer0forADC(ADCProcessing);
 SendStrToUART(strPrompt);
}

// ==========================================================
//       RS232   PA0
// ==========================================================
void PinReading(void)
{
   
  Read_Pin(params[0]);
 
}

// ==========================================================
//      RS232   
// ==========================================================
void TestReading(void)
{
   
  Read_Test(params[0]);
 
}
