#include "io8535.h"
#include "inavr.h"
#include "uart.h"
#include "timer0.h"

extern unsigned int params[5];

int (*Timer0func)(void);
struct PWMParams_type PWMParams;
char state;
char HTimer;

#pragma vector=TIMER0_OVF0_vect
__interrupt  void TIMER0_OVF0_interrupt( void )
{ 
 TCNT0=HTimer; 
 if (Timer0func) Timer0func();
}

void SetTimer0Func(int (*func)(void))
{
  PWMParams.L = params[0];
  PWMParams.H = params[1];
  HTimer=0xFF - (char)params[2];
  if (params[3]) 
  { 
   Timer0func = func; 
   TCCR0  = 0x05;        //     1024
   TIMSK |=(1 << TOIE0); //     0  
  } 
  else
  {
   Timer0func = 0; 
   TIMSK &=~(1 << TOIE0); //     0  
  } 
}  

int PWMProcessing(void)
{   
  if (state) OCR1A = PWMParams.L;
      else   OCR1A = PWMParams.H;
  state=!state;
  return 0;
}

void SetTimer0forADC(int (*func)(void))
{ 
  char k;
  TCCR0  = 0x05;        //     1024
  HTimer = 0xFF - (char)params[2];
  state  = (char)params[3];
  Timer0func = func; 
  ADMUX = params[0];   
  ADCSR = (1 << ADEN)|(1 << ADFR)|(1 << ADSC)|(1 << ADIF)|
          (0x07 & params[1]); //  ADC  
  TIMSK |=(1 << TOIE0);   //     0 

 cycle:

  if (!DataInReceiveBuffer()) goto cycle;
  k=ReceiveByte();
  if (k==0x03) 
  {
    Timer0func = 0; 
    TIMSK &=~(1 << TOIE0); //     0  
    return;         
  } 
 goto cycle;           
}  

int ADCProcessing(void)
{
int res;
  if (ADCSR & (1 << ADIF)) 
  {
    ADCSR |= (1 << ADIF); 
    res=ADC;
    if (state)
    {  
      TransmitByte((char)(res >> 8));
      TransmitByte((char)res );
    }
    else
    {
      res>>=2;
      TransmitByte((char)res);
    }
  }
  return 0; 
} 
