#include "io8535.h"
#include "inavr.h"
#include "uart.h"

/* Static Variables */
static unsigned char UART_RxBuf[UART_RX_BUFFER_SIZE];
static unsigned char UART_RxHead;
static unsigned char UART_RxTail;
static unsigned char UART_TxBuf[UART_TX_BUFFER_SIZE];
static unsigned char UART_TxHead;
static unsigned char UART_TxTail;



/* initialize UART */
void InitUART( unsigned char baudrate )
{
unsigned char x;
  UBRR = baudrate; /* set the baud rate */
    /* enable UART receiver and transmitter, and
    receive interrupt */
  UCR = ( (1<<RXCIE) | (1<<RXEN) | (1<<TXEN) & ~(1<<CHR9) );
  x = 0; /* flush receive buffer */
  UART_RxTail = x;
  UART_RxHead = x;
  UART_TxTail = x;
  UART_TxHead = x;
}

/* interrupt handlers */
#pragma vector=UART_RX_vect
__interrupt void UART_RX_interrupt( void )
{
unsigned char data;
unsigned char tmphead;
  data = UDR; /* read the received data */
              /* calculate buffer index */
  tmphead = ( UART_RxHead + 1 ) & UART_RX_BUFFER_MASK;
  UART_RxHead = tmphead; /* store new index */
  if ( tmphead == UART_RxTail )
  {
    /* ERROR! Receive buffer overflow */
  }
  UART_RxBuf[tmphead] = data; /* store received data in buffer */
}

#pragma vector=UART_UDRE_vect
__interrupt void UART_TX_interrupt( void )
{
unsigned char tmptail;
  /* check if all data is transmitted */
  if ( UART_TxHead != UART_TxTail )
  {
   /* calculate buffer index */
   tmptail = ( UART_TxTail + 1 ) & UART_TX_BUFFER_MASK;
   UART_TxTail = tmptail; /* store new index */
   UDR = UART_TxBuf[tmptail]; /* start transmition */
  }
  else
  {
    UCR &= ~(1<<UDRIE); /* disable UDRE interrupt */
  }
}


/* Read and write functions */
unsigned char ReceiveByte( void )
{
unsigned char tmptail;
  while ( UART_RxHead == UART_RxTail ); /* wait for incomming data */
  tmptail = ( UART_RxTail + 1 ) & UART_RX_BUFFER_MASK;/* calculate buffer index */
  UART_RxTail = tmptail;      /* store new index */
  return UART_RxBuf[tmptail]; /* return data */
} 


 
void TransmitByte( unsigned char data )
{
unsigned char tmphead;
  /* calculate buffer index */
  tmphead = ( UART_TxHead + 1 ) & UART_TX_BUFFER_MASK; /* wait for free space in buffer */
  while ( tmphead == UART_TxTail );
  UART_TxBuf[tmphead] = data; /* store data in buffer */
  UART_TxHead = tmphead;      /* store new index */
  UCR |= (1<<UDRIE);          /* enable UDRE interrupt */
}

unsigned char DataInReceiveBuffer( void )
{
  return ( UART_RxHead != UART_RxTail ); 
  /* return 0 (FALSE) if the receive buffer is empty */
}

