#include <pic.h>
#include <sys.h>    
#include <flashrw.h>

//  EECON1 = 0b10000000;
//            7         - EEPGD: Program / Data EEPROM Select bit
//             6        - Unimplemented: Read as '0'
//              5       - Unimplemented: Read as '0'
//               4      - Unimplemented: Read as '0'
//                3     - WRERR: EEPROM Error Flag bit
//                 2    - WREN: EEPROM Write Enable bit
//                  1   - WR: Write Control bit
//                   0  - RD: Read Control bit


  
unsigned char ReadFromEEPROM(unsigned int addr)
{
  EEADR =(unsigned char)addr;
	RD=1;  
  return (EEDATA);
}

void WriteToEEPROM(unsigned int addr, unsigned char b)
{
  EEADR =(unsigned char)addr;
  EEDATA=b;
	WREN=1;
	GIE=0;
	EECON2=0x55;
	EECON2=0xAA;
	WR=1;  
  GIE=1;
  while (!EEIF);
  WREN=0;
  EEIF=0;
}
