// ==========================================================
//      RS232
// ==========================================================
#include <pic.h>
#include <sys.h>  
#include <stdlib.h>
//#include <stdio.h>
#include <main.h>
#include <ctype.h> 
#include <uart.h>
//#include <utils.h>

#include <flashrw.h>


bank1 unsigned char UART_RxBuf[UART_RX_BUFFER_SIZE];
bank1 unsigned char UART_RxHead;
bank1 unsigned char UART_RxTail;
bank1 unsigned char UART_TxBuf[UART_TX_BUFFER_SIZE];
bank1 unsigned char UART_TxHead;
bank1 unsigned char UART_TxTail;
bank1 bit bit_overrun_err;
bank1 bit bit_frame_err;
bank1 unsigned char InBuf[IN_BUF_LEN];   
bank1 unsigned char InBufCnt;






void InitReceiption( void )
{
  InBufCnt=0;
}	

unsigned char ReceiveByte( void )
{
unsigned char tmptail;
  while ( UART_RxHead == UART_RxTail );                //   
  tmptail = ( UART_RxTail + 1 ) & UART_RX_BUFFER_MASK; //    
  UART_RxTail = tmptail;                               //   
  return UART_RxBuf[tmptail];                          //  
} 


 
void TransmitByte( unsigned char data )
{
unsigned char tmphead;
  tmphead = ( UART_TxHead + 1 ) & UART_TX_BUFFER_MASK; //    
  while ( tmphead == UART_TxTail );                    //      
  UART_TxBuf[tmphead] = data;                          //    
  UART_TxHead = tmphead;                               //   
  TXIE=1;                                              //   
}

unsigned char DataInReceiveBuffer( void )
{
  return ( UART_RxHead != UART_RxTail ); //  0 (False)    
}




