#include <pic.h>
#include <sys.h>    
#include <stdlib.h>
//#include <stdio.h>
#include <main.h>
#include <uart.h>
#include <flashrw.h>


//      
bank1 extern unsigned char UART_RxBuf[UART_RX_BUFFER_SIZE];
bank1 extern unsigned char UART_RxHead;
bank1 extern unsigned char UART_RxTail;
bank1 extern unsigned char UART_TxBuf[UART_TX_BUFFER_SIZE];
bank1 extern unsigned char UART_TxHead;
bank1 extern unsigned char UART_TxTail;
bank1 extern bit bit_overrun_err;
bank1 extern bit bit_frame_err;

const char DCiphs[]={
                 // hgaedcbf
	                0b00111111,  // 0
	                0b00000110,  // 1
	                0b01111010,  // 2
	                0b01101110,  // 3
	                0b01000111,  // 4
	                0b01101101,  // 5
	                0b01111101,  // 6
	                0b00100110,  // 7
	                0b01111111,  // 8
	                0b01101111,  // 9
	                0b01110111,  // A
	                0b01011101,  // B
	                0b00111001,  // C
	                0b01011110,  // D
	                0b01111001,  // E
	                0b01110001,  // F
                 };



char dispbuf[10];   //  
char blink_buf[10]; //   

char cntpos;    //      
char cnt;
char mode;      //   
char blink_cnt;
char blink_period;
bit f_blink;


//    
//static volatile unsigned int  rc_falltime;
static volatile unsigned int  rc_time;
static volatile char rc_bitcnt;
static volatile int rc_rbyte;
static volatile bit c_bit;
static volatile char rc_cmd;
static volatile unsigned int time_matching;
#define FIRSTBTMAX 432 //(0.0025*T1CLOCK/2)
#define FIRSTBTMIN 172 //(0.001*T1CLOCK/2)
//static volatile bit rc_err;
//static volatile char rc_err_cod;
//static volatile bit fhalf_bit;
static volatile bit rc_cmd_received;
//char err_ptn;


void main(void)
{
	int i;
	
  CMCON=0b00000111; //  
  VRCON=0b00000000; //   
  PORTA=0b11111111;
/*        7         - 
           6        -  
            5       - SEL   
             4      - RES     
              3     - D     (   0)
               2    - C     (   0)
                1   - B     (   0)
                 0  - A     (   0)

*/  
  TRISA=0b11100000; // 1- , 0 - 

  PORTB=0b11111110;
/*        7         - H     (   0)  
           6        - G     (   0)  
            5       - F     (   0)  
             4      - E     (   0)  
              3     - IRC      
               2    - TX     
                1   - RX     
                 0  - CLK      

*/  
  TRISB=0b00001110;

  T1CON=0b00000001;   //   1   = 0.  895000

  OPTION=0b11000010;  //   8   0
/*
         bit 7: RBPU: PORTB Pull-up Enable bit                           
               1 = PORTB pull-ups are disabled                                 
               0 = PORTB pull-ups are enabled by individual port latch values  
         bit 6: INTEDG: Interrupt Edge Select bit                        
               1 = Interrupt on rising edge of RB0/INT pin                     
               0 = Interrupt on falling edge of RB0/INT pin                    
         bit 5: T0CS: TMR0 Clock Source Select bit                       
               1 = Transition on RA4/T0CKI pin                                 
               0 = Internal instruction cycle clock (CLKOUT)                   
         bit 4: T0SE: TMR0 Source Edge Select bit                        
               1 = Increment on high-to-low transition on RA4/T0CKI pin        
               0 = Increment on low-to-high transition on RA4/T0CKI pin        
         bit 3: PSA: Prescaler Assignment bit                            
               1 = Prescaler is assigned to the WDT                            
               0 = Prescaler is assigned to the Timer0 module                  
         bit 2-0: PS2:PS0: Prescaler Rate Select bits                    
               Bit     Value TMR0 Rate WDT Rate          
               000      1 : 2           1 : 1         
               001      1 : 4           1 : 2         
               010      1 : 8           1 : 4         
               011      1 : 16          1 : 8         
               100      1 : 32          1 : 16        
               101      1 : 64          1 : 32        
               110      1 : 128         1 : 64        
               111      1 : 256         1 : 128       

*/

//         

  RCSTA = 0b10010000;
//          7         - SPEN: Serial Port Enable bit
//           6        - RX9: 9-bit Receive Enable bit
//            5       - SREN: Single Receive Enable bit
//             4      - CREN: Continuous Receive Enable bit
//              3     - ADDEN: Address Detect Enable bit
//               2    - FERR: Framing Error bit
//                1   - OERR: Overrun Error bit
//                 0  - RX9D: 9th bit of received data (Can be parity bit)
  TXSTA = 0b00100100;
//          7         - CSRC: Clock Source Select bit
//           6        - TX9: 9-bit Transmit Enable bit
//            5       - TXEN: Transmit Enable bit  (1 = Transmit enabled)
//             4      - SYNC: USART Mode Select bit
//              3     - Unimplemented: Read as '0'
//               2    - BRGH: High Baud Rate Select bit (1 = High speed)
//                1   - TRMT: Transmit Shift Register Status bit
//                 0  - TX9D: 9th bit of transmit data. Can be parity bit.
  SPBRG = 5; //  (FOSC/(BAUDRATE*16))-1 ; baudrate=115200



//       

   T1CON =0b00110001; //     T1CLOCK=345600 
//          7         - Unimplemented: Read as 0
//           6        - Unimplemented: Read as 0
//            5       - T1CKPS1:T1CKPS0: Timer1 Input Clock Prescale Select bits
//             4      -  (11 = 1:8 Prescale value)
//              3     - T1OSCEN: Timer1 Oscillator Enable Control bit
//               2    - T1SYNC: Timer1 External Clock Input Synchronization Control
//                1   - TMR1CS: Timer1 Clock Source Select bit: 1 -  , 0 -   /4
//                 0  - TMR1ON: Timer1 On bit
//                                             

   CCP1CON = 0b00000100;   // CCP     
//             7         - Unimplemented: Read as '0'
//              6        - Unimplemented: Read as '0'
//               5       - CCPxX:CCPxY: PWM Least Significant bits
//                4      - 
//                 3     - CCPxM3:CCPxM0: CCPx Mode Select bits
//                  2    -   0000 = Capture/Compare/PWM off (resets CCPx module)                                                   
//                   1   -   0100 = Capture mode, every falling edge                                                               
//                    0  -   0101 = Capture mode, every rising edge                                                                
//                           0110 = Capture mode, every 4th rising edge                                                            
//                           0111 = Capture mode, every 16th rising edge                                                           
//                           1000 = Compare mode, set output on match (CCPxIF bit is set)                                          
//                           1001 = Compare mode, clear output on match (CCPxIF bit is set)                                        
//                           1010 = Compare mode, generate software interrupt on match (CCPxIF bit is set, CCPx pin is unaffected) 
//                           1011 = Compare mode, trigger special event (CCPxIF bit is set, CCPx pin is unaffected); CCP1 resets   
//                                                TMR1; CCP2 resets TMR1 and starts an A/D conversion (if A/D module is enabled)   
//                           11xx = PWM mode                                                                                       
//
//
//
   PIE1 = 0b00110100;
//          7         - EEIE: EE Write Complete Interrupt Enable Bit
//           6        - CMIE: Comparator Interrupt Enable bit
//            5       - RCIE: USART Receive Interrupt Enable bit
//             4      - TXIE: USART Transmit Interrupt Enable bit
//              3     - Unimplemented: Read as 0
//               2    - CCP1IE: CCP1 Interrupt Enable bit
//                1   - TMR2IE: TMR2 to PR2 Match Interrupt Enable bit
//                 0  - TMR1IE: TMR1 Overflow Interrupt Enable bit
   PIR1 = 0b00000000;
//          7         - EEIF: EEPROM Write Operation Interrupt Flag bit
//           6        - CMIF: Comparator Interrupt Flag bit
//            5       - RCIF: USART Receive Interrupt Flag bit
//             4      - TXIF: USART Transmit Interrupt Flag bit
//              3     - Unimplemented: Read as 0
//               2    - CCP1IF: CCP1 Interrupt Flag bit
//                1   - TMR2IF: TMR2 to PR2 Match Interrupt Flag bit
//                 0  - TMR1IF: TMR1 Overflow Interrupt Flag bit
   


  INTCON=0b11100000;  //     0
/*
          bit 7: GIE: Global Interrupt Enable bit                                                            
                 1 = Enables all un-masked interrupts                                                        
                 0 = Disables all interrupts                                                                 
          bit 6: PEIE: Peripheral Interrupt Enable bit                                                       
                 1 = Enables all un-masked peripheral interrupts                                             
                 0 = Disables all peripheral interrupts                                                      
          bit 5: T0IE: TMR0 Overflow Interrupt Enable bit                                                    
                 1 = Enables the TMR0 interrupt                                                              
                 0 = Disables the TMR0 interrupt                                                             
          bit 4: INTE: RB0/INT External Interrupt Enable bit}                                                
                 1 = Enables the RB0/INT external interrupt                                                  
                 0 = Disables the RB0/INT external interrupt                                                 
          bit 3: RBIE: RB Port Change Interrupt Enable bit                                                   
                 1 = Enables the RB port change interrupt                                                    
                 0 = Disables the RB port change interrupt                                                   
          bit 2: T0IF: TMR0 Overflow Interrupt Flag bit                                                      
                 1 = TMR0 register has overflowed (must be cleared in software)                              
                 0 = TMR0 register did not overflow                                                          
          bit 1: INTF: RB0/INT External Interrupt Flag bit                                                   
                 1 = The RB0/INT external interrupt occurred (must be cleared in software)                   
                 0 = The RB0/INT external interrupt did not occur                                            
          bit 0: RBIF: RB Port Change Interrupt Flag bit                                                     
                 1 = When at least one of the RB7:RB4 pins changed state (must be cleared in software)       
                 0 = None of the RB7:RB4 pins have changed state                                             
*/

//  PIE1=  0b00000000;  // 
//  PIR1=0;
  
  PORTA=0b00001111;  //     
  blink_period=27;
  mode=0;
  
  for (i=0;i<10;i++) dispbuf[i]=~0x88;
  for (;;)
  {
  	if (DataInReceiveBuffer())
  	{
      switch (mode)
      {
        case 0:
          switch (ReceiveByte())	                                
          {                                                     
            case 0x31: //    	            
              mode=1;
              cnt=0;                                           
              break;                                            
            case 0x32: //                 
            	mode=2;
            	cnt=0;                                           
              break;                                            
            case 0x33: //                   
            	for (i=0;i<10;i++) dispbuf[i]=~0x00;              
              break;                                            
            case 0x34: //                   
            	for (i=0;i<10;i++) blink_buf[i]=0x00;             
              break;                                            
            case 0x35: //     0xff   
            	for (i=0;i<10;i++) dispbuf[i]=~0xff;              
              break;                                            
            case 0x36: //     0xff   
            	for (i=0;i<10;i++) blink_buf[i]=0xff;             
              break;                                            
            case 0x37: //                    
            	mode=3;      
            	cnt=0;                                     
              break;                                            
          }		         
          break;
        case 1:  //    	  
          dispbuf[cnt]=~ReceiveByte();
          cnt++;
          if (cnt==10) mode=0;
          break;
        case 2:  //      
          blink_buf[cnt]=ReceiveByte();
          cnt++;
          if (cnt==10) mode=0;
          break;
        case 3:  //       
          blink_period=ReceiveByte();
          mode=0;
          break;                                                
      }  //  switch (mode)
    }    //  if (DataInReceiveBuffer())                                                  
  		
  		
/*
  		dispbuf[curpos]=ReceiveByte();
  		curpos++;
  		if (curpos==10) curpos=0;
*/
  	
  	if (rc_cmd_received)
  	{
  		rc_cmd_received=0;
  		TransmitByte(rc_cmd);
  	}	
  	
  	
  }	
  
  
  
}  





void interrupt isr(void)
{
  unsigned char data;
  unsigned char tmp; 

//   CCP2  ...............................................................................................    
//   
  if (TMR1IF && TMR1IE)
  {
	  TMR1IF=0;  //         
	  TMR1IE=0;
    rc_rbyte=0;
    rc_bitcnt=0; 
  	CCP1CON = 0b00000100;
  }

  if (CCP1IF)
  {

    CCP1IF=0;	
    
    //      345600 
    switch (rc_bitcnt)
    {
    case 0: //    
      rc_time=(CCPR1H << 8) | CCPR1L;      
      CCP1CON = 0b00000101; //       
      CCP1IF=0;
      rc_bitcnt++;
      break;
    case 1: //     
      rc_time=((CCPR1H << 8) | CCPR1L) - rc_time;
      // ,        
      if ((rc_time>FIRSTBTMAX) || (rc_time<FIRSTBTMIN) )
      { 
      	//    
        rc_rbyte=0;
        rc_bitcnt=0; 
      	CCP1CON = 0b00000100;
      	CCP1IF=0;
        break;
      }	
      CCP1CON = 0b00001010; //    
      time_matching=((CCPR1H << 8) | CCPR1L);
      time_matching+=(rc_time >> 1);    //      
      rc_time=rc_time+(rc_time >> 1);
      CCPR1H=time_matching >> 8;        
      CCPR1L=time_matching & 0xFF;
      CCP1IF=0;
      rc_bitcnt++;
      break;
    default:
      if 	(rc_bitcnt & 1)
      {
        //     
        if  (rc_bitcnt==27) 
        {
          //       
          if (rc_rbyte & 0x0800) 
          {
            if (!c_bit)
            {
            	rc_cmd_received=1;  //       
              c_bit=1;
            }
          }
          else
          {
            if (c_bit)
            {
            	rc_cmd_received=1;
            	c_bit=0;
            }
          }	  	
          
        	rc_cmd=rc_rbyte & 0xff;
          rc_rbyte=0;
          rc_bitcnt=0; 
        	CCP1CON = 0b00000100;
        }
        else 
        {
          rc_bitcnt++;
          //    
          time_matching=((CCPR1H << 8) | CCPR1L);
          time_matching+=rc_time;
          CCP1CON = 0b00001010; //    
          CCPR1H=time_matching >> 8;
          CCPR1L=time_matching & 0xFF;
          CCP1IF=0;
        }  
      	TMR1IE=0;
      }
      else
      {
      	
        //     
        TMR1ON = 0; //   1
        TMR1H=0;
        TMR1L=0;
        TMR1IE=1;   //         
        TMR1IF=0;
        TMR1ON = 1; //  
        if (IRC)
        {
        	rc_rbyte=(rc_rbyte << 1) | 1;
        	CCP1CON = 0b00000100; //       
        	CCP1IF=0;
        }
        else
        {
        	rc_rbyte=rc_rbyte << 1;
          CCP1CON = 0b00000101; //       
          CCP1IF=0;
        }
        rc_bitcnt++;
      }		
      break;	
    } // switch	
  }	
  


	if (T0IF)  //   1350    11059200
	{
		T0IF=0;
		cntpos++;
		if (cntpos==10)
		{
      PORTA=0b00011111; //       
      PORTA=0b00001111; //   
      PORTB=0b11110000;
			cntpos=0;
			//  
			blink_cnt++;
			if (blink_cnt==blink_period)
			{
        blink_cnt=0;
        f_blink=!f_blink;
//        for (tmp=0;tmp<10;tmp++) blink_buf[tmp]^=blink_buf[tmp]; 
			}	
   	}	
   	else
   	{
      
      PORTA=0b00001111; //   
      PORTB=0b11110001; //    
#asm
      nop
      nop
#endasm
      PORTB=0b11110000;
   	}	
		
		
    
    if (f_blink) 
      tmp=blink_buf[cntpos];
    else 
      tmp=0;  
    
    PORTA=(dispbuf[cntpos] | tmp) & 0x0F;
    PORTB=(dispbuf[cntpos] | tmp) & 0xF0;  

		
	}	
//      ..............................................................................................
	if(RCIF)     
	{
		if (OERR) 
		{
			bit_overrun_err=1;//  
			CREN=0;           //    
			CREN=1;
		}	
		if (FERR)
		{
			bit_frame_err=1; //  
		}	
    data = RCREG;    //  
    tmp = ( UART_RxHead + 1 ) & UART_RX_BUFFER_MASK;  //     
    UART_RxHead = tmp;        //   
    if ( tmp == UART_RxTail )
    {
      bit_overrun_err=1; //      
    }  
    UART_RxBuf[tmp] = data; 	    //         
  } 
//     .............................................................................................
  if (TXIF && TXIE)    
 	{
    if ( UART_TxHead != UART_TxTail ) //     
    {
     tmp = ( UART_TxTail + 1 ) & UART_TX_BUFFER_MASK; //   
     UART_TxTail = tmp;                               //   
     TXREG = UART_TxBuf[tmp];                         //  
    }
    else
    {
      TXIE=0; //     ,   
    }
  }    	
	
}	
