;Special Functions Registers

SP   .EQU 081H ;stack pointer
DPL  .EQU 082H ;data pointer (DPTR) low
DPH  .EQU 083H ;data pointer (DPTR) high
PCON .EQU 087H ;power control register

TCON .EQU 088H ;timers control register
IT0  .EQU 088H ;bit 0 TCON,INT0 type
IE0  .EQU 089H ;bit 1 TCON,INT0 flag
IT1  .EQU 08AH ;bit 2 TCON,INT1 type
IE1  .EQU 08BH ;bit 3 TCON,INT1 flag
TR0  .EQU 08CH ;bit 4 TCON,timer0 start
TF0  .EQU 08DH ;bit 5 TCON,timer0 overflow
TR1  .EQU 08EH ;bit 6 TCON,timer1 start
TF1  .EQU 08FH ;bit 7 TCON,timer1 overflow

TMOD .EQU 089H ;timers mode register
TL0  .EQU 08AH ;timer0 L
TL1  .EQU 08BH ;timer1 L
TH0  .EQU 08CH ;timer0 H
TH1  .EQU 08DH ;timer1 H

SCON .EQU 098H ;serial port control register
RI   .EQU 098H ;bit 0 SCON,reseiver interrupt flag
TI   .EQU 099H ;bit 1 SCON,transmitter interrupt flag
RB8  .EQU 09AH ;bit 2 SCON,reseiver 9-th bit
TB8  .EQU 09BH ;bit 3 SCON,transmitter 9-th bit
REN  .EQU 09CH ;bit 4 SCON,reseive enable
SM2  .EQU 09DH ;bit 5 SCON,serial port mode
SM1  .EQU 09EH ;bit 6 SCON,serial port mode
SM0  .EQU 09FH ;bit 7 SCON,serial port mode

SBUF .EQU 099H ;serial port buffer

IE   .EQU 0A8H ;interrupts enable register
EX0  .EQU 0A8H ;bit 0 IE,INT0 enable
ET0  .EQU 0A9H ;bit 1 IE,timer0 interrupt enable
EX1  .EQU 0AAH ;bit 2 IE,INT1 enable
ET1  .EQU 0ABH ;bit 3 IE,timer1 interrupt enable
ES   .EQU 0ACH ;bit 4 IE,serial port interrupt enable
ET2  .EQU 0ADH ;bit 5 IE
EA   .EQU 0AFH ;bit 7 IE,all interrupts enable

IP   .EQU 0B8H ;interrupts priority register
PX0  .EQU 0B8H ;bit 0 IP,INT0 priority
PT0  .EQU 0B9H ;bit 1 IP,timer0 interrupt priority
PX1  .EQU 0BAH ;bit 2 IP,INT0 priority
PT1  .EQU 0BBH ;bit 3 IP,timer1 interrupt priority
PS   .EQU 0BCH ;bit 4 IP,serial port interrupt priority
PT2  .EQU 0BDH ;bit 5 IP

PSW  .EQU 0D0H ;processor status word
P    .EQU 0D0H ;bit 0 PSW,parity flag
OV   .EQU 0D2H ;bit 2 PSW,overflow flag
RS0  .EQU 0D3H ;bit 3 PSW,register bank select
RS1  .EQU 0D4H ;bit 4 PSW,register bank select
F0   .EQU 0D5H ;bit 5 PSW,flag 0
AC   .EQU 0D6H ;bit 6 PSW,aux. carry flag
CV   .EQU 0D7H ;bit 7 PSW,carry flag

ACC   .EQU 0E0H ;accumulator
ACC.0 .EQU 0E0H ;bit 0 ACC
ACC.1 .EQU 0E1H ;bit 1 ACC
ACC.2 .EQU 0E2H ;bit 2 ACC
ACC.3 .EQU 0E3H ;bit 3 ACC
ACC.4 .EQU 0E4H ;bit 4 ACC
ACC.5 .EQU 0E5H ;bit 5 ACC
ACC.6 .EQU 0E6H ;bit 6 ACC
ACC.7 .EQU 0E7H ;bit 7 ACC

B    .EQU 0F0H ;second accumulator
B.0  .EQU 0F0H ;bit 0 B
B.1  .EQU 0F1H ;bit 1 B
B.2  .EQU 0F2H ;bit 2 B
B.3  .EQU 0F3H ;bit 3 B
B.4  .EQU 0F4H ;bit 4 B
B.5  .EQU 0F5H ;bit 5 B
B.6  .EQU 0F6H ;bit 6 B
B.7  .EQU 0F7H ;bit 7 B

;Registers

R00  .EQU 000H ;R0 in bank 0
R01  .EQU 001H ;R1 in bank 0
R02  .EQU 002H ;R2 in bank 0
R03  .EQU 003H ;R3 in bank 0
R04  .EQU 004H ;R4 in bank 0
R05  .EQU 005H ;R5 in bank 0
R06  .EQU 006H ;R6 in bank 0
R07  .EQU 007H ;R7 in bank 0

R10  .EQU 008H ;R0 in bank 1
R11  .EQU 009H ;R1 in bank 1
R12  .EQU 00AH ;R2 in bank 1
R13  .EQU 00BH ;R3 in bank 1
R14  .EQU 00CH ;R4 in bank 1
R15  .EQU 00DH ;R5 in bank 1
R16  .EQU 00EH ;R6 in bank 1
R17  .EQU 00FH ;R7 in bank 1

R20  .EQU 010H ;R0 in bank 2
R21  .EQU 011H ;R1 in bank 2
R22  .EQU 012H ;R2 in bank 2
R23  .EQU 013H ;R3 in bank 2
R24  .EQU 014H ;R4 in bank 2
R25  .EQU 015H ;R5 in bank 2
R26  .EQU 016H ;R6 in bank 2
R27  .EQU 017H ;R7 in bank 2

R30  .EQU 018H ;R0 in bank 3
R31  .EQU 019H ;R1 in bank 3
R32  .EQU 01AH ;R2 in bank 3
R33  .EQU 01BH ;R3 in bank 3
R34  .EQU 01CH ;R4 in bank 3
R35  .EQU 01DH ;R5 in bank 3
R36  .EQU 01EH ;R6 in bank 3
R37  .EQU 01FH ;R7 in bank 3

;Ports

P0	.EQU 080H ;port 0
P0.0	.EQU 080H ;bit P0.0
P0.1	.EQU 081H ;bit P0.1
P0.2	.EQU 082H ;bit P0.2
P0.3	.EQU 083H ;bit P0.3
P0.4	.EQU 084H ;bit P0.4
P0.5	.EQU 085H ;bit P0.5
P0.6	.EQU 086H ;bit P0.6
P0.7	.EQU 087H ;bit P0.7

P1     .EQU 090H ;port 1
P1.0	.EQU 090H ;bit P1.0
P1.1	.EQU 091H ;bit P1.1
P1.2	.EQU 092H ;bit P1.2
P1.3   .EQU 093H ;bit P1.3
P1.4   .EQU 094H ;bit P1.4
P1.5   .EQU 095H ;bit P1.5
P1.6   .EQU 096H ;bit P1.6
P1.7   .EQU 097H ;bit P1.7

P2     .EQU 0A0H ;port 2
P2.0	.EQU 0A0H ;bit P2.0
P2.1	.EQU 0A1H ;bit P2.1
P2.2	.EQU 0A2H ;bit P2.2
P2.3	.EQU 0A3H ;bit P2.3
P2.4	.EQU 0A4H ;bit P2.4
P2.5	.EQU 0A5H ;bit P2.5
P2.6	.EQU 0A6H ;bit P2.6
P2.7	.EQU 0A7H ;bit P2.7

P3     .EQU 0B0H ;port 3
P3.0   .EQU 0B0H ;bit P3.0 (RXD)
P3.1   .EQU 0B1H ;bit P3.1 (TXD)
P3.2   .EQU 0B2H ;bit P3.2 (INT0)
P3.3	.EQU 0B3H ;bit P3.3 (INT1)
P3.4   .EQU 0B4H ;bit P3.4 (T0)
P3.5   .EQU 0B5H ;bit P3.5 (T1)
P3.6   .EQU 0B6H ;bit P3.6 (WR)
P3.7   .EQU 0B7H ;bit P3.7 (RD)

RXD    .EQU 0B0H ;bit P3.0 (RXD)
TXD    .EQU 0B1H ;bit P3.1 (TXD)
INT0   .EQU 0B2H ;bit P3.2 (INT0)
INT1	.EQU 0B3H ;bit P3.3 (INT1)
T0     .EQU 0B4H ;bit P3.4 (T0)
T1     .EQU 0B5H ;bit P3.5 (T1)
WR     .EQU 0B6H ;bit P3.6 (WR)
RD     .EQU 0B7H ;bit P3.7 (RD)

;Bit Addressing Memory

M_20H.0	.EQU 000H
M_20H.1	.EQU 001H
M_20H.2	.EQU 002H
M_20H.3	.EQU 003H
M_20H.4	.EQU 004H
M_20H.5	.EQU 005H
M_20H.6	.EQU 006H
M_20H.7	.EQU 007H

M_21H.0	.EQU 008H
M_21H.1	.EQU 009H
M_21H.2	.EQU 00AH
M_21H.3	.EQU 00BH
M_21H.4	.EQU 00CH
M_21H.5	.EQU 00DH
M_21H.6	.EQU 00EH
M_21H.7	.EQU 00FH

M_22H.0	.EQU 010H
M_22H.1	.EQU 011H
M_22H.2	.EQU 012H
M_22H.3	.EQU 013H
M_22H.4	.EQU 014H
M_22H.5	.EQU 015H
M_22H.6	.EQU 016H
M_22H.7	.EQU 017H

M_23H.0	.EQU 018H
M_23H.1	.EQU 019H
M_23H.2	.EQU 01AH
M_23H.3	.EQU 01BH
M_23H.4	.EQU 01CH
M_23H.5	.EQU 01DH
M_23H.6	.EQU 01EH
M_23H.7	.EQU 01FH

M_24H.0	.EQU 020H
M_24H.1	.EQU 021H
M_24H.2	.EQU 022H
M_24H.3	.EQU 023H
M_24H.4	.EQU 024H
M_24H.5	.EQU 025H
M_24H.6	.EQU 026H
M_24H.7	.EQU 027H

M_25H.0	.EQU 028H
M_25H.1	.EQU 029H
M_25H.2	.EQU 02AH
M_25H.3	.EQU 02BH
M_25H.4	.EQU 02CH
M_25H.5	.EQU 02DH
M_25H.6	.EQU 02EH
M_25H.7	.EQU 02FH

M_26H.0	.EQU 030H
M_26H.1	.EQU 031H
M_26H.2	.EQU 032H
M_26H.3	.EQU 033H
M_26H.4	.EQU 034H
M_26H.5	.EQU 035H
M_26H.6	.EQU 036H
M_26H.7	.EQU 037H

M_27H.0	.EQU 038H
M_27H.1	.EQU 039H
M_27H.2	.EQU 03AH
M_27H.3	.EQU 03BH
M_27H.4	.EQU 03CH
M_27H.5	.EQU 03DH
M_27H.6	.EQU 03EH
M_27H.7	.EQU 03FH

M_28H.0	.EQU 040H
M_28H.1	.EQU 041H
M_28H.2	.EQU 042H
M_28H.3	.EQU 043H
M_28H.4	.EQU 044H
M_28H.5	.EQU 045H
M_28H.6	.EQU 046H
M_28H.7	.EQU 047H

M_29H.0	.EQU 048H
M_29H.1	.EQU 049H
M_29H.2	.EQU 04AH
M_29H.3	.EQU 04BH
M_29H.4	.EQU 04CH
M_29H.5	.EQU 04DH
M_29H.6	.EQU 04EH
M_29H.7	.EQU 04FH

M_2AH.0	.EQU 050H
M_2AH.1	.EQU 051H
M_2AH.2	.EQU 052H
M_2AH.3	.EQU 053H
M_2AH.4	.EQU 054H
M_2AH.5	.EQU 055H
M_2AH.6	.EQU 056H
M_2AH.7	.EQU 057H

M_2BH.0	.EQU 058H
M_2BH.1	.EQU 059H
M_2BH.2	.EQU 05AH
M_2BH.3	.EQU 05BH
M_2BH.4	.EQU 05CH
M_2BH.5	.EQU 05DH
M_2BH.6	.EQU 05EH
M_2BH.7	.EQU 05FH

M_2CH.0	.EQU 060H
M_2CH.1	.EQU 061H
M_2CH.2	.EQU 062H
M_2CH.3	.EQU 063H
M_2CH.4	.EQU 064H
M_2CH.5	.EQU 065H
M_2CH.6	.EQU 066H
M_2CH.7	.EQU 067H

M_2DH.0	.EQU 068H
M_2DH.1	.EQU 069H
M_2DH.2	.EQU 06AH
M_2DH.3	.EQU 06BH
M_2DH.4	.EQU 06CH
M_2DH.5	.EQU 06DH
M_2DH.6	.EQU 06EH
M_2DH.7	.EQU 06FH

M_2EH.0	.EQU 070H
M_2EH.1	.EQU 071H
M_2EH.2	.EQU 072H
M_2EH.3	.EQU 073H
M_2EH.4	.EQU 074H
M_2EH.5	.EQU 075H
M_2EH.6	.EQU 076H
M_2EH.7	.EQU 077H

M_2FH.0	.EQU 078H
M_2FH.1	.EQU 079H
M_2FH.2	.EQU 07AH
M_2FH.3	.EQU 07BH
M_2FH.4	.EQU 07CH
M_2FH.5	.EQU 07DH
M_2FH.6	.EQU 07EH
M_2FH.7	.EQU 07FH
