;----------------------------------------------------
;  UPS.ASM    
;  Program for Blaster Control Board (INTROMARIN-C).
;----------------------------------------------------

	LIST    p=16F84 ; PIC16F84 is the target processor

#include p16f84.inc

;#define PROC16C71

; variables definition

	; 
T	EQU	10H	;    =200
LEN	EQU	11H	; . .   =100
PP	EQU	12H	;  
BAT	EQU	13H	;    
FRONT	EQU	14H	;    
SIN_OK	EQU	15H	;  
SHORT	EQU	16H	;  
FLAG_F	EQU	17H	;   
PWcnt	EQU	18H	;  .  
SINcnt	EQU	19H	;    
t	EQU	20H	;   
BATime	EQU	21H	; 
time	EQU	22H	;  20 =5.12
zumm	EQU	23H	;   

	; 
period	EQU	.165	; 
len	EQU	.80

	;   A
OS	EQU	2	;   
LOWBAT	EQU	3	;  LOW BATTERY
;	EQU	4	; 


	;   B
SINH	EQU	0	;  
PWGOOD	EQU	1	;  POWER_GOOD
;	EQU	2	; 
RELAY	EQU	3	;   
BASE0	EQU	4	;   
BASE1 	EQU	5	;   
;	EQU	6	;  
ZUMM	EQU	7	;  
	 

		
	GOTO	Start
;------------------------------------------;
;                  MAIN                    ;
;------------------------------------------;
		ORG	200
	
;  
Start:	;  

	; Initialize PORTA by
	BCF	STATUS, RP0 	
	CLRF 	PORTA 	
	BSF	STATUS, RP0 
	MOVLW 	0x1f		; Set RA0-RA4 as inputs 
	MOVWF 	TRISA 	
       #ifdef	PROC16C71
	MOVLW 	0x00		; Set RA0-RA4 as analog
	MOVWF 	ADCON1
       #endif

	; Initialize PORTB by 
	BCF 	STATUS, RP0 	
	CLRF 	PORTB
	BSF 	STATUS, RP0 
	MOVLW 	0x03		; Set RB0,Rb1 as inputs, all other as output 
	MOVWF 	TRISB

	; TIMER INTERRUPT ENABLE
	BSF 	STATUS, RP0
	MOVLW	0xA0
	MOVWF	INTCON
	
	; SET_TIMER
	BSF 	STATUS, RP0	;  
		; NEW !!!! WDT
	movlw	0x58
	movwf	OPTION_REG	;  ,
				;    WDT,
				;   1
		; NEW !!! WDT
	BCF 	STATUS, RP0
	BCF	INTCON, T0IF	;  
	;MOVF	period		; 
	MOVLW	period
	MOVWF	TMR0
	
	; PRESET REGISTERS	
	BCF 	STATUS, RP0 
	MOVLW	.199
	MOVWF	T
	MOVLW	.80
	MOVWF	LEN
	BSF	BAT, 0
	CLRF	FRONT
	CLRF	BATime	
	CLRF	time	
	CLRF	zumm	

	
	; 
	;BCF	PORTB, 3
	;CALL 	ZUMM
	;CALL 	ZUMM
	;CALL 	ZUMM
	;BSF	PORTB, 3

	;  
	GOTO	$



;------------------------------------------;
;                       ;
;------------------------------------------;
		ORG	4
;__interrupt{
  ;------------------------------__SET_TIMER  ------------------
	BCF 	STATUS, RP0
	btfss	TMR0, 0		; 
	goto	$+1
	BCF	INTCON, T0IF	;  
	MOVLW	period		;   
	MOVWF	TMR0
  ;-------------------------------------------------------------
  	INCF	T, 1		;   
	MOVF	T, 0
	SUBLW	.199	
	BTFSS	STATUS, C
	CLRF	T		;   
  ;-------------------------------------------------------------
	INCF	t, 1
	MOVF	T, 1		;   . 
	BTFSC	STATUS, Z
	CLRF	t
  ;-------------------------------------------------------------
	clrwdt		; !!!! NEW WDT !!!!
  ;-------------------------------------------------------------
  ;__if(t==0)||(t==99) { PP++
	MOVF	t, 0		
	SUBLW	.0	
	BTFSS	STATUS, Z
	GOTO	INT1
	CLRF	PP		;   
	MOVLW	len		;  LEN
	MOVWF	LEN
	GOTO	INT2
INT1:	MOVF	t, 0
	SUBLW	.99
	BTFSS	STATUS, Z
	GOTO 	INT2
	BSF	PP, 0		;   
	MOVLW	len		;  LEN
	MOVWF	LEN		
INT2:   MOVF	LEN, 1		;  LEN
	BTFSS	STATUS, Z
	DECF	LEN, 1
  ;__}

  ;*******************   ************************
  ;--------------------------    --------------- 
	BTFSC	PORTB, PWGOOD
	GOTO	POWER
	BSF	BAT, 0
	CLRF	PWcnt
	CLRF	SIN_OK
POWER:
  ;--------------------------    ------------------ 
	BTFSS	PORTB, PWGOOD
	GOTO	DESIGN	
  	BTFSS	PWcnt, 7		
	GOTO	DESIGN	
	BTFSS	SIN_OK, 0
	GOTO	DESIGN
	CLRF	BAT
DESIGN:
  ;*************************************************************

  ;--------------------------   --------------------
	BTFSC	BAT, 0
 	BCF	PORTB, RELAY
	BTFSS	BAT, 0
 	BSF	PORTB, RELAY
  ;--------------------------     -------
  ;__if(BAT==1){		
	BTFSS	BAT, 0
	GOTO	INT4
    ;__if(LEN!=0){
	MOVF	LEN, 1
	BTFSC	STATUS, Z
	GOTO	INT4
      ;__if(PP==0){
	BTFSC	PP, 0
	GOTO    INT3
	BSF	PORTB, BASE0
	BCF	PORTB, BASE1
	GOTO	INT5
INT3:	BCF	PORTB, BASE0
	BSF	PORTB, BASE1
	GOTO	INT5
      ;__} 	  	
    ;__} 
    ;__else{}
INT4:	BCF	PORTB, BASE0
	BCF	PORTB, BASE1
INT5:	
  ;__}
  ;-------------------------     --------
	MOVF	t, 0	
	BTFSS	STATUS, Z
	GOTO	Z1
	INCF	time, 1
	INCF	BATime, 1
	BTFSC	BAT, 0
	GOTO	Z2
	CLRF	BATime
	BCF	zumm, 0
	GOTO	Z1
Z2:	MOVF	BATime, 0	; if(BATime>64) BATime=64
	SUBLW	.255
	BTFSS	STATUS, Z
	GOTO	$+5
	MOVLW	.254
	MOVWF	BATime
	BCF	zumm, 0
	GOTO	$+2
	BSF	zumm, 0		;  
Z1:	
  ;-------------------------  ----------------------------
	BTFSS	zumm, 0		
	GOTO	NOZUMM
	BTFSS	time, 5		
	GOTO	NOZUMM
	BTFSC	t, 1
	BSF	PORTB, 7
	BTFSS	t, 1
NOZUMM:	BCF	PORTB, 7
	
  ;-------------     ----------
  ; if(T==0){
	MOVF	T, 0
	BTFSS	STATUS, Z
	GOTO	NO_PW
    ; if(!PWGOOD)               {
	BTFSS	PORTB, PWGOOD
	CLRF	PWcnt		;}	
 	INCF	PWcnt, 1   
    ; if(PWcnt>128) PWcnt=128	{
	MOVF	PWcnt, 0
	SUBLW	.128
	BTFSC	STATUS, C
	GOTO	$+3
    	MOVLW	.128
	MOVWF	PWcnt		;} 
  ; }
NO_PW:	

  ;--------------------------      ----------
  ; if( ){
	BTFSS	PWcnt, 7
	GOTO	NO_SIN
  ; }	  
	INCF	SINcnt, 1
  ;_if( . > 0.5 ){
	BTFSS	PORTB, SINH
	CLRF	FRONT
	INCF	FRONT, 1
	MOVF	FRONT, 0
	SUBLW	.5
 	BTFSS	STATUS, Z
	GOTO	INT6
   ;_ 
   ;    
	MOVF	SINcnt, 0
	MOVWF	SHORT
	CLRF	SINcnt
	SUBLW	.195		; >195
	BTFSC	STATUS, C
	GOTO	NO_SIN
	MOVF	SHORT, 0
	SUBLW	.205		; >205
	BTFSS	STATUS, C
	GOTO	NO_SIN
   ;  
	MOVF	T, 0
	SUBLW	.5
	BTFSC	STATUS, C
	GOTO	SIN1
	MOVF	T, 0
	SUBLW	.194
	BTFSS	STATUS, C
	GOTO	SIN1
	MOVF	T, 0
	ADDLW	3
	MOVWF	T
	GOTO	NO_SIN	
SIN1:	MOVLW	.199
	MOVWF	T
	BSF	SIN_OK, 0
	GOTO	$+2
NO_SIN:	CLRF	SIN_OK
  ;__}
INT6:
   


	RETFIE
;__}




END
